/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.circuits.Phasor;
import flanagan.complex.Complex;
import flanagan.complex.ComplexMatrix;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;

public class TransmissionLine {
    protected String title = "Transmission Line";
    protected double distributedResistance = 0.0;
    protected double distributedConductance = 0.0;
    protected double distributedCapacitance = 0.0;
    protected double distributedInductance = 0.0;
    protected Complex distributedImpedance = null;
    protected Complex distributedAdmittance = null;
    protected Complex loadImpedance = Complex.plusInfinity();
    protected double lineLength = -1.0;
    protected double segmentLength = -1.0;
    protected double frequency = 0.0;
    protected double omega = 0.0;
    protected Complex inputVoltage = null;
    protected Complex inputCurrent = null;
    protected Complex outputVoltage = null;
    protected Complex outputCurrent = null;
    protected double idealWavelength = 0.0;
    protected double generalWavelength = 0.0;
    protected double lowLossWavelength = 0.0;
    protected double idealPhaseVelocity = 0.0;
    protected double generalPhaseVelocity = 0.0;
    protected double lowLossPhaseVelocity = 0.0;
    protected double idealGroupVelocity = 0.0;
    protected double generalGroupVelocity = 0.0;
    protected double lowLossGroupVelocity = 0.0;
    protected double delta = 0.001;
    protected double idealAttenuationConstant = 0.0;
    protected double generalAttenuationConstant = 0.0;
    protected double lowLossAttenuationConstant = 0.0;
    protected double idealPhaseConstant = 0.0;
    protected double generalPhaseConstant = 0.0;
    protected double lowLossPhaseConstant = 0.0;
    protected Complex idealPropagationConstant = null;
    protected Complex generalPropagationConstant = null;
    protected Complex lowLossPropagationConstant = null;
    protected Complex idealCharacteristicImpedance = null;
    protected double idealRealCharacteristicImpedance = 0.0;
    protected Complex generalCharacteristicImpedance = null;
    protected Complex lowLossCharacteristicImpedance = null;
    protected Complex idealInputImpedance = null;
    protected Complex generalInputImpedance = null;
    protected Complex lowLossInputImpedance = null;
    protected Complex idealShortedLineImpedance = null;
    protected Complex generalShortedLineImpedance = null;
    protected Complex lowLossShortedLineImpedance = null;
    protected Complex idealOpenLineImpedance = null;
    protected Complex generalOpenLineImpedance = null;
    protected Complex lowLossOpenLineImpedance = null;
    protected Complex idealQuarterWaveLineImpedance = null;
    protected Complex generalQuarterWaveLineImpedance = null;
    protected Complex lowLossQuarterWaveLineImpedance = null;
    protected Complex idealHalfWaveLineImpedance = null;
    protected Complex generalHalfWaveLineImpedance = null;
    protected Complex lowLossHalfWaveLineImpedance = null;
    protected Complex idealRefectionCoefficient = null;
    protected Complex generalRefectionCoefficient = null;
    protected Complex lowLossRefectionCoefficient = null;
    protected double idealStandingWaveRatio = 0.0;
    protected double generalStandingWaveRatio = 0.0;
    protected double lowLossStandingWaveRatio = 0.0;
    protected ComplexMatrix idealABCDmatrix = null;
    protected ComplexMatrix generalABCDmatrix = null;
    protected ComplexMatrix lowLossABCDmatrix = null;
    protected int numberOfPoints = 1000;

    public TransmissionLine() {
    }

    public TransmissionLine(String title) {
        this.title = title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
        this.omega = this.frequency * 2.0 * Math.PI;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getRadialFrequency() {
        return this.omega;
    }

    public void setLoadImpedance(double impedance) {
        this.loadImpedance = new Complex(impedance, 0.0);
    }

    public void setLoadImpedance(Complex impedance) {
        this.loadImpedance = impedance;
    }

    public Complex getLoadImpedance() {
        return this.loadImpedance;
    }

    public void setLineLength(double length) {
        this.lineLength = length;
    }

    public double getLineLength() {
        return this.lineLength;
    }

    public void setSegmentLength(double length) {
        this.segmentLength = length;
    }

    public void setOutputVoltage(Phasor voltage) {
        this.outputVoltage = Phasor.toRectangular(voltage);
    }

    public void setOutputVoltage(Complex voltage) {
        this.outputVoltage = voltage;
    }

    public void setOutputVoltage(double magnitude, double phase) {
        this.outputVoltage = new Complex();
        this.outputVoltage.polar(magnitude, phase);
    }

    public void setOutputCurrent(Phasor current) {
        this.outputCurrent = Phasor.toRectangular(current);
    }

    public void setOutputCurrent(Complex current) {
        this.outputCurrent = current;
    }

    public void setOutputCurrent(double magnitude, double phase) {
        this.outputCurrent = new Complex();
        this.outputCurrent.polar(magnitude, phase);
    }

    public void setDistributedResistance(double resistance) {
        this.distributedResistance = resistance;
    }

    public void setDistributedInductance(double inductance) {
        this.distributedInductance = inductance;
    }

    public void setDistributedCapacitance(double capacitance) {
        this.distributedCapacitance = capacitance;
    }

    public void setDistributedConductance(double conductance) {
        this.distributedConductance = conductance;
    }

    public double getDistributedResistance() {
        return this.distributedResistance;
    }

    public double getDistributedInductance() {
        return this.distributedInductance;
    }

    public double getDistributedCapacitance() {
        return this.distributedCapacitance;
    }

    public double getDistributedConductance() {
        return this.distributedConductance;
    }

    public Complex getDistributedImpedance() {
        this.distributedImpedance = new Complex(this.distributedResistance, this.distributedInductance * this.omega);
        return this.distributedImpedance;
    }

    public Complex getDistributedAdmittance() {
        this.distributedAdmittance = new Complex(this.distributedConductance, this.distributedCapacitance * this.omega);
        return this.distributedAdmittance;
    }

    public double getWavelength() {
        this.generalWavelength = this.getPhaseVelocity() / this.frequency;
        return this.generalWavelength;
    }

    public double getIdealWavelength() {
        this.idealWavelength = this.getIdealPhaseVelocity() / this.frequency;
        return this.idealWavelength;
    }

    public double getLowLossWavelength() {
        this.lowLossWavelength = this.getLowLossPhaseVelocity() / this.frequency;
        return this.lowLossWavelength;
    }

    public double getPhaseVelocity() {
        this.generalPhaseVelocity = this.omega / this.getPhaseConstant();
        return this.generalPhaseVelocity;
    }

    public double getIdealPhaseVelocity() {
        this.idealPhaseVelocity = this.omega / this.getIdealPhaseConstant();
        return this.idealPhaseVelocity;
    }

    public double getLowLossPhaseVelocity() {
        this.lowLossPhaseVelocity = this.omega / this.getLowLossPhaseConstant();
        return this.lowLossPhaseVelocity;
    }

    public double getGroupVelocity() {
        if (this.distributedResistance == 0.0 && this.distributedConductance == 0.0) {
            this.generalPhaseVelocity = 1.0 / Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        } else {
            double omegaStored = this.omega;
            this.omega = omegaStored * (1.0 - this.delta);
            double betaLower = this.getPhaseConstant();
            this.omega = omegaStored * (1.0 + this.delta);
            double betaUpper = this.getPhaseConstant();
            this.omega = omegaStored;
            this.generalPhaseVelocity = 2.0 * this.omega * this.delta / (betaUpper - betaLower);
        }
        return this.generalGroupVelocity;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public double getIdealGroupVelocity() {
        this.idealGroupVelocity = 1.0 / Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        return this.idealGroupVelocity;
    }

    public double getLowLossGroupVelocity() {
        double temp0 = this.omega * this.omega;
        double temp1 = Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        double temp2 = this.distributedResistance * this.distributedConductance / (4.0 * temp0 * this.distributedInductance * this.distributedCapacitance);
        double temp3 = this.distributedConductance * this.distributedConductance / (8.0 * temp0 * this.distributedCapacitance * this.distributedCapacitance);
        double temp4 = this.distributedResistance * this.distributedResistance / (8.0 * temp0 * this.distributedInductance * this.distributedInductance);
        this.lowLossPhaseConstant = 1.0 / (temp1 * (1.0 + temp2 - temp3 - temp4));
        return this.lowLossGroupVelocity;
    }

    public double getAttenuationConstant() {
        this.generalAttenuationConstant = this.distributedResistance == 0.0 && this.distributedConductance == 0.0 ? 0.0 : Complex.sqrt(this.getDistributedImpedance().times(this.getDistributedAdmittance())).getReal();
        return this.generalAttenuationConstant;
    }

    public double getLowLossAttenuationConstant() {
        double temp1 = Math.sqrt(this.distributedInductance / this.distributedCapacitance);
        double temp2 = this.distributedResistance / (2.0 * temp1);
        double temp3 = this.distributedConductance * temp1 / 2.0;
        this.lowLossAttenuationConstant = temp2 + temp3;
        return this.lowLossAttenuationConstant;
    }

    public double getIdealAttenuationConstant() {
        this.idealAttenuationConstant = 0.0;
        return this.idealAttenuationConstant;
    }

    public double getPhaseConstant() {
        this.generalPhaseConstant = this.distributedResistance == 0.0 && this.distributedConductance == 0.0 ? this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance) : Complex.sqrt(this.getDistributedImpedance().times(this.getDistributedAdmittance())).getImag();
        return this.generalPhaseConstant;
    }

    public double getLowLossPhaseConstant() {
        double temp0 = this.omega * this.omega;
        double temp1 = this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        double temp2 = this.distributedResistance * this.distributedConductance / (4.0 * temp0 * this.distributedInductance * this.distributedCapacitance);
        double temp3 = this.distributedConductance * this.distributedConductance / (8.0 * temp0 * this.distributedCapacitance * this.distributedCapacitance);
        double temp4 = this.distributedResistance * this.distributedResistance / (8.0 * temp0 * this.distributedInductance * this.distributedInductance);
        this.lowLossPhaseConstant = temp1 * (1.0 - temp2 + temp3 + temp4);
        return this.lowLossPhaseConstant;
    }

    public double getIdealPhaseConstant() {
        this.idealPhaseConstant = this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance);
        return this.idealPhaseConstant;
    }

    public Complex getPropagationConstant() {
        this.generalPropagationConstant = this.distributedResistance == 0.0 && this.distributedConductance == 0.0 ? new Complex(0.0, this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance)) : Complex.sqrt(this.getDistributedImpedance().times(this.getDistributedAdmittance()));
        return this.generalPropagationConstant;
    }

    public Complex getLowLossPropagationConstant() {
        this.lowLossPropagationConstant = new Complex(this.getLowLossAttenuationConstant(), this.getLowLossPhaseConstant());
        return this.lowLossPropagationConstant;
    }

    public Complex getIdealPropagationConstant() {
        this.idealPropagationConstant = new Complex(0.0, this.omega * Math.sqrt(this.distributedInductance * this.distributedCapacitance));
        return this.idealPropagationConstant;
    }

    public Complex getCharacteristicImpedance() {
        this.generalCharacteristicImpedance = Complex.sqrt(this.getDistributedImpedance().over(this.getDistributedAdmittance()));
        return this.generalCharacteristicImpedance;
    }

    public Complex getLowLossCharacteristicImpedance() {
        double temp0 = this.omega * this.omega;
        double temp1 = Math.sqrt(this.distributedInductance / this.distributedCapacitance);
        double temp2 = this.distributedResistance * this.distributedResistance / (8.0 * temp0 * this.distributedInductance * this.distributedInductance);
        double temp3 = this.distributedConductance * this.distributedConductance / (8.0 * temp0 * this.distributedCapacitance * this.distributedCapacitance);
        double temp4 = this.distributedResistance * this.distributedConductance / (4.0 * temp0 * this.distributedInductance * this.distributedCapacitance);
        double temp5 = this.distributedConductance / (2.0 * this.omega * this.distributedCapacitance);
        double temp6 = this.distributedResistance / (2.0 * this.omega * this.distributedInductance);
        this.lowLossCharacteristicImpedance = new Complex(temp1 * (1.0 + temp2 - temp3 + temp4), temp1 * (temp5 - temp6));
        return this.lowLossCharacteristicImpedance;
    }

    public Complex getIdealCharacteristicImpedance() {
        this.idealRealCharacteristicImpedance = Math.sqrt(this.distributedInductance / this.distributedCapacitance);
        this.idealCharacteristicImpedance = new Complex(this.idealRealCharacteristicImpedance, 0.0);
        return this.idealCharacteristicImpedance;
    }

    public double getIdealCharacteristicImpedanceAsReal() {
        this.idealRealCharacteristicImpedance = Math.sqrt(this.distributedInductance / this.distributedCapacitance);
        this.idealCharacteristicImpedance = new Complex(this.idealRealCharacteristicImpedance, 0.0);
        return this.idealRealCharacteristicImpedance;
    }

    public Complex getInputImpedance() {
        Complex gamma = this.getPropagationConstant();
        Complex zed0 = this.getCharacteristicImpedance();
        Complex temp0 = Complex.cosh(gamma.times(this.lineLength));
        Complex temp1 = Complex.sinh(gamma.times(this.lineLength));
        Complex temp2 = temp0.times(this.loadImpedance);
        Complex temp3 = temp1.times(zed0);
        Complex temp4 = temp0.times(zed0);
        Complex temp5 = temp1.times(this.loadImpedance);
        Complex temp6 = temp2.plus(temp3).over(temp4.plus(temp5));
        this.generalInputImpedance = zed0.times(temp6);
        return this.generalInputImpedance;
    }

    public Complex getLowLossInputImpedance() {
        Complex gamma = this.getLowLossPropagationConstant();
        Complex zed0 = this.getLowLossCharacteristicImpedance();
        Complex temp0 = Complex.cosh(gamma.times(this.lineLength));
        Complex temp1 = Complex.sinh(gamma.times(this.lineLength));
        Complex temp2 = temp0.times(this.loadImpedance);
        Complex temp3 = temp1.times(zed0);
        Complex temp4 = temp0.times(zed0);
        Complex temp5 = temp1.times(this.loadImpedance);
        Complex temp6 = temp2.plus(temp3).over(temp4.plus(temp5));
        this.lowLossInputImpedance = zed0.times(temp6);
        return this.lowLossInputImpedance;
    }

    public Complex getIdealInputImpedance() {
        double beta = this.getIdealPhaseConstant();
        double zed0 = this.getIdealCharacteristicImpedanceAsReal();
        double temp0 = Math.cos(beta * this.lineLength);
        double temp1 = Math.sin(beta * this.lineLength);
        Complex temp2 = new Complex(0.0, temp1 * zed0).plus(this.loadImpedance.times(temp0));
        Complex temp3 = new Complex(temp0 * zed0, 0.0).plus(Complex.plusJay().times(this.loadImpedance.times(temp1)));
        Complex temp4 = temp2.over(temp3);
        this.idealInputImpedance = temp4.times(zed0);
        return this.idealInputImpedance;
    }

    public Complex getShortedLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        this.generalShortedLineImpedance = this.getCharacteristicImpedance().times(Complex.tanh(this.getPropagationConstant().times(this.lineLength)));
        return this.generalShortedLineImpedance;
    }

    public Complex getLowLossShortedLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        double temp0 = this.getLowLossAttenuationConstant() * this.lineLength;
        double temp1 = Math.cos(this.getLowLossPhaseConstant() * this.lineLength);
        double temp2 = Math.sin(this.getLowLossPhaseConstant() * this.lineLength);
        Complex temp3 = new Complex(temp0 * temp1, temp2);
        Complex temp4 = new Complex(temp1, temp0 * temp2);
        this.lowLossShortedLineImpedance = temp3.over(temp4);
        return this.lowLossShortedLineImpedance;
    }

    public Complex getIdealShortedLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        this.idealShortedLineImpedance = new Complex(0.0, this.getIdealCharacteristicImpedanceAsReal() * Math.tan(this.getIdealPhaseConstant() * this.lineLength));
        return this.idealShortedLineImpedance;
    }

    public Complex getOpenLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        this.generalShortedLineImpedance = this.getCharacteristicImpedance().times(Complex.coth(this.getPropagationConstant().times(this.lineLength)));
        return this.generalShortedLineImpedance;
    }

    public Complex getLowLossOpenLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        double temp0 = this.getLowLossAttenuationConstant() * this.lineLength;
        double temp1 = Math.cos(this.getLowLossPhaseConstant() * this.lineLength);
        double temp2 = Math.sin(this.getLowLossPhaseConstant() * this.lineLength);
        Complex temp3 = new Complex(temp1, temp0 * temp2);
        Complex temp4 = new Complex(temp0 * temp1, temp2);
        this.lowLossShortedLineImpedance = temp3.over(temp4);
        return this.lowLossShortedLineImpedance;
    }

    public Complex getIdealOpenLineImpedance() {
        if (this.lineLength == -1.0) {
            throw new IllegalArgumentException("No line length as been entered");
        }
        this.idealShortedLineImpedance = new Complex(0.0, -this.getIdealCharacteristicImpedanceAsReal() * Fmath.cot(this.getIdealPhaseConstant() * this.lineLength));
        return this.idealShortedLineImpedance;
    }

    public Complex getQuarterWaveLineImpedance() {
        Complex alpha = new Complex(this.getAttenuationConstant(), 0.0);
        Complex zed0 = this.getCharacteristicImpedance();
        Complex temp0 = Complex.sinh(alpha.times(this.lineLength));
        Complex temp1 = Complex.cosh(alpha.times(this.lineLength));
        Complex temp2 = temp0.times(this.loadImpedance);
        Complex temp3 = temp1.times(zed0);
        Complex temp4 = temp0.times(zed0);
        Complex temp5 = temp1.times(this.loadImpedance);
        Complex temp6 = temp2.plus(temp3).over(temp4.plus(temp5));
        this.generalQuarterWaveLineImpedance = zed0.times(temp6);
        return this.generalQuarterWaveLineImpedance;
    }

    public Complex getLowLossQuarterWaveLineImpedance() {
        Complex alpha = new Complex(this.getLowLossAttenuationConstant(), 0.0);
        Complex zed0 = this.getLowLossCharacteristicImpedance();
        Complex temp0 = alpha.times(this.lineLength);
        Complex temp1 = zed0.plus(this.loadImpedance.times(temp0));
        Complex temp2 = this.loadImpedance.plus(zed0.times(temp0));
        Complex temp3 = temp1.over(temp2);
        this.lowLossQuarterWaveLineImpedance = zed0.times(temp3);
        return this.lowLossQuarterWaveLineImpedance;
    }

    public Complex getIdealQuarterWaveLineImpedance() {
        Complex zed02 = new Complex(Fmath.square(this.getIdealCharacteristicImpedanceAsReal()), 0.0);
        this.idealQuarterWaveLineImpedance = zed02.over(this.loadImpedance);
        return this.idealQuarterWaveLineImpedance;
    }

    public Complex getHalfWaveLineImpedance() {
        Complex alpha = new Complex(this.getAttenuationConstant(), 0.0);
        Complex zed0 = this.getCharacteristicImpedance();
        Complex temp0 = Complex.cosh(alpha.times(this.lineLength));
        Complex temp1 = Complex.sinh(alpha.times(this.lineLength));
        Complex temp2 = temp0.times(this.loadImpedance);
        Complex temp3 = temp1.times(zed0);
        Complex temp4 = temp0.times(zed0);
        Complex temp5 = temp1.times(this.loadImpedance);
        Complex temp6 = temp2.plus(temp3).over(temp4.plus(temp5));
        this.generalHalfWaveLineImpedance = zed0.times(temp6);
        return this.generalHalfWaveLineImpedance;
    }

    public Complex getLowLossHalfWaveLineImpedance() {
        Complex alpha = new Complex(this.getLowLossAttenuationConstant(), 0.0);
        Complex zed0 = this.getLowLossCharacteristicImpedance();
        Complex temp0 = alpha.times(this.lineLength);
        Complex temp1 = this.loadImpedance.plus(zed0.times(temp0));
        Complex temp2 = zed0.plus(this.loadImpedance.times(temp0));
        Complex temp3 = temp1.over(temp2);
        this.lowLossHalfWaveLineImpedance = zed0.times(temp3);
        return this.lowLossHalfWaveLineImpedance;
    }

    public Complex getIdealHalfWaveLineImpedance() {
        this.idealHalfWaveLineImpedance = this.loadImpedance;
        return this.idealHalfWaveLineImpedance;
    }

    public Complex getRefectionCoefficient() {
        Complex complex1 = this.loadImpedance.minus(this.getCharacteristicImpedance());
        Complex complex2 = this.loadImpedance.plus(this.getCharacteristicImpedance());
        this.generalRefectionCoefficient = complex1.over(complex2);
        return this.generalRefectionCoefficient;
    }

    public Complex getLowLossRefectionCoefficient() {
        Complex complex1 = this.loadImpedance.minus(this.getLowLossCharacteristicImpedance());
        Complex complex2 = this.loadImpedance.plus(this.getLowLossCharacteristicImpedance());
        this.lowLossRefectionCoefficient = complex1.over(complex2);
        return this.lowLossRefectionCoefficient;
    }

    public Complex getIdealRefectionCoefficient() {
        Complex complex1 = this.loadImpedance.minus(this.getIdealCharacteristicImpedance());
        Complex complex2 = this.loadImpedance.plus(this.getIdealCharacteristicImpedance());
        this.idealRefectionCoefficient = complex1.over(complex2);
        return this.idealRefectionCoefficient;
    }

    public double getStandingWaveRatio() {
        double rho = this.getRefectionCoefficient().abs();
        this.generalStandingWaveRatio = (1.0 + rho) / (1.0 - rho);
        return this.generalStandingWaveRatio;
    }

    public double getLowLossStandingWaveRatio() {
        double rho = this.getLowLossRefectionCoefficient().abs();
        this.lowLossStandingWaveRatio = (1.0 + rho) / (1.0 - rho);
        return this.lowLossStandingWaveRatio;
    }

    public double getIdealStandingWaveRatio() {
        double rho = this.getIdealRefectionCoefficient().abs();
        this.idealStandingWaveRatio = (1.0 + rho) / (1.0 - rho);
        return this.idealStandingWaveRatio;
    }

    public ComplexMatrix getABCDmatrix() {
        if (this.segmentLength == -1.0) {
            throw new IllegalArgumentException("No distance along the line as been entered");
        }
        if (this.distributedResistance == 0.0 && this.distributedConductance == 0.0) {
            this.generalABCDmatrix = this.getIdealABCDmatrix();
        } else {
            this.generalABCDmatrix = new ComplexMatrix(2, 2);
            Complex gammal = this.getPropagationConstant().times(this.segmentLength);
            Complex zed0 = this.getCharacteristicImpedance();
            this.generalABCDmatrix.setElement(0, 0, Complex.cosh(gammal));
            this.generalABCDmatrix.setElement(0, 1, Complex.sinh(gammal).times(zed0));
            this.generalABCDmatrix.setElement(1, 0, Complex.sinh(gammal).over(zed0));
            this.generalABCDmatrix.setElement(1, 1, Complex.cosh(gammal));
        }
        return this.generalABCDmatrix;
    }

    public ComplexMatrix getIdealABCDmatrix() {
        if (this.segmentLength == -1.0) {
            throw new IllegalArgumentException("No distance along the line as been entered");
        }
        this.idealABCDmatrix = new ComplexMatrix(2, 2);
        double betal = this.getIdealPhaseConstant() * this.segmentLength;
        double zed0 = this.getIdealCharacteristicImpedanceAsReal();
        this.idealABCDmatrix.setElement(0, 0, new Complex(Math.cos(betal), 0.0));
        this.idealABCDmatrix.setElement(0, 1, new Complex(0.0, Math.sin(betal) * zed0));
        this.idealABCDmatrix.setElement(1, 0, new Complex(0.0, Math.sin(betal) / zed0));
        this.idealABCDmatrix.setElement(1, 1, new Complex(Math.cos(betal), 0.0));
        return this.idealABCDmatrix;
    }

    public ComplexMatrix getLowLossABCDmatrix() {
        if (this.segmentLength == -1.0) {
            throw new IllegalArgumentException("No distance along the line as been entered");
        }
        this.lowLossABCDmatrix = new ComplexMatrix(2, 2);
        Complex gammal = this.getLowLossPropagationConstant().times(this.segmentLength);
        Complex zed0 = this.getLowLossCharacteristicImpedance();
        this.lowLossABCDmatrix.setElement(0, 0, Complex.cosh(gammal));
        this.lowLossABCDmatrix.setElement(0, 1, Complex.sinh(gammal).times(zed0));
        this.lowLossABCDmatrix.setElement(1, 0, Complex.sinh(gammal).over(zed0));
        this.lowLossABCDmatrix.setElement(1, 1, Complex.cosh(gammal));
        return this.lowLossABCDmatrix;
    }

    public Complex[] voltageAndCurrentAsComplex(double segLen) {
        this.segmentLength = segLen;
        return this.voltageAndCurrentAsComplex();
    }

    public Complex[] voltageAndCurrentAsComplex() {
        Complex[] outputVector = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix abcdMatrix = this.getABCDmatrix();
        Complex[] inputVector = abcdMatrix.solveLinearSet(outputVector);
        this.inputVoltage = inputVector[0];
        this.inputCurrent = inputVector[1];
        return inputVector;
    }

    public Phasor[] voltageAndCurrentAsPhasor(double segLen) {
        this.segmentLength = segLen;
        Complex[] outputVector = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix abcdMatrix = this.getABCDmatrix();
        Complex[] inputVector = abcdMatrix.solveLinearSet(outputVector);
        this.inputVoltage = inputVector[0];
        this.inputCurrent = inputVector[1];
        Phasor[] input = new Phasor[]{Phasor.toPhasor(this.inputVoltage), Phasor.toPhasor(this.inputCurrent)};
        return input;
    }

    public Phasor[] voltageAndCurrentAsPhasor() {
        Complex[] outputVector = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix abcdMatrix = this.getABCDmatrix();
        Complex[] inputVector = abcdMatrix.solveLinearSet(outputVector);
        this.inputVoltage = inputVector[0];
        this.inputCurrent = inputVector[1];
        Phasor[] input = new Phasor[]{Phasor.toPhasor(this.inputVoltage), Phasor.toPhasor(this.inputCurrent)};
        return input;
    }

    public double[] voltageAndCurrentAsReal() {
        Complex[] outputVector = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix abcdMatrix = this.getABCDmatrix();
        Complex[] inputVector = abcdMatrix.solveLinearSet(outputVector);
        double[] input = new double[]{inputVector[0].abs() * Math.cos(inputVector[0].arg()), inputVector[1].abs() * Math.cos(inputVector[1].arg())};
        return input;
    }

    public double[] voltageAndCurrentAsReal(double segLen) {
        this.segmentLength = segLen;
        return this.voltageAndCurrentAsReal();
    }

    public double[] voltageAndCurrentAsMagnitudeAndPhase() {
        Complex[] outputVector = new Complex[]{this.outputVoltage, this.outputCurrent};
        ComplexMatrix abcdMatrix = this.getABCDmatrix();
        Complex[] inputVector = abcdMatrix.solveLinearSet(outputVector);
        double[] input = new double[]{inputVector[0].abs(), inputVector[0].arg(), inputVector[1].abs(), inputVector[1].arg()};
        return input;
    }

    public double[] voltageAndCurrentAsAsMagnitudeAndPhase(double segLen) {
        this.segmentLength = segLen;
        return this.voltageAndCurrentAsMagnitudeAndPhase();
    }

    public void plotVandI() {
        int i;
        double[][] data = PlotGraph.data(4, this.numberOfPoints);
        double increment = this.segmentLength / (double)(this.numberOfPoints - 1);
        data[0][0] = 0.0;
        data[2][0] = 0.0;
        for (i = 1; i < this.numberOfPoints; ++i) {
            data[0][i] = data[0][i - 1] + increment;
            data[2][i] = data[2][i - 1] + increment;
        }
        for (i = 0; i < this.numberOfPoints; ++i) {
            double[] output = this.voltageAndCurrentAsReal(data[0][i]);
            data[1][i] = output[0];
            data[3][i] = output[1];
        }
        data[4][0] = 0.0;
        data[6][0] = 0.0;
        data[4][1] = data[0][this.numberOfPoints / 2];
        data[6][1] = data[0][this.numberOfPoints / 2];
        data[4][2] = data[0][this.numberOfPoints - 1];
        data[6][2] = data[0][this.numberOfPoints - 1];
        data[5][0] = data[1][0];
        data[7][0] = data[3][0];
        data[5][1] = data[1][this.numberOfPoints / 2];
        data[7][1] = data[3][this.numberOfPoints / 2];
        data[5][2] = data[1][this.numberOfPoints - 1];
        data[7][2] = data[3][this.numberOfPoints - 1];
        PlotGraph pg = new PlotGraph(data);
        int[] lineOpt = new int[]{3, 3, 0, 0};
        pg.setLine(lineOpt);
        int[] pointOpt = new int[]{0, 0, 1, 2};
        pg.setPoint(pointOpt);
        pg.setXaxisLegend("distance / metres");
        pg.setYaxisLegend("Voltage / V and Current / A");
        pg.plot();
    }

    public TransmissionLine copy() {
        if (this == null) {
            return null;
        }
        TransmissionLine tl = new TransmissionLine();
        tl.title = this.title;
        tl.distributedResistance = this.distributedResistance;
        tl.distributedConductance = this.distributedConductance;
        tl.distributedCapacitance = this.distributedCapacitance;
        tl.distributedInductance = this.distributedInductance;
        tl.distributedImpedance = this.distributedImpedance.copy();
        tl.distributedAdmittance = this.distributedAdmittance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.lineLength = this.lineLength;
        tl.segmentLength = this.segmentLength;
        tl.frequency = this.frequency;
        tl.segmentLength = this.segmentLength;
        tl.omega = this.omega;
        tl.inputVoltage = this.inputVoltage.copy();
        tl.inputCurrent = this.inputCurrent.copy();
        tl.outputVoltage = this.outputVoltage.copy();
        tl.outputCurrent = this.outputCurrent.copy();
        tl.idealWavelength = this.idealWavelength;
        tl.generalWavelength = this.generalWavelength;
        tl.lowLossWavelength = this.lowLossWavelength;
        tl.idealPhaseVelocity = this.idealPhaseVelocity;
        tl.generalPhaseVelocity = this.generalPhaseVelocity;
        tl.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
        tl.idealGroupVelocity = this.idealGroupVelocity;
        tl.generalGroupVelocity = this.generalGroupVelocity;
        tl.lowLossGroupVelocity = this.lowLossGroupVelocity;
        tl.delta = this.delta;
        tl.idealAttenuationConstant = this.idealAttenuationConstant;
        tl.generalAttenuationConstant = this.generalAttenuationConstant;
        tl.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
        tl.idealPhaseConstant = this.idealPhaseConstant;
        tl.generalPhaseConstant = this.generalPhaseConstant;
        tl.lowLossPhaseConstant = this.lowLossPhaseConstant;
        tl.idealPropagationConstant = this.idealPropagationConstant.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.loadImpedance = this.loadImpedance.copy();
        tl.generalPropagationConstant = this.generalPropagationConstant.copy();
        tl.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
        tl.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
        tl.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
        tl.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
        tl.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
        tl.idealInputImpedance = this.idealInputImpedance.copy();
        tl.generalInputImpedance = this.generalInputImpedance.copy();
        tl.lowLossInputImpedance = this.lowLossInputImpedance.copy();
        tl.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
        tl.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
        tl.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
        tl.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
        tl.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
        tl.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
        tl.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
        tl.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
        tl.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
        tl.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
        tl.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
        tl.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
        tl.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
        tl.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
        tl.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
        tl.idealStandingWaveRatio = this.idealStandingWaveRatio;
        tl.generalStandingWaveRatio = this.generalStandingWaveRatio;
        tl.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
        tl.idealABCDmatrix = this.idealABCDmatrix.copy();
        tl.generalABCDmatrix = this.generalABCDmatrix.copy();
        tl.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
        tl.numberOfPoints = this.numberOfPoints;
        return tl;
    }

    public Object clone() {
        TransmissionLine ret = null;
        if (this != null) {
            TransmissionLine tl = new TransmissionLine();
            tl.title = this.title;
            tl.distributedResistance = this.distributedResistance;
            tl.distributedConductance = this.distributedConductance;
            tl.distributedCapacitance = this.distributedCapacitance;
            tl.distributedInductance = this.distributedInductance;
            tl.distributedImpedance = this.distributedImpedance.copy();
            tl.distributedAdmittance = this.distributedAdmittance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.lineLength = this.lineLength;
            tl.segmentLength = this.segmentLength;
            tl.frequency = this.frequency;
            tl.segmentLength = this.segmentLength;
            tl.omega = this.omega;
            tl.inputVoltage = this.inputVoltage.copy();
            tl.inputCurrent = this.inputCurrent.copy();
            tl.outputVoltage = this.outputVoltage.copy();
            tl.outputCurrent = this.outputCurrent.copy();
            tl.idealWavelength = this.idealWavelength;
            tl.generalWavelength = this.generalWavelength;
            tl.lowLossWavelength = this.lowLossWavelength;
            tl.idealPhaseVelocity = this.idealPhaseVelocity;
            tl.generalPhaseVelocity = this.generalPhaseVelocity;
            tl.lowLossPhaseVelocity = this.lowLossPhaseVelocity;
            tl.idealGroupVelocity = this.idealGroupVelocity;
            tl.generalGroupVelocity = this.generalGroupVelocity;
            tl.lowLossGroupVelocity = this.lowLossGroupVelocity;
            tl.delta = this.delta;
            tl.idealAttenuationConstant = this.idealAttenuationConstant;
            tl.generalAttenuationConstant = this.generalAttenuationConstant;
            tl.lowLossAttenuationConstant = this.lowLossAttenuationConstant;
            tl.idealPhaseConstant = this.idealPhaseConstant;
            tl.generalPhaseConstant = this.generalPhaseConstant;
            tl.lowLossPhaseConstant = this.lowLossPhaseConstant;
            tl.idealPropagationConstant = this.idealPropagationConstant.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.loadImpedance = this.loadImpedance.copy();
            tl.generalPropagationConstant = this.generalPropagationConstant.copy();
            tl.lowLossPropagationConstant = this.lowLossPropagationConstant.copy();
            tl.idealCharacteristicImpedance = this.idealCharacteristicImpedance.copy();
            tl.idealRealCharacteristicImpedance = this.idealRealCharacteristicImpedance;
            tl.generalCharacteristicImpedance = this.generalCharacteristicImpedance.copy();
            tl.lowLossCharacteristicImpedance = this.lowLossCharacteristicImpedance.copy();
            tl.idealInputImpedance = this.idealInputImpedance.copy();
            tl.generalInputImpedance = this.generalInputImpedance.copy();
            tl.lowLossInputImpedance = this.lowLossInputImpedance.copy();
            tl.idealShortedLineImpedance = this.idealShortedLineImpedance.copy();
            tl.generalShortedLineImpedance = this.generalShortedLineImpedance.copy();
            tl.lowLossShortedLineImpedance = this.lowLossShortedLineImpedance.copy();
            tl.idealOpenLineImpedance = this.idealOpenLineImpedance.copy();
            tl.generalOpenLineImpedance = this.generalOpenLineImpedance.copy();
            tl.lowLossOpenLineImpedance = this.lowLossOpenLineImpedance.copy();
            tl.idealQuarterWaveLineImpedance = this.idealQuarterWaveLineImpedance.copy();
            tl.generalQuarterWaveLineImpedance = this.generalQuarterWaveLineImpedance.copy();
            tl.lowLossQuarterWaveLineImpedance = this.lowLossQuarterWaveLineImpedance.copy();
            tl.idealHalfWaveLineImpedance = this.idealHalfWaveLineImpedance.copy();
            tl.generalHalfWaveLineImpedance = this.generalHalfWaveLineImpedance.copy();
            tl.lowLossHalfWaveLineImpedance = this.lowLossHalfWaveLineImpedance.copy();
            tl.idealRefectionCoefficient = this.idealRefectionCoefficient.copy();
            tl.generalRefectionCoefficient = this.generalRefectionCoefficient.copy();
            tl.lowLossRefectionCoefficient = this.lowLossRefectionCoefficient.copy();
            tl.idealStandingWaveRatio = this.idealStandingWaveRatio;
            tl.generalStandingWaveRatio = this.generalStandingWaveRatio;
            tl.lowLossStandingWaveRatio = this.lowLossStandingWaveRatio;
            tl.idealABCDmatrix = this.idealABCDmatrix.copy();
            tl.generalABCDmatrix = this.generalABCDmatrix.copy();
            tl.lowLossABCDmatrix = this.lowLossABCDmatrix.copy();
            tl.numberOfPoints = this.numberOfPoints;
            ret = tl;
        }
        return ret;
    }
}

