/*
 * Decompiled with CFR 0.152.
 */
package flanagan.analysis;

import flanagan.analysis.BetaFunction;
import flanagan.analysis.EC50FixedFunction;
import flanagan.analysis.EC50Function;
import flanagan.analysis.ErlangFunction;
import flanagan.analysis.ErrorProp;
import flanagan.analysis.ExponentialFunction;
import flanagan.analysis.ExponentialMultipleFunction;
import flanagan.analysis.ExponentialSimpleFunction;
import flanagan.analysis.FrechetFunctionOne;
import flanagan.analysis.FrechetFunctionTwo;
import flanagan.analysis.GammaFunction;
import flanagan.analysis.GaussianFunction;
import flanagan.analysis.GaussianFunctionFixed;
import flanagan.analysis.GumbelFunction;
import flanagan.analysis.LogNormalThreeParFunction;
import flanagan.analysis.LogNormalTwoParFunction;
import flanagan.analysis.Logistic5FixedFunction;
import flanagan.analysis.Logistic5Function;
import flanagan.analysis.LogisticFunction;
import flanagan.analysis.LorentzianFunction;
import flanagan.analysis.MultipleGaussianFunction;
import flanagan.analysis.NonIntegerPolyFunction;
import flanagan.analysis.OneMinusExponentialFunction;
import flanagan.analysis.ParetoFunctionOne;
import flanagan.analysis.ParetoFunctionTwo;
import flanagan.analysis.PoissonFunction;
import flanagan.analysis.RayleighFunctionOne;
import flanagan.analysis.RayleighFunctionTwo;
import flanagan.analysis.RectangularHyperbolaFunction;
import flanagan.analysis.RegressionFunction;
import flanagan.analysis.RegressionFunction2;
import flanagan.analysis.ShiftedRectangularHyperbolaFunction;
import flanagan.analysis.SigmoidHillSipsFunction;
import flanagan.analysis.SigmoidThresholdFunction;
import flanagan.analysis.Stat;
import flanagan.analysis.StepFunctionFunction;
import flanagan.analysis.WeibullFunctionOne;
import flanagan.analysis.WeibullFunctionTwo;
import flanagan.io.Db;
import flanagan.io.FileOutput;
import flanagan.math.ArrayMaths;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.math.Matrix;
import flanagan.plot.PlotGraph;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JOptionPane;

public class Regression {
    protected int nData0 = 0;
    protected int nData = 0;
    protected int nXarrays = 1;
    protected int nYarrays = 1;
    protected int nParam = 0;
    protected int degreesOfFreedom = 0;
    protected double[][] xData = null;
    protected double[] yData = null;
    protected double[] yCalc = null;
    protected double[] weight = null;
    protected double[] residual = null;
    protected double[] residualW = null;
    protected boolean weightOpt = false;
    protected int weightFlag = 0;
    protected String[] weightWord = new String[]{"", "Weighted "};
    protected double[] best = null;
    protected double[] bestSd = null;
    protected double[] pseudoSd = null;
    protected double[] tValues = null;
    protected double[] pValues = null;
    protected double fixedInterceptL = 0.0;
    protected double fixedInterceptP = 0.0;
    protected double yMean = Double.NaN;
    protected double yWeightedMean = Double.NaN;
    protected double chiSquare = Double.NaN;
    protected double reducedChiSquare = Double.NaN;
    protected double sumOfSquaresError = Double.NaN;
    protected double sumOfSquaresTotal = Double.NaN;
    protected double sumOfSquaresRegrn = Double.NaN;
    protected double lastSSnoConstraint = 0.0;
    protected double[][] covar = null;
    protected double[][] corrCoeff = null;
    protected double xyR = Double.NaN;
    protected double yyR = Double.NaN;
    protected double multR = Double.NaN;
    protected double adjustedR = Double.NaN;
    protected double multipleF = Double.NaN;
    protected double multipleFprob = Double.NaN;
    protected String[] paraName = null;
    protected int prec = 4;
    protected int field = 13;
    protected int lastMethod = -1;
    protected boolean bestPolyFlag = false;
    protected int bestPolynomialDegree = 0;
    protected double fProbSignificance = 0.05;
    protected ArrayList<Object> bestPolyArray = new ArrayList();
    protected boolean userSupplied = true;
    protected double kayValue = 0.0;
    protected boolean frechetWeibull = true;
    protected boolean linNonLin = true;
    protected boolean trueFreq = false;
    protected String xLegend = "x axis values";
    protected String yLegend = "y axis values";
    protected String graphTitle = " ";
    protected String graphTitle2 = " ";
    protected boolean legendCheck = false;
    protected boolean supressPrint = false;
    protected boolean supressYYplot = false;
    protected boolean supressErrorMessages = false;
    protected boolean nlrStatus = true;
    protected int scaleOpt = 0;
    protected double[] scale = null;
    protected boolean zeroCheck = false;
    protected boolean penalty = false;
    protected boolean sumPenalty = false;
    protected int nConstraints = 0;
    protected int nSumConstraints = 0;
    protected int maxConstraintIndex = -1;
    protected double constraintTolerance = 1.0E-4;
    protected ArrayList<Object> penalties = new ArrayList();
    protected ArrayList<Object> sumPenalties = new ArrayList();
    protected int[] penaltyCheck = null;
    protected int[] sumPenaltyCheck = null;
    protected double penaltyWeight = 1.0E30;
    protected int[] penaltyParam = null;
    protected int[][] sumPenaltyParam = null;
    protected double[][] sumPlusOrMinus = null;
    protected int[] sumPenaltyNumber = null;
    protected double[] constraints = null;
    protected double[] sumConstraints = null;
    protected int constraintMethod = 0;
    protected boolean scaleFlag = true;
    protected double yScaleFactor = 1.0;
    protected int nMax = 3000;
    protected int minIter = 300;
    protected int nIter = 0;
    protected int konvge = 3;
    protected int kRestart = 0;
    protected double fMin = -1.0;
    protected double fTol = 1.0E-9;
    protected double rCoeff = 1.0;
    protected double eCoeff = 2.0;
    protected double cCoeff = 0.5;
    protected double[] startH = null;
    protected double[] stepH = null;
    protected double[] startSH = null;
    protected double[] stepSH = null;
    protected double dStep = 0.5;
    protected double[][] grad = null;
    protected double delta = 1.0E-4;
    protected double deltaBeale = 0.001;
    protected boolean invertFlag = true;
    protected boolean posVarFlag = true;
    protected int minTest = 0;
    protected double simplexSd = 0.0;
    protected boolean statFlag = true;
    protected boolean plotOpt = true;
    protected boolean multipleY = false;
    protected boolean ignoreDofFcheck = false;
    protected double[] values = null;
    protected boolean[] fixed = null;
    protected int nGaussians = 0;
    protected double[] multGaussFract = null;
    protected double[] multGaussFractErrors = null;
    protected double[] multGaussCoeffVar = null;
    protected double[] multGaussTvalue = null;
    protected double[] multGaussPvalue = null;
    protected double multGaussScale = 1.0;
    protected double multGaussScaleError = 0.0;
    protected double multGaussScaleCoeffVar = 0.0;
    protected double multGaussScaleTvalue = 0.0;
    protected double multGaussScalePvalue = 0.0;
    protected boolean plotWindowCloseChoice = false;
    protected double minimumY = 0.0;
    protected double minimumYindex = 0.0;
    protected double maximumY = 0.0;
    protected double maximumYindex = 0.0;
    protected double bottom = 0.0;
    protected double top = 0.0;
    protected double bottomS = 0.0;
    protected double bottomSindex = 0.0;
    protected double topS = 0.0;
    protected double topSindex = 0.0;
    protected int midPointLowerIndex = 0;
    protected int midPointUpperIndex = 0;
    protected double midPointXvalue = 0.0;
    protected double midPointYvalue = 0.0;
    protected int directionFlag = 0;
    protected double dDurbinWatson = Double.NaN;
    protected boolean dDurbinWatsonDone = false;
    protected static double histTol = 1.0001;

    public Regression() {
    }

    public Regression(double[][] xData, double[] yData, double[] weight) {
        int n = weight.length;
        this.nData0 = yData.length;
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(Conv.copy(xData), Conv.copy(yData), Conv.copy(weight));
    }

    public Regression(double[][] xxData, double[][] yyData, double[][] wWeight) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        int nX1 = xxData.length;
        int nX2 = xxData[0].length;
        double[] yData = new double[nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        double[][] xData = new double[nY1 * nY2][nX1];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int nX = xxData[i].length;
            if (nY != nX) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                xData[ii][i] = xxData[i][j];
                weight[ii] = wWeight[i][j];
                ++ii;
            }
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public Regression(double[] xxData, double[] yData, double[] weight) {
        this.nData0 = yData.length;
        int n = xxData.length;
        int m = weight.length;
        double[][] xData = new double[1][n];
        for (int i = 0; i < n; ++i) {
            xData[0][i] = xxData[i];
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(Conv.copy(xData), Conv.copy(yData), Conv.copy(weight));
    }

    public Regression(double[] xxData, double[][] yyData, double[][] wWeight) {
        int j;
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        double[] yData = new double[nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                weight[ii] = wWeight[i][j];
                ++ii;
            }
        }
        int n = xxData.length;
        if (n != nY2) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] xData = new double[1][nY1 * n];
        ii = 0;
        for (j = 0; j < nY1; ++j) {
            for (int i = 0; i < n; ++i) {
                xData[0][ii] = xxData[i];
                ++ii;
            }
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public Regression(double[][] xData, double[] yData) {
        this.nData0 = yData.length;
        int n = yData.length;
        double[] weight = new double[n];
        this.weightOpt = false;
        this.weightFlag = 0;
        for (int i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.setDefaultValues(Conv.copy(xData), Conv.copy(yData), weight);
    }

    public Regression(double[][] xxData, double[][] yyData) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        int nX1 = xxData.length;
        int nX2 = xxData[0].length;
        double[] yData = new double[nY1 * nY2];
        if (nY1 != nX1) {
            throw new IllegalArgumentException("Multiple xData and yData arrays of different overall dimensions not supported");
        }
        double[][] xData = new double[1][nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int nX = xxData[i].length;
            if (nY != nX) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                xData[0][ii] = xxData[i][j];
                ++ii;
            }
        }
        int n = yData.length;
        double[] weight = new double[n];
        this.weightOpt = false;
        for (int i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public Regression(double[] xxData, double[] yData) {
        int i;
        this.nData0 = yData.length;
        int n = xxData.length;
        double[][] xData = new double[1][n];
        double[] weight = new double[n];
        for (i = 0; i < n; ++i) {
            xData[0][i] = xxData[i];
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        for (i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.setDefaultValues(xData, Conv.copy(yData), weight);
    }

    public Regression(double[] xxData, double[][] yyData) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        double[] yData = new double[nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                ++ii;
            }
        }
        double[][] xData = new double[1][nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        ii = 0;
        int n = xxData.length;
        for (int j = 0; j < nY1; ++j) {
            for (int i = 0; i < n; ++i) {
                xData[0][ii] = xxData[i];
                weight[ii] = 1.0;
                ++ii;
            }
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public Regression(double[] xxData, double binWidth, double binZero) {
        int n;
        double[][] data = Regression.histogramBins(Conv.copy(xxData), binWidth, binZero);
        this.nData0 = n = data[0].length;
        double[][] xData = new double[1][n];
        double[] yData = new double[n];
        double[] weight = new double[n];
        for (int i = 0; i < n; ++i) {
            xData[0][i] = data[0][i];
            yData[i] = data[1][i];
        }
        boolean flag = Regression.setTrueFreqWeights(yData, weight);
        if (flag) {
            this.trueFreq = true;
            this.weightOpt = true;
            this.weightFlag = 1;
        } else {
            this.trueFreq = false;
            this.weightOpt = false;
            this.weightFlag = 0;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public Regression(double[] xxData, double binWidth) {
        int n;
        double[][] data = Regression.histogramBins(Conv.copy(xxData), binWidth);
        this.nData0 = n = data[0].length;
        double[][] xData = new double[1][n];
        double[] yData = new double[n];
        double[] weight = new double[n];
        for (int i = 0; i < n; ++i) {
            xData[0][i] = data[0][i];
            yData[i] = data[1][i];
        }
        boolean flag = Regression.setTrueFreqWeights(yData, weight);
        if (flag) {
            this.trueFreq = true;
            this.weightOpt = true;
            this.weightFlag = 1;
        } else {
            this.trueFreq = false;
            this.weightOpt = false;
            this.weightFlag = 0;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    protected double[] checkForZeroWeights(double[] weight) {
        this.weightOpt = true;
        int nZeros = 0;
        int n = weight.length;
        for (int i = 0; i < n; ++i) {
            if (!(weight[i] <= 0.0)) continue;
            ++nZeros;
        }
        double perCentZeros = 100.0 * (double)nZeros / (double)n;
        if (perCentZeros > 40.0) {
            System.out.println(perCentZeros + "% of the weights are zero or less; all weights set to 1.0");
            for (int i = 0; i < n; ++i) {
                weight[i] = 1.0;
            }
            this.weightOpt = false;
        } else if (perCentZeros > 0.0) {
            for (int i = 0; i < n; ++i) {
                double ww;
                boolean test;
                int ii;
                if (!(weight[i] <= 0.0)) continue;
                if (i == 0) {
                    ii = 1;
                    test = true;
                    while (test) {
                        if (weight[ii] > 0.0) {
                            ww = weight[0];
                            weight[0] = weight[ii];
                            System.out.println("weight at point " + i + ", " + ww + ", replaced by " + weight[i]);
                            test = false;
                            continue;
                        }
                        ++ii;
                    }
                }
                if (i == n - 1) {
                    ii = n - 2;
                    test = true;
                    while (test) {
                        if (weight[ii] > 0.0) {
                            ww = weight[i];
                            weight[i] = weight[ii];
                            System.out.println("weight at point " + i + ", " + ww + ", replaced by " + weight[i]);
                            test = false;
                            continue;
                        }
                        --ii;
                    }
                }
                if (i <= 0 || i >= n - 2) continue;
                double lower = 0.0;
                double upper = 0.0;
                int ii2 = i - 1;
                boolean test2 = true;
                while (test2) {
                    if (weight[ii2] > 0.0) {
                        lower = weight[ii2];
                        test2 = false;
                        continue;
                    }
                    if (--ii2 != 0) continue;
                    test2 = false;
                }
                ii2 = i + 1;
                test2 = true;
                while (test2) {
                    if (weight[ii2] > 0.0) {
                        upper = weight[ii2];
                        test2 = false;
                        continue;
                    }
                    if (++ii2 != n - 1) continue;
                    test2 = false;
                }
                double ww2 = weight[i];
                weight[i] = lower == 0.0 ? upper : (upper == 0.0 ? lower : (lower + upper) / 2.0);
                System.out.println("weight at point " + i + ", " + ww2 + ", replaced by " + weight[i]);
            }
        }
        return weight;
    }

    public void enterData(double[][] xData, double[] yData, double[] weight) {
        int n = weight.length;
        this.nData0 = yData.length;
        this.weightOpt = true;
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[][] xxData, double[][] yyData, double[][] wWeight) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        int nX1 = xxData.length;
        int nX2 = xxData[0].length;
        double[] yData = new double[nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        double[][] xData = new double[nY1 * nY2][nX1];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int nX = xxData[i].length;
            if (nY != nX) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                xData[ii][i] = xxData[i][j];
                weight[ii] = wWeight[i][j];
                ++ii;
            }
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double[] yData, double[] weight) {
        this.nData0 = yData.length;
        int n = xxData.length;
        int m = weight.length;
        double[][] xData = new double[1][n];
        for (int i = 0; i < n; ++i) {
            xData[0][i] = xxData[i];
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double[][] yyData, double[][] wWeight) {
        int j;
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        double[] yData = new double[nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                weight[ii] = wWeight[i][j];
                ++ii;
            }
        }
        int n = xxData.length;
        if (n != nY2) {
            throw new IllegalArgumentException("x and y data lengths must be the same");
        }
        double[][] xData = new double[1][nY1 * n];
        ii = 0;
        for (j = 0; j < nY1; ++j) {
            for (int i = 0; i < n; ++i) {
                xData[0][ii] = xxData[i];
                ++ii;
            }
        }
        weight = this.checkForZeroWeights(weight);
        if (this.weightOpt) {
            this.weightFlag = 1;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[][] xData, double[] yData) {
        this.nData0 = yData.length;
        int n = yData.length;
        double[] weight = new double[n];
        this.weightOpt = false;
        for (int i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[][] xxData, double[][] yyData) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        int nX1 = xxData.length;
        int nX2 = xxData[0].length;
        double[] yData = new double[nY1 * nY2];
        double[][] xData = new double[nY1 * nY2][nX1];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            int nX = xxData[i].length;
            if (nY != nX) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length as the x array length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                xData[ii][i] = xxData[i][j];
                ++ii;
            }
        }
        int n = yData.length;
        double[] weight = new double[n];
        this.weightOpt = false;
        for (int i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double[] yData) {
        int i;
        this.nData0 = yData.length;
        int n = xxData.length;
        double[][] xData = new double[1][n];
        double[] weight = new double[n];
        for (i = 0; i < n; ++i) {
            xData[0][i] = xxData[i];
        }
        this.weightOpt = false;
        for (i = 0; i < n; ++i) {
            weight[i] = 1.0;
        }
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double[][] yyData) {
        int nY2;
        int nY1;
        this.multipleY = true;
        this.nYarrays = nY1 = yyData.length;
        this.nData0 = nY2 = yyData[0].length;
        double[] yData = new double[nY1 * nY2];
        int ii = 0;
        for (int i = 0; i < nY1; ++i) {
            int nY = yyData[i].length;
            if (nY != nY2) {
                throw new IllegalArgumentException("multiple y arrays must be of the same length");
            }
            for (int j = 0; j < nY2; ++j) {
                yData[ii] = yyData[i][j];
                ++ii;
            }
        }
        double[][] xData = new double[1][nY1 * nY2];
        double[] weight = new double[nY1 * nY2];
        ii = 0;
        int n = xxData.length;
        for (int j = 0; j < nY1; ++j) {
            for (int i = 0; i < n; ++i) {
                xData[0][ii] = xxData[i];
                weight[ii] = 1.0;
                ++ii;
            }
        }
        this.weightOpt = false;
        this.weightFlag = 0;
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double binWidth, double binZero) {
        int n;
        double[][] data = Regression.histogramBins(xxData, binWidth, binZero);
        this.nData0 = n = data[0].length;
        double[][] xData = new double[1][n];
        double[] yData = new double[n];
        double[] weight = new double[n];
        for (int i = 0; i < n; ++i) {
            xData[0][i] = data[0][i];
            yData[i] = data[1][i];
        }
        boolean flag = Regression.setTrueFreqWeights(yData, weight);
        if (flag) {
            this.trueFreq = true;
            this.weightOpt = true;
            this.weightFlag = 1;
        } else {
            this.trueFreq = false;
            this.weightOpt = false;
            this.weightFlag = 0;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    public void enterData(double[] xxData, double binWidth) {
        int n;
        double[][] data = Regression.histogramBins(xxData, binWidth);
        this.nData0 = n = data[0].length;
        double[][] xData = new double[1][n];
        double[] yData = new double[n];
        double[] weight = new double[n];
        for (int i = 0; i < n; ++i) {
            xData[0][i] = data[0][i];
            yData[i] = data[1][i];
        }
        boolean flag = Regression.setTrueFreqWeights(yData, weight);
        if (flag) {
            this.trueFreq = true;
            this.weightOpt = true;
            this.weightFlag = 0;
        } else {
            this.trueFreq = false;
            this.weightOpt = false;
            this.weightFlag = 0;
        }
        this.setDefaultValues(xData, yData, weight);
    }

    protected static boolean setTrueFreqWeights(double[] yData, double[] weight) {
        int ii;
        int nData = yData.length;
        boolean flag = true;
        boolean unityWeight = false;
        for (ii = 0; ii < nData; ++ii) {
            weight[ii] = Math.sqrt(Math.abs(yData[ii]));
        }
        for (ii = 0; ii < nData; ++ii) {
            double last = 0.0;
            double next = 0.0;
            if (weight[ii] != 0.0) continue;
            boolean testLast = true;
            int iLast = ii - 1;
            while (testLast) {
                if (iLast < 0) {
                    testLast = false;
                    continue;
                }
                if (weight[iLast] == 0.0) {
                    --iLast;
                    continue;
                }
                last = weight[iLast];
                testLast = false;
            }
            boolean testNext = true;
            int iNext = ii + 1;
            while (testNext) {
                if (iNext >= nData) {
                    testNext = false;
                    continue;
                }
                if (weight[iNext] == 0.0) {
                    ++iNext;
                    continue;
                }
                next = weight[iNext];
                testNext = false;
            }
            weight[ii] = (last + next) / 2.0;
        }
        return flag;
    }

    protected void setDefaultValues(double[][] xData, double[] yData, double[] weight) {
        int i;
        this.nData = yData.length;
        this.nParam = this.nXarrays = xData.length;
        this.yData = new double[this.nData];
        this.yCalc = new double[this.nData];
        this.weight = new double[this.nData];
        this.residual = new double[this.nData];
        this.residualW = new double[this.nData];
        this.xData = new double[this.nXarrays][this.nData];
        int n = weight.length;
        if (n != this.nData) {
            throw new IllegalArgumentException("The weight and the y data lengths do not agree");
        }
        for (i = 0; i < this.nData; ++i) {
            this.yData[i] = yData[i];
            this.weight[i] = weight[i];
        }
        for (int j = 0; j < this.nXarrays; ++j) {
            n = xData[j].length;
            if (n != this.nData) {
                throw new IllegalArgumentException("An x [" + j + "] length " + n + " and the y data length, " + this.nData + ", do not agree");
            }
            for (int i2 = 0; i2 < this.nData; ++i2) {
                this.xData[j][i2] = xData[j][i2];
            }
        }
        this.minimumY = this.yData[0];
        this.minimumYindex = 0.0;
        this.maximumY = this.yData[0];
        this.maximumYindex = 0.0;
        for (i = 0; i < this.nData; ++i) {
            if (this.yData[i] < this.minimumY) {
                this.minimumY = this.yData[i];
                this.minimumYindex = i;
            }
            if (!(this.yData[i] > this.maximumY)) continue;
            this.maximumY = this.yData[i];
            this.maximumYindex = i;
        }
    }

    private void reassessFtol() {
        double meanExp = Math.pow(10.0, Math.floor(Math.log10((this.minimumY + this.maximumY) / 2.0)));
        double fTolnew = meanExp * this.fTol;
        if (fTolnew < this.fTol) {
            this.fTol = fTolnew;
        }
    }

    public static void setDenominatorToN() {
        Stat.setStaticDenominatorToN();
    }

    public static void setDenominatorToNminusOne() {
        Stat.setStaticDenominatorToNminusOne();
    }

    public static void resetCFmaxIter(int cfMaxIter) {
        Stat.resetCFmaxIter(cfMaxIter);
    }

    public static int getCFmaxIter() {
        return Stat.getCFmaxIter();
    }

    public static void resetCFtolerance(double cfTol) {
        Stat.resetCFtolerance(cfTol);
    }

    public static double getCFtolerance() {
        return Stat.getCFtolerance();
    }

    public void supressPrint() {
        this.supressPrint = true;
    }

    public void supressYYplot() {
        this.supressYYplot = true;
    }

    public void supressErrorMessages() {
        this.supressErrorMessages = true;
    }

    public void ignoreDofFcheck() {
        this.ignoreDofFcheck = true;
    }

    public void supressStats() {
        this.statFlag = false;
    }

    public void reinstateStats() {
        this.statFlag = true;
    }

    public void setCloseChoice(int closeChoice) {
        switch (closeChoice) {
            case 1: {
                this.plotWindowCloseChoice = false;
                break;
            }
            case 2: {
                this.plotWindowCloseChoice = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Option " + closeChoice + " not recognised");
            }
        }
    }

    public void setYscaleOption(boolean flag) {
        this.scaleFlag = flag;
        if (!flag) {
            this.yScaleFactor = 1.0;
        }
    }

    public void setYscale(boolean flag) {
        this.scaleFlag = flag;
        if (!flag) {
            this.yScaleFactor = 1.0;
        }
    }

    public void setYscaleFactor(double scale) {
        this.scaleFlag = false;
        this.yScaleFactor = scale;
    }

    public boolean getYscaleOption() {
        return this.scaleFlag;
    }

    public boolean getYscale() {
        return this.scaleFlag;
    }

    public void setTrueFreq(boolean trFr) {
        boolean trFrOld = this.trueFreq;
        this.trueFreq = trFr;
        if (trFr) {
            boolean flag = Regression.setTrueFreqWeights(this.yData, this.weight);
            if (flag) {
                this.trueFreq = true;
                this.weightOpt = true;
            } else {
                this.trueFreq = false;
                this.weightOpt = false;
            }
        } else if (trFrOld) {
            for (int i = 0; i < this.weight.length; ++i) {
                this.weight[i] = 1.0;
            }
            this.weightOpt = false;
        }
    }

    public boolean getTrueFreq() {
        return this.trueFreq;
    }

    public void setXlegend(String legend) {
        this.xLegend = legend;
        this.legendCheck = true;
    }

    public void setYlegend(String legend) {
        this.yLegend = legend;
        this.legendCheck = true;
    }

    public void setTitle(String title) {
        this.graphTitle = title;
    }

    public void constant() {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 46;
        this.linNonLin = true;
        this.nParam = 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.best[0] = Stat.mean(this.yData, this.weight);
        this.bestSd[0] = Stat.standardDeviation(this.yData, this.weight);
        this.tValues[0] = this.best[0] / this.bestSd[0];
        double atv = Math.abs(this.tValues[0]);
        this.pValues[0] = atv != atv ? Double.NaN : 1.0 - Stat.studentTcdf(-atv, atv, this.degreesOfFreedom);
        this.sumOfSquaresError = 0.0;
        this.chiSquare = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            this.yCalc[i] = this.best[0];
            this.residual[i] = this.yCalc[i] - this.yData[i];
            this.residualW[i] = this.residual[i] / this.weight[i];
            this.sumOfSquaresError += this.residual[i] * this.residual[i];
            this.chiSquare += this.residualW[i] * this.residualW[i];
        }
        this.reducedChiSquare = this.chiSquare / (double)this.degreesOfFreedom;
        this.calcDurbinWatson();
    }

    public void constantPlot(String xLegend, String yLegend) {
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        this.constant();
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY();
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void constantPlot() {
        this.constant();
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY();
        }
    }

    public void linear() {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 0;
        this.linNonLin = true;
        this.nParam = this.nXarrays + 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        double[][] aa = new double[this.nParam][this.nData];
        for (int j = 0; j < this.nData; ++j) {
            aa[0][j] = 1.0;
        }
        for (int i = 1; i < this.nParam; ++i) {
            for (int j = 0; j < this.nData; ++j) {
                aa[i][j] = this.xData[i - 1][j];
            }
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(aa);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(aa);
        }
    }

    public void linearPlot(String xLegend, String yLegend) {
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        this.linear();
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY();
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void linearPlot() {
        this.linear();
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY();
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void linear(double intercept) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 47;
        this.fixedInterceptL = intercept;
        this.linNonLin = true;
        this.nParam = this.nXarrays;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        double[][] aa = new double[this.nParam][this.nData];
        int j = 0;
        while (j < this.nData) {
            int n = j++;
            this.yData[n] = this.yData[n] - intercept;
        }
        for (int i = 0; i < this.nParam; ++i) {
            for (int j2 = 0; j2 < this.nData; ++j2) {
                aa[i][j2] = this.xData[i][j2];
            }
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(aa);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(aa);
        }
        j = 0;
        while (j < this.nData) {
            int n = j;
            this.yData[n] = this.yData[n] + intercept;
            int n2 = j++;
            this.yCalc[n2] = this.yCalc[n2] + intercept;
        }
    }

    public void linearPlot(double intercept, String xLegend, String yLegend) {
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        this.linear(intercept);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY();
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void linearPlot(double intercept) {
        this.linear(intercept);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY();
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void polynomial(int deg) {
        int j;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        if (deg < 1) {
            throw new IllegalArgumentException("Polynomial degree must be greater than zero");
        }
        this.lastMethod = 1;
        this.linNonLin = true;
        this.nParam = deg + 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        double[][] aa = new double[this.nParam][this.nData];
        for (j = 0; j < this.nData; ++j) {
            aa[0][j] = 1.0;
        }
        for (j = 0; j < this.nData; ++j) {
            aa[1][j] = this.xData[0][j];
        }
        for (int i = 2; i < this.nParam; ++i) {
            for (int j2 = 0; j2 < this.nData; ++j2) {
                aa[i][j2] = Math.pow(this.xData[0][j2], i);
            }
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(aa);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(aa);
        }
    }

    public void polynomialPlot(int n, String xLegend, String yLegend) {
        int flag;
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        this.polynomial(n);
        if (!this.supressPrint) {
            this.print();
        }
        if ((flag = this.plotXY()) != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void polynomialPlot(int n) {
        int flag;
        this.polynomial(n);
        if (!this.supressPrint) {
            this.print();
        }
        if ((flag = this.plotXY()) != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void polynomial(int deg, double intercept) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        if (deg < 1) {
            throw new IllegalArgumentException("Polynomial degree must be greater than zero");
        }
        this.lastMethod = 48;
        this.fixedInterceptP = intercept;
        this.linNonLin = true;
        this.nParam = deg;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        double[][] aa = new double[this.nParam][this.nData];
        int j = 0;
        while (j < this.nData) {
            int n = j++;
            this.yData[n] = this.yData[n] - intercept;
        }
        for (j = 0; j < this.nData; ++j) {
            aa[0][j] = this.xData[0][j];
        }
        for (int i = 1; i < this.nParam; ++i) {
            for (int j2 = 0; j2 < this.nData; ++j2) {
                aa[i][j2] = Math.pow(this.xData[0][j2], i + 1);
            }
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(aa);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(aa);
        }
        j = 0;
        while (j < this.nData) {
            int n = j;
            this.yData[n] = this.yData[n] + intercept;
            int n2 = j++;
            this.yCalc[n2] = this.yCalc[n2] + intercept;
        }
    }

    public void polynomialPlot(int n, double intercept, String xLegend, String yLegend) {
        int flag;
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        this.polynomial(n, intercept);
        if (!this.supressPrint) {
            this.print();
        }
        if ((flag = this.plotXY()) != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void polynomialPlot(int n, double intercept) {
        int flag;
        this.polynomial(n, intercept);
        if (!this.supressPrint) {
            this.print();
        }
        if ((flag = this.plotXY()) != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public ArrayList<Object> bestPolynomial() {
        return this.polynomialBest(0);
    }

    public ArrayList<Object> polynomialBest(int flag) {
        double chi;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        this.bestPolyFlag = true;
        this.linNonLin = true;
        ArrayList<Object> array0 = null;
        ArrayList<Double> array1 = new ArrayList<Double>();
        int deg = 0;
        int degBest = 0;
        int degMax = this.nData - 2;
        int nComp = 0;
        double fRatio = 0.0;
        double fProb = 0.0;
        double fSign = 0.0;
        boolean test0 = true;
        Regression reg = new Regression(this.xData[0], this.yData);
        reg.constant();
        double chiLast = chi = reg.getChiSquare();
        if (++deg > degMax) {
            test0 = false;
            System.out.println("Method bestPolynomial requires at least three data points: null  returned");
            return null;
        }
        reg.linear();
        chi = reg.getChiSquare();
        array0 = Regression.testOfAdditionalTerms_ArrayList(chiLast, 0, chi, 1, this.nData, this.fProbSignificance);
        ++nComp;
        fRatio = (Double)array0.get(0);
        fProb = (Double)array0.get(1);
        fSign = (Double)array0.get(8);
        array1.add(new Double(chiLast));
        array1.add(new Double(chi));
        array1.add(new Double(fRatio));
        array1.add(new Double(fProb));
        array1.add(new Double(fSign));
        if (fRatio < fSign) {
            test0 = false;
            degBest = 0;
        }
        if (++deg > degMax) {
            test0 = false;
        }
        while (test0) {
            chiLast = chi;
            reg.polynomial(deg);
            chi = reg.getChiSquare();
            array0 = Regression.testOfAdditionalTerms_ArrayList(chiLast, deg - 1, chi, deg, this.nData, this.fProbSignificance);
            ++nComp;
            fRatio = (Double)array0.get(0);
            fProb = (Double)array0.get(1);
            fSign = (Double)array0.get(8);
            array1.add(new Double(chiLast));
            array1.add(new Double(chi));
            array1.add(new Double(fRatio));
            array1.add(new Double(fProb));
            array1.add(new Double(fSign));
            if (fRatio < fSign) {
                test0 = false;
                degBest = deg - 1;
            }
            if (++deg <= degMax) continue;
            test0 = false;
        }
        this.bestPolynomialDegree = degBest;
        int[] deg0s = new int[nComp];
        int[] deg1s = new int[nComp];
        double[] chi0s = new double[nComp];
        double[] chi1s = new double[nComp];
        double[] fRatios = new double[nComp];
        double[] fProbs = new double[nComp];
        double[] fSigns = new double[nComp];
        for (int i = 0; i < nComp; ++i) {
            deg0s[i] = i;
            deg1s[i] = i + 1;
            chi0s[i] = (Double)array1.get(5 * i);
            chi1s[i] = (Double)array1.get(5 * i + 1);
            fRatios[i] = (Double)array1.get(5 * i + 2);
            fProbs[i] = (Double)array1.get(5 * i + 3);
            fSigns[i] = (Double)array1.get(5 * i + 4);
        }
        this.bestPolyArray.clear();
        this.bestPolyArray.add(new Integer(this.bestPolynomialDegree));
        this.bestPolyArray.add(new Integer(nComp));
        this.bestPolyArray.add(deg0s);
        this.bestPolyArray.add(deg1s);
        this.bestPolyArray.add(chi0s);
        this.bestPolyArray.add(chi1s);
        this.bestPolyArray.add(fRatios);
        this.bestPolyArray.add(fProbs);
        this.bestPolyArray.add(fSigns);
        this.bestPolyArray.add(this.fProbSignificance);
        boolean testZero = true;
        int ii = 0;
        while (testZero) {
            if (chi0s[ii] == 0.0) {
                this.bestPolynomialDegree = ii;
                testZero = false;
                continue;
            }
            if (++ii < nComp) continue;
            testZero = false;
        }
        block0 : switch (flag) {
            case 0: {
                switch (this.bestPolynomialDegree) {
                    case 0: {
                        this.constant();
                        break block0;
                    }
                    case 1: {
                        this.linear();
                        break block0;
                    }
                }
                this.polynomial(this.bestPolynomialDegree);
                break;
            }
            case 1: {
                switch (this.bestPolynomialDegree) {
                    case 0: {
                        this.constantPlot();
                        break block0;
                    }
                    case 1: {
                        this.linearPlot();
                        break block0;
                    }
                }
                this.polynomialPlot(this.bestPolynomialDegree);
            }
        }
        return this.bestPolyArray;
    }

    public ArrayList<Object> bestPolynomialPlot(String xLegend, String yLegend) {
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        return this.polynomialBest(1);
    }

    public ArrayList<Object> bestPolynomialPlot() {
        return this.polynomialBest(1);
    }

    public ArrayList<Object> bestPolynomial(double fixedIntercept) {
        this.fixedInterceptP = fixedIntercept;
        return this.polynomialBest(fixedIntercept, 0);
    }

    public ArrayList<Object> polynomialBest(double intercept, int flag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        if (this.nXarrays > 1) {
            throw new IllegalArgumentException("This class will only perform a polynomial regression on a single x array");
        }
        this.bestPolyFlag = true;
        this.linNonLin = true;
        ArrayList<Object> array0 = null;
        ArrayList<Double> array1 = new ArrayList<Double>();
        int deg = 1;
        int degBest = 1;
        int degMax = this.nData - 2;
        int nComp = 0;
        double fRatio = 0.0;
        double fProb = 0.0;
        double fSign = 0.0;
        boolean test0 = true;
        Regression reg = new Regression(this.xData[0], this.yData);
        double chi = 0.0;
        double chiLast = 0.0;
        if (deg > degMax) {
            test0 = false;
            System.out.println("Method bestPolynomial requires at least three data points: null  returned");
            return null;
        }
        reg.linear(intercept);
        chi = reg.getChiSquare();
        if (++deg > degMax) {
            test0 = false;
        }
        if (!test0 && degBest == 0) {
            degBest = 1;
        }
        while (test0) {
            chiLast = chi;
            reg.polynomial(deg, intercept);
            chi = reg.getChiSquare();
            array0 = Regression.testOfAdditionalTerms_ArrayList(chiLast, deg - 1, chi, deg, this.nData, this.fProbSignificance);
            ++nComp;
            fRatio = (Double)array0.get(0);
            fProb = (Double)array0.get(1);
            fSign = (Double)array0.get(8);
            array1.add(new Double(chiLast));
            array1.add(new Double(chi));
            array1.add(new Double(fRatio));
            array1.add(new Double(fProb));
            array1.add(new Double(fSign));
            if (fRatio < fSign) {
                test0 = false;
                degBest = deg - 1;
            }
            if (++deg <= degMax) continue;
            test0 = false;
        }
        this.bestPolynomialDegree = degBest;
        int[] deg0s = new int[nComp];
        int[] deg1s = new int[nComp];
        double[] chi0s = new double[nComp];
        double[] chi1s = new double[nComp];
        double[] fRatios = new double[nComp];
        double[] fProbs = new double[nComp];
        double[] fSigns = new double[nComp];
        for (int i = 0; i < nComp; ++i) {
            deg0s[i] = i + 1;
            deg1s[i] = i + 2;
            chi0s[i] = (Double)array1.get(5 * i);
            chi1s[i] = (Double)array1.get(5 * i + 1);
            fRatios[i] = (Double)array1.get(5 * i + 2);
            fProbs[i] = (Double)array1.get(5 * i + 3);
            fSigns[i] = (Double)array1.get(5 * i + 4);
        }
        this.bestPolyArray.clear();
        this.bestPolyArray.add(new Integer(this.bestPolynomialDegree));
        this.bestPolyArray.add(new Integer(nComp));
        this.bestPolyArray.add(deg0s);
        this.bestPolyArray.add(deg1s);
        this.bestPolyArray.add(chi0s);
        this.bestPolyArray.add(chi1s);
        this.bestPolyArray.add(fRatios);
        this.bestPolyArray.add(fProbs);
        this.bestPolyArray.add(fSigns);
        this.bestPolyArray.add(this.fProbSignificance);
        boolean testZero = true;
        int ii = 0;
        while (testZero) {
            if (chi0s[ii] == 0.0) {
                this.bestPolynomialDegree = ii + 1;
                testZero = false;
                continue;
            }
            if (++ii < nComp) continue;
            testZero = false;
        }
        block0 : switch (flag) {
            case 0: {
                switch (this.bestPolynomialDegree) {
                    case 1: {
                        this.linear(intercept);
                        break block0;
                    }
                }
                this.polynomial(this.bestPolynomialDegree, intercept);
                break;
            }
            case 1: {
                switch (this.bestPolynomialDegree) {
                    case 1: {
                        this.linearPlot(intercept);
                        break block0;
                    }
                }
                this.polynomialPlot(this.bestPolynomialDegree, intercept);
            }
        }
        return this.bestPolyArray;
    }

    public ArrayList<Object> bestPolynomialPlot(double fixedIntercept, String xLegend, String yLegend) {
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        return this.polynomialBest(fixedIntercept, 1);
    }

    public ArrayList<Object> bestPolynomialPlot(double fixedIntercept) {
        return this.polynomialBest(fixedIntercept, 1);
    }

    public void setFtestSignificance(double signif) {
        this.fProbSignificance = signif;
    }

    public double getFtestSignificance(double signif) {
        return this.fProbSignificance;
    }

    public void nonIntegerPolynomial(int nTerms) {
        this.fitNonIntegerPolynomial(nTerms, 0);
    }

    public void nonIntegerPolynomial() {
        this.fitNonIntegerPolynomial(3, 0);
    }

    public void nonIntegerPolynomialPlot(int nTerms) {
        this.fitNonIntegerPolynomial(nTerms, 1);
    }

    public void nonIntegerPolynomialPlot() {
        this.fitNonIntegerPolynomial(3, 1);
    }

    public void nonIntegerPolynomialPlot(int nTerms, String xLegend, String yLegend) {
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        this.fitNonIntegerPolynomial(nTerms, 1);
    }

    public void nonIntegerPolynomialPlot(String xLegend, String yLegend) {
        this.xLegend = xLegend;
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        this.fitNonIntegerPolynomial(3, 1);
    }

    protected void fitNonIntegerPolynomial(int nTerms, int plotFlag) {
        int i;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 50;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        int deg = nTerms - 1;
        this.nParam = 2 * nTerms - 1;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Regression reg = new Regression(this.xData[0], this.yData, this.weight);
        reg.polynomial(deg);
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        double[] best = reg.getBestEstimates();
        double sum = 0.0;
        for (i = 0; i < nTerms; ++i) {
            start[i] = best[i];
            sum += start[i];
        }
        sum /= (double)nTerms;
        for (i = 0; i < nTerms; ++i) {
            step[i] = start[i] * 0.1;
            if (step[i] != 0.0) continue;
            step[i] = 0.1 * sum;
        }
        double ii = 1.0;
        for (int i2 = nTerms; i2 < this.nParam; ++i2) {
            start[i2] = ii;
            step[i2] = start[i2] * 0.1;
            ii += 1.0;
        }
        NonIntegerPolyFunction f = new NonIntegerPolyFunction();
        f.setNterms(nTerms);
        NonIntegerPolyFunction regFun = f;
        this.nelderMead(regFun, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void linearGeneral() {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 2;
        this.linNonLin = true;
        this.nParam = this.nXarrays;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        this.best = new double[this.nParam];
        this.bestSd = new double[this.nParam];
        this.tValues = new double[this.nParam];
        this.pValues = new double[this.nParam];
        this.generalLinear(this.xData);
        if (!this.ignoreDofFcheck) {
            this.generalLinearStats(this.xData);
        }
    }

    public void linearGeneralPlot(String xLegend, String yLegend) {
        this.xLegend = xLegend;
        this.yLegend = yLegend;
        this.legendCheck = true;
        this.linearGeneral();
        if (!this.supressPrint) {
            this.print();
        }
        if (!this.supressYYplot) {
            this.plotYY();
        }
    }

    public void linearGeneralPlot() {
        this.linearGeneral();
        if (!this.supressPrint) {
            this.print();
        }
        if (!this.supressYYplot) {
            this.plotYY();
        }
    }

    protected void generalLinear(double[][] xd) {
        int j;
        int i;
        if (this.nData <= this.nParam && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Number of unknown parameters is greater than or equal to the number of data points");
        }
        double sde = 0.0;
        double sum = 0.0;
        double yCalctemp = 0.0;
        double[][] a = new double[this.nParam][this.nParam];
        double[][] h = new double[this.nParam][this.nParam];
        double[] b = new double[this.nParam];
        double[] coeff = new double[this.nParam];
        if (this.ignoreDofFcheck) {
            this.bestSd = new double[this.nParam];
            this.pseudoSd = new double[this.nParam];
            this.tValues = new double[this.nParam];
            this.pValues = new double[this.nParam];
            this.covar = new double[this.nParam][this.nParam];
            this.corrCoeff = new double[this.nParam][this.nParam];
            for (i = 0; i < this.nParam; ++i) {
                this.bestSd[i] = Double.NaN;
                this.pseudoSd[i] = Double.NaN;
                for (j = 0; j < this.nParam; ++j) {
                    this.covar[i][j] = Double.NaN;
                    this.corrCoeff[i][j] = Double.NaN;
                }
            }
        }
        for (i = 0; i < this.nParam; ++i) {
            sum = 0.0;
            for (j = 0; j < this.nData; ++j) {
                sum += this.yData[j] * xd[i][j] / Fmath.square(this.weight[j]);
            }
            b[i] = sum;
        }
        for (i = 0; i < this.nParam; ++i) {
            for (j = 0; j < this.nParam; ++j) {
                sum = 0.0;
                for (int k = 0; k < this.nData; ++k) {
                    sum += xd[i][k] * xd[j][k] / Fmath.square(this.weight[k]);
                }
                a[j][i] = sum;
            }
        }
        Matrix aa = new Matrix(a);
        if (this.supressErrorMessages) {
            aa.supressErrorMessage();
        }
        coeff = aa.solveLinearSet(b);
        for (int i2 = 0; i2 < this.nParam; ++i2) {
            this.best[i2] = coeff[i2];
        }
    }

    protected void generalLinearStats(double[][] xd) {
        int j;
        int i;
        int i2;
        double sde = 0.0;
        double sum = 0.0;
        double yCalctemp = 0.0;
        double[][] a = new double[this.nParam][this.nParam];
        double[][] h = new double[this.nParam][this.nParam];
        double[][] stat = new double[this.nParam][this.nParam];
        double[][] cov = new double[this.nParam][this.nParam];
        this.covar = new double[this.nParam][this.nParam];
        this.corrCoeff = new double[this.nParam][this.nParam];
        double[] coeffSd = new double[this.nParam];
        double[] coeff = new double[this.nParam];
        for (i2 = 0; i2 < this.nParam; ++i2) {
            coeff[i2] = this.best[i2];
        }
        this.chiSquare = 0.0;
        this.sumOfSquaresError = 0.0;
        for (i2 = 0; i2 < this.nData; ++i2) {
            yCalctemp = 0.0;
            for (int j2 = 0; j2 < this.nParam; ++j2) {
                yCalctemp += coeff[j2] * xd[j2][i2];
            }
            this.yCalc[i2] = yCalctemp;
            this.residual[i2] = yCalctemp -= this.yData[i2];
            this.residualW[i2] = yCalctemp / this.weight[i2];
            this.chiSquare += Fmath.square(yCalctemp / this.weight[i2]);
            this.sumOfSquaresError += Fmath.square(yCalctemp);
        }
        this.reducedChiSquare = this.chiSquare / (double)this.degreesOfFreedom;
        double varY = this.sumOfSquaresError / (double)this.degreesOfFreedom;
        double sdY = Math.sqrt(varY);
        if (this.sumOfSquaresError == 0.0) {
            for (i = 0; i < this.nParam; ++i) {
                coeffSd[i] = 0.0;
                for (j = 0; j < this.nParam; ++j) {
                    this.covar[i][j] = 0.0;
                    this.corrCoeff[i][j] = i == j ? 1.0 : 0.0;
                }
            }
        } else {
            int j3;
            int i3;
            for (int i4 = 0; i4 < this.nParam; ++i4) {
                for (j = 0; j < this.nParam; ++j) {
                    sum = 0.0;
                    for (int k = 0; k < this.nData; ++k) {
                        sde = this.weightOpt ? this.weight[k] : sdY;
                        sum += xd[i4][k] * xd[j][k] / Fmath.square(sde);
                    }
                    h[j][i4] = sum;
                }
            }
            Matrix hh = new Matrix(h);
            if (this.supressErrorMessages) {
                hh.supressErrorMessage();
            }
            hh = hh.inverse();
            stat = hh.getArrayCopy();
            for (j = 0; j < this.nParam; ++j) {
                coeffSd[j] = Math.sqrt(stat[j][j]);
            }
            for (i3 = 0; i3 < this.nParam; ++i3) {
                for (j3 = 0; j3 < this.nParam; ++j3) {
                    this.covar[i3][j3] = stat[i3][j3];
                }
            }
            for (i3 = 0; i3 < this.nParam; ++i3) {
                for (j3 = 0; j3 < this.nParam; ++j3) {
                    this.corrCoeff[i3][j3] = i3 == j3 ? 1.0 : this.covar[i3][j3] / (coeffSd[i3] * coeffSd[j3]);
                }
            }
        }
        for (i = 0; i < this.nParam; ++i) {
            this.bestSd[i] = coeffSd[i];
            this.tValues[i] = this.best[i] / this.bestSd[i];
            double atv = Math.abs(this.tValues[i]);
            this.pValues[i] = atv != atv ? Double.NaN : 1.0 - Stat.studentTcdf(-atv, atv, this.degreesOfFreedom);
        }
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            this.xyR = Stat.corrCoeff(this.xData[0], this.yData, this.weight);
        }
        this.yyR = Stat.corrCoeff(this.yCalc, this.yData, this.weight);
        this.yMean = Stat.mean(this.yData);
        this.yWeightedMean = Stat.mean(this.yData, this.weight);
        this.sumOfSquaresTotal = 0.0;
        for (i = 0; i < this.nData; ++i) {
            this.sumOfSquaresTotal += Fmath.square((this.yData[i] - this.yWeightedMean) / this.weight[i]);
        }
        this.sumOfSquaresRegrn = this.sumOfSquaresTotal - this.chiSquare;
        if (this.sumOfSquaresRegrn < 0.0) {
            this.sumOfSquaresRegrn = 0.0;
        }
        this.multR = this.sumOfSquaresRegrn / this.sumOfSquaresTotal;
        this.adjustedR = Double.NaN;
        this.multipleF = Double.NaN;
        if (this.nData - this.nParam - 1 > 0) {
            this.adjustedR = 1.0 - (1.0 - this.multR) * (double)(this.nData - 1) / (double)(this.nData - this.nParam - 1);
        }
        this.multipleF = this.multR * ((double)(this.nData - this.nParam) - 1.0) / ((1.0 - this.multR) * (double)this.nParam);
        if (this.multipleF >= 0.0) {
            this.multipleFprob = Stat.fTestProb(this.multipleF, this.nXarrays, this.nData - this.nParam - 1);
        }
        this.calcDurbinWatson();
    }

    protected void nelderMead(Object regFun, double[] start, double[] step, double fTol, int nMax) {
        int i;
        int i2;
        int i3;
        int i4;
        int np = start.length;
        if (this.maxConstraintIndex >= np) {
            throw new IllegalArgumentException("You have entered more constrained parameters (" + this.maxConstraintIndex + ") than minimisation parameters (" + np + ")");
        }
        this.nlrStatus = true;
        this.nParam = np;
        int nnp = np + 1;
        this.lastSSnoConstraint = 0.0;
        if (this.scaleOpt < 2) {
            this.scale = new double[np];
        }
        if (this.scaleOpt == 2 && this.scale.length != start.length) {
            throw new IllegalArgumentException("scale array and initial estimate array are of different lengths");
        }
        if (step.length != start.length) {
            throw new IllegalArgumentException("step array length " + step.length + " and initial estimate array length " + start.length + " are of different");
        }
        for (i4 = 0; i4 < np; ++i4) {
            if (step[i4] != 0.0) continue;
            throw new IllegalArgumentException("step " + i4 + " size is zero");
        }
        if (this.minIter > this.nMax) {
            this.nMax = this.minIter;
        }
        if (this.ignoreDofFcheck) {
            this.bestSd = new double[this.nParam];
            this.pseudoSd = new double[this.nParam];
            this.tValues = new double[this.nParam];
            this.pValues = new double[this.nParam];
            this.covar = new double[this.nParam][this.nParam];
            this.corrCoeff = new double[this.nParam][this.nParam];
            for (i4 = 0; i4 < this.nParam; ++i4) {
                this.bestSd[i4] = Double.NaN;
                this.pseudoSd[i4] = Double.NaN;
                for (int j = 0; j < this.nParam; ++j) {
                    this.covar[i4][j] = Double.NaN;
                    this.corrCoeff[i4][j] = Double.NaN;
                }
            }
        }
        this.startH = new double[np];
        this.stepH = new double[np];
        this.startSH = new double[np];
        this.stepSH = new double[np];
        double[] pmin = new double[np];
        this.best = new double[np];
        this.bestSd = new double[np];
        this.tValues = new double[np];
        this.pValues = new double[np];
        double[][] pp = new double[nnp][nnp];
        double[] yy = new double[nnp];
        double[] pbar = new double[nnp];
        double[] pstar = new double[nnp];
        double[] p2star = new double[nnp];
        double yabsmean = 0.0;
        for (i3 = 0; i3 < this.nData; ++i3) {
            yabsmean += Math.abs(this.yData[i3]);
        }
        yabsmean /= (double)this.nData;
        if (this.penalty) {
            Integer itemp = (Integer)this.penalties.get(1);
            this.nConstraints = itemp;
            this.penaltyParam = new int[this.nConstraints];
            this.penaltyCheck = new int[this.nConstraints];
            this.constraints = new double[this.nConstraints];
            Double dtemp = null;
            int j = 2;
            for (i2 = 0; i2 < this.nConstraints; ++i2) {
                itemp = (Integer)this.penalties.get(j);
                this.penaltyParam[i2] = itemp;
                itemp = (Integer)this.penalties.get(++j);
                this.penaltyCheck[i2] = itemp;
                dtemp = (Double)this.penalties.get(++j);
                this.constraints[i2] = dtemp;
                ++j;
            }
        }
        if (this.sumPenalty) {
            Integer itemp = (Integer)this.sumPenalties.get(1);
            this.nSumConstraints = itemp;
            this.sumPenaltyParam = new int[this.nSumConstraints][];
            this.sumPlusOrMinus = new double[this.nSumConstraints][];
            this.sumPenaltyCheck = new int[this.nSumConstraints];
            this.sumPenaltyNumber = new int[this.nSumConstraints];
            this.sumConstraints = new double[this.nSumConstraints];
            int[] itempArray = null;
            double[] dtempArray = null;
            Double dtemp = null;
            int j = 2;
            for (int i5 = 0; i5 < this.nSumConstraints; ++i5) {
                itemp = (Integer)this.sumPenalties.get(j);
                this.sumPenaltyNumber[i5] = itemp;
                itempArray = (int[])this.sumPenalties.get(++j);
                this.sumPenaltyParam[i5] = itempArray;
                dtempArray = (double[])this.sumPenalties.get(++j);
                this.sumPlusOrMinus[i5] = dtempArray;
                itemp = (Integer)this.sumPenalties.get(++j);
                this.sumPenaltyCheck[i5] = itemp;
                dtemp = (Double)this.sumPenalties.get(++j);
                this.sumConstraints[i5] = dtemp;
                ++j;
            }
        }
        for (i3 = 0; i3 < np; ++i3) {
            step[i3] = Math.abs(step[i3]);
            this.startH[i3] = start[i3];
            this.stepH[i3] = step[i3];
        }
        if (this.scaleOpt > 0) {
            boolean testzero = false;
            for (int i6 = 0; i6 < np; ++i6) {
                if (start[i6] != 0.0) continue;
                testzero = true;
            }
            if (testzero) {
                System.out.println("Neler and Mead Simplex: a start value of zero precludes scaling");
                System.out.println("Regression performed without scaling");
                this.scaleOpt = 0;
            }
        }
        switch (this.scaleOpt) {
            case 0: {
                for (i3 = 0; i3 < np; ++i3) {
                    this.scale[i3] = 1.0;
                }
                break;
            }
            case 1: {
                for (i3 = 0; i3 < np; ++i3) {
                    this.scale[i3] = 1.0 / start[i3];
                    step[i3] = step[i3] / start[i3];
                    start[i3] = 1.0;
                }
                break;
            }
            case 2: {
                for (i3 = 0; i3 < np; ++i3) {
                    int n = i3;
                    step[n] = step[n] * this.scale[i3];
                    int n2 = i3;
                    start[n2] = start[n2] * this.scale[i3];
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Scaling factor option " + this.scaleOpt + " not recognised");
            }
        }
        this.fTol = fTol;
        this.nMax = nMax;
        this.nIter = 0;
        for (i3 = 0; i3 < np; ++i3) {
            this.startSH[i3] = start[i3];
            this.stepSH[i3] = step[i3];
            this.scale[i3] = this.scale[i3];
        }
        double sho = 0.0;
        for (int i7 = 0; i7 < np; ++i7) {
            pstar[i7] = sho = start[i7];
            p2star[i7] = sho;
            pmin[i7] = sho;
        }
        int jcount = this.konvge;
        for (i2 = 0; i2 < np; ++i2) {
            pp[i2][nnp - 1] = start[i2];
        }
        yy[nnp - 1] = this.sumSquares(regFun, start);
        for (int j = 0; j < np; ++j) {
            start[j] = start[j] + step[j];
            for (int i8 = 0; i8 < np; ++i8) {
                pp[i8][j] = start[i8];
            }
            yy[j] = this.sumSquares(regFun, start);
            start[j] = start[j] - step[j];
        }
        double ynewlo = 0.0;
        double ystar = 0.0;
        double y2star = 0.0;
        double ylo = 0.0;
        int ilo = 0;
        int ihi = 0;
        int ln = 0;
        boolean test = true;
        double curMin = 0.0;
        double sumnm = 0.0;
        double zn = 0.0;
        double summnm = 0.0;
        while (test) {
            int i9;
            int j;
            ynewlo = ylo = yy[0];
            ilo = 0;
            ihi = 0;
            for (i = 1; i < nnp; ++i) {
                if (yy[i] < ylo) {
                    ylo = yy[i];
                    ilo = i;
                }
                if (!(yy[i] > ynewlo)) continue;
                ynewlo = yy[i];
                ihi = i;
            }
            for (i = 0; i < np; ++i) {
                zn = 0.0;
                for (int j2 = 0; j2 < nnp; ++j2) {
                    zn += pp[i][j2];
                }
                pbar[i] = (zn -= pp[i][ihi]) / (double)np;
            }
            for (i = 0; i < np; ++i) {
                pstar[i] = (1.0 + this.rCoeff) * pbar[i] - this.rCoeff * pp[i][ihi];
            }
            ystar = this.sumSquares(regFun, pstar);
            ++this.nIter;
            if (ystar < ylo) {
                for (i = 0; i < np; ++i) {
                    p2star[i] = pstar[i] * (1.0 + this.eCoeff) - this.eCoeff * pbar[i];
                }
                y2star = this.sumSquares(regFun, p2star);
                ++this.nIter;
                if (y2star < ylo) {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = p2star[i];
                    }
                    yy[ihi] = y2star;
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            } else {
                ln = 0;
                for (i = 0; i < nnp; ++i) {
                    if (i == ihi || !(ystar > yy[i])) continue;
                    ++ln;
                }
                if (ln == np) {
                    if (ystar <= yy[ihi]) {
                        for (i = 0; i < np; ++i) {
                            pp[i][ihi] = pstar[i];
                        }
                        yy[ihi] = ystar;
                    }
                    for (i = 0; i < np; ++i) {
                        p2star[i] = this.cCoeff * pp[i][ihi] + (1.0 - this.cCoeff) * pbar[i];
                    }
                    y2star = this.sumSquares(regFun, p2star);
                    ++this.nIter;
                    if (y2star > yy[ihi]) {
                        for (j = 0; j < nnp; ++j) {
                            for (i9 = 0; i9 < np; ++i9) {
                                pp[i9][j] = 0.5 * (pp[i9][j] + pp[i9][ilo]);
                                pmin[i9] = pp[i9][j];
                            }
                            yy[j] = this.sumSquares(regFun, pmin);
                        }
                        this.nIter += nnp;
                    } else {
                        for (i = 0; i < np; ++i) {
                            pp[i][ihi] = p2star[i];
                        }
                        yy[ihi] = y2star;
                    }
                } else {
                    for (i = 0; i < np; ++i) {
                        pp[i][ihi] = pstar[i];
                    }
                    yy[ihi] = ystar;
                }
            }
            sumnm = 0.0;
            ynewlo = yy[0];
            ilo = 0;
            for (i = 0; i < nnp; ++i) {
                sumnm += yy[i];
                if (!(ynewlo > yy[i])) continue;
                ynewlo = yy[i];
                ilo = i;
            }
            sumnm /= (double)nnp;
            summnm = 0.0;
            for (i = 0; i < nnp; ++i) {
                zn = yy[i] - sumnm;
                summnm += zn * zn;
            }
            curMin = Math.sqrt(summnm / (double)np);
            switch (this.minTest) {
                case 0: {
                    if (!(curMin < fTol) || this.nIter <= this.minIter) break;
                    test = false;
                    break;
                }
                case 1: {
                    if (!(Math.sqrt(ynewlo / (double)this.degreesOfFreedom) < yabsmean * fTol) || this.nIter <= this.minIter) break;
                    test = false;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Simplex standard deviation test option " + this.minTest + " not recognised");
                }
            }
            this.sumOfSquaresError = ynewlo;
            if (!test) {
                for (i = 0; i < np; ++i) {
                    pmin[i] = pp[i][ilo];
                }
                yy[nnp - 1] = ynewlo;
                this.simplexSd = curMin;
                if (--jcount > 0) {
                    test = true;
                    for (j = 0; j < np; ++j) {
                        pmin[j] = pmin[j] + step[j];
                        for (i9 = 0; i9 < np; ++i9) {
                            pp[i9][j] = pmin[i9];
                        }
                        yy[j] = this.sumSquares(regFun, pmin);
                        pmin[j] = pmin[j] - step[j];
                    }
                }
            }
            if (!test || this.nIter <= this.nMax) continue;
            if (!this.supressErrorMessages) {
                System.out.println("Maximum iteration number reached, in Regression.simplex(...)");
                System.out.println("without the convergence criterion being satisfied");
                System.out.println("Current parameter estimates and sum of squares values returned");
            }
            this.nlrStatus = false;
            for (i = 0; i < np; ++i) {
                pmin[i] = pp[i][ilo];
            }
            yy[nnp - 1] = ynewlo;
            test = false;
        }
        for (i = 0; i < np; ++i) {
            pmin[i] = pp[i][ilo];
            this.best[i] = pmin[i] / this.scale[i];
            this.scale[i] = 1.0;
        }
        this.fMin = ynewlo;
        this.kRestart = this.konvge - jcount;
        if (this.statFlag) {
            if (!this.ignoreDofFcheck) {
                this.pseudoLinearStats(regFun);
            }
        } else {
            for (i = 0; i < np; ++i) {
                this.bestSd[i] = Double.NaN;
            }
        }
    }

    public void simplex(RegressionFunction g, double[] start, double[] step, double fTol, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        RegressionFunction regFun = g;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMax);
    }

    public void simplexPlot(RegressionFunction g, double[] start, double[] step, double fTol, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplexPlot2 should have been called");
        }
        RegressionFunction regFun = g;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMax);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex(RegressionFunction g, double[] start, double[] step, double fTol) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        RegressionFunction regFun = g;
        int nMaxx = this.nMax;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMaxx);
    }

    public void simplexPlot(RegressionFunction g, double[] start, double[] step, double fTol) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplexPlot2 should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex(g, start, step, fTol);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex(RegressionFunction g, double[] start, double[] step, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        RegressionFunction regFun = g;
        double fToll = this.fTol;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMax);
    }

    public void simplexPlot(RegressionFunction g, double[] start, double[] step, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplexPlot2 should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex(g, start, step, nMax);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex(RegressionFunction g, double[] start, double[] step) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        RegressionFunction regFun = g;
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMaxx);
    }

    public void simplexPlot(RegressionFunction g, double[] start, double[] step) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplexPlot2 should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex(g, start, step);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex(RegressionFunction g, double[] start, double fTol, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        RegressionFunction regFun = g;
        int n = start.length;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMax);
    }

    public void simplexPlot(RegressionFunction g, double[] start, double fTol, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplexPlot2 should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex(g, start, fTol, nMax);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex(RegressionFunction g, double[] start, double fTol) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        RegressionFunction regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMaxx);
    }

    public void simplexPlot(RegressionFunction g, double[] start, double fTol) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplexPlot2 should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex(g, start, fTol);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex(RegressionFunction g, double[] start, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        RegressionFunction regFun = g;
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMax);
    }

    public void simplexPlot(RegressionFunction g, double[] start, int nMax) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplexPlot2 should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex(g, start, nMax);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex(RegressionFunction g, double[] start) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplex2 should have been called");
        }
        RegressionFunction regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMaxx);
    }

    public void simplexPlot(RegressionFunction g, double[] start) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays\nsimplexPlot2 should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex(g, start);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex2(RegressionFunction2 g, double[] start, double[] step, double fTol, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMax);
    }

    public void simplexPlot2(RegressionFunction2 g, double[] start, double[] step, double fTol, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMax);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY2(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex2(RegressionFunction2 g, double[] start, double[] step, double fTol) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        int nMaxx = this.nMax;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fTol, nMaxx);
    }

    public void simplexPlot2(RegressionFunction2 g, double[] start, double[] step, double fTol) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex2(g, start, step, fTol);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY2(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex2(RegressionFunction2 g, double[] start, double[] step, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        double fToll = this.fTol;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMax);
    }

    public void simplexPlot2(RegressionFunction2 g, double[] start, double[] step, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex2(g, start, step, nMax);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY2(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex2(RegressionFunction2 g, double[] start, double[] step) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        double fToll = this.fTol;
        int nMaxx = this.nMax;
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, step, fToll, nMaxx);
    }

    public void simplexPlot2(RegressionFunction2 g, double[] start, double[] step) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex2(g, start, step);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY2(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex2(RegressionFunction2 g, double[] start, double fTol, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        int n = start.length;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMax);
    }

    public void simplexPlot2(RegressionFunction2 g, double[] start, double fTol, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex2(g, start, fTol, nMax);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY2(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex2(RegressionFunction2 g, double[] start, double fTol) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fTol, nMaxx);
    }

    public void simplexPlot2(RegressionFunction2 g, double[] start, double fTol) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex2(g, start, fTol);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY2(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex2(RegressionFunction2 g, double[] start, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        int n = start.length;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMax);
    }

    public void simplexPlot2(RegressionFunction2 g, double[] start, int nMax) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex2(g, start, nMax);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY2(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    public void simplex2(RegressionFunction2 g, double[] start) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        RegressionFunction2 regFun = g;
        int n = start.length;
        int nMaxx = this.nMax;
        double fToll = this.fTol;
        double[] stepp = new double[n];
        for (int i = 0; i < n; ++i) {
            stepp[i] = this.dStep * start[i];
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - start.length;
        this.nelderMead(regFun, start, stepp, fToll, nMaxx);
    }

    public void simplexPlot2(RegressionFunction2 g, double[] start) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.lastMethod = 3;
        this.userSupplied = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.simplex2(g, start);
        if (!this.supressPrint) {
            this.print();
        }
        int flag = 0;
        if (this.xData.length < 2) {
            flag = this.plotXY2(g);
        }
        if (flag != -2 && !this.supressYYplot) {
            this.plotYY();
        }
    }

    protected double sumSquares(Object regFun, double[] x) {
        RegressionFunction g1 = null;
        RegressionFunction2 g2 = null;
        if (this.multipleY) {
            g2 = (RegressionFunction2)regFun;
        } else {
            g1 = (RegressionFunction)regFun;
        }
        double ss = -3.0;
        double[] param = new double[this.nParam];
        double[] xd = new double[this.nXarrays];
        for (int i = 0; i < this.nParam; ++i) {
            param[i] = x[i] / this.scale[i];
        }
        double tempFunctVal = this.lastSSnoConstraint;
        boolean test = true;
        if (this.penalty) {
            int k = 0;
            block11: for (int i = 0; i < this.nConstraints; ++i) {
                k = this.penaltyParam[i];
                switch (this.penaltyCheck[i]) {
                    case -1: {
                        if (!(param[k] < this.constraints[i])) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * Fmath.square(this.constraints[i] - param[k]);
                        test = false;
                        continue block11;
                    }
                    case 0: {
                        if (param[k] < this.constraints[i] * (1.0 - this.constraintTolerance)) {
                            ss = tempFunctVal + this.penaltyWeight * Fmath.square(this.constraints[i] * (1.0 - this.constraintTolerance) - param[k]);
                            test = false;
                        }
                        if (!(param[k] > this.constraints[i] * (1.0 + this.constraintTolerance))) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * Fmath.square(param[k] - this.constraints[i] * (1.0 + this.constraintTolerance));
                        test = false;
                        continue block11;
                    }
                    case 1: {
                        if (!(param[k] > this.constraints[i])) continue block11;
                        ss = tempFunctVal + this.penaltyWeight * Fmath.square(param[k] - this.constraints[i]);
                        test = false;
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("The " + i + "th penalty check " + this.penaltyCheck[i] + " not recognised");
                    }
                }
            }
        }
        if (this.sumPenalty) {
            int kk = 0;
            double pSign = 0.0;
            block12: for (int i = 0; i < this.nSumConstraints; ++i) {
                double sumPenaltySum = 0.0;
                for (int j = 0; j < this.sumPenaltyNumber[i]; ++j) {
                    kk = this.sumPenaltyParam[i][j];
                    pSign = this.sumPlusOrMinus[i][j];
                    sumPenaltySum += param[kk] * pSign;
                }
                switch (this.sumPenaltyCheck[i]) {
                    case -1: {
                        if (!(sumPenaltySum < this.sumConstraints[i])) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * Fmath.square(this.sumConstraints[i] - sumPenaltySum);
                        test = false;
                        continue block12;
                    }
                    case 0: {
                        if (sumPenaltySum < this.sumConstraints[i] * (1.0 - this.constraintTolerance)) {
                            ss = tempFunctVal + this.penaltyWeight * Fmath.square(this.sumConstraints[i] * (1.0 - this.constraintTolerance) - sumPenaltySum);
                            test = false;
                        }
                        if (!(sumPenaltySum > this.sumConstraints[i] * (1.0 + this.constraintTolerance))) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * Fmath.square(sumPenaltySum - this.sumConstraints[i] * (1.0 + this.constraintTolerance));
                        test = false;
                        continue block12;
                    }
                    case 1: {
                        if (!(sumPenaltySum > this.sumConstraints[i])) continue block12;
                        ss = tempFunctVal + this.penaltyWeight * Fmath.square(sumPenaltySum - this.sumConstraints[i]);
                        test = false;
                        continue block12;
                    }
                    default: {
                        throw new IllegalArgumentException("The " + i + "th summation penalty check " + this.sumPenaltyCheck[i] + " not recognised");
                    }
                }
            }
        }
        if (test) {
            ss = 0.0;
            for (int i = 0; i < this.nData; ++i) {
                for (int j = 0; j < this.nXarrays; ++j) {
                    xd[j] = this.xData[j][i];
                }
                if (!this.multipleY) {
                    ss += Fmath.square((this.yData[i] - g1.function(param, xd)) / this.weight[i]);
                    continue;
                }
                ss += Fmath.square((this.yData[i] - g2.function(param, xd, i)) / this.weight[i]);
            }
            this.lastSSnoConstraint = ss;
        }
        return ss;
    }

    public void addConstraint(int paramIndex, int conDir, double constraint) {
        this.penalty = true;
        if (this.penalties.isEmpty()) {
            this.penalties.add(new Integer(this.constraintMethod));
        }
        if (this.penalties.size() == 1) {
            this.penalties.add(new Integer(1));
        } else {
            int nPC = (Integer)this.penalties.get(1);
            this.penalties.set(1, new Integer(++nPC));
        }
        this.penalties.add(new Integer(paramIndex));
        this.penalties.add(new Integer(conDir));
        this.penalties.add(new Double(constraint));
        if (paramIndex > this.maxConstraintIndex) {
            this.maxConstraintIndex = paramIndex;
        }
    }

    public void addConstraint(int[] paramIndices, int[] plusOrMinus, int conDir, double constraint) {
        ArrayMaths am = new ArrayMaths(plusOrMinus);
        double[] dpom = am.getArray_as_double();
        this.addConstraint(paramIndices, dpom, conDir, constraint);
    }

    public void addConstraint(int[] paramIndices, double[] plusOrMinus, int conDir, double constraint) {
        int nCon = paramIndices.length;
        int nPorM = plusOrMinus.length;
        if (nCon != nPorM) {
            throw new IllegalArgumentException("num of parameters, " + nCon + ", does not equal number of parameter signs, " + nPorM);
        }
        this.sumPenalty = true;
        if (this.sumPenalties.isEmpty()) {
            this.sumPenalties.add(new Integer(this.constraintMethod));
        }
        if (this.sumPenalties.size() == 1) {
            this.sumPenalties.add(new Integer(1));
        } else {
            int nPC = (Integer)this.sumPenalties.get(1);
            this.sumPenalties.set(1, new Integer(++nPC));
        }
        this.sumPenalties.add(new Integer(nCon));
        this.sumPenalties.add(paramIndices);
        this.sumPenalties.add(plusOrMinus);
        this.sumPenalties.add(new Integer(conDir));
        this.sumPenalties.add(new Double(constraint));
        ArrayMaths am = new ArrayMaths(paramIndices);
        int maxI = am.getMaximum_as_int();
        if (maxI > this.maxConstraintIndex) {
            this.maxConstraintIndex = maxI;
        }
    }

    public void removeConstraints() {
        int i;
        int m;
        if (!this.penalties.isEmpty()) {
            m = this.penalties.size();
            for (i = m - 1; i >= 0; --i) {
                this.penalties.remove(i);
            }
        }
        this.penalty = false;
        this.nConstraints = 0;
        if (!this.sumPenalties.isEmpty()) {
            m = this.sumPenalties.size();
            for (i = m - 1; i >= 0; --i) {
                this.sumPenalties.remove(i);
            }
        }
        this.sumPenalty = false;
        this.nSumConstraints = 0;
        this.maxConstraintIndex = -1;
    }

    public void setConstraintTolerance(double tolerance) {
        this.constraintTolerance = tolerance;
    }

    protected int pseudoLinearStats(Object regFun) {
        int i;
        int i2;
        double f1 = 0.0;
        double f2 = 0.0;
        double f3 = 0.0;
        double f4 = 0.0;
        int flag = 0;
        int np = this.nParam;
        double[] f = new double[np];
        double[] pmin = new double[np];
        double[] coeffSd = new double[np];
        double[] xd = new double[this.nXarrays];
        double[][] stat = new double[np][np];
        this.pseudoSd = new double[np];
        Object temp = null;
        this.grad = new double[np][2];
        this.covar = new double[np][np];
        this.corrCoeff = new double[np][np];
        pmin = Conv.copy(this.best);
        double hold0 = 1.0;
        double hold1 = 1.0;
        for (i2 = 0; i2 < np; ++i2) {
            for (int k = 0; k < np; ++k) {
                f[k] = pmin[k];
            }
            hold0 = pmin[i2];
            if (hold0 == 0.0) {
                hold0 = this.stepH[i2];
                this.zeroCheck = true;
            }
            f[i2] = hold0 * (1.0 - this.delta);
            this.lastSSnoConstraint = this.sumOfSquaresError;
            f1 = this.sumSquares(regFun, f);
            f[i2] = hold0 * (1.0 + this.delta);
            this.lastSSnoConstraint = this.sumOfSquaresError;
            f2 = this.sumSquares(regFun, f);
            this.grad[i2][0] = (this.fMin - f1) / Math.abs(this.delta * hold0);
            this.grad[i2][1] = (f2 - this.fMin) / Math.abs(this.delta * hold0);
        }
        this.lastSSnoConstraint = this.sumOfSquaresError;
        for (i2 = 0; i2 < np; ++i2) {
            for (int j = 0; j < np; ++j) {
                for (int k = 0; k < np; ++k) {
                    f[k] = pmin[k];
                }
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.stepH[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 + this.delta / 2.0);
                hold0 = f[j];
                if (hold0 == 0.0) {
                    hold0 = this.stepH[j];
                    this.zeroCheck = true;
                }
                f[j] = hold0 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquaresError;
                f1 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j] = pmin[j];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.stepH[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 - this.delta / 2.0);
                hold0 = f[j];
                if (hold0 == 0.0) {
                    hold0 = this.stepH[j];
                    this.zeroCheck = true;
                }
                f[j] = hold0 * (1.0 + this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquaresError;
                f2 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j] = pmin[j];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.stepH[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 + this.delta / 2.0);
                hold0 = f[j];
                if (hold0 == 0.0) {
                    hold0 = this.stepH[j];
                    this.zeroCheck = true;
                }
                f[j] = hold0 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquaresError;
                f3 = this.sumSquares(regFun, f);
                f[i2] = pmin[i2];
                f[j] = pmin[j];
                hold0 = f[i2];
                if (hold0 == 0.0) {
                    hold0 = this.stepH[i2];
                    this.zeroCheck = true;
                }
                f[i2] = hold0 * (1.0 - this.delta / 2.0);
                hold0 = f[j];
                if (hold0 == 0.0) {
                    hold0 = this.stepH[j];
                    this.zeroCheck = true;
                }
                f[j] = hold0 * (1.0 - this.delta / 2.0);
                this.lastSSnoConstraint = this.sumOfSquaresError;
                f4 = this.sumSquares(regFun, f);
                stat[i2][j] = (f1 - f2 - f3 + f4) / (this.delta * this.delta);
            }
        }
        double ss = 0.0;
        double sc = 0.0;
        for (int i3 = 0; i3 < this.nData; ++i3) {
            for (int j = 0; j < this.nXarrays; ++j) {
                xd[j] = this.xData[j][i3];
            }
            this.yCalc[i3] = this.multipleY ? ((RegressionFunction2)regFun).function(pmin, xd, i3) : ((RegressionFunction)regFun).function(pmin, xd);
            this.residual[i3] = this.yCalc[i3] - this.yData[i3];
            ss += Fmath.square(this.residual[i3]);
            this.residualW[i3] = this.residual[i3] / this.weight[i3];
            sc += Fmath.square(this.residualW[i3]);
        }
        this.sumOfSquaresError = ss;
        double varY = ss / (double)(this.nData - np);
        double sdY = Math.sqrt(varY);
        this.chiSquare = sc;
        this.reducedChiSquare = sc / (double)(this.nData - np);
        double red = 1.0;
        if (!this.weightOpt && !this.trueFreq) {
            red = this.sumOfSquaresError / (double)(this.nData - np);
        }
        for (i = 0; i < np; ++i) {
            this.pseudoSd[i] = 2.0 * this.delta * red * Math.abs(pmin[i]) / (this.grad[i][1] - this.grad[i][0]);
            this.pseudoSd[i] = this.pseudoSd[i] >= 0.0 ? Math.sqrt(this.pseudoSd[i]) : Double.NaN;
        }
        if (np == 1) {
            hold0 = pmin[0];
            if (hold0 == 0.0) {
                hold0 = this.stepH[0];
            }
            stat[0][0] = 1.0 / stat[0][0];
            this.covar[0][0] = stat[0][0] * red * hold0 * hold0;
            if (this.covar[0][0] >= 0.0) {
                coeffSd[0] = Math.sqrt(this.covar[0][0]);
                this.corrCoeff[0][0] = 1.0;
            } else {
                coeffSd[0] = Double.NaN;
                this.corrCoeff[0][0] = Double.NaN;
                this.posVarFlag = false;
            }
        } else {
            int j;
            int i4;
            double determinant;
            Matrix cov = new Matrix(stat);
            if (this.supressErrorMessages) {
                cov.supressErrorMessage();
            }
            if ((determinant = cov.determinant()) == 0.0) {
                this.invertFlag = false;
            } else {
                cov = cov.inverse();
                this.invertFlag = cov.getMatrixCheck();
            }
            if (!this.invertFlag) {
                --flag;
            }
            stat = cov.getArrayCopy();
            this.posVarFlag = true;
            if (this.invertFlag) {
                for (i4 = 0; i4 < np; ++i4) {
                    hold0 = pmin[i4];
                    if (hold0 == 0.0) {
                        hold0 = this.stepH[i4];
                    }
                    for (j = i4; j < np; ++j) {
                        hold1 = pmin[j];
                        if (hold1 == 0.0) {
                            hold1 = this.stepH[j];
                        }
                        this.covar[i4][j] = 2.0 * stat[i4][j] * red * hold0 * hold1;
                        this.covar[j][i4] = this.covar[i4][j];
                    }
                    if (this.covar[i4][i4] >= 0.0) {
                        coeffSd[i4] = Math.sqrt(this.covar[i4][i4]);
                        continue;
                    }
                    coeffSd[i4] = Double.NaN;
                    this.posVarFlag = false;
                }
                for (i4 = 0; i4 < np; ++i4) {
                    for (j = 0; j < np; ++j) {
                        this.corrCoeff[i4][j] = coeffSd[i4] != Double.NaN && coeffSd[j] != Double.NaN ? this.covar[i4][j] / (coeffSd[i4] * coeffSd[j]) : Double.NaN;
                    }
                }
            } else {
                for (i4 = 0; i4 < np; ++i4) {
                    for (j = 0; j < np; ++j) {
                        this.covar[i4][j] = Double.NaN;
                        this.corrCoeff[i4][j] = Double.NaN;
                    }
                    coeffSd[i4] = Double.NaN;
                }
            }
        }
        if (!this.posVarFlag) {
            --flag;
        }
        for (i = 0; i < this.nParam; ++i) {
            this.bestSd[i] = coeffSd[i];
            this.tValues[i] = this.best[i] / this.bestSd[i];
            double atv = Math.abs(this.tValues[i]);
            this.pValues[i] = atv != atv ? Double.NaN : 1.0 - Stat.studentTcdf(-atv, atv, this.degreesOfFreedom);
        }
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            this.xyR = Stat.corrCoeff(this.xData[0], this.yData, this.weight);
        }
        this.yyR = Stat.corrCoeff(this.yCalc, this.yData, this.weight);
        this.yMean = Stat.mean(this.yData);
        this.yWeightedMean = Stat.mean(this.yData, this.weight);
        this.sumOfSquaresTotal = 0.0;
        for (i = 0; i < this.nData; ++i) {
            this.sumOfSquaresTotal += Fmath.square((this.yData[i] - this.yWeightedMean) / this.weight[i]);
        }
        this.sumOfSquaresRegrn = this.sumOfSquaresTotal - this.chiSquare;
        if (this.sumOfSquaresRegrn < 0.0) {
            this.sumOfSquaresRegrn = 0.0;
        }
        this.multR = this.sumOfSquaresRegrn / this.sumOfSquaresTotal;
        this.adjustedR = Double.NaN;
        this.multipleF = Double.NaN;
        if (this.nData - this.nXarrays - 1 > 0) {
            this.adjustedR = 1.0 - (1.0 - this.multR) * (double)(this.nData - 1) / (double)(this.nData - this.nXarrays - 1);
        }
        this.multipleF = this.multR * ((double)(this.nData - this.nXarrays) - 1.0) / ((1.0 - this.multR) * (double)this.nXarrays);
        if (this.multipleF >= 0.0) {
            this.multipleFprob = Stat.fTestProb(this.multipleF, this.nXarrays, this.nData - this.nXarrays - 1);
        }
        this.calcDurbinWatson();
        return flag;
    }

    protected void calcDurbinWatson() {
        double dNumer = 0.0;
        double temp = 0.0;
        for (int i = 1; i < this.nData; ++i) {
            temp = this.residual[i] - this.residual[i - 1];
            dNumer += temp * temp;
        }
        double dDenom = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            dDenom += this.residual[i] * this.residual[i];
        }
        this.dDurbinWatson = dNumer / dDenom;
        this.dDurbinWatsonDone = true;
    }

    protected double getDurbinWatsonD() {
        if (!this.dDurbinWatsonDone) {
            this.calcDurbinWatson();
        }
        return this.dDurbinWatson;
    }

    public void print(String filename, int prec) {
        this.prec = prec;
        this.print(filename);
    }

    public void print(int prec) {
        this.prec = prec;
        String filename = "RegressionOutput.txt";
        this.print(filename);
    }

    public void print(String filename) {
        if (filename.indexOf(46) == -1) {
            filename = filename + ".txt";
        }
        FileOutput fout = new FileOutput(filename, 'n');
        fout.dateAndTimeln(filename);
        fout.println(this.graphTitle);
        this.paraName = new String[this.nParam];
        if (this.lastMethod == 38) {
            this.paraName = new String[3];
        }
        if (this.bestPolyFlag) {
            fout.println("This is the best fit found by the method bestPolynomial");
        }
        if (this.weightOpt) {
            fout.println("Weighted Least Squares Minimisation");
        } else {
            fout.println("Unweighted Least Squares Minimisation");
        }
        switch (this.lastMethod) {
            case 0: {
                fout.println("Linear Regression with intercept");
                fout.println("y = c[0] + c[1]*x1 + c[2]*x2 +c[3]*x3 + . . .");
                for (int i = 0; i < this.nParam; ++i) {
                    this.paraName[i] = "c[" + i + "]";
                }
                this.linearPrint(fout);
                break;
            }
            case 1: {
                fout.println("Polynomial (with degree = " + (this.nParam - 1) + "), Fitting: Linear Regression");
                fout.println("y = c[0] + c[1]*x + c[2]*x^2 +c[3]*x^3 + . . .");
                for (int i = 0; i < this.nParam; ++i) {
                    this.paraName[i] = "c[" + i + "]";
                }
                this.linearPrint(fout);
                break;
            }
            case 2: {
                fout.println("Generalised linear regression");
                fout.println("y = c[0]*f1(x) + c[1]*f2(x) + c[2]*f3(x) + . . .");
                for (int i = 0; i < this.nParam; ++i) {
                    this.paraName[i] = "c[" + i + "]";
                }
                this.linearPrint(fout);
                break;
            }
            case 3: {
                fout.println("Nelder and Mead Simplex Non-linear Regression");
                fout.println("y = f(x1, x2, x3 . . ., c[0], c[1], c[2] . . .");
                fout.println("y is non-linear with respect to the c[i]");
                for (int i = 0; i < this.nParam; ++i) {
                    this.paraName[i] = "c[" + i + "]";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 4: {
                fout.println("Fitting to a Normal (Gaussian) distribution");
                fout.println("y = (yscale/(sd.sqrt(2.pi)).exp(0.5.square((x-mean)/sd))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mean";
                this.paraName[1] = "sd";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 5: {
                fout.println("Fitting to a Lorentzian distribution");
                fout.println("y = (yscale/pi).(gamma/2)/((x-mean)^2+(gamma/2)^2)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mean";
                this.paraName[1] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 6: {
                fout.println("Fitting to a Poisson distribution");
                fout.println("y = yscale.mu^k.exp(-mu)/mu!");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mean";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 7: {
                fout.println("Fitting to a Two Parameter Minimum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fout.println("y = (yscale/sigma)*exp((x - mu)/sigma))*exp(-exp((x-mu)/sigma))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 8: {
                fout.println("Fitting to a Two Parameter Maximum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fout.println("y = (yscale/sigma)*exp(-(x - mu)/sigma))*exp(-exp(-(x-mu)/sigma))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 9: {
                fout.println("Fitting to a One Parameter Minimum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fout.println("y = (yscale)*exp(x/sigma))*exp(-exp(x/sigma))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 10: {
                fout.println("Fitting to a One Parameter Maximum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fout.println("y = (yscale)*exp(-x/sigma))*exp(-exp(-x/sigma))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 11: {
                fout.println("Fitting to a Standard Minimum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fout.println("y = (yscale)*exp(x))*exp(-exp(x))");
                fout.println("Linear regression used to fit y = yscale*z where z = exp(x))*exp(-exp(x)))");
                if (this.scaleFlag) {
                    this.paraName[0] = "y scale";
                }
                this.linearPrint(fout);
                break;
            }
            case 12: {
                fout.println("Fitting to a Standard Maximum Order Statistic Gumbel [Type 1 Extreme Value] Distribution");
                fout.println("y = (yscale)*exp(-x))*exp(-exp(-x))");
                fout.println("Linear regression used to fit y = yscale*z where z = exp(-x))*exp(-exp(-x)))");
                if (this.scaleFlag) {
                    this.paraName[0] = "y scale";
                }
                this.linearPrint(fout);
                break;
            }
            case 13: {
                fout.println("Fitting to a Three Parameter Frechet [Type 2 Extreme Value] Distribution");
                fout.println("y = yscale.(gamma/sigma)*((x - mu)/sigma)^(-gamma-1)*exp(-((x-mu)/sigma)^-gamma");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                this.paraName[2] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 14: {
                fout.println("Fitting to a Two parameter Frechet [Type2  Extreme Value] Distribution");
                fout.println("y = yscale.(gamma/sigma)*(x/sigma)^(-gamma-1)*exp(-(x/sigma)^-gamma");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                this.paraName[1] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 15: {
                fout.println("Fitting to a Standard Frechet [Type 2 Extreme Value] Distribution");
                fout.println("y = yscale.gamma*(x)^(-gamma-1)*exp(-(x)^-gamma");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 16: {
                fout.println("Fitting to a Three parameter Weibull [Type 3 Extreme Value] Distribution");
                fout.println("y = yscale.(gamma/sigma)*((x - mu)/sigma)^(gamma-1)*exp(-((x-mu)/sigma)^gamma");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                this.paraName[2] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 17: {
                fout.println("Fitting to a Two parameter Weibull [Type 3 Extreme Value] Distribution");
                fout.println("y = yscale.(gamma/sigma)*(x/sigma)^(gamma-1)*exp(-(x/sigma)^gamma");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                this.paraName[1] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 18: {
                fout.println("Fitting to a Standard Weibull [Type 3 Extreme Value] Distribution");
                fout.println("y = yscale.gamma*(x)^(gamma-1)*exp(-(x)^gamma");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 19: {
                fout.println("Fitting to a Two parameter Exponential Distribution");
                fout.println("y = (yscale/sigma)*exp(-(x-mu)/sigma)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 20: {
                fout.println("Fitting to a One parameter Exponential Distribution");
                fout.println("y = (yscale/sigma)*exp(-x/sigma)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 21: {
                fout.println("Fitting to a Standard Exponential Distribution");
                fout.println("y = yscale*exp(-x)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                if (this.scaleFlag) {
                    this.paraName[0] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 22: {
                fout.println("Fitting to a Rayleigh Distribution");
                fout.println("y = (yscale/sigma)*(x/sigma)*exp(-0.5*(x/sigma)^2)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 23: {
                fout.println("Fitting to a Two Parameter Pareto Distribution");
                fout.println("y = yscale*(alpha*beta^alpha)/(x^(alpha+1))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 24: {
                fout.println("Fitting to a One Parameter Pareto Distribution");
                fout.println("y = yscale*(alpha)/(x^(alpha+1))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 25: {
                fout.println("Fitting to a Sigmoidal Threshold Function");
                fout.println("y = yscale/(1 + exp(-slopeTerm(x - theta)))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "slope term";
                this.paraName[1] = "theta";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 26: {
                fout.println("Fitting to a Rectangular Hyperbola");
                fout.println("y = yscale.x/(theta + x)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "theta";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 27: {
                fout.println("Fitting to a Scaled Heaviside Step Function");
                fout.println("y = yscale.H(x - theta)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "theta";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 28: {
                fout.println("Fitting to a Hill/Sips Sigmoid");
                fout.println("y = yscale.x^n/(theta^n + x^n)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "theta";
                this.paraName[1] = "n";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 29: {
                fout.println("Fitting to a Shifted Pareto Distribution");
                fout.println("y = yscale*(alpha*beta^alpha)/((x-theta)^(alpha+1))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                this.paraName[2] = "theta";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 30: {
                fout.println("Fitting to a Logistic distribution");
                fout.println("y = yscale*exp(-(x-mu)/beta)/(beta*(1 + exp(-(x-mu)/beta))^2");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "beta";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 31: {
                fout.println("Fitting to a Beta distribution - [0, 1] interval");
                fout.println("y = yscale*x^(alpha-1)*(1-x)^(beta-1)/B(alpha, beta)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 32: {
                fout.println("Fitting to a Beta distribution - [min, max] interval");
                fout.println("y = yscale*(x-min)^(alpha-1)*(max-x)^(beta-1)/(B(alpha, beta)*(max-min)^(alpha+beta-1)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                this.paraName[2] = "min";
                this.paraName[3] = "max";
                if (this.scaleFlag) {
                    this.paraName[4] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 33: {
                fout.println("Fitting to a Three Parameter Gamma distribution");
                fout.println("y = yscale*((x-mu)/beta)^(gamma-1)*exp(-(x-mu)/beta)/(beta*Gamma(gamma))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "beta";
                this.paraName[2] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 34: {
                fout.println("Fitting to a Standard Gamma distribution");
                fout.println("y = yscale*x^(gamma-1)*exp(-x)/Gamma(gamma)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 35: {
                fout.println("Fitting to an Erang distribution");
                fout.println("y = yscale*lambda^k*x^(k-1)*exp(-x*lambda)/(k-1)!");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "lambda";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 36: {
                fout.println("Fitting to a two parameter log-normal distribution");
                fout.println("y = (yscale/(x.sigma.sqrt(2.pi)).exp(0.5.square((log(x)-muu)/sigma))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mu";
                this.paraName[1] = "sigma";
                if (this.scaleFlag) {
                    this.paraName[2] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 37: {
                fout.println("Fitting to a three parameter log-normal distribution");
                fout.println("y = (yscale/((x-alpha).beta.sqrt(2.pi)).exp(0.5.square((log(x-alpha)/gamma)/beta))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "alpha";
                this.paraName[1] = "beta";
                this.paraName[2] = "gamma";
                if (this.scaleFlag) {
                    this.paraName[3] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 38: {
                fout.println("Fitting to a Normal (Gaussian) distribution with fixed parameters");
                fout.println("y = (yscale/(sd.sqrt(2.pi)).exp(0.5.square((x-mean)/sd))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "mean";
                this.paraName[1] = "sd";
                this.paraName[2] = "y scale";
                this.nonLinearPrint(fout);
                break;
            }
            case 39: {
                fout.println("Fitting to a EC50 dose response curve (four parameter logistic)");
                fout.println("y = top + (bottom - top)/(1 + (x/EC50)^HillSlope)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "top";
                this.paraName[1] = "bottom";
                this.paraName[2] = "EC50";
                this.paraName[3] = "Hill Slope";
                this.nonLinearPrint(fout);
                break;
            }
            case 40: {
                fout.println("Fitting to a EC50 dose response curve (four parameter logistic)");
                fout.println("y = top + (bottom - top)/(1 + (x/EC50)^HillSlope) [top and bottom fixed]");
                fout.println("bottom = " + this.bottom);
                fout.println("top =    " + this.top);
                fout.println();
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "EC50";
                this.paraName[1] = "Hill Slope";
                this.nonLinearPrint(fout);
                break;
            }
            case 41: {
                fout.println("Fitting to a EC50 dose response curve - bottom constrained to be zero or positive");
                fout.println("y = top + (bottom - top)/(1 + (x/EC50)^HillSlope)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "top";
                this.paraName[1] = "bottom";
                this.paraName[2] = "EC50";
                this.paraName[3] = "Hill Slope";
                this.nonLinearPrint(fout);
                break;
            }
            case 42: {
                fout.println("Fitting to a five parameter logistic");
                fout.println("y = top + (bottom - top)/(1 + (x/C50)^HillSlope)^asymm [top and bottom fixed]");
                fout.println("bottom = " + this.bottom);
                fout.println("top =    " + this.top);
                fout.println();
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "C50";
                this.paraName[1] = "HillSlope";
                this.paraName[2] = "asymm";
                this.nonLinearPrint(fout);
                break;
            }
            case 43: {
                fout.println("Fitting to an exponential");
                fout.println("y = yscale.exp(A.x)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "A";
                if (this.scaleFlag) {
                    this.paraName[1] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 44: {
                fout.println("Fitting to multiple exponentials");
                fout.println("y = Sum[Ai.exp(Bi.x)], i=1 to n");
                fout.println("Nelder and Mead Simplex used to fit the data");
                for (int i = 0; i < this.nParam; i += 2) {
                    this.paraName[i] = "A[" + (i + 1) + "]";
                    this.paraName[i + 1] = "B[" + (i + 1) + "]";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 45: {
                fout.println("Fitting to one minus an exponential");
                fout.println("y = A(1 - exp(B.x)");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "A";
                this.paraName[1] = "B";
                this.nonLinearPrint(fout);
                break;
            }
            case 46: {
                fout.println("Fitting to a constant");
                fout.println("y = a");
                fout.println("Stat weighted mean used to fit the data");
                this.paraName[0] = "a";
                this.linearPrint(fout);
                break;
            }
            case 47: {
                fout.println("Linear Regression with fixed intercept");
                fout.println("y = fixed intercept + c[0]*x1 + c[1]*x2 +c[2]*x3 + . . .     ");
                for (int i = 0; i < this.nParam; ++i) {
                    this.paraName[i] = "c[" + i + "]";
                }
                this.linearPrint(fout);
                break;
            }
            case 48: {
                fout.println("Polynomial (with degree = " + this.nParam + ") and fixed intercept, Fitting: Linear Regression");
                fout.println("y = fixed intercept + c[0]*x + c[1]*x^2 +c[2]*x^3 + . . .");
                for (int i = 0; i < this.nParam; ++i) {
                    this.paraName[i] = "c[" + i + "]";
                }
                this.linearPrint(fout);
                break;
            }
            case 49: {
                fout.println("Fitting multiple Gaussian distributions");
                fout.println("y = Sum(A[i]/(sd[i].sqrt(2.pi)).exp(0.5.square((x-mean[i])/sd[i])) = yscale.Sum(f[i]/(sd[i].sqrt(2.pi)).exp(0.5.square((x-mean[i])/sd[i]))");
                fout.println("Nelder and Mead Simplex used to fit the data");
                for (int i = 0; i < this.nGaussians; ++i) {
                    this.paraName[3 * i] = "mean[" + i + "]";
                    this.paraName[3 * i + 1] = "sd[" + i + "]";
                    this.paraName[3 * i + 2] = "A[" + i + "]";
                }
                if (this.scaleFlag) {
                    this.paraName[3 * this.nGaussians] = "y scale";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 50: {
                fout.println("Fitting to a non-integer polynomial");
                fout.println("y = c[0] + c[1]*x + c[2]*x^c[3]");
                for (int i = 0; i < this.nParam; ++i) {
                    this.paraName[i] = "c[" + i + "]";
                }
                this.nonLinearPrint(fout);
                break;
            }
            case 51: {
                fout.println("Five parameter logistic function");
                fout.println("y = top + (bottom - top)/((1 + (x/y50)^HillSlope)^asymm");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "top";
                this.paraName[1] = "bottom";
                this.paraName[2] = "y50";
                this.paraName[3] = "HillSlope";
                this.paraName[3] = "asymm";
                this.nonLinearPrint(fout);
                break;
            }
            case 52: {
                fout.println("Fitting to a Shifted Rectangular Hyperbola");
                fout.println("y = A.x/(theta + x) + alpha");
                fout.println("Nelder and Mead Simplex used to fit the data");
                this.paraName[0] = "theta";
                this.paraName[1] = "alpha";
                this.paraName[2] = "A";
                this.nonLinearPrint(fout);
                break;
            }
            default: {
                throw new IllegalArgumentException("Method number (this.lastMethod) not found");
            }
        }
        fout.close();
    }

    public void print() {
        String filename = "RegressOutput.txt";
        this.print(filename);
    }

    protected void linearPrint(FileOutput fout) {
        int i;
        if (this.legendCheck) {
            fout.println();
            fout.println("x1 = " + this.xLegend);
            fout.println("y  = " + this.yLegend);
        }
        fout.println();
        if (this.lastMethod == 47) {
            fout.println("Fixed Intercept = " + this.fixedInterceptL);
        }
        if (this.lastMethod == 48) {
            fout.println("Fixed Intercept = " + this.fixedInterceptP);
        }
        fout.printtab(" ", this.field);
        fout.printtab("Best", this.field);
        fout.printtab("Error", this.field);
        fout.printtab("Coefficient of", this.field);
        fout.printtab("t-value  ", this.field);
        fout.println("p-value");
        fout.printtab(" ", this.field);
        fout.printtab("Estimate", this.field);
        fout.printtab("        ", this.field);
        fout.printtab("variation (%)", this.field);
        fout.printtab("t ", this.field);
        fout.println("P > |t|");
        for (int i2 = 0; i2 < this.nParam; ++i2) {
            fout.printtab(this.paraName[i2], this.field);
            fout.printtab(Fmath.truncate(this.best[i2], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.bestSd[i2], this.prec), this.field);
            fout.printtab(Fmath.truncate(Math.abs(this.bestSd[i2] * 100.0 / this.best[i2]), this.prec), this.field);
            fout.printtab(Fmath.truncate(this.tValues[i2], this.prec), this.field);
            fout.println(Fmath.truncate(this.pValues[i2], this.prec));
        }
        fout.println();
        int ii = 0;
        if (this.lastMethod < 2) {
            ii = 1;
        }
        for (i = 0; i < this.nXarrays; ++i) {
            fout.printtab("x" + String.valueOf(i + ii), this.field);
        }
        fout.printtab("y(expl)", this.field);
        fout.printtab("y(calc)", this.field);
        fout.printtab("weight", this.field);
        fout.printtab("residual", this.field);
        fout.println("residual");
        for (i = 0; i < this.nXarrays; ++i) {
            fout.printtab(" ", this.field);
        }
        fout.printtab(" ", this.field);
        fout.printtab(" ", this.field);
        fout.printtab(" ", this.field);
        fout.printtab("(unweighted)", this.field);
        fout.println("(weighted)");
        for (i = 0; i < this.nData; ++i) {
            for (int j = 0; j < this.nXarrays; ++j) {
                fout.printtab(Fmath.truncate(this.xData[j][i], this.prec), this.field);
            }
            fout.printtab(Fmath.truncate(this.yData[i], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.yCalc[i], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.weight[i], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.residual[i], this.prec), this.field);
            fout.println(Fmath.truncate(this.residualW[i], this.prec));
        }
        fout.println();
        fout.println("Sum of squares " + Fmath.truncate(this.sumOfSquaresError, this.prec));
        if (this.trueFreq) {
            fout.printtab("Chi Square (Poissonian bins)");
            fout.println(Fmath.truncate(this.chiSquare, this.prec));
            fout.printtab("Reduced Chi Square (Poissonian bins)");
            fout.println(Fmath.truncate(this.reducedChiSquare, this.prec));
            fout.printtab("Chi Square (Poissonian bins) Probability");
            fout.println(Fmath.truncate(1.0 - Stat.chiSquareProb(this.chiSquare, this.nData - this.nXarrays), this.prec));
        } else if (this.weightOpt) {
            fout.printtab("Chi Square");
            fout.println(Fmath.truncate(this.chiSquare, this.prec));
            fout.printtab("Reduced Chi Square");
            fout.println(Fmath.truncate(this.reducedChiSquare, this.prec));
        }
        fout.println(" ");
        if (this.lastMethod != 46) {
            if (this.nXarrays == 1 && this.nYarrays == 1 && this.lastMethod != 47 && this.lastMethod != 48) {
                fout.println("Correlation: x - y data");
                fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient (R)");
                fout.println(Fmath.truncate(this.xyR, this.prec));
                if (Math.abs(this.xyR) <= 1.0) {
                    fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                    fout.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.xyR, this.nData - 2), this.prec));
                }
            }
            fout.println(" ");
            fout.println("Correlation: y(experimental) - y(calculated)");
            fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient");
            fout.println(Fmath.truncate(this.yyR, this.prec));
            if (Math.abs(this.yyR) <= 1.0) {
                fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fout.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.yyR, this.nData - 2), this.prec));
            }
            fout.println();
            if (this.chiSquare != 0.0) {
                fout.println("Correlation coefficients");
                fout.printtab(" ", this.field);
                for (i = 0; i < this.nParam; ++i) {
                    fout.printtab(this.paraName[i], this.field);
                }
                fout.println();
                for (int j = 0; j < this.nParam; ++j) {
                    fout.printtab(this.paraName[j], this.field);
                    for (int i3 = 0; i3 < this.nParam; ++i3) {
                        fout.printtab(Fmath.truncate(this.corrCoeff[i3][j], this.prec), this.field);
                    }
                    fout.println();
                }
            }
        }
        fout.println(" ");
        fout.printtab("Degrees of freedom");
        fout.println(this.nData - this.nParam);
        fout.printtab("Number of data points");
        fout.println(this.nData);
        fout.printtab("Number of estimated paramaters");
        fout.println(this.nParam);
        fout.println();
        fout.printtab("Durbin-Watson d statistic");
        fout.println(Fmath.truncate(this.getDurbinWatsonD(), this.prec));
        fout.println();
        if (this.bestPolyFlag) {
            fout.println("Method bestPolynomial search history");
            fout.println("F-probability significance level: " + this.fProbSignificance + " (" + this.fProbSignificance * 100.0 + " %)");
            fout.println("Degree of best fit polynomial " + this.bestPolynomialDegree);
            fout.println(" ");
            fout.print("Polynomial degree", 2 * this.field);
            fout.print("chi square", 2 * this.field);
            fout.print("F-ratio", this.field);
            fout.print("F-probability", this.field + 2);
            fout.println("F-value at the");
            fout.print("comparison", 2 * this.field);
            fout.print("comparison", 2 * this.field);
            fout.print("   ", this.field);
            fout.print("   ", this.field + 2);
            fout.println("significance level");
            int nAttempts = (Integer)this.bestPolyArray.get(1);
            int[] deg0s = (int[])this.bestPolyArray.get(2);
            int[] deg1s = (int[])this.bestPolyArray.get(3);
            double[] chi0s = (double[])this.bestPolyArray.get(4);
            double[] chi1s = (double[])this.bestPolyArray.get(5);
            double[] fRatios = (double[])this.bestPolyArray.get(6);
            double[] fProbs = (double[])this.bestPolyArray.get(7);
            double[] fSigns = (double[])this.bestPolyArray.get(8);
            for (int i4 = 0; i4 < nAttempts; ++i4) {
                fout.print(deg0s[i4], this.field);
                fout.print(deg1s[i4], this.field);
                fout.print(Fmath.truncate(chi0s[i4], this.prec), this.field);
                fout.print(Fmath.truncate(chi1s[i4], this.prec), this.field);
                fout.print(Fmath.truncate(fRatios[i4], this.prec), this.field);
                fout.print(Fmath.truncate(fProbs[i4], this.prec), this.field + 2);
                fout.println(Fmath.truncate(fSigns[i4], this.prec));
            }
        }
        fout.println();
        fout.println("Coefficient of determination,   =                   " + Fmath.truncate(this.multR, this.prec));
        fout.println("Adjusted Coefficient of determination,    =         " + Fmath.truncate(this.adjustedR, this.prec));
        fout.println("Coefficient of determination, F-ratio =             " + Fmath.truncate(this.multipleF, this.prec));
        fout.println("Coefficient of determination, F-ratio probability = " + Fmath.truncate(this.multipleFprob, this.prec));
        fout.println("Total (weighted) sum of squares  =                  " + Fmath.truncate(this.sumOfSquaresTotal, this.prec));
        fout.println("Regression (weighted) sum of squares  =             " + Fmath.truncate(this.sumOfSquaresRegrn, this.prec));
        fout.println("Error (weighted) sum of squares  =                  " + Fmath.truncate(this.chiSquare, this.prec));
        fout.println();
        fout.println("End of file");
        fout.close();
    }

    protected void nonLinearPrint(FileOutput fout) {
        int i;
        int j;
        int i2;
        int i3;
        int ii;
        int nT;
        if (this.userSupplied) {
            fout.println();
            fout.println("Initial estimates were supplied by the user");
        } else {
            fout.println("Initial estimates were calculated internally");
        }
        switch (this.scaleOpt) {
            case 1: {
                fout.println();
                fout.println("Initial estimates were scaled to unity within the regression");
                break;
            }
            case 2: {
                fout.println();
                fout.println("Initial estimates were scaled with user supplied scaling factors within the regression");
            }
        }
        if (this.legendCheck) {
            fout.println();
            fout.println("x1 = " + this.xLegend);
            fout.println("y  = " + this.yLegend);
        }
        fout.println();
        if (!this.nlrStatus) {
            fout.println("Convergence criterion was not satisfied");
            fout.println("The following results are, or are derived from, the current estimates on exiting the regression method");
            fout.println();
        }
        fout.println("Estimated parameters");
        fout.println("The statistics are obtained assuming that the model behaves as a linear model about the minimum.");
        fout.println("The Hessian matrix is calculated as the numerically derived second derivatives of chi square with respect to all pairs of parameters.");
        if (this.zeroCheck) {
            fout.println("The best estimate/s equal to zero were replaced by the step size in the numerical differentiation!!!");
        }
        fout.println("Consequentlty treat the statistics with great caution");
        if (!this.posVarFlag) {
            fout.println("Covariance matrix contains at least one negative diagonal element");
            fout.println(" - all variances are dubious");
            fout.println(" - may not be at a minimum or the model may be so non-linear that the linear approximation in calculating the statisics is invalid");
        }
        if (!this.invertFlag) {
            fout.println("Hessian matrix is singular");
            fout.println(" - variances cannot be calculated");
            fout.println(" - may not be at a minimum  or the model may be so non-linear that the linear approximation in calculating the statisics is invalid");
        }
        fout.println(" ");
        if (!this.scaleFlag) {
            fout.println("The ordinate scaling factor [yscale, Ao] has been set equal to " + this.yScaleFactor);
            fout.println(" ");
        }
        if (this.lastMethod == 35) {
            fout.println("The integer rate parameter, k, was varied in unit steps to obtain a minimum sum of squares");
            fout.println("This value of k was " + this.kayValue);
            fout.println(" ");
        }
        fout.printtab(" ", this.field);
        if (this.invertFlag) {
            fout.printtab("Best", this.field);
            fout.printtab("Estimate of", this.field);
            fout.printtab("Coefficient", this.field);
            fout.printtab("t-value", this.field);
            fout.println("p-value");
        } else {
            fout.println("Best");
        }
        if (this.invertFlag) {
            fout.printtab(" ", this.field);
            fout.printtab("estimate", this.field);
            fout.printtab("the error", this.field);
            fout.printtab("of", this.field);
            fout.printtab("t", this.field);
            fout.println("P > |t|");
        } else {
            fout.printtab(" ", this.field);
            fout.println("estimate");
        }
        if (this.invertFlag) {
            fout.printtab(" ", this.field);
            fout.printtab(" ", this.field);
            fout.printtab(" ", this.field);
            fout.println("variation (%)");
        } else {
            fout.println("   ");
        }
        if (this.lastMethod == 38) {
            nT = 3;
            ii = 0;
            for (i3 = 0; i3 < nT; ++i3) {
                fout.printtab(this.paraName[i3], this.field);
                if (this.fixed[i3]) {
                    fout.printtab(this.values[i3]);
                    fout.println(" fixed parameter");
                    continue;
                }
                if (this.invertFlag) {
                    fout.printtab(Fmath.truncate(this.best[ii], this.prec), this.field);
                    fout.printtab(Fmath.truncate(this.bestSd[ii], this.prec), this.field);
                    fout.printtab(Fmath.truncate(Math.abs(this.bestSd[ii] * 100.0 / this.best[ii]), this.prec), this.field);
                    fout.printtab(Fmath.truncate(this.tValues[ii], this.prec), this.field);
                    fout.println(Fmath.truncate(this.pValues[ii], this.prec));
                } else {
                    fout.println(Fmath.truncate(this.best[ii], this.prec));
                }
                ++ii;
            }
        } else {
            for (i2 = 0; i2 < this.nParam; ++i2) {
                if (this.invertFlag) {
                    fout.printtab(this.paraName[i2], this.field);
                    fout.printtab(Fmath.truncate(this.best[i2], this.prec), this.field);
                    fout.printtab(Fmath.truncate(this.bestSd[i2], this.prec), this.field);
                    fout.printtab(Fmath.truncate(Math.abs(this.bestSd[i2] * 100.0 / this.best[i2]), this.prec), this.field);
                    fout.printtab(Fmath.truncate(this.tValues[i2], this.prec), this.field);
                    fout.println(Fmath.truncate(this.pValues[i2], this.prec));
                    continue;
                }
                fout.printtab(this.paraName[i2], this.field);
                fout.println(Fmath.truncate(this.best[i2], this.prec));
            }
        }
        fout.println();
        fout.printtab(" ", this.field);
        fout.printtab("Best", this.field);
        fout.printtab("Pre-min", this.field);
        fout.printtab("Post-min", this.field);
        fout.printtab("Initial", this.field);
        fout.printtab("Fractional", this.field);
        fout.println("Scaling");
        fout.printtab(" ", this.field);
        fout.printtab("estimate", this.field);
        fout.printtab("gradient", this.field);
        fout.printtab("gradient", this.field);
        fout.printtab("estimate", this.field);
        fout.printtab("step", this.field);
        fout.println("factor");
        if (this.lastMethod == 38) {
            nT = 3;
            ii = 0;
            for (i3 = 0; i3 < nT; ++i3) {
                fout.printtab(this.paraName[i3], this.field);
                if (this.fixed[i3]) {
                    fout.printtab(this.values[i3]);
                    fout.println(" fixed parameter");
                    continue;
                }
                fout.printtab(Fmath.truncate(this.best[ii], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.grad[ii][0], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.grad[ii][1], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.startH[ii], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.stepH[ii], this.prec), this.field);
                fout.println(Fmath.truncate(this.scale[ii], this.prec));
                ++ii;
            }
        } else {
            for (i2 = 0; i2 < this.nParam; ++i2) {
                fout.printtab(this.paraName[i2], this.field);
                fout.printtab(Fmath.truncate(this.best[i2], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.grad[i2][0], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.grad[i2][1], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.startH[i2], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.stepH[i2], this.prec), this.field);
                fout.println(Fmath.truncate(this.scale[i2], this.prec));
            }
        }
        fout.println();
        ErrorProp ePeak = null;
        ErrorProp eYscale = null;
        if (this.scaleFlag) {
            switch (this.lastMethod) {
                case 4: {
                    ErrorProp eSigma = new ErrorProp(this.best[1], this.bestSd[1]);
                    eYscale = new ErrorProp(this.best[2] / Math.sqrt(Math.PI * 2), this.bestSd[2] / Math.sqrt(Math.PI * 2));
                    ePeak = eYscale.over(eSigma);
                    fout.printsp("Calculated estimate of the peak value = ");
                    fout.println(ErrorProp.truncate(ePeak, this.prec));
                    break;
                }
                case 5: {
                    ErrorProp eGamma = new ErrorProp(this.best[1], this.bestSd[1]);
                    eYscale = new ErrorProp(2.0 * this.best[2] / Math.PI, 2.0 * this.bestSd[2] / Math.PI);
                    ePeak = eYscale.over(eGamma);
                    fout.printsp("Calculated estimate of the peak value = ");
                    fout.println(ErrorProp.truncate(ePeak, this.prec));
                }
            }
        }
        if (this.lastMethod == 25) {
            fout.printsp("Calculated estimate of the maximum gradient = ");
            if (this.scaleFlag) {
                fout.println(Fmath.truncate(this.best[0] * this.best[2] / 4.0, this.prec));
            } else {
                fout.println(Fmath.truncate(this.best[0] * this.yScaleFactor / 4.0, this.prec));
            }
        }
        if (this.lastMethod == 28) {
            fout.printsp("Calculated estimate of the maximum gradient = ");
            if (this.scaleFlag) {
                fout.println(Fmath.truncate(this.best[1] * this.best[2] / (4.0 * this.best[0]), this.prec));
            } else {
                fout.println(Fmath.truncate(this.best[1] * this.yScaleFactor / (4.0 * this.best[0]), this.prec));
            }
            fout.printsp("Calculated estimate of the Ka, i.e. theta raised to the power n = ");
            fout.println(Fmath.truncate(Math.pow(this.best[0], this.best[1]), this.prec));
        }
        fout.println();
        if (this.lastMethod == 49) {
            fout.println("A[i] values converted to fractional contributions, f[i], and a scaling factor, yscale");
            fout.printtab(" ", this.field);
            if (this.invertFlag) {
                fout.printtab("Best", this.field);
                fout.printtab("Estimate of", this.field);
                fout.printtab("Coefficient", this.field);
                fout.printtab("t-value", this.field);
                fout.println("p-value");
            } else {
                fout.println("Best");
            }
            if (this.invertFlag) {
                fout.printtab(" ", this.field);
                fout.printtab("estimate", this.field);
                fout.printtab("the error", this.field);
                fout.printtab("of", this.field);
                fout.printtab("t", this.field);
                fout.println("P > |t|");
            } else {
                fout.printtab(" ", this.field);
                fout.println("estimate");
            }
            if (this.invertFlag) {
                fout.printtab(" ", this.field);
                fout.printtab(" ", this.field);
                fout.printtab(" ", this.field);
                fout.println("variation (%)");
            } else {
                fout.println("   ");
            }
            for (int i4 = 0; i4 < this.nGaussians; ++i4) {
                if (this.invertFlag) {
                    fout.printtab("f[" + i4 + "]", this.field);
                    fout.printtab(Fmath.truncate(this.multGaussFract[i4], this.prec), this.field);
                    fout.printtab(Fmath.truncate(this.multGaussFractErrors[i4], this.prec), this.field);
                    fout.printtab(Fmath.truncate(this.multGaussCoeffVar[i4], this.prec), this.field);
                    fout.printtab(Fmath.truncate(this.multGaussTvalue[i4], this.prec), this.field);
                    fout.println(Fmath.truncate(this.multGaussPvalue[i4], this.prec));
                    continue;
                }
                fout.printtab("f[" + i4 + "]", this.field);
                fout.println(Fmath.truncate(this.multGaussFract[i4], this.prec));
            }
        }
        if (this.invertFlag) {
            fout.printtab("yscale", this.field);
            fout.printtab(Fmath.truncate(this.multGaussScale, this.prec), this.field);
            fout.printtab(Fmath.truncate(this.multGaussScaleError, this.prec), this.field);
            fout.printtab(Fmath.truncate(this.multGaussScaleCoeffVar, this.prec), this.field);
            fout.printtab(Fmath.truncate(this.multGaussScaleTvalue, this.prec), this.field);
            fout.println(Fmath.truncate(this.multGaussScalePvalue, this.prec));
        } else {
            fout.printtab("yscale", this.field);
            fout.println(Fmath.truncate(this.multGaussScale, this.prec));
        }
        fout.println();
        int kk = 0;
        for (j = 0; j < this.nYarrays; ++j) {
            if (this.multipleY) {
                fout.println("Y array " + j);
            }
            for (i = 0; i < this.nXarrays; ++i) {
                fout.printtab("x" + String.valueOf(i), this.field);
            }
            fout.printtab("y(expl)", this.field);
            fout.printtab("y(calc)", this.field);
            fout.printtab("weight", this.field);
            fout.printtab("residual", this.field);
            fout.println("residual");
            for (i = 0; i < this.nXarrays; ++i) {
                fout.printtab(" ", this.field);
            }
            fout.printtab(" ", this.field);
            fout.printtab(" ", this.field);
            fout.printtab(" ", this.field);
            fout.printtab("(unweighted)", this.field);
            fout.println("(weighted)");
            for (i = 0; i < this.nData0; ++i) {
                for (int jj = 0; jj < this.nXarrays; ++jj) {
                    fout.printtab(Fmath.truncate(this.xData[jj][kk], this.prec), this.field);
                }
                fout.printtab(Fmath.truncate(this.yData[kk], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.yCalc[kk], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.weight[kk], this.prec), this.field);
                fout.printtab(Fmath.truncate(this.residual[kk], this.prec), this.field);
                fout.println(Fmath.truncate(this.residualW[kk], this.prec));
                ++kk;
            }
            fout.println();
        }
        fout.printtab("Sum of squares of the unweighted residuals");
        fout.println(Fmath.truncate(this.sumOfSquaresError, this.prec));
        if (this.trueFreq) {
            fout.printtab("Chi Square (Poissonian bins)");
            fout.println(Fmath.truncate(this.chiSquare, this.prec));
            fout.printtab("Reduced Chi Square (Poissonian bins)");
            fout.println(Fmath.truncate(this.reducedChiSquare, this.prec));
            fout.printtab("Chi Square (Poissonian bins) Probability");
            fout.println(Fmath.truncate(1.0 - Stat.chiSquareProb(this.reducedChiSquare, this.degreesOfFreedom), this.prec));
        } else if (this.weightOpt) {
            fout.printtab("Chi Square");
            fout.println(Fmath.truncate(this.chiSquare, this.prec));
            fout.printtab("Reduced Chi Square");
            fout.println(Fmath.truncate(this.reducedChiSquare, this.prec));
        }
        fout.println(" ");
        if (this.nXarrays == 1 && this.nYarrays == 1) {
            fout.println("Correlation: x - y data");
            fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient (R)");
            fout.println(Fmath.truncate(this.xyR, this.prec));
            if (Math.abs(this.xyR) <= 1.0) {
                fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
                fout.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.xyR, this.nData - 2), this.prec));
            }
        }
        fout.println(" ");
        fout.println("Correlation: y(experimental) - y(calculated)");
        fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient");
        fout.println(Fmath.truncate(this.yyR, this.prec));
        if (Math.abs(this.yyR) <= 1.0) {
            fout.printtab(this.weightWord[this.weightFlag] + "Linear Correlation Coefficient Probability");
            fout.println(Fmath.truncate(Stat.linearCorrCoeffProb(this.yyR, this.nData - 2), this.prec));
        }
        fout.println(" ");
        fout.printtab("Degrees of freedom");
        fout.println(this.degreesOfFreedom);
        fout.printtab("Number of data points");
        fout.println(this.nData);
        fout.printtab("Number of estimated paramaters");
        fout.println(this.nParam);
        fout.println();
        if (this.posVarFlag && this.invertFlag && this.chiSquare != 0.0) {
            fout.println("Parameter - parameter correlation coefficients");
            fout.printtab(" ", this.field);
            for (int i5 = 0; i5 < this.nParam; ++i5) {
                fout.printtab(this.paraName[i5], this.field);
            }
            fout.println();
            for (j = 0; j < this.nParam; ++j) {
                fout.printtab(this.paraName[j], this.field);
                for (i = 0; i < this.nParam; ++i) {
                    fout.printtab(Fmath.truncate(this.corrCoeff[i][j], this.prec), this.field);
                }
                fout.println();
            }
            fout.println();
        }
        fout.println();
        fout.println("Coefficient of determination, R =                   " + Fmath.truncate(this.multR, this.prec));
        fout.println("Adjusted Coefficient of determination, R' =         " + Fmath.truncate(this.adjustedR, this.prec));
        fout.println("Coefficient of determination, F-ratio =             " + Fmath.truncate(this.multipleF, this.prec));
        fout.println("Coefficient of determination, F-ratio probability = " + Fmath.truncate(this.multipleFprob, this.prec));
        fout.println("Total (weighted) sum of squares  =                  " + Fmath.truncate(this.sumOfSquaresTotal, this.prec));
        fout.println("Regression (weighted) sum of squares  =             " + Fmath.truncate(this.sumOfSquaresRegrn, this.prec));
        fout.println("Error (weighted) sum of squares  =                  " + Fmath.truncate(this.chiSquare, this.prec));
        fout.println();
        fout.println();
        fout.printtab("Durbin-Watson d statistic");
        fout.println(Fmath.truncate(this.getDurbinWatsonD(), this.prec));
        fout.println();
        fout.println();
        fout.printtab("Number of iterations taken");
        fout.println(this.nIter);
        fout.printtab("Maximum number of iterations allowed");
        fout.println(this.nMax);
        fout.printtab("Number of restarts taken");
        fout.println(this.kRestart);
        fout.printtab("Maximum number of restarts allowed");
        fout.println(this.konvge);
        fout.printtab("Standard deviation of the simplex at the minimum");
        fout.println(Fmath.truncate(this.simplexSd, this.prec));
        fout.printtab("Convergence tolerance");
        fout.println(this.fTol);
        switch (this.minTest) {
            case 0: {
                fout.println("simplex sd < the tolerance times the mean of the absolute values of the y values");
                break;
            }
            case 1: {
                fout.println("simplex sd < the tolerance");
                break;
            }
            case 2: {
                fout.println("simplex sd < the tolerance times the square root(sum of squares/degrees of freedom");
            }
        }
        fout.println("Step used in numerical differentiation to obtain Hessian matrix");
        fout.println("d(parameter) = parameter*" + this.delta);
        fout.println();
        fout.println("End of file");
        fout.close();
    }

    public void plotYY(String title) {
        this.graphTitle = title;
        int ncurves = 2;
        int npoints = this.nData0;
        double[][] data = PlotGraph.data(ncurves, npoints);
        int kk = 0;
        for (int jj = 0; jj < this.nYarrays; ++jj) {
            for (int i = 0; i < this.nData0; ++i) {
                data[0][i] = this.yData[kk];
                data[1][i] = this.yCalc[kk];
                ++kk;
            }
            String title0 = this.setGandPtitle(this.graphTitle);
            if (this.multipleY) {
                title0 = title0 + "y array " + jj;
            }
            String title1 = "Calculated versus experimental y values";
            Regression yyRegr = new Regression(this.yData, this.yCalc, this.weight);
            yyRegr.linear();
            double[] coef = yyRegr.getCoeff();
            data[2][0] = Fmath.minimum(this.yData);
            data[3][0] = coef[0] + coef[1] * data[2][0];
            data[2][1] = Fmath.maximum(this.yData);
            data[3][1] = coef[0] + coef[1] * data[2][1];
            PlotGraph pg = new PlotGraph(data);
            if (this.plotWindowCloseChoice) {
                pg.setCloseChoice(2);
            } else {
                pg.setCloseChoice(1);
            }
            pg.setGraphTitle(title0);
            pg.setGraphTitle2(title1);
            pg.setXaxisLegend("Experimental y value");
            pg.setYaxisLegend("Calculated y value");
            int[] popt = new int[]{1, 0};
            pg.setPoint(popt);
            int[] lopt = new int[]{0, 3};
            pg.setLine(lopt);
            pg.plot();
        }
    }

    protected String setGandPtitle(String title) {
        String title1 = "";
        switch (this.lastMethod) {
            case 0: {
                title1 = "Linear regression (with intercept): " + title;
                break;
            }
            case 1: {
                title1 = "Linear(polynomial with degree = " + (this.nParam - 1) + ") regression: " + title;
                break;
            }
            case 2: {
                title1 = "General linear regression: " + title;
                break;
            }
            case 3: {
                title1 = "Non-linear (simplex) regression: " + title;
                break;
            }
            case 4: {
                title1 = "Fit to a Gaussian distribution: " + title;
                break;
            }
            case 5: {
                title1 = "Fit to a Lorentzian distribution: " + title;
                break;
            }
            case 6: {
                title1 = "Fit to a Poisson distribution: " + title;
                break;
            }
            case 7: {
                title1 = "Fit to a Two Parameter Minimum Order Statistic Gumbel distribution: " + title;
                break;
            }
            case 8: {
                title1 = "Fit to a two Parameter Maximum Order Statistic Gumbel distribution: " + title;
                break;
            }
            case 9: {
                title1 = "Fit to a One Parameter Minimum Order Statistic Gumbel distribution: " + title;
                break;
            }
            case 10: {
                title1 = "Fit to a One Parameter Maximum Order Statistic Gumbel distribution: " + title;
                break;
            }
            case 11: {
                title1 = "Fit to a Standard Minimum Order Statistic Gumbel distribution: " + title;
                break;
            }
            case 12: {
                title1 = "Fit to a Standard Maximum Order Statistic Gumbel distribution: " + title;
                break;
            }
            case 13: {
                title1 = "Fit to a Three Parameter Frechet distribution: " + title;
                break;
            }
            case 14: {
                title1 = "Fit to a Two Parameter Frechet distribution: " + title;
                break;
            }
            case 15: {
                title1 = "Fit to a Standard Frechet distribution: " + title;
                break;
            }
            case 16: {
                title1 = "Fit to a Three Parameter Weibull distribution: " + title;
                break;
            }
            case 17: {
                title1 = "Fit to a Two Parameter Weibull distribution: " + title;
                break;
            }
            case 18: {
                title1 = "Fit to a Standard Weibull distribution: " + title;
                break;
            }
            case 19: {
                title1 = "Fit to a Two Parameter Exponential distribution: " + title;
                break;
            }
            case 20: {
                title1 = "Fit to a One Parameter Exponential distribution: " + title;
                break;
            }
            case 21: {
                title1 = "Fit to a Standard exponential distribution: " + title;
                break;
            }
            case 22: {
                title1 = "Fit to a Rayleigh distribution: " + title;
                break;
            }
            case 23: {
                title1 = "Fit to a Two Parameter Pareto distribution: " + title;
                break;
            }
            case 24: {
                title1 = "Fit to a One Parameter Pareto distribution: " + title;
                break;
            }
            case 25: {
                title1 = "Fit to a Sigmoid Threshold Function: " + title;
                break;
            }
            case 26: {
                title1 = "Fit to a Rectangular Hyperbola: " + title;
                break;
            }
            case 27: {
                title1 = "Fit to a Scaled Heaviside Step Function: " + title;
                break;
            }
            case 28: {
                title1 = "Fit to a Hill/Sips Sigmoid: " + title;
                break;
            }
            case 29: {
                title1 = "Fit to a Shifted Pareto distribution: " + title;
                break;
            }
            case 30: {
                title1 = "Fit to a Logistic distribution: " + title;
                break;
            }
            case 31: {
                title1 = "Fit to a Beta distribution - interval [0, 1]: " + title;
                break;
            }
            case 32: {
                title1 = "Fit to a Beta distribution - interval [min, max]: " + title;
                break;
            }
            case 33: {
                title1 = "Fit to a Three Parameter Gamma distribution]: " + title;
                break;
            }
            case 34: {
                title1 = "Fit to a Standard Gamma distribution]: " + title;
                break;
            }
            case 35: {
                title1 = "Fit to an Erlang distribution]: " + title;
                break;
            }
            case 36: {
                title1 = "Fit to an two parameter log-normal distribution]: " + title;
                break;
            }
            case 37: {
                title1 = "Fit to an three parameter log-normal distribution]: " + title;
                break;
            }
            case 38: {
                title1 = "Fit to a Gaussian distribution with fixed parameters: " + title;
                break;
            }
            case 39: {
                title1 = "Fit to a EC50 dose response curve (four parameter logistic): " + title;
                break;
            }
            case 40: {
                title1 = "Fit to a EC50 dose response curve (top and bottom fixed): " + title;
                break;
            }
            case 41: {
                title1 = "Fit to a EC50 dose response curve - bottom constrained [>= 0]: " + title;
                break;
            }
            case 42: {
                title1 = "Fitting to a five parameter logistic function (top and bottom fixed)";
                break;
            }
            case 43: {
                title1 = "Fit to an exponential yscale.exp(A.x): " + title;
                break;
            }
            case 44: {
                title1 = "Fit to multiple exponentials sum[Ai.exp(Bi.x)]: " + title;
                break;
            }
            case 45: {
                title1 = "Fit to an exponential A.(1 - exp(B.x): " + title;
                break;
            }
            case 46: {
                title1 = "Fit to a constant a: " + title;
                break;
            }
            case 47: {
                title1 = "Linear regression (with fixed intercept): " + title;
                break;
            }
            case 48: {
                title1 = "Linear(polynomial with degree = " + (this.nParam - 1) + " and fixed intercept) regression: " + title;
                break;
            }
            case 49: {
                title1 = "Fitting multiple Gaussian distributions";
                break;
            }
            case 50: {
                title1 = "Fitting to a non-integer polynomial";
                break;
            }
            case 51: {
                title1 = "Fitting to a five parameter logistic function";
                break;
            }
            case 52: {
                title1 = "Fit to a shifted Rectangular Hyperbola: " + title;
                break;
            }
            default: {
                title1 = " " + title;
            }
        }
        return title1;
    }

    public void plotYY() {
        this.plotYY(this.graphTitle);
    }

    protected int plotXY(String title) {
        this.graphTitle = title;
        int flag = 0;
        if (!this.linNonLin && this.nParam > 0) {
            System.out.println("You attempted to use Regression.plotXY() for a non-linear regression without providing the function reference (pointer) in the plotXY argument list");
            System.out.println("No plot attempted");
            flag = -1;
            return flag;
        }
        flag = this.plotXYlinear(title);
        return flag;
    }

    public int plotXY() {
        int flag = this.plotXY(this.graphTitle);
        return flag;
    }

    protected int plotXY(RegressionFunction g, String title) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y array\nplotXY2 should have been called");
        }
        RegressionFunction regFun = g;
        int flag = this.plotXYnonlinear(regFun, title);
        return flag;
    }

    protected int plotXY2(RegressionFunction2 g, String title) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nsimplex should have been called");
        }
        this.graphTitle = title;
        RegressionFunction2 regFun = g;
        int flag = this.plotXYnonlinear(regFun, title);
        return flag;
    }

    protected int plotXY(RegressionFunction g) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y array\nplotXY2 should have been called");
        }
        RegressionFunction regFun = g;
        int flag = this.plotXYnonlinear(regFun, this.graphTitle);
        return flag;
    }

    protected int plotXY2(RegressionFunction2 g) {
        if (!this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle singly dimensioned y array\nplotXY should have been called");
        }
        RegressionFunction2 regFun = g;
        int flag = this.plotXYnonlinear(regFun, this.graphTitle);
        return flag;
    }

    public void addLegends() {
        int ans = JOptionPane.showConfirmDialog(null, "Do you wish to add your own legends to the x and y axes", "Axis Legends", 0, 3);
        if (ans == 0) {
            this.xLegend = JOptionPane.showInputDialog("Type the legend for the abscissae (x-axis) [first data set]");
            this.yLegend = JOptionPane.showInputDialog("Type the legend for the ordinates (y-axis) [second data set]");
            this.legendCheck = true;
        }
    }

    protected int plotXYlinear(String title) {
        String title2;
        String title1;
        double[][] data;
        int flag;
        block49: {
            int i;
            int npoints;
            block48: {
                this.graphTitle = title;
                flag = 0;
                if (this.nXarrays > 1) {
                    System.out.println("You attempted to use Regression.plotXY() for a multiple regression");
                    System.out.println("No plot attempted");
                    flag = -2;
                    return flag;
                }
                int ncurves = 2;
                npoints = 200;
                if (npoints < this.nData0) {
                    npoints = this.nData0;
                }
                if (this.lastMethod == 11 || this.lastMethod == 12 || this.lastMethod == 21) {
                    npoints = this.nData0;
                }
                data = PlotGraph.data(ncurves, npoints);
                double xmin = Fmath.minimum(this.xData[0]);
                double xmax = Fmath.maximum(this.xData[0]);
                double inc = (xmax - xmin) / (double)(npoints - 1);
                title1 = " ";
                title2 = " ";
                for (i = 0; i < this.nData0; ++i) {
                    data[0][i] = this.xData[0][i];
                    data[1][i] = this.yData[i];
                }
                data[2][0] = xmin;
                for (i = 1; i < npoints; ++i) {
                    data[2][i] = data[2][i - 1] + inc;
                }
                if (this.nParam != 0) break block48;
                switch (this.lastMethod) {
                    case 11: {
                        title1 = "No regression: Minimum Order Statistic Standard Gumbel (y = exp(x)exp(-exp(x))): " + this.graphTitle;
                        title2 = " points - experimental values;   line - theoretical curve;   no parameters to be estimated";
                        if (this.weightOpt) {
                            title2 = title2 + ";   error bars - weighting factors";
                        }
                        for (i = 0; i < npoints; ++i) {
                            data[3][i] = this.yCalc[i];
                        }
                        break block49;
                    }
                    case 12: {
                        title1 = "No regression:  Maximum Order Statistic Standard Gumbel (y = exp(-x)exp(-exp(-x))): " + this.graphTitle;
                        title2 = " points - experimental values;   line - theoretical curve;   no parameters to be estimated";
                        if (this.weightOpt) {
                            title2 = title2 + ";   error bars - weighting factors";
                        }
                        for (i = 0; i < npoints; ++i) {
                            data[3][i] = this.yCalc[i];
                        }
                        break block49;
                    }
                    case 21: {
                        title1 = "No regression:  Standard Exponential (y = exp(-x)): " + this.graphTitle;
                        title2 = " points - experimental values;   line - theoretical curve;   no parameters to be estimated";
                        if (this.weightOpt) {
                            title2 = title2 + ";   error bars - weighting factors";
                        }
                        for (i = 0; i < npoints; ++i) {
                            data[3][i] = this.yCalc[i];
                        }
                        break;
                    }
                }
                break block49;
            }
            switch (this.lastMethod) {
                case 0: {
                    title1 = "Linear regression  (y = a + b.x): " + this.graphTitle;
                    title2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        title2 = title2 + ";   error bars - weighting factors";
                    }
                    for (i = 0; i < npoints; ++i) {
                        data[3][i] = this.best[0] + this.best[1] * data[2][i];
                    }
                    break;
                }
                case 1: {
                    double sum;
                    title1 = "Linear (polynomial with degree = " + (this.nParam - 1) + ") regression: " + this.graphTitle;
                    title2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        title2 = title2 + ";   error bars - weighting factors";
                    }
                    for (i = 0; i < npoints; ++i) {
                        sum = this.best[0];
                        for (int j = 1; j < this.nParam; ++j) {
                            sum += this.best[j] * Math.pow(data[2][i], j);
                        }
                        data[3][i] = sum;
                    }
                    break;
                }
                case 2: {
                    title1 = "Linear regression  (y = a.x): " + this.graphTitle;
                    title2 = " points - experimental values;   line - best fit curve";
                    if (this.nXarrays == 1) {
                        if (this.weightOpt) {
                            title2 = title2 + ";   error bars - weighting factors";
                        }
                        for (i = 0; i < npoints; ++i) {
                            data[3][i] = this.best[0] * data[2][i];
                        }
                        break;
                    }
                    System.out.println("Regression.plotXY(linear): lastMethod, " + this.lastMethod + ",cannot be plotted in two dimensions");
                    System.out.println("No plot attempted");
                    flag = -1;
                    break;
                }
                case 11: {
                    title1 = "Linear regression: Minimum Order Statistic Standard Gumbel (y = a.z where z = exp(x)exp(-exp(x))): " + this.graphTitle;
                    title2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        title2 = title2 + ";   error bars - weighting factors";
                    }
                    for (i = 0; i < npoints; ++i) {
                        data[3][i] = this.best[0] * Math.exp(data[2][i]) * Math.exp(-Math.exp(data[2][i]));
                    }
                    break;
                }
                case 12: {
                    title1 = "Linear regression:  Maximum Order Statistic Standard Gumbel (y = a.z where z=exp(-x)exp(-exp(-x))): " + this.graphTitle;
                    title2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        title2 = title2 + ";   error bars - weighting factors";
                    }
                    for (i = 0; i < npoints; ++i) {
                        data[3][i] = this.best[0] * Math.exp(-data[2][i]) * Math.exp(-Math.exp(-data[2][i]));
                    }
                    break;
                }
                case 46: {
                    title1 = "Linear regression:  Fit to a constant (y = a): " + this.graphTitle;
                    title2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        title2 = title2 + ";   error bars - weighting factors";
                    }
                    for (i = 0; i < npoints; ++i) {
                        data[3][i] = this.best[0];
                    }
                    break;
                }
                case 47: {
                    title1 = "Linear regression  (y = fixed intercept + b.x): " + this.graphTitle;
                    title2 = " points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        title2 = title2 + ";   error bars - weighting factors";
                    }
                    for (i = 0; i < npoints; ++i) {
                        data[3][i] = this.fixedInterceptL + this.best[0] * data[2][i];
                    }
                    break;
                }
                case 48: {
                    double sum;
                    title1 = "Linear (polynomial with degree = " + this.nParam + ") regression: " + this.graphTitle;
                    title2 = "Fixed intercept;   points - experimental values;   line - best fit curve";
                    if (this.weightOpt) {
                        title2 = title2 + ";   error bars - weighting factors";
                    }
                    for (i = 0; i < npoints; ++i) {
                        sum = this.fixedInterceptP;
                        for (int j = 0; j < this.nParam; ++j) {
                            sum += this.best[j] * Math.pow(data[2][i], j + 1);
                        }
                        data[3][i] = sum;
                    }
                    break;
                }
                default: {
                    System.out.println("Regression.plotXY(linear): lastMethod, " + this.lastMethod + ", either not recognised or cannot be plotted in two dimensions");
                    System.out.println("No plot attempted");
                    flag = -1;
                    return flag;
                }
            }
        }
        PlotGraph pg = new PlotGraph(data);
        if (this.plotWindowCloseChoice) {
            pg.setCloseChoice(2);
        } else {
            pg.setCloseChoice(1);
        }
        pg.setGraphTitle(title1);
        pg.setGraphTitle2(title2);
        pg.setXaxisLegend(this.xLegend);
        pg.setYaxisLegend(this.yLegend);
        int[] popt = new int[]{1, 0};
        pg.setPoint(popt);
        int[] lopt = new int[]{0, 3};
        pg.setLine(lopt);
        if (this.weightOpt) {
            pg.setErrorBars(0, this.weight);
        }
        pg.plot();
        return flag;
    }

    public int plotXYnonlinear(Object regFun, String title) {
        this.graphTitle = title;
        RegressionFunction g1 = null;
        RegressionFunction2 g2 = null;
        if (this.multipleY) {
            g2 = (RegressionFunction2)regFun;
        } else {
            g1 = (RegressionFunction)regFun;
        }
        int flag = 0;
        if (this.lastMethod < 3) {
            System.out.println("Regression.plotXY(non-linear): lastMethod, " + this.lastMethod + ", either not recognised or cannot be plotted in two dimensions");
            System.out.println("No plot attempted");
            flag = -1;
            return flag;
        }
        if (this.nXarrays > 1) {
            System.out.println("Multiple Linear Regression with more than one independent variable cannot be plotted in two dimensions");
            System.out.println("plotYY() called instead of plotXY()");
            this.plotYY(title);
            flag = -2;
        } else if (this.multipleY) {
            int ncurves = 2;
            int npoints = 200;
            if (npoints < this.nData0) {
                npoints = this.nData0;
            }
            int kk = 0;
            double[] wWeight = new double[this.nData0];
            for (int jj = 0; jj < this.nYarrays; ++jj) {
                double[][] data = PlotGraph.data(ncurves, npoints);
                for (int i = 0; i < this.nData0; ++i) {
                    data[0][i] = this.xData[0][kk];
                    data[1][i] = this.yData[kk];
                    wWeight[i] = this.weight[kk];
                    ++kk;
                }
                double xmin = Fmath.minimum(this.xData[0]);
                double xmax = Fmath.maximum(this.xData[0]);
                double inc = (xmax - xmin) / (double)(npoints - 1);
                data[2][0] = xmin;
                for (int i = 1; i < npoints; ++i) {
                    data[2][i] = data[2][i - 1] + inc;
                }
                double[] xd = new double[this.nXarrays];
                for (int i = 0; i < npoints; ++i) {
                    xd[0] = data[2][i];
                    data[3][i] = g2.function(this.best, xd, jj * this.nData0);
                }
                String title1 = this.setGandPtitle(title);
                String title2 = " points - experimental values;   line - best fit curve;  y data array " + jj;
                if (this.weightOpt) {
                    title2 = title2 + ";   error bars - weighting factors";
                }
                PlotGraph pg = new PlotGraph(data);
                if (this.plotWindowCloseChoice) {
                    pg.setCloseChoice(2);
                } else {
                    pg.setCloseChoice(1);
                }
                pg.setGraphTitle(title1);
                pg.setGraphTitle2(title2);
                pg.setXaxisLegend(this.xLegend);
                pg.setYaxisLegend(this.yLegend);
                int[] popt = new int[]{1, 0};
                pg.setPoint(popt);
                int[] lopt = new int[]{0, 3};
                pg.setLine(lopt);
                if (this.weightOpt) {
                    pg.setErrorBars(0, wWeight);
                }
                pg.plot();
            }
        } else {
            int ncurves = 2;
            int npoints = 200;
            if (npoints < this.nData0) {
                npoints = this.nData0;
            }
            if (this.lastMethod == 6) {
                npoints = this.nData0;
            }
            double[][] data = PlotGraph.data(ncurves, npoints);
            for (int i = 0; i < this.nData0; ++i) {
                data[0][i] = this.xData[0][i];
                data[1][i] = this.yData[i];
            }
            if (this.lastMethod == 6) {
                double[] xd = new double[this.nXarrays];
                for (int i = 0; i < npoints; ++i) {
                    data[2][i] = data[0][i];
                    xd[0] = data[2][i];
                    data[3][i] = g1.function(this.best, xd);
                }
            } else {
                double xmin = Fmath.minimum(this.xData[0]);
                double xmax = Fmath.maximum(this.xData[0]);
                double inc = (xmax - xmin) / (double)(npoints - 1);
                data[2][0] = xmin;
                for (int i = 1; i < npoints; ++i) {
                    data[2][i] = data[2][i - 1] + inc;
                }
                double[] xd = new double[this.nXarrays];
                for (int i = 0; i < npoints; ++i) {
                    xd[0] = data[2][i];
                    data[3][i] = g1.function(this.best, xd);
                }
            }
            String title1 = this.setGandPtitle(title);
            String title2 = " points - experimental values;   line - best fit curve";
            if (this.weightOpt) {
                title2 = title2 + ";   error bars - weighting factors";
            }
            PlotGraph pg = new PlotGraph(data);
            if (this.plotWindowCloseChoice) {
                pg.setCloseChoice(2);
            } else {
                pg.setCloseChoice(1);
            }
            pg.setGraphTitle(title1);
            pg.setGraphTitle2(title2);
            pg.setXaxisLegend(this.xLegend);
            pg.setYaxisLegend(this.yLegend);
            int[] popt = new int[]{1, 0};
            pg.setPoint(popt);
            int[] lopt = new int[]{0, 3};
            pg.setLine(lopt);
            if (this.weightOpt) {
                pg.setErrorBars(0, this.weight);
            }
            pg.plot();
        }
        return flag;
    }

    public int plotXYfixed(Object regFun, String title) {
        this.graphTitle = title;
        RegressionFunction g1 = null;
        RegressionFunction2 g2 = null;
        if (this.multipleY) {
            g2 = (RegressionFunction2)regFun;
        } else {
            g1 = (RegressionFunction)regFun;
        }
        int flag = 0;
        if (this.lastMethod < 3) {
            System.out.println("Regression.plotXY(non-linear): lastMethod, " + this.lastMethod + ", either not recognised or cannot be plotted in two dimensions");
            System.out.println("No plot attempted");
            flag = -1;
            return flag;
        }
        if (this.nXarrays > 1) {
            System.out.println("Multiple Linear Regression with more than one independent variable cannot be plotted in two dimensions");
            System.out.println("plotYY() called instead of plotXY()");
            this.plotYY(title);
            flag = -2;
        } else if (this.multipleY) {
            int ncurves = 2;
            int npoints = 200;
            if (npoints < this.nData0) {
                npoints = this.nData0;
            }
            int kk = 0;
            double[] wWeight = new double[this.nData0];
            for (int jj = 0; jj < this.nYarrays; ++jj) {
                double[][] data = PlotGraph.data(ncurves, npoints);
                for (int i = 0; i < this.nData0; ++i) {
                    data[0][i] = this.xData[0][kk];
                    data[1][i] = this.yData[kk];
                    wWeight[i] = this.weight[kk];
                    ++kk;
                }
                double xmin = Fmath.minimum(this.xData[0]);
                double xmax = Fmath.maximum(this.xData[0]);
                double inc = (xmax - xmin) / (double)(npoints - 1);
                data[2][0] = xmin;
                for (int i = 1; i < npoints; ++i) {
                    data[2][i] = data[2][i - 1] + inc;
                }
                double[] xd = new double[this.nXarrays];
                for (int i = 0; i < npoints; ++i) {
                    xd[0] = data[2][i];
                    data[3][i] = g2.function(this.values, xd, jj * this.nData0);
                }
                String title1 = this.setGandPtitle(title);
                String title2 = " points - experimental values;   line - best fit curve;  y data array " + jj;
                if (this.weightOpt) {
                    title2 = title2 + ";   error bars - weighting factors";
                }
                PlotGraph pg = new PlotGraph(data);
                if (this.plotWindowCloseChoice) {
                    pg.setCloseChoice(2);
                } else {
                    pg.setCloseChoice(1);
                }
                pg.setGraphTitle(title1);
                pg.setGraphTitle2(title2);
                pg.setXaxisLegend(this.xLegend);
                pg.setYaxisLegend(this.yLegend);
                int[] popt = new int[]{1, 0};
                pg.setPoint(popt);
                int[] lopt = new int[]{0, 3};
                pg.setLine(lopt);
                if (this.weightOpt) {
                    pg.setErrorBars(0, wWeight);
                }
                pg.plot();
            }
        } else {
            int ncurves = 2;
            int npoints = 200;
            if (npoints < this.nData0) {
                npoints = this.nData0;
            }
            if (this.lastMethod == 6) {
                npoints = this.nData0;
            }
            double[][] data = PlotGraph.data(ncurves, npoints);
            for (int i = 0; i < this.nData0; ++i) {
                data[0][i] = this.xData[0][i];
                data[1][i] = this.yData[i];
            }
            if (this.lastMethod == 6) {
                double[] xd = new double[this.nXarrays];
                for (int i = 0; i < npoints; ++i) {
                    data[2][i] = data[0][i];
                    xd[0] = data[2][i];
                    data[3][i] = g1.function(this.values, xd);
                }
            } else {
                double xmin = Fmath.minimum(this.xData[0]);
                double xmax = Fmath.maximum(this.xData[0]);
                double inc = (xmax - xmin) / (double)(npoints - 1);
                data[2][0] = xmin;
                for (int i = 1; i < npoints; ++i) {
                    data[2][i] = data[2][i - 1] + inc;
                }
                double[] xd = new double[this.nXarrays];
                for (int i = 0; i < npoints; ++i) {
                    xd[0] = data[2][i];
                    data[3][i] = g1.function(this.values, xd);
                }
            }
            String title1 = this.setGandPtitle(title);
            String title2 = " points - experimental values;   line - best fit curve";
            if (this.weightOpt) {
                title2 = title2 + ";   error bars - weighting factors";
            }
            PlotGraph pg = new PlotGraph(data);
            if (this.plotWindowCloseChoice) {
                pg.setCloseChoice(2);
            } else {
                pg.setCloseChoice(1);
            }
            pg.setGraphTitle(title1);
            pg.setGraphTitle2(title2);
            pg.setXaxisLegend(this.xLegend);
            pg.setYaxisLegend(this.yLegend);
            int[] popt = new int[]{1, 0};
            pg.setPoint(popt);
            int[] lopt = new int[]{0, 3};
            pg.setLine(lopt);
            if (this.weightOpt) {
                pg.setErrorBars(0, this.weight);
            }
            pg.plot();
        }
        return flag;
    }

    public boolean getNlrStatus() {
        return this.nlrStatus;
    }

    public void setScale(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("The argument must be 0 (no scaling) 1(initial estimates all scaled to unity) or the array of scaling factors");
        }
        this.scaleOpt = n;
    }

    public void setScale(double[] sc) {
        this.scale = sc;
        this.scaleOpt = 2;
    }

    public double[] getScale() {
        return this.scale;
    }

    public void setMinTest(int n) {
        if (n < 0 || n > 1) {
            throw new IllegalArgumentException("minTest must be 0 or 1");
        }
        this.minTest = n;
    }

    public int getMinTest() {
        return this.minTest;
    }

    public double getSimplexSd() {
        return this.simplexSd;
    }

    public double[] getBestEstimates() {
        return Conv.copy(this.best);
    }

    public double[] getCoeff() {
        return Conv.copy(this.best);
    }

    public double[] getbestestimatesStandardDeviations() {
        return Conv.copy(this.bestSd);
    }

    public double[] getBestEstimatesStandardDeviations() {
        return Conv.copy(this.bestSd);
    }

    public double[] getCoeffSd() {
        return Conv.copy(this.bestSd);
    }

    public double[] getBestEstimatesErrors() {
        return Conv.copy(this.bestSd);
    }

    public double[] getInitialEstimates() {
        return Conv.copy(this.startH);
    }

    public double[] getScaledInitialEstimates() {
        return Conv.copy(this.startSH);
    }

    public double[] getInitialSteps() {
        return Conv.copy(this.stepH);
    }

    public double[] getScaledInitialSteps() {
        return Conv.copy(this.stepSH);
    }

    public double[] getCoeffVar() {
        double[] coeffVar = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            coeffVar[i] = this.bestSd[i] * 100.0 / this.best[i];
        }
        return coeffVar;
    }

    public double[] getPseudoSd() {
        return Conv.copy(this.pseudoSd);
    }

    public double[] getPseudoErrors() {
        return Conv.copy(this.pseudoSd);
    }

    public double[] getTvalues() {
        return Conv.copy(this.tValues);
    }

    public double[] getPvalues() {
        return Conv.copy(this.pValues);
    }

    public double[][] getXdata() {
        return Conv.copy(this.xData);
    }

    public double[] getYdata() {
        return Conv.copy(this.yData);
    }

    public double[] getYcalc() {
        double[] temp = new double[this.nData];
        for (int i = 0; i < this.nData; ++i) {
            temp[i] = this.yCalc[i];
        }
        return temp;
    }

    public double[] getResiduals() {
        double[] temp = new double[this.nData];
        for (int i = 0; i < this.nData; ++i) {
            temp[i] = this.yData[i] - this.yCalc[i];
        }
        return temp;
    }

    public double[] getWeightedResiduals() {
        double[] temp = new double[this.nData];
        for (int i = 0; i < this.nData; ++i) {
            temp[i] = (this.yData[i] - this.yCalc[i]) / this.weight[i];
        }
        return temp;
    }

    public double getSumOfSquares() {
        return this.sumOfSquaresError;
    }

    public double getSumOfUnweightedResidualSquares() {
        return this.sumOfSquaresError;
    }

    public double getSumOfWeightedResidualSquares() {
        return this.chiSquare;
    }

    public double getChiSquare() {
        return this.chiSquare;
    }

    public double getReducedChiSquare() {
        return this.reducedChiSquare;
    }

    public double getTotalSumOfWeightedSquares() {
        return this.sumOfSquaresTotal;
    }

    public double getRegressionSumOfWeightedSquares() {
        return this.sumOfSquaresRegrn;
    }

    public double getCoefficientOfDetermination() {
        return this.multR;
    }

    public double getSampleR() {
        return this.multR;
    }

    public double getAdjustedCoefficientOfDetermination() {
        return this.adjustedR;
    }

    public double getCoeffDeterminationFratio() {
        return this.multipleF;
    }

    public double getCoeffDeterminationFratioProb() {
        return this.multipleFprob;
    }

    public double[][] getCovMatrix() {
        return this.covar;
    }

    public double[][] getCorrCoeffMatrix() {
        return this.corrCoeff;
    }

    public int getNiter() {
        return this.nIter;
    }

    public void setNmax(int nmax) {
        this.nMax = nmax;
    }

    public int getNmax() {
        return this.nMax;
    }

    public void setNmin(int nmin) {
        this.minIter = nmin;
    }

    public int getNmin() {
        return this.minIter;
    }

    public int getNrestarts() {
        return this.kRestart;
    }

    public void setNrestartsMax(int nrs) {
        this.konvge = nrs;
    }

    public int getNrestartsMax() {
        return this.konvge;
    }

    public double getDegFree() {
        return this.degreesOfFreedom;
    }

    public void setNMreflect(double refl) {
        this.rCoeff = refl;
    }

    public double getNMreflect() {
        return this.rCoeff;
    }

    public void setNMextend(double ext) {
        this.eCoeff = ext;
    }

    public double getNMextend() {
        return this.eCoeff;
    }

    public void setNMcontract(double con) {
        this.cCoeff = con;
    }

    public double getNMcontract() {
        return this.cCoeff;
    }

    public void setTolerance(double tol) {
        this.fTol = tol;
    }

    public double getTolerance() {
        return this.fTol;
    }

    public double[][] getGrad() {
        return this.grad;
    }

    public void setDelta(double delta) {
        this.delta = delta;
    }

    public double getDelta() {
        return this.delta;
    }

    public boolean getInversionCheck() {
        return this.invertFlag;
    }

    public boolean getPosVarCheck() {
        return this.posVarFlag;
    }

    public static Vector<Object> testOfAdditionalTerms(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints) {
        return Regression.testOfAdditionalTerms(chiSquareR, nParametersR, chiSquareF, nParametersF, nPoints, 0.05);
    }

    public static Vector<Object> testOfAdditionalTerms(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints, double significance) {
        ArrayList<Object> res = Regression.testOfAdditionalTerms_ArrayList(chiSquareR, nParametersR, chiSquareF, nParametersF, nPoints);
        Vector<Object> ret = null;
        if (res != null) {
            int n = ret.size();
            ret = new Vector<Object>(n);
            for (int i = 0; i < n; ++i) {
                ret.addElement(res.get(i));
            }
        }
        return ret;
    }

    public static Vector<Object> testOfAdditionalTerms_Vector(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints) {
        return Regression.testOfAdditionalTerms(chiSquareR, nParametersR, chiSquareF, nParametersF, nPoints, 0.05);
    }

    public static Vector<Object> testOfAdditionalTerms_Vector(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints, double significance) {
        return Regression.testOfAdditionalTerms(chiSquareR, nParametersR, chiSquareF, nParametersF, nPoints, significance);
    }

    public static ArrayList<Object> testOfAdditionalTerms_ArrayList(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints) {
        return Regression.testOfAdditionalTerms_ArrayList(chiSquareR, nParametersR, chiSquareF, nParametersF, nPoints, 0.05);
    }

    public static ArrayList<Object> testOfAdditionalTerms_ArrayList(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints, double significance) {
        int degFreedomR = nPoints - nParametersR;
        int degFreedomF = nPoints - nParametersF;
        boolean reversed = false;
        if (degFreedomR < degFreedomF) {
            reversed = true;
            double holdD = chiSquareR;
            chiSquareR = chiSquareF;
            chiSquareF = holdD;
            int holdI = nParametersR;
            nParametersR = nParametersF;
            nParametersF = holdI;
            degFreedomR = nPoints - nParametersR;
            degFreedomF = nPoints - nParametersF;
            System.out.println("package flanagan.analysis; class Regression; method testAdditionalTerms");
            System.out.println("the order of the chi-squares has been reversed to give a second chi- square with the lowest degrees of freedom");
        }
        int degFreedomD = degFreedomR - degFreedomF;
        double numer = (chiSquareR - chiSquareF) / (double)degFreedomD;
        double denom = chiSquareF / (double)degFreedomF;
        double fRatio = numer / denom;
        double fProb = 1.0;
        if (chiSquareR > chiSquareF) {
            fProb = Stat.fTestProb(fRatio, degFreedomD, degFreedomF);
        }
        ArrayList<Object> arrayl = new ArrayList<Object>();
        arrayl.add(new Double(fRatio));
        arrayl.add(new Double(fProb));
        arrayl.add(new Boolean(reversed));
        arrayl.add(new Double(chiSquareR));
        arrayl.add(new Integer(nParametersR));
        arrayl.add(new Double(chiSquareF));
        arrayl.add(new Integer(nParametersF));
        arrayl.add(new Integer(nPoints));
        arrayl.add(new Double(Stat.fTestValueGivenFprob(significance, degFreedomD, degFreedomF)));
        return arrayl;
    }

    public static double testOfAdditionalTermsFratio(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints) {
        return Regression.testOfAdditionalTermsFratio(chiSquareR, nParametersR, chiSquareF, nParametersF, nPoints, 0.05);
    }

    public static double testOfAdditionalTermsFratio(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints, double significance) {
        int degFreedomR = nPoints - nParametersR;
        int degFreedomF = nPoints - nParametersF;
        boolean reversed = false;
        if (degFreedomR < degFreedomF) {
            reversed = true;
            double holdD = chiSquareR;
            chiSquareR = chiSquareF;
            chiSquareF = holdD;
            int holdI = nParametersR;
            nParametersR = nParametersF;
            nParametersF = holdI;
            degFreedomR = nPoints - nParametersR;
            degFreedomF = nPoints - nParametersF;
            System.out.println("package flanagan.analysis; class Regression; method testAdditionalTermsFratio");
            System.out.println("the order of the chi-squares has been reversed to give a second chi- square with the lowest degrees of freedom");
        }
        int degFreedomD = degFreedomR - degFreedomF;
        double numer = (chiSquareR - chiSquareF) / (double)degFreedomD;
        double denom = chiSquareF / (double)degFreedomF;
        double fRatio = numer / denom;
        return fRatio;
    }

    public static double testOfAdditionalTermsFprobability(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints) {
        return Regression.testOfAdditionalTermsFprobability(chiSquareR, nParametersR, chiSquareF, nParametersF, nPoints, 0.05);
    }

    public static double testOfAdditionalTermsFprobability(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints, double significance) {
        int degFreedomR = nPoints - nParametersR;
        int degFreedomF = nPoints - nParametersF;
        boolean reversed = false;
        if (degFreedomR < degFreedomF) {
            reversed = true;
            double holdD = chiSquareR;
            chiSquareR = chiSquareF;
            chiSquareF = holdD;
            int holdI = nParametersR;
            nParametersR = nParametersF;
            nParametersF = holdI;
            degFreedomR = nPoints - nParametersR;
            degFreedomF = nPoints - nParametersF;
            System.out.println("package flanagan.analysis; class Regression; method testAdditionalTermsFprobability");
            System.out.println("the order of the chi-squares has been reversed to give a second chi- square with the lowest degrees of freedom");
        }
        int degFreedomD = degFreedomR - degFreedomF;
        double numer = (chiSquareR - chiSquareF) / (double)degFreedomD;
        double denom = chiSquareF / (double)degFreedomF;
        double fRatio = numer / denom;
        double fProb = 1.0;
        if (chiSquareR > chiSquareF) {
            fProb = Stat.fTestProb(fRatio, degFreedomD, degFreedomF);
        }
        return fProb;
    }

    public static double testOfAdditionalTermsFprobabilty(double chiSquareR, int nParametersR, double chiSquareF, int nParametersF, int nPoints) {
        return Regression.testOfAdditionalTermsFprobability(chiSquareR, nParametersR, chiSquareF, nParametersF, nPoints, 0.05);
    }

    public void poisson() {
        this.userSupplied = false;
        this.fitPoisson(0);
    }

    public void poissonPlot() {
        this.userSupplied = false;
        this.fitPoisson(1);
    }

    protected void fitPoisson(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 6;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        for (int i = 0; i < this.nData; ++i) {
            if (this.xData[0][i] - Math.floor(this.xData[0][i]) == 0.0) continue;
            throw new IllegalArgumentException("all abscissae must be, mathematically, integer values");
        }
        ArrayList<Object> ret1 = Regression.dataSign(this.yData);
        Double tempd = null;
        Integer tempi = null;
        tempi = (Integer)ret1.get(5);
        int peaki = tempi;
        double mean = this.xData[0][peaki];
        tempd = (Double)ret1.get(4);
        double peak = tempd;
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        start[0] = mean;
        if (this.scaleFlag) {
            start[1] = peak / (Math.exp(mean * Math.log(mean) - Stat.logFactorial(mean)) * Math.exp(-mean));
        }
        step[0] = 0.1 * start[0];
        if (step[0] == 0.0) {
            ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
            Double tempdd = null;
            tempdd = (Double)ret0.get(2);
            double xmax = tempdd;
            if (xmax == 0.0) {
                tempdd = (Double)ret0.get(0);
                xmax = tempdd;
            }
            step[0] = xmax * 0.1;
        }
        if (this.scaleFlag) {
            step[1] = 0.1 * start[1];
        }
        PoissonFunction f = new PoissonFunction();
        this.addConstraint(1, -1, 0.0);
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        PoissonFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            if (!this.supressPrint) {
                this.print();
            }
            this.plotOpt = false;
            int flag = this.plotXY(f);
            if (flag != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void gaussian() {
        this.userSupplied = false;
        this.fitGaussian(0);
    }

    public void normal() {
        this.userSupplied = false;
        this.fitGaussian(0);
    }

    public void gaussianPlot() {
        this.userSupplied = false;
        this.fitGaussian(1);
    }

    public void normalPlot() {
        this.userSupplied = false;
        this.fitGaussian(1);
    }

    protected void fitGaussian(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 4;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitGaussian(): This implementation of the Gaussian distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> ret1 = Regression.dataSign(this.yData);
        Integer tempi = null;
        tempi = (Integer)ret1.get(5);
        int peaki = tempi;
        double mean = this.xData[0][peaki];
        double sd = Math.sqrt(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        tempd = (Double)ret1.get(4);
        double ym = tempd;
        ym = ym * sd * Math.sqrt(Math.PI * 2);
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        start[0] = mean;
        start[1] = sd;
        if (this.scaleFlag) {
            start[2] = ym;
        }
        step[0] = 0.1 * sd;
        step[1] = 0.1 * start[1];
        if (step[1] == 0.0) {
            ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
            Double tempdd = null;
            tempdd = (Double)ret0.get(2);
            double xmax = tempdd;
            if (xmax == 0.0) {
                tempdd = (Double)ret0.get(0);
                xmax = tempdd;
            }
            step[1] = xmax * 0.1;
        }
        if (this.scaleFlag) {
            step[2] = 0.1 * start[2];
        }
        GaussianFunction f = new GaussianFunction();
        this.addConstraint(1, -1, 0.0);
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        GaussianFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public void gaussian(double[] initialEstimates, boolean[] fixed) {
        this.userSupplied = true;
        this.fitGaussianFixed(initialEstimates, fixed, 0);
    }

    public void normal(double[] initialEstimates, boolean[] fixed) {
        this.userSupplied = true;
        this.fitGaussianFixed(initialEstimates, fixed, 0);
    }

    public void gaussianPlot(double[] initialEstimates, boolean[] fixed) {
        this.userSupplied = true;
        this.fitGaussianFixed(initialEstimates, fixed, 1);
    }

    public void normalPlot(double[] initialEstimates, boolean[] fixed) {
        this.userSupplied = true;
        this.fitGaussianFixed(initialEstimates, fixed, 1);
    }

    protected void fitGaussianFixed(double[] initialEstimates, boolean[] fixed, int plotFlag) {
        int flag;
        int i;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 38;
        this.values = initialEstimates;
        this.fixed = fixed;
        this.scaleFlag = true;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitGaussian(): This implementation of the Gaussian distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i2 = 0; i2 < this.nData; ++i2) {
                this.yData[i2] = -this.yData[i2];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        GaussianFunctionFixed f = new GaussianFunctionFixed();
        f.fixed = fixed;
        f.param = initialEstimates;
        int nT = this.nParam;
        for (int i3 = 0; i3 < this.nParam; ++i3) {
            if (!fixed[i3]) continue;
            --nT;
        }
        if (nT == 0) {
            if (plotFlag == 0) {
                throw new IllegalArgumentException("At least one parameter must be available for variation by the Regression procedure or GauasianPlot should have been called and not Gaussian");
            }
            plotFlag = 3;
        }
        double[] start = new double[nT];
        double[] step = new double[nT];
        boolean[] constraint = new boolean[nT];
        double xMin = Fmath.minimum(this.xData[0]);
        double xMax = Fmath.maximum(this.xData[0]);
        double yMax = Fmath.maximum(this.yData);
        if (initialEstimates[2] == 0.0) {
            if (fixed[2]) {
                throw new IllegalArgumentException("Scale factor has been fixed at zero");
            }
            initialEstimates[2] = yMax;
        }
        int ii = 0;
        for (i = 0; i < this.nParam; ++i) {
            if (fixed[i]) continue;
            start[ii] = initialEstimates[i];
            step[ii] = start[ii] * 0.1;
            if (step[ii] == 0.0) {
                step[ii] = (xMax - xMin) * 0.1;
            }
            constraint[ii] = false;
            if (i == 1) {
                constraint[ii] = true;
            }
            ++ii;
        }
        this.nParam = nT;
        for (i = 0; i < this.nParam; ++i) {
            if (!constraint[i]) continue;
            this.addConstraint(i, -1, 0.0);
        }
        GaussianFunctionFixed regFun2 = f;
        if (plotFlag != 3) {
            this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        }
        if (plotFlag == 1) {
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (plotFlag == 3) {
            flag = this.plotXYfixed(regFun2, "Gaussian distribution - all parameters fixed");
        }
        if (yFlag) {
            for (int i4 = 0; i4 < this.nData - 1; ++i4) {
                this.yData[i4] = -this.yData[i4];
            }
        }
    }

    public void multipleGaussiansPlot(int nGaussians, double[] initMeans, double[] initSDs, double[] initFracts) {
        if (initMeans.length != nGaussians) {
            throw new IllegalArgumentException("length of initial means array, " + initMeans.length + ", does not equal the number of Gaussians, " + nGaussians);
        }
        if (initSDs.length != nGaussians) {
            throw new IllegalArgumentException("length of initial standard deviations array, " + initSDs.length + ", does not equal the number of Gaussians, " + nGaussians);
        }
        if (initFracts.length != nGaussians) {
            throw new IllegalArgumentException("length of initial fractional weights array, " + initFracts.length + ", does not equal the number of Gaussians, " + nGaussians);
        }
        double sum = 0.0;
        for (int i = 0; i < nGaussians; ++i) {
            sum += initFracts[i];
        }
        if (sum != 1.0) {
            System.out.println("Regression method multipleGaussiansPlot: the sum of the initial estimates of the fractional weights, " + sum + ", does not equal 1.0");
            System.out.println("Program continued using the supplied fractional weights");
        }
        this.fitMultipleGaussians(nGaussians, initMeans, initSDs, initFracts, 1);
    }

    protected void fitMultipleGaussians(int nGaussians, double[] initMeans, double[] initSDs, double[] initFracts, int plotFlag) {
        this.nGaussians = nGaussians;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 49;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3 * this.nGaussians;
        boolean scaleFlagHold = this.scaleFlag;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        int nMaxHold = this.nMax;
        if (this.nMax < 10000) {
            this.nMax = 10000;
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitGaussian(): This implementation of the Gaussian distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> ret1 = Regression.dataSign(this.yData);
        Integer tempi = null;
        tempi = (Integer)ret1.get(5);
        int peaki = tempi;
        double mean = this.xData[0][peaki];
        double sd = Math.sqrt(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        tempd = (Double)ret1.get(4);
        double ym = tempd;
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        int counter = 0;
        for (int i = 0; i < nGaussians; ++i) {
            start[counter] = initMeans[i];
            step[counter] = Math.abs(0.1 * start[counter]);
            start[counter + 1] = initSDs[i];
            step[counter + 1] = Math.abs(0.1 * start[counter + 1]);
            if (step[counter + 1] == 0.0) {
                ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
                Double tempdd = null;
                tempdd = (Double)ret0.get(2);
                double xmax = tempdd;
                if (xmax == 0.0) {
                    tempdd = (Double)ret0.get(0);
                    xmax = tempdd;
                }
                step[counter + 1] = Math.abs(xmax * 0.1);
            }
            start[counter + 2] = initFracts[i] * Math.sqrt(Math.PI * 2) * start[counter + 1] * ym;
            step[counter + 2] = Math.abs(0.1 * start[counter + 2]);
            counter += 3;
        }
        MultipleGaussianFunction f = new MultipleGaussianFunction();
        f.scaleOption = this.scaleFlag;
        double ysf = this.yScaleFactor;
        if (!this.scaleFlag) {
            ysf = 1.0;
        }
        f.scaleFactor = ysf;
        f.nGaussians = this.nGaussians;
        for (int i = 0; i < this.nGaussians; ++i) {
            this.addConstraint(3 * i + 1, -1, 0.0);
            this.addConstraint(3 * i + 2, -1, 0.0);
        }
        MultipleGaussianFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        this.multGaussFract = new double[this.nGaussians];
        this.multGaussFractErrors = new double[this.nGaussians];
        this.multGaussCoeffVar = new double[this.nGaussians];
        this.multGaussTvalue = new double[this.nGaussians];
        this.multGaussPvalue = new double[this.nGaussians];
        for (int i = 0; i < nGaussians; ++i) {
            this.multGaussFractErrors[i] = Double.NaN;
            this.multGaussCoeffVar[i] = Double.NaN;
            this.multGaussTvalue[i] = Double.NaN;
            this.multGaussPvalue[i] = Double.NaN;
        }
        this.multGaussScaleError = Double.NaN;
        this.multGaussScaleCoeffVar = Double.NaN;
        this.multGaussScaleTvalue = Double.NaN;
        this.multGaussScalePvalue = Double.NaN;
        this.multGaussScaleTvalue = Double.NaN;
        this.multGaussScalePvalue = Double.NaN;
        if (this.invertFlag) {
            ErrorProp[] multGaussErrorProp = new ErrorProp[this.nGaussians];
            ErrorProp sum = new ErrorProp(0.0, 0.0);
            for (int i = 0; i < nGaussians; ++i) {
                multGaussErrorProp[i] = new ErrorProp(this.best[3 * i + 2], this.bestSd[3 * i + 2]);
                sum = sum.plus(multGaussErrorProp[i]);
            }
            ErrorProp epScale = new ErrorProp(0.0, 0.0);
            for (int i = 0; i < nGaussians; ++i) {
                ErrorProp epFract = multGaussErrorProp[i].over(sum);
                this.multGaussFract[i] = epFract.getValue();
                this.multGaussFractErrors[i] = epFract.getError();
                epScale = epScale.plus(multGaussErrorProp[i].over(epFract));
                this.multGaussCoeffVar[i] = 100.0 * this.multGaussFractErrors[i] / this.multGaussFract[i];
                this.multGaussTvalue[i] = this.multGaussFract[i] / this.multGaussFractErrors[i];
                double atv = Math.abs(this.multGaussTvalue[i]);
                this.multGaussPvalue[i] = atv != atv ? Double.NaN : 1.0 - Stat.studentTcdf(-atv, atv, this.degreesOfFreedom);
            }
            epScale = epScale.over(this.nGaussians);
            this.multGaussScale = epScale.getValue();
            this.multGaussScaleError = epScale.getError();
            this.multGaussScaleCoeffVar = 100.0 * this.multGaussScaleError / this.multGaussScale;
            this.multGaussScaleTvalue = this.multGaussScale / this.multGaussScaleError;
            double atv = Math.abs(this.multGaussScaleTvalue);
            this.multGaussScalePvalue = atv != atv ? Double.NaN : 1.0 - Stat.studentTcdf(-atv, atv, this.degreesOfFreedom);
        } else {
            int i;
            double sum = 0.0;
            for (i = 0; i < nGaussians; ++i) {
                sum += this.best[3 * i + 2];
            }
            this.multGaussScale = 0.0;
            for (i = 0; i < nGaussians; ++i) {
                this.multGaussFract[i] = this.best[3 * i + 2] / sum;
                this.multGaussScale += this.multGaussFract[i];
            }
            this.multGaussScale /= (double)this.nGaussians;
        }
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
        this.nMax = nMaxHold;
        this.scaleFlag = scaleFlagHold;
    }

    public void logNormal() {
        this.fitLogNormalTwoPar(0);
    }

    public void logNormalTwoPar() {
        this.fitLogNormalTwoPar(0);
    }

    public void logNormalPlot() {
        this.fitLogNormalTwoPar(1);
    }

    public void logNormalTwoParPlot() {
        this.fitLogNormalTwoPar(1);
    }

    protected void fitLogNormalTwoPar(int plotFlag) {
        double xmax;
        Double tempdd;
        ArrayList<Object> ret0;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 36;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitLogNormalTwoPar(): This implementation of the two parameter log-nprmal distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> ret1 = Regression.dataSign(this.yData);
        Integer tempi = null;
        tempi = (Integer)ret1.get(5);
        int peaki = tempi;
        double mean = this.xData[0][peaki];
        double mu = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            mu += Math.log(this.xData[0][i]);
        }
        mu /= (double)this.nData;
        double sigma = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            sigma += Fmath.square(Math.log(this.xData[0][i]) - mu);
        }
        sigma = Math.sqrt(sigma / (double)this.nData);
        tempd = (Double)ret1.get(4);
        double ym = tempd;
        ym *= Math.exp(mu - sigma * sigma / 2.0);
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        start[0] = mu;
        start[1] = sigma;
        if (this.scaleFlag) {
            start[2] = ym;
        }
        step[0] = 0.1 * start[0];
        step[1] = 0.1 * start[1];
        if (step[0] == 0.0) {
            ret0 = Regression.dataSign(this.xData[0]);
            tempdd = null;
            tempdd = (Double)ret0.get(2);
            xmax = tempdd;
            if (xmax == 0.0) {
                tempdd = (Double)ret0.get(0);
                xmax = tempdd;
            }
            step[0] = xmax * 0.1;
        }
        if (step[0] == 0.0) {
            ret0 = Regression.dataSign(this.xData[0]);
            tempdd = null;
            tempdd = (Double)ret0.get(2);
            xmax = tempdd;
            if (xmax == 0.0) {
                tempdd = (Double)ret0.get(0);
                xmax = tempdd;
            }
            step[1] = xmax * 0.1;
        }
        if (this.scaleFlag) {
            step[2] = 0.1 * start[2];
        }
        LogNormalTwoParFunction f = new LogNormalTwoParFunction();
        this.addConstraint(1, -1, 0.0);
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        LogNormalTwoParFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public void logNormalThreePar() {
        this.fitLogNormalThreePar(0);
    }

    public void logNormalThreeParPlot() {
        this.fitLogNormalThreePar(1);
    }

    protected void fitLogNormalThreePar(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 37;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 4;
        if (!this.scaleFlag) {
            this.nParam = 3;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitLogNormalThreePar(): This implementation of the three parameter log-normal distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> ret1 = Regression.dataSign(this.yData);
        Integer tempi = null;
        tempi = (Integer)ret1.get(5);
        int peaki = tempi;
        double mean = this.xData[0][peaki];
        double gamma = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            gamma += this.xData[0][i];
        }
        gamma /= (double)this.nData;
        double beta = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            beta += Fmath.square(Math.log(this.xData[0][i]) - Math.log(gamma));
        }
        beta = Math.sqrt(beta / (double)this.nData);
        ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
        Double tempdd = null;
        tempdd = (Double)ret0.get(0);
        double xmin = tempdd;
        tempdd = (Double)ret0.get(2);
        double xmax = tempdd;
        double alpha = xmin - (xmax - xmin) / 100.0;
        if (xmin == 0.0) {
            alpha -= (xmax - xmin) / 100.0;
        }
        tempd = (Double)ret1.get(4);
        double ym = tempd;
        ym = ym * (gamma + alpha) * Math.exp(-beta * beta / 2.0);
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        start[0] = alpha;
        start[1] = beta;
        start[2] = gamma;
        if (this.scaleFlag) {
            start[3] = ym;
        }
        step[0] = 0.1 * start[0];
        step[1] = 0.1 * start[1];
        step[2] = 0.1 * start[2];
        for (int i = 0; i < 3; ++i) {
            if (step[i] != 0.0) continue;
            step[i] = xmax * 0.1;
        }
        if (this.scaleFlag) {
            step[3] = 0.1 * start[3];
        }
        LogNormalThreeParFunction f = new LogNormalThreeParFunction();
        this.addConstraint(0, 1, xmin);
        this.addConstraint(1, -1, 0.0);
        this.addConstraint(2, -1, 0.0);
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        LogNormalThreeParFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public void lorentzian() {
        this.fitLorentzian(0);
    }

    public void lorentzianPlot() {
        this.fitLorentzian(1);
    }

    protected void fitLorentzian(int allTest) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 5;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitLorentzian(): This implementation of the Lorentzian distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> ret1 = Regression.dataSign(this.yData);
        Integer tempi = null;
        tempi = (Integer)ret1.get(5);
        int peaki = tempi;
        double mean = this.xData[0][peaki];
        double sd = Regression.halfWidth(this.xData[0], this.yData);
        tempd = (Double)ret1.get(4);
        double ym = tempd;
        ym = ym * sd * Math.PI / 2.0;
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        start[0] = mean;
        start[1] = sd * 0.9;
        if (this.scaleFlag) {
            start[2] = ym;
        }
        step[0] = 0.2 * sd;
        if (step[0] == 0.0) {
            ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
            Double tempdd = null;
            tempdd = (Double)ret0.get(2);
            double xmax = tempdd;
            if (xmax == 0.0) {
                tempdd = (Double)ret0.get(0);
                xmax = tempdd;
            }
            step[0] = xmax * 0.1;
        }
        step[1] = 0.2 * start[1];
        if (this.scaleFlag) {
            step[2] = 0.2 * start[2];
        }
        LorentzianFunction f = new LorentzianFunction();
        this.addConstraint(1, -1, 0.0);
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        LorentzianFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (allTest == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public static void fitOneOrSeveralDistributions(double[] array) {
        int numberOfPoints = array.length;
        double maxValue = Fmath.maximum(array);
        double minValue = Fmath.minimum(array);
        double span = maxValue - minValue;
        int numberOfBins = (int)Math.ceil(Math.sqrt(numberOfPoints));
        double binWidth = span / (double)numberOfBins;
        double averagePointsPerBin = (double)numberOfPoints / (double)numberOfBins;
        String comment = "Maximum value:  " + maxValue + "\n";
        comment = comment + "Minimum value:  " + minValue + "\n";
        comment = comment + "Suggested bin width:  " + binWidth + "\n";
        comment = comment + "Giving an average points per bin:  " + averagePointsPerBin + "\n";
        comment = comment + "If you wish to change the bin width enter the new value below \n";
        comment = comment + "and click on OK\n";
        comment = comment + "If you do NOT wish to change the bin width simply click on OK";
        binWidth = Db.readDouble(comment, binWidth);
        comment = "Input the name of the output text file\n";
        comment = comment + "[Do not forget the extension, e.g.   .txt]";
        String outputTitle = Db.readLine(comment, "fitOneOrSeveralDistributionsOutput.txt");
        FileOutput fout = new FileOutput(outputTitle, 'n');
        fout.println("Fitting a set of data to one or more distributions");
        fout.println("Class Regression/Stat: method fitAllDistributions");
        fout.dateAndTimeln();
        fout.println();
        fout.printtab("Number of points: ");
        fout.println(numberOfPoints);
        fout.printtab("Minimum value: ");
        fout.println(minValue);
        fout.printtab("Maximum value: ");
        fout.println(maxValue);
        fout.printtab("Number of bins: ");
        fout.println(numberOfBins);
        fout.printtab("Bin width: ");
        fout.println(binWidth);
        fout.printtab("Average number of points per bin: ");
        fout.println(averagePointsPerBin);
        fout.println();
        String[] comments = new String[]{"Gaussian Distribution", "Two parameter Log-normal Distribution", "Three parameter Log-normal Distribution", "Logistic Distribution", "Lorentzian Distribution", "Type 1 Extreme Distribution - Gumbel minimum order statistic", "Type 1 Extreme Distribution - Gumbel maximum order statistic", "Type 2 Extreme Distribution - Frechet", "Type 3 Extreme Distribution - Weibull", "Type 3 Extreme Distribution - Exponential Distribution", "Type 3 Extreme Distribution - Rayleigh Distribution", "Pareto Distribution", "Beta Distribution", "Gamma Distribution", "Erlang Distribution", "exit"};
        String[] boxTitles = new String[]{" ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", " ", "exit"};
        String headerComment = "Choose next distribution to be fitted by clicking on box number";
        int defaultBox = 1;
        boolean testDistType = true;
        Regression reg = null;
        double[] coeff = null;
        block17: while (testDistType) {
            int opt = Db.optionBox(headerComment, comments, boxTitles, defaultBox);
            switch (opt) {
                case 1: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.gaussianPlot();
                    coeff = reg.getCoeff();
                    fout.println("NORMAL (GAUSSIAN) DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Mean [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Standard deviation [sigma] ");
                    fout.println(coeff[1]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[2]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 2: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.logNormalTwoParPlot();
                    coeff = reg.getCoeff();
                    fout.println("LOG-NORMAL DISTRIBUTION (two parameter statistic)");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Shape parameter [sigma] ");
                    fout.println(coeff[1]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[2]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 3: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.logNormalThreeParPlot();
                    coeff = reg.getCoeff();
                    fout.println("LOG-NORMAL DISTRIBUTION (three parameter statistic)");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [alpha] ");
                    fout.println(coeff[0]);
                    fout.printtab("Shape parameter [beta] ");
                    fout.println(coeff[1]);
                    fout.printtab("Scale parameter [gamma] ");
                    fout.println(coeff[2]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[3]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 4: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.logisticPlot();
                    coeff = reg.getCoeff();
                    fout.println("LOGISTIC DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scale parameter [beta] ");
                    fout.println(coeff[1]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[2]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 5: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.lorentzianPlot();
                    coeff = reg.getCoeff();
                    fout.println("LORENTZIAN DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Mean [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Half-height parameter [Gamma] ");
                    fout.println(coeff[1]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[2]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 6: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.gumbelMinPlot();
                    coeff = reg.getCoeff();
                    fout.println("TYPE 1 (GUMBEL) EXTREME DISTRIBUTION [MINIMUM ORDER STATISTIC]");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scale parameter [sigma] ");
                    fout.println(coeff[1]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[2]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 7: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.gumbelMaxPlot();
                    coeff = reg.getCoeff();
                    fout.println("TYPE 1 (GUMBEL) EXTREME DISTRIBUTION [MAXIMUM ORDER STATISTIC]");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scale parameter [sigma] ");
                    fout.println(coeff[1]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[2]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 8: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.frechetPlot();
                    coeff = reg.getCoeff();
                    fout.println("TYPE 2 (FRECHET) EXTREME DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scale parameter [sigma] ");
                    fout.println(coeff[1]);
                    fout.printtab("Shape parameter [gamma] ");
                    fout.println(coeff[2]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[3]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 9: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.weibullPlot();
                    coeff = reg.getCoeff();
                    fout.println("TYPE 3 (WEIBULL) EXTREME DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scale parameter [sigma] ");
                    fout.println(coeff[1]);
                    fout.printtab("Shape parameter [gamma] ");
                    fout.println(coeff[2]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[3]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 10: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.exponentialPlot();
                    coeff = reg.getCoeff();
                    fout.println("EXPONENTIAL DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scale parameter [sigma] ");
                    fout.println(coeff[1]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[2]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 11: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.rayleighPlot();
                    coeff = reg.getCoeff();
                    fout.println("RAYLEIGH DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Scale parameter [beta] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[1]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 12: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.paretoThreeParPlot();
                    coeff = reg.getCoeff();
                    fout.println("PARETO DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Shape parameter [alpha] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scale parameter [beta] ");
                    fout.println(coeff[1]);
                    fout.printtab("Threshold parameter [theta] ");
                    fout.println(coeff[2]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[3]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 13: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.betaMinMaxPlot();
                    coeff = reg.getCoeff();
                    fout.println("BETA DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Shape parameter [alpha] ");
                    fout.println(coeff[0]);
                    fout.printtab("Shape parameter [beta] ");
                    fout.println(coeff[1]);
                    fout.printtab("minimum limit [min] ");
                    fout.println(coeff[2]);
                    fout.printtab("maximum limit [max] ");
                    fout.println(coeff[3]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[4]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 14: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.gammaPlot();
                    coeff = reg.getCoeff();
                    fout.println("GAMMA DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Location parameter [mu] ");
                    fout.println(coeff[0]);
                    fout.printtab("Scale parameter [beta] ");
                    fout.println(coeff[1]);
                    fout.printtab("Shape parameter [gamma] ");
                    fout.println(coeff[2]);
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[3]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
                case 15: {
                    reg = new Regression(array, binWidth);
                    reg.supressPrint();
                    reg.erlangPlot();
                    coeff = reg.getCoeff();
                    fout.println("ERLANG DISTRIBUTION");
                    fout.println("Best Estimates:");
                    fout.printtab("Shape parameter [lambda] ");
                    fout.println(coeff[0]);
                    fout.printtab("Rate parameter [k] ");
                    fout.println(reg.getKayValue());
                    fout.printtab("Scaling factor [Ao] ");
                    fout.println(coeff[1]);
                    Regression.regressionDetails(fout, reg);
                    continue block17;
                }
            }
            fout.close();
            testDistType = false;
        }
    }

    protected static void regressionDetails(FileOutput fout, Regression reg) {
        fout.println();
        fout.println("Regression details:");
        fout.printtab("Chi squared: ");
        fout.println(reg.getChiSquare());
        fout.printtab("Reduced chi squared: ");
        fout.println(reg.getReducedChiSquare());
        fout.printtab("Sum of squares: ");
        fout.println(reg.getSumOfSquares());
        fout.printtab("Degrees of freedom: ");
        fout.println(reg.getDegFree());
        fout.printtab("Number of iterations: ");
        fout.println(reg.getNiter());
        fout.printtab("maximum number of iterations allowed: ");
        fout.println(reg.getNmax());
        fout.println();
        fout.println();
    }

    public double getXYcorrCoeff() {
        return this.xyR;
    }

    public double getYYcorrCoeff() {
        return this.yyR;
    }

    protected static ArrayList<Object> dataSign(double[] data) {
        ArrayList<Object> ret = new ArrayList<Object>();
        int n = data.length;
        double max = data[0];
        int maxi = 0;
        double min = data[0];
        int mini = 0;
        double peak = 0.0;
        int peaki = -1;
        int signFlag = -1;
        double shift = 0.0;
        double mean = 0.0;
        int signCheckZero = 0;
        int signCheckNeg = 0;
        int signCheckPos = 0;
        for (int i = 0; i < n; ++i) {
            mean = data[i];
            if (data[i] > max) {
                max = data[i];
                maxi = i;
            }
            if (data[i] < min) {
                min = data[i];
                mini = i;
            }
            if (data[i] == 0.0) {
                ++signCheckZero;
            }
            if (data[i] > 0.0) {
                ++signCheckPos;
            }
            if (!(data[i] < 0.0)) continue;
            ++signCheckNeg;
        }
        mean /= (double)n;
        if (signCheckZero + signCheckPos == n) {
            peak = max;
            peaki = maxi;
            signFlag = 0;
        } else if (signCheckZero + signCheckNeg == n) {
            peak = min;
            peaki = mini;
            signFlag = 1;
        } else {
            peak = max;
            peaki = maxi;
            if (-min > max) {
                peak = min;
                peak = mini;
            }
            signFlag = 2;
            shift = -min;
        }
        ret.add(new Double(min));
        ret.add(new Integer(mini));
        ret.add(new Double(max));
        ret.add(new Integer(maxi));
        ret.add(new Double(peak));
        ret.add(new Integer(peaki));
        ret.add(new Integer(signFlag));
        ret.add(new Double(shift));
        ret.add(new Double(mean));
        ret.add(new Integer(signCheckZero));
        ret.add(new Integer(signCheckPos));
        ret.add(new Integer(signCheckNeg));
        return ret;
    }

    public void frechet() {
        this.fitFrechet(0, 0);
    }

    public void frechetPlot() {
        this.fitFrechet(1, 0);
    }

    public void frechetTwoPar() {
        this.fitFrechet(0, 1);
    }

    public void frechetTwoParPlot() {
        this.fitFrechet(1, 1);
    }

    public void frechetStandard() {
        this.fitFrechet(0, 2);
    }

    public void frechetStandardPlot() {
        this.fitFrechet(1, 2);
    }

    protected void fitFrechet(int allTest, int typeFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (typeFlag) {
            case 0: {
                this.lastMethod = 13;
                this.nParam = 4;
                break;
            }
            case 1: {
                this.lastMethod = 14;
                this.nParam = 3;
                break;
            }
            case 2: {
                this.lastMethod = 15;
                this.nParam = 2;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.frechetWeibull = true;
        this.fitFrechetWeibull(allTest, typeFlag);
    }

    protected void fitFrechetWeibull(int allTest, int typeFlag) {
        RegressionFunction regFun3;
        RegressionFunction ff;
        RegressionFunction regFun2;
        RegressionFunction f;
        int i;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        Integer tempi = null;
        tempi = (Integer)retY.get(5);
        int peaki = tempi;
        tempd = (Double)retY.get(8);
        double mean = tempd;
        boolean testInf = true;
        double dof = this.degreesOfFreedom;
        while (testInf) {
            if (this.infinityCheck(yPeak, peaki)) {
                if ((dof -= 1.0) < 1.0 && !this.ignoreDofFcheck) {
                    throw new IllegalArgumentException("The effective degrees of freedom have been reduced to zero");
                }
                retY = Regression.dataSign(this.yData);
                tempd = (Double)retY.get(4);
                yPeak = tempd;
                tempi = (Integer)retY.get(5);
                peaki = tempi;
                tempd = (Double)retY.get(8);
                mean = tempd;
                continue;
            }
            testInf = false;
        }
        String ss = "Weibull";
        if (this.frechetWeibull) {
            ss = "Frechet";
        }
        boolean ySignFlag = false;
        if (yPeak < 0.0) {
            this.reverseYsign(ss);
            retY = Regression.dataSign(this.yData);
            yPeak = -yPeak;
            ySignFlag = true;
        }
        boolean magCheck = false;
        double magScale = this.checkYallSmall(yPeak, ss);
        if (magScale != 1.0) {
            magCheck = true;
            yPeak = 1.0;
        }
        ArrayList<Object> retX = Regression.dataSign(this.xData[0]);
        tempd = (Double)retX.get(0);
        double xMin = tempd;
        tempd = (Double)retX.get(2);
        double xMax = tempd;
        double distribMode = this.xData[0][peaki];
        double sd = Math.log(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        double[] xx = new double[this.nData];
        double[] yy = new double[this.nData];
        double[] ww = new double[this.nData];
        for (int i2 = 0; i2 < this.nData; ++i2) {
            xx[i2] = this.xData[0][i2];
            yy[i2] = this.yData[i2];
            ww[i2] = this.weight[i2];
        }
        double[] cumX = new double[this.nData];
        double[] cumY = new double[this.nData];
        double[] cumW = new double[this.nData];
        ErrorProp[] cumYe = ErrorProp.oneDarray(this.nData);
        double yScale = this.calculateCumulativeValues(cumX, cumY, cumW, cumYe, peaki, yPeak, distribMode, ss);
        if (this.frechetWeibull) {
            for (i = 0; i < this.nData; ++i) {
                cumYe[i] = ErrorProp.over(1.0, cumYe[i]);
                cumYe[i] = ErrorProp.log(cumYe[i]);
                cumYe[i] = ErrorProp.log(cumYe[i]);
                cumY[i] = cumYe[i].getValue();
                cumW[i] = cumYe[i].getError();
            }
        } else {
            for (i = 0; i < this.nData; ++i) {
                cumYe[i] = ErrorProp.minus(1.0, cumYe[i]);
                cumYe[i] = ErrorProp.over(1.0, cumYe[i]);
                cumYe[i] = ErrorProp.log(cumYe[i]);
                cumYe[i] = ErrorProp.log(cumYe[i]);
                cumY[i] = cumYe[i].getValue();
                cumW[i] = cumYe[i].getError();
            }
        }
        for (i = 0; i < this.nData; ++i) {
            this.xData[0][i] = cumX[i];
            this.yData[i] = cumY[i];
            this.weight[i] = cumW[i];
        }
        boolean weightOptHold = this.weightOpt;
        this.weightOpt = true;
        boolean statFlagHold = this.statFlag;
        this.statFlag = false;
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        for (int i3 = 0; i3 < this.nParam; ++i3) {
            start[i3] = 1.0;
            step[i3] = 0.2;
        }
        Object gammamin = null;
        double gammat = 0.0;
        switch (typeFlag) {
            case 0: {
                start[0] = xMin - Math.abs(0.1 * xMin);
                start[1] = sd;
                start[2] = 4.0;
                step[0] = 0.2 * start[0];
                if (step[0] == 0.0) {
                    ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
                    Double tempdd = null;
                    tempdd = (Double)ret0.get(2);
                    double xmax = tempdd;
                    if (xmax == 0.0) {
                        tempdd = (Double)ret0.get(0);
                        xmax = tempdd;
                    }
                    step[0] = xmax * 0.1;
                }
                step[1] = 0.2 * start[1];
                step[2] = 0.5 * start[2];
                this.addConstraint(0, 1, xMin);
                this.addConstraint(1, -1, 0.0);
                this.addConstraint(2, -1, 0.0);
                break;
            }
            case 1: {
                start[0] = sd;
                start[1] = 4.0;
                step[0] = 0.2 * start[0];
                step[1] = 0.5 * start[1];
                this.addConstraint(0, -1, 0.0);
                this.addConstraint(1, -1, 0.0);
                break;
            }
            case 2: {
                start[0] = 4.0;
                step[0] = 0.5 * start[0];
                this.addConstraint(0, -1, 0.0);
            }
        }
        if (this.frechetWeibull) {
            f = new FrechetFunctionTwo();
            f.typeFlag = typeFlag;
            regFun2 = f;
            System.out.println("pppp " + start[0] + "   " + start[1] + "   " + start[2]);
            this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        } else {
            f = new WeibullFunctionTwo();
            ((WeibullFunctionTwo)f).typeFlag = typeFlag;
            regFun2 = f;
            this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        }
        double[] ests = Conv.copy(this.best);
        this.statFlag = statFlagHold;
        this.weightOpt = weightOptHold;
        for (int i4 = 0; i4 < this.nData; ++i4) {
            this.xData[0][i4] = xx[i4];
            this.yData[i4] = yy[i4];
            this.weight[i4] = ww[i4];
        }
        switch (typeFlag) {
            case 0: {
                start[0] = ests[0];
                start[1] = ests[1];
                start[2] = ests[2];
                if (this.scaleFlag) {
                    start[3] = 1.0 / yScale;
                }
                step[0] = 0.1 * start[0];
                if (step[0] == 0.0) {
                    ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
                    Double tempdd = null;
                    tempdd = (Double)ret0.get(2);
                    double xmax = tempdd;
                    if (xmax == 0.0) {
                        tempdd = (Double)ret0.get(0);
                        xmax = tempdd;
                    }
                    step[0] = xmax * 0.1;
                }
                step[1] = 0.1 * start[1];
                step[2] = 0.1 * start[2];
                if (!this.scaleFlag) break;
                step[3] = 0.1 * start[3];
                break;
            }
            case 1: {
                start[0] = ests[0];
                start[1] = ests[1];
                if (this.scaleFlag) {
                    start[2] = 1.0 / yScale;
                }
                step[0] = 0.1 * start[0];
                step[1] = 0.1 * start[1];
                if (!this.scaleFlag) break;
                step[2] = 0.1 * start[2];
                break;
            }
            case 2: {
                start[0] = ests[0];
                if (this.scaleFlag) {
                    start[1] = 1.0 / yScale;
                }
                step[0] = 0.1 * start[0];
                if (!this.scaleFlag) break;
                step[1] = 0.1 * start[1];
            }
        }
        if (this.frechetWeibull) {
            ff = new FrechetFunctionOne();
            ff.typeFlag = typeFlag;
            ff.scaleOption = this.scaleFlag;
            ff.scaleFactor = this.yScaleFactor;
            regFun3 = ff;
            this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
            if (allTest == 1) {
                int flag;
                if (!this.supressPrint) {
                    this.print();
                }
                if ((flag = this.plotXY(ff)) != -2 && !this.supressYYplot) {
                    this.plotYY();
                }
            }
        } else {
            ff = new WeibullFunctionOne();
            ((WeibullFunctionOne)ff).typeFlag = typeFlag;
            ((WeibullFunctionOne)ff).scaleOption = this.scaleFlag;
            ((WeibullFunctionOne)ff).scaleFactor = this.yScaleFactor;
            regFun3 = ff;
            this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
            if (allTest == 1) {
                int flag;
                if (!this.supressPrint) {
                    this.print();
                }
                if ((flag = this.plotXY(ff)) != -2 && !this.supressYYplot) {
                    this.plotYY();
                }
            }
        }
        this.weightOpt = weightOptHold;
        if (magCheck) {
            for (int i5 = 0; i5 < this.nData; ++i5) {
                this.yData[i5] = yy[i5] / magScale;
                if (!this.weightOpt) continue;
                this.weight[i5] = ww[i5] / magScale;
            }
        }
        if (ySignFlag) {
            for (int i6 = 0; i6 < this.nData; ++i6) {
                this.yData[i6] = -this.yData[i6];
            }
        }
    }

    public boolean infinityCheck(double yPeak, int peaki) {
        boolean flag = false;
        if (yPeak == Double.POSITIVE_INFINITY || yPeak == Double.NEGATIVE_INFINITY) {
            int ii = peaki + 1;
            if (peaki == this.nData - 1) {
                ii = peaki - 1;
            }
            this.xData[0][peaki] = this.xData[0][ii];
            this.yData[peaki] = this.yData[ii];
            this.weight[peaki] = this.weight[ii];
            System.out.println("An infinty has been removed at point " + peaki);
            flag = true;
        }
        return flag;
    }

    public void reverseYsign(String ss) {
        System.out.println("This implementation of the " + ss + " distributions takes only positive y values\n(noise taking low values below zero are allowed)");
        System.out.println("All y values have been multiplied by -1 before fitting");
        for (int i = 0; i < this.nData; ++i) {
            this.yData[i] = -this.yData[i];
        }
    }

    public double checkYallSmall(double yPeak, String ss) {
        double magScale = 1.0;
        double recipYpeak = Fmath.truncate(1.0 / yPeak, 4);
        if (yPeak < 1.0E-4) {
            System.out.println(ss + " fitting: The ordinate axis (y axis) has been rescaled by " + recipYpeak + " to reduce rounding errors");
            for (int i = 0; i < this.nData; ++i) {
                int n = i;
                this.yData[n] = this.yData[n] * recipYpeak;
                if (!this.weightOpt) continue;
                int n2 = i;
                this.weight[n2] = this.weight[n2] * recipYpeak;
            }
            magScale = recipYpeak;
        }
        return magScale;
    }

    public double calculateCumulativeValues(double[] cumX, double[] cumY, double[] cumW, ErrorProp[] cumYe, int peaki, double yPeak, double distribMode, String ss) {
        int i;
        cumX[0] = this.xData[0][0];
        for (int i2 = 1; i2 < this.nData; ++i2) {
            cumX[i2] = this.xData[0][i2];
        }
        ErrorProp[] yE = ErrorProp.oneDarray(this.nData);
        for (int i3 = 0; i3 < this.nData; ++i3) {
            yE[i3].reset(this.yData[i3], this.weight[i3]);
        }
        if (peaki != 0) {
            if (peaki == this.nData - 1) {
                System.out.println("The data does not cover a wide enough range of x values to fit to a " + ss + " distribution with any accuracy");
                System.out.println("The regression will be attempted but you should treat any result with great caution");
            }
            if (this.yData[0] < this.yData[1] * 0.5 && this.yData[0] > distribMode * 0.02) {
                ErrorProp x0 = new ErrorProp(0.0, 0.0);
                x0 = yE[0].times(this.xData[0][1] - this.xData[0][0]);
                x0 = x0.over(yE[1].minus(yE[0]));
                x0 = ErrorProp.minus(this.xData[0][0], x0);
                if (this.yData[0] >= 0.9 * yPeak) {
                    x0 = x0.plus(this.xData[0][0]).over(2.0);
                }
                if (x0.getValue() < 0.0) {
                    x0.reset(0.0, 0.0);
                }
                cumYe[0] = yE[0].over(2.0);
                cumYe[0] = cumYe[0].times(ErrorProp.minus(this.xData[0][0], x0));
            } else {
                cumYe[0].reset(0.0, this.weight[0]);
            }
        } else {
            cumYe[0].reset(0.0, this.weight[0]);
        }
        for (int i4 = 1; i4 < this.nData; ++i4) {
            cumYe[i4] = yE[i4].plus(yE[i4 - 1]);
            cumYe[i4] = cumYe[i4].over(2.0);
            cumYe[i4] = cumYe[i4].times(this.xData[0][i4] - this.xData[0][i4 - 1]);
            cumYe[i4] = cumYe[i4].plus(cumYe[i4 - 1]);
        }
        ErrorProp cumYtotal = cumYe[this.nData - 1].copy();
        if (peaki == this.nData - 1) {
            cumYtotal = cumYtotal.times(2.0);
        } else if (this.yData[this.nData - 1] < this.yData[this.nData - 2] * 0.5 && this.yData[this.nData - 1] > distribMode * 0.02) {
            ErrorProp xn = new ErrorProp();
            xn = yE[this.nData - 1].times(this.xData[0][this.nData - 2] - this.xData[0][this.nData - 1]);
            xn = xn.over(yE[this.nData - 2].minus(yE[this.nData - 1]));
            xn = ErrorProp.minus(this.xData[0][this.nData - 1], xn);
            if (this.yData[0] >= 0.9 * yPeak) {
                xn = xn.plus(this.xData[0][this.nData - 1]).over(2.0);
            }
            cumYtotal = cumYtotal.plus(ErrorProp.times(0.5, yE[this.nData - 1].times(xn.minus(this.xData[0][this.nData - 1]))));
        }
        for (int i5 = 0; i5 < this.nData; ++i5) {
            cumY[i5] = cumYe[i5].getValue();
            cumW[i5] = cumYe[i5].getError();
        }
        double yScale = 1.0 / cumYtotal.getValue();
        for (int i6 = 0; i6 < this.nData; ++i6) {
            cumYe[i6] = cumYe[i6].over(cumYtotal);
        }
        int jj = 0;
        boolean test = true;
        for (i = 0; i < this.nData; ++i) {
            if (!(cumYe[i].getValue() <= 0.0)) continue;
            if (i <= jj) {
                test = true;
                jj = i;
                while (test) {
                    if (++jj >= this.nData) {
                        throw new ArithmeticException("all zero cumulative data!!");
                    }
                    if (!(cumYe[jj].getValue() > 0.0)) continue;
                    cumYe[i] = cumYe[jj].copy();
                    cumX[i] = cumX[jj];
                    test = false;
                }
                continue;
            }
            if (i == this.nData - 1) {
                cumYe[i] = cumYe[i - 1].copy();
                cumX[i] = cumX[i - 1];
                continue;
            }
            cumYe[i] = cumYe[i - 1].plus(cumYe[i + 1]);
            cumYe[i] = cumYe[i].over(2.0);
            cumX[i] = (cumX[i - 1] + cumX[i + 1]) / 2.0;
        }
        jj = this.nData - 1;
        for (i = this.nData - 1; i >= 0; --i) {
            if (!(cumYe[i].getValue() >= 1.0)) continue;
            if (i >= jj) {
                test = true;
                jj = this.nData - 1;
                while (test) {
                    if (--jj < 0) {
                        throw new ArithmeticException("all unity cumulative data!!");
                    }
                    if (!(cumYe[jj].getValue() < 1.0)) continue;
                    cumYe[i] = cumYe[jj].copy();
                    cumX[i] = cumX[jj];
                    test = false;
                }
                continue;
            }
            if (i == 0) {
                cumYe[i] = cumYe[i + 1].copy();
                cumX[i] = cumX[i + 1];
                continue;
            }
            cumYe[i] = cumYe[i - 1].plus(cumYe[i + 1]);
            cumYe[i] = cumYe[i].over(2.0);
            cumX[i] = (cumX[i - 1] + cumX[i + 1]) / 2.0;
        }
        return yScale;
    }

    public void weibull() {
        this.fitWeibull(0, 0);
    }

    public void weibullPlot() {
        this.fitWeibull(1, 0);
    }

    public void weibullTwoPar() {
        this.fitWeibull(0, 1);
    }

    public void weibullTwoParPlot() {
        this.fitWeibull(1, 1);
    }

    public void weibullStandard() {
        this.fitWeibull(0, 2);
    }

    public void weibullStandardPlot() {
        this.fitWeibull(1, 2);
    }

    protected void fitWeibull(int allTest, int typeFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (typeFlag) {
            case 0: {
                this.lastMethod = 16;
                this.nParam = 4;
                break;
            }
            case 1: {
                this.lastMethod = 17;
                this.nParam = 3;
                break;
            }
            case 2: {
                this.lastMethod = 18;
                this.nParam = 2;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.frechetWeibull = false;
        this.fitFrechetWeibull(allTest, typeFlag);
    }

    public void gumbelMin() {
        this.fitGumbel(0, 0);
    }

    public void gumbelMinPlot() {
        this.fitGumbel(1, 0);
    }

    public void gumbelMax() {
        this.fitGumbel(0, 1);
    }

    public void gumbelMaxPlot() {
        this.fitGumbel(1, 1);
    }

    public void gumbelMinOnePar() {
        this.fitGumbel(0, 2);
    }

    public void gumbelMinOneParPlot() {
        this.fitGumbel(1, 2);
    }

    public void gumbelMaxOnePar() {
        this.fitGumbel(0, 3);
    }

    public void gumbelMaxOneParPlot() {
        this.fitGumbel(1, 3);
    }

    public void gumbelMinStandard() {
        this.fitGumbel(0, 4);
    }

    public void gumbelMinStandardPlot() {
        this.fitGumbel(1, 4);
    }

    public void gumbelMaxStandard() {
        this.fitGumbel(0, 5);
    }

    public void gumbelMaxStandardPlot() {
        this.fitGumbel(1, 5);
    }

    protected void noParameters(String ss) {
        System.out.println(ss + " Regression");
        System.out.println("No parameters set for estimation");
        System.out.println("Theoretical curve obtained");
        String filename1 = "RegressOutput.txt";
        String filename2 = "RegressOutputN.txt";
        FileOutput fout = new FileOutput(filename1, 'n');
        System.out.println("Results printed to the file " + filename2);
        fout.dateAndTimeln(filename1);
        fout.println("No parameters set for estimation");
        switch (this.lastMethod) {
            case 11: {
                int i;
                fout.println("Minimal Standard Gumbel p(x) = exp(x)exp(-exp(x))");
                for (i = 0; i < this.nData; ++i) {
                    this.yCalc[i] = Math.exp(this.xData[0][i]) * Math.exp(-Math.exp(this.xData[0][i]));
                }
                break;
            }
            case 12: {
                int i;
                fout.println("Maximal Standard Gumbel p(x) = exp(-x)exp(-exp(-x))");
                for (i = 0; i < this.nData; ++i) {
                    this.yCalc[i] = Math.exp(-this.xData[0][i]) * Math.exp(-Math.exp(-this.xData[0][i]));
                }
                break;
            }
            case 21: {
                int i;
                fout.println("Standard Exponential p(x) = exp(-x)");
                for (i = 0; i < this.nData; ++i) {
                    this.yCalc[i] = Math.exp(-this.xData[0][i]);
                }
                break;
            }
        }
        this.sumOfSquaresError = 0.0;
        this.chiSquare = 0.0;
        double temp = 0.0;
        for (int i = 0; i < this.nData; ++i) {
            temp = Fmath.square(this.yData[i] - this.yCalc[i]);
            this.sumOfSquaresError += temp;
            this.chiSquare += temp / Fmath.square(this.weight[i]);
        }
        double corrCoeff = Stat.corrCoeff(this.yData, this.yCalc);
        fout.printtab("Correlation Coefficient");
        fout.println(Fmath.truncate(corrCoeff, this.prec));
        if (Math.abs(corrCoeff) <= 1.0) {
            fout.printtab("Correlation Coefficient Probability");
            fout.println(Fmath.truncate(1.0 - Stat.linearCorrCoeffProb(corrCoeff, this.degreesOfFreedom - 1), this.prec));
        }
        fout.printtab("Sum of Squares");
        fout.println(Fmath.truncate(this.sumOfSquaresError, this.prec));
        if (this.weightOpt || this.trueFreq) {
            fout.printtab("Chi Square");
            fout.println(Fmath.truncate(this.chiSquare, this.prec));
            fout.printtab("chi square probability");
            fout.println(Fmath.truncate(Stat.chiSquareProb(this.chiSquare, this.degreesOfFreedom - 1), this.prec));
        }
        fout.println(" ");
        fout.printtab("x", this.field);
        fout.printtab("p(x) [expl]", this.field);
        fout.printtab("p(x) [calc]", this.field);
        fout.println("residual");
        for (int i = 0; i < this.nData; ++i) {
            fout.printtab(Fmath.truncate(this.xData[0][i], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.yData[i], this.prec), this.field);
            fout.printtab(Fmath.truncate(this.yCalc[i], this.prec), this.field);
            fout.println(Fmath.truncate(this.yData[i] - this.yCalc[i], this.prec));
        }
        fout.close();
        this.plotXY();
        if (!this.supressYYplot) {
            this.plotYY();
        }
    }

    protected void fitGumbel(int allTest, int typeFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (typeFlag) {
            case 0: {
                this.lastMethod = 7;
                this.nParam = 3;
                break;
            }
            case 1: {
                this.lastMethod = 8;
                this.nParam = 3;
                break;
            }
            case 2: {
                this.lastMethod = 9;
                this.nParam = 2;
                break;
            }
            case 3: {
                this.lastMethod = 10;
                this.nParam = 2;
                break;
            }
            case 4: {
                this.lastMethod = 11;
                this.nParam = 1;
                break;
            }
            case 5: {
                this.lastMethod = 12;
                this.nParam = 1;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        if (this.nParam == 0) {
            this.noParameters("Gumbel");
        } else {
            Regression.sort(this.xData[0], this.yData, this.weight);
            Double tempd = null;
            ArrayList<Object> retY = Regression.dataSign(this.yData);
            tempd = (Double)retY.get(4);
            double yPeak = tempd;
            boolean yFlag = false;
            if (yPeak < 0.0) {
                System.out.println("Regression.fitGumbel(): This implementation of the Gumbel distribution takes only positive y values\n(noise taking low values below zero are allowed)");
                System.out.println("All y values have been multiplied by -1 before fitting");
                for (int i = 0; i < this.nData; ++i) {
                    this.yData[i] = -this.yData[i];
                }
                retY = Regression.dataSign(this.yData);
                yFlag = true;
            }
            ArrayList<Object> retX = Regression.dataSign(this.xData[0]);
            Integer tempi = null;
            tempi = (Integer)retY.get(5);
            int peaki = tempi;
            double distribMode = this.xData[0][peaki];
            double sd = Regression.halfWidth(this.xData[0], this.yData);
            double[] start = new double[this.nParam];
            double[] step = new double[this.nParam];
            switch (typeFlag) {
                case 0: 
                case 1: {
                    start[0] = distribMode;
                    start[1] = sd * Math.sqrt(6.0) / Math.PI;
                    if (this.scaleFlag) {
                        start[2] = yPeak * start[1] * Math.exp(1.0);
                    }
                    step[0] = 0.1 * start[0];
                    if (step[0] == 0.0) {
                        ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
                        Double tempdd = null;
                        tempdd = (Double)ret0.get(2);
                        double xmax = tempdd;
                        if (xmax == 0.0) {
                            tempdd = (Double)ret0.get(0);
                            xmax = tempdd;
                        }
                        step[0] = xmax * 0.1;
                    }
                    step[1] = 0.1 * start[1];
                    if (this.scaleFlag) {
                        step[2] = 0.1 * start[2];
                    }
                    this.addConstraint(1, -1, 0.0);
                    break;
                }
                case 2: 
                case 3: {
                    start[0] = sd * Math.sqrt(6.0) / Math.PI;
                    if (this.scaleFlag) {
                        start[1] = yPeak * start[0] * Math.exp(1.0);
                    }
                    step[0] = 0.1 * start[0];
                    if (this.scaleFlag) {
                        step[1] = 0.1 * start[1];
                    }
                    this.addConstraint(0, -1, 0.0);
                    break;
                }
                case 4: 
                case 5: {
                    if (!this.scaleFlag) break;
                    start[0] = yPeak * Math.exp(1.0);
                    step[0] = 0.1 * start[0];
                }
            }
            GumbelFunction ff = new GumbelFunction();
            ff.typeFlag = typeFlag;
            ff.scaleOption = this.scaleFlag;
            ff.scaleFactor = this.yScaleFactor;
            if (typeFlag < 4) {
                GumbelFunction regFun3 = ff;
                this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
                if (allTest == 1) {
                    int flag;
                    if (!this.supressPrint) {
                        this.print();
                    }
                    if ((flag = this.plotXY(ff)) != -2 && !this.supressYYplot) {
                        this.plotYY();
                    }
                }
            } else {
                double[][] xxx = new double[1][this.nData];
                double aa = 1.0;
                if (typeFlag == 5) {
                    aa = -1.0;
                }
                for (int i = 0; i < this.nData; ++i) {
                    xxx[0][i] = Math.exp(aa * this.xData[0][i]) * Math.exp(-Math.exp(aa * this.xData[0][i]));
                }
                this.linNonLin = true;
                this.generalLinear(xxx);
                if (!this.supressPrint) {
                    this.print();
                }
                if (!this.supressYYplot) {
                    this.plotYY();
                }
                this.plotXY();
                this.linNonLin = false;
            }
            if (yFlag) {
                for (int i = 0; i < this.nData - 1; ++i) {
                    this.yData[i] = -this.yData[i];
                }
            }
        }
    }

    protected static void sort(double[] x, double[] y, double[] w) {
        int index = 0;
        int lastIndex = -1;
        int n = x.length;
        double holdx = 0.0;
        double holdy = 0.0;
        double holdw = 0.0;
        while (lastIndex < n - 1) {
            index = lastIndex + 1;
            for (int i = lastIndex + 2; i < n; ++i) {
                if (!(x[i] < x[index])) continue;
                index = i;
            }
            holdx = x[index];
            x[index] = x[++lastIndex];
            x[lastIndex] = holdx;
            holdy = y[index];
            y[index] = y[lastIndex];
            y[lastIndex] = holdy;
            holdw = w[index];
            w[index] = w[lastIndex];
            w[lastIndex] = holdw;
        }
    }

    protected static double halfWidth(double[] xData, double[] yData) {
        double ymax = yData[0];
        int imax = 0;
        int n = xData.length;
        for (int i = 1; i < n; ++i) {
            if (!(yData[i] > ymax)) continue;
            ymax = yData[i];
            imax = i;
        }
        ymax /= 2.0;
        double halfXlow = -1.0;
        double halfYlow = -1.0;
        double temp = -1.0;
        int ihl = -1;
        if (imax > 0) {
            ihl = imax - 1;
            halfYlow = Math.abs(ymax - yData[ihl]);
            for (int i = imax - 2; i >= 0; --i) {
                temp = Math.abs(ymax - yData[i]);
                if (!(temp < halfYlow)) continue;
                halfYlow = temp;
                ihl = i;
            }
            halfXlow = Math.abs(xData[ihl] - xData[imax]);
        }
        double halfXhigh = -1.0;
        double halfYhigh = -1.0;
        temp = -1.0;
        int ihh = -1;
        if (imax < n - 1) {
            ihh = imax + 1;
            halfYhigh = Math.abs(ymax - yData[ihh]);
            for (int i = imax + 2; i < n; ++i) {
                temp = Math.abs(ymax - yData[i]);
                if (!(temp < halfYhigh)) continue;
                halfYhigh = temp;
                ihh = i;
            }
            halfXhigh = Math.abs(xData[ihh] - xData[imax]);
        }
        double halfw = 0.0;
        if (ihl != -1) {
            halfw += halfXlow;
        }
        if (ihh != -1) {
            halfw += halfXhigh;
        }
        return halfw;
    }

    public void exponentialSimple() {
        this.fitsexponentialSimple(0);
    }

    public void exponentialSimplePlot() {
        this.fitsexponentialSimple(1);
    }

    protected void fitsexponentialSimple(int plotFlag) {
        double[] errrs;
        double[] coeff;
        int nLen;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 43;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            this.nParam = 1;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int nLin = nLen = this.yData.length;
        boolean[] zeros = new boolean[nLen];
        for (int i = 0; i < nLen; ++i) {
            zeros[i] = true;
            if (!(this.xData[0][i] <= 0.0) && !(this.yData[i] <= 0.0)) continue;
            zeros[i] = false;
            --nLin;
        }
        double[] xlin = new double[nLin];
        double[] ylin = new double[nLin];
        double[] wlin = new double[nLin];
        int counter = 0;
        for (int i = 0; i < nLen; ++i) {
            if (!zeros[i]) continue;
            xlin[counter] = Math.log(this.xData[0][i]);
            ylin[counter] = Math.log(this.yData[i]);
            wlin[counter] = Math.abs(this.weight[i] / this.yData[i]);
            ++counter;
        }
        Regression reglin = new Regression(xlin, ylin, wlin);
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        if (this.scaleFlag) {
            reglin.linear();
            coeff = reglin.getBestEstimates();
            errrs = reglin.getBestEstimatesErrors();
            start[0] = coeff[1];
            start[1] = Math.exp(coeff[0]);
            step[0] = errrs[1] / 2.0;
            step[1] = errrs[0] * start[0] / 2.0;
            if (step[0] <= 0.0 || Fmath.isNaN(step[0])) {
                step[0] = Math.abs(start[0] * 0.1);
            }
            if (step[1] <= 0.0 || Fmath.isNaN(step[1])) {
                step[1] = Math.abs(start[1] * 0.1);
            }
        } else {
            reglin.linearGeneral();
            coeff = reglin.getBestEstimates();
            errrs = reglin.getBestEstimatesErrors();
            start[0] = coeff[1];
            step[0] = errrs[1] / 2.0;
            if (step[0] <= 0.0 || Fmath.isNaN(step[0])) {
                step[0] = Math.abs(start[0] * 0.1);
            }
        }
        ExponentialSimpleFunction f = new ExponentialSimpleFunction();
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        ExponentialSimpleFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void exponentialMultiple(int nExps) {
        this.userSupplied = false;
        this.fitsexponentialMultiple(nExps, 0);
    }

    public void exponentialMultiplePlot(int nExps) {
        this.userSupplied = false;
        this.fitsexponentialMultiple(nExps, 1);
    }

    public void exponentialMultiple(int nExps, double[] AandBs) {
        this.userSupplied = true;
        this.fitsexponentialMultiple(nExps, 0, AandBs);
    }

    public void exponentialMultiplePlot(int nExps, double[] AandBs) {
        this.userSupplied = true;
        this.fitsexponentialMultiple(nExps, 1, AandBs);
    }

    protected void fitsexponentialMultiple(int nExps, int plotFlag) {
        int nLen;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 44;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2 * nExps;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int nLin = nLen = this.yData.length;
        boolean[] zeros = new boolean[nLen];
        for (int i = 0; i < nLen; ++i) {
            zeros[i] = true;
            if (!(this.xData[0][i] <= 0.0) && !(this.yData[i] <= 0.0)) continue;
            zeros[i] = false;
            --nLin;
        }
        double[] xlin = new double[nLin];
        double[] ylin = new double[nLin];
        double[] wlin = new double[nLin];
        int counter = 0;
        for (int i = 0; i < nLen; ++i) {
            if (!zeros[i]) continue;
            xlin[counter] = Math.log(this.xData[0][i]);
            ylin[counter] = Math.log(this.yData[i]);
            wlin[counter] = Math.abs(this.weight[i] / this.yData[i]);
            ++counter;
        }
        Regression reglin = new Regression(xlin, ylin, wlin);
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        reglin.linear();
        double[] coeff = reglin.getBestEstimates();
        double[] errrs = reglin.getBestEstimatesErrors();
        for (int i = 0; i < this.nParam; i += 2) {
            start[i] = Math.exp(coeff[0]) / (double)this.nParam;
            start[i + 1] = coeff[1];
            step[i] = errrs[0] * start[i] / 2.0;
            step[i + 1] = errrs[1] / 2.0;
            if (step[i] <= 0.0 || Fmath.isNaN(step[i])) {
                step[i] = Math.abs(start[i] * 0.1);
            }
            if (!(step[i + 1] <= 0.0) && !Fmath.isNaN(step[i + 1])) continue;
            step[i + 1] = Math.abs(start[i + 1] * 0.1);
        }
        ExponentialMultipleFunction f = new ExponentialMultipleFunction();
        f.nExps = this.nParam;
        ExponentialMultipleFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    protected void fitsexponentialMultiple(int nExps, int plotFlag, double[] aAndBs) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 44;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2 * nExps;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; i += 2) {
            start[i] = aAndBs[i];
            step[i] = Math.abs(start[i] * 0.1);
        }
        ExponentialMultipleFunction f = new ExponentialMultipleFunction();
        f.nExps = this.nParam;
        ExponentialMultipleFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void oneMinusExponential() {
        this.fitsoneMinusExponential(0);
    }

    public void oneMinusExponentialPlot() {
        this.fitsoneMinusExponential(1);
    }

    protected void fitsoneMinusExponential(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 45;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        ArrayMaths am = new ArrayMaths(this.yData);
        double maxY = am.maximum();
        double minY = am.minimum();
        double testDirection = 1.0;
        double maxYhalf = maxY / 2.0;
        if (Math.abs(minY) > Math.abs(maxY)) {
            testDirection = -1.0;
            maxY = minY;
            maxYhalf = minY / 2.0;
        }
        double timeHalf = Double.NaN;
        boolean test = true;
        int ii = 0;
        while (test) {
            if (this.yData[ii] == maxYhalf) {
                timeHalf = this.xData[0][ii] - this.xData[0][0];
                test = false;
                continue;
            }
            if (this.yData[ii] < maxYhalf && this.yData[ii + 1] > maxYhalf) {
                timeHalf = (this.xData[0][ii] + this.xData[0][ii + 1]) / 2.0 - this.xData[0][0];
                test = false;
                continue;
            }
            if (this.yData[ii] > maxYhalf && this.yData[ii + 1] < maxYhalf) {
                timeHalf = (this.xData[0][ii] + this.xData[0][ii + 1]) / 2.0 - this.xData[0][0];
                test = false;
                continue;
            }
            if (++ii < this.nData - 1) continue;
            test = false;
        }
        if (timeHalf != timeHalf) {
            timeHalf = am.maximumDifference();
        }
        double guessB = -testDirection / timeHalf;
        double[] start = new double[]{maxY, guessB};
        double[] step = new double[]{Math.abs(start[0] / 5.0), Math.abs(start[1] / 5.0)};
        OneMinusExponentialFunction f = new OneMinusExponentialFunction();
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        OneMinusExponentialFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        double ss0 = this.sumOfSquaresError;
        double[] bestEstimates0 = this.best;
        start[0] = -maxY;
        start[1] = -guessB;
        step[0] = Math.abs(start[0] / 5.0);
        step[1] = Math.abs(start[1] / 5.0);
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (this.sumOfSquaresError > ss0) {
            start[0] = bestEstimates0[0];
            start[1] = bestEstimates0[1];
            step[0] = Math.abs(start[0] / 20.0);
            step[1] = Math.abs(start[1] / 20.0);
            this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        }
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void exponential() {
        this.fitExponential(0, 0);
    }

    public void exponentialPlot() {
        this.fitExponential(1, 0);
    }

    public void exponentialOnePar() {
        this.fitExponential(0, 1);
    }

    public void exponentialOneParPlot() {
        this.fitExponential(1, 1);
    }

    public void exponentialStandard() {
        this.fitExponential(0, 2);
    }

    public void exponentialStandardPlot() {
        this.fitExponential(1, 2);
    }

    protected void fitExponential(int allTest, int typeFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (typeFlag) {
            case 0: {
                this.lastMethod = 19;
                this.nParam = 3;
                break;
            }
            case 1: {
                this.lastMethod = 20;
                this.nParam = 2;
                break;
            }
            case 2: {
                this.lastMethod = 21;
                this.nParam = 1;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        if (this.nParam == 0) {
            this.noParameters("Exponential");
        } else {
            double[] xx = new double[this.nData];
            double[] yy = new double[this.nData];
            double[] ww = new double[this.nData];
            for (int i = 0; i < this.nData; ++i) {
                xx[i] = this.xData[0][i];
                yy[i] = this.yData[i];
                ww[i] = this.weight[i];
            }
            Regression.sort(this.xData[0], this.yData, this.weight);
            Double tempd = null;
            ArrayList<Object> retY = Regression.dataSign(this.yData);
            tempd = (Double)retY.get(4);
            double yPeak = tempd;
            Integer tempi = null;
            tempi = (Integer)retY.get(5);
            int peaki = tempi;
            String ss = "Exponential";
            boolean ySignFlag = false;
            if (yPeak < 0.0) {
                this.reverseYsign(ss);
                retY = Regression.dataSign(this.yData);
                yPeak = -yPeak;
                ySignFlag = true;
            }
            boolean magCheck = false;
            double magScale = this.checkYallSmall(yPeak, ss);
            if (magScale != 1.0) {
                magCheck = true;
                yPeak = 1.0;
            }
            ArrayList<Object> retX = Regression.dataSign(this.xData[0]);
            tempd = (Double)retX.get(0);
            double xMin = tempd;
            double yE = yPeak / Math.exp(1.0);
            if (this.yData[0] < yPeak) {
                yE = (yPeak + this.yData[0]) / (2.0 * Math.exp(1.0));
            }
            double yDiff = Math.abs(this.yData[0] - yE);
            double yTest = 0.0;
            int iE = 0;
            for (int i = 1; i < this.nData; ++i) {
                yTest = Math.abs(this.yData[i] - yE);
                if (!(yTest < yDiff)) continue;
                yDiff = yTest;
                iE = i;
            }
            double sigma = this.xData[0][iE] - this.xData[0][0];
            double[] start = new double[this.nParam];
            double[] step = new double[this.nParam];
            switch (typeFlag) {
                case 0: {
                    start[0] = xMin * 0.9;
                    start[1] = sigma;
                    if (this.scaleFlag) {
                        start[2] = yPeak * sigma;
                    }
                    step[0] = 0.1 * start[0];
                    if (step[0] == 0.0) {
                        ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
                        Double tempdd = null;
                        tempdd = (Double)ret0.get(2);
                        double xmax = tempdd;
                        if (xmax == 0.0) {
                            tempdd = (Double)ret0.get(0);
                            xmax = tempdd;
                        }
                        step[0] = xmax * 0.1;
                    }
                    step[1] = 0.1 * start[1];
                    if (!this.scaleFlag) break;
                    step[2] = 0.1 * start[2];
                    break;
                }
                case 1: {
                    start[0] = sigma;
                    if (this.scaleFlag) {
                        start[1] = yPeak * sigma;
                    }
                    step[0] = 0.1 * start[0];
                    if (!this.scaleFlag) break;
                    step[1] = 0.1 * start[1];
                    break;
                }
                case 2: {
                    if (!this.scaleFlag) break;
                    start[0] = yPeak;
                    step[0] = 0.1 * start[0];
                }
            }
            ExponentialFunction ff = new ExponentialFunction();
            ff.typeFlag = typeFlag;
            ff.scaleOption = this.scaleFlag;
            ff.scaleFactor = this.yScaleFactor;
            ExponentialFunction regFun3 = ff;
            this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
            if (allTest == 1) {
                int flag;
                if (!this.supressPrint) {
                    this.print();
                }
                if ((flag = this.plotXY(ff)) != -2 && !this.supressYYplot) {
                    this.plotYY();
                }
            }
            if (magCheck) {
                for (int i = 0; i < this.nData; ++i) {
                    this.yData[i] = yy[i] / magScale;
                    if (!this.weightOpt) continue;
                    this.weight[i] = ww[i] / magScale;
                }
            }
            if (ySignFlag) {
                for (int i = 0; i < this.nData; ++i) {
                    this.yData[i] = -this.yData[i];
                }
            }
        }
    }

    public void checkZeroNeg(double[] xx, double[] yy, double[] ww) {
        int jj = 0;
        boolean test = true;
        for (int i = 0; i < this.nData; ++i) {
            if (!(yy[i] <= 0.0)) continue;
            if (i <= jj) {
                test = true;
                jj = i;
                while (test) {
                    if (++jj >= this.nData) {
                        throw new ArithmeticException("all zero cumulative data!!");
                    }
                    if (!(yy[jj] > 0.0)) continue;
                    yy[i] = yy[jj];
                    xx[i] = xx[jj];
                    ww[i] = ww[jj];
                    test = false;
                }
                continue;
            }
            if (i == this.nData - 1) {
                yy[i] = yy[i - 1];
                xx[i] = xx[i - 1];
                ww[i] = ww[i - 1];
                continue;
            }
            yy[i] = (yy[i - 1] + yy[i + 1]) / 2.0;
            xx[i] = (xx[i - 1] + xx[i + 1]) / 2.0;
            ww[i] = (ww[i - 1] + ww[i + 1]) / 2.0;
        }
    }

    public void rayleigh() {
        this.fitRayleigh(0, 0);
    }

    public void rayleighPlot() {
        this.fitRayleigh(1, 0);
    }

    protected void fitRayleigh(int allTest, int typeFlag) {
        int i;
        RayleighFunctionTwo f;
        int i2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 22;
        this.userSupplied = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        Integer tempi = null;
        tempi = (Integer)retY.get(5);
        int peaki = tempi;
        String ss = "Rayleigh";
        boolean ySignFlag = false;
        if (yPeak < 0.0) {
            this.reverseYsign(ss);
            retY = Regression.dataSign(this.yData);
            yPeak = -yPeak;
            ySignFlag = true;
        }
        boolean magCheck = false;
        double magScale = this.checkYallSmall(yPeak, ss);
        if (magScale != 1.0) {
            magCheck = true;
            yPeak = 1.0;
        }
        double[] xx = new double[this.nData];
        double[] yy = new double[this.nData];
        double[] ww = new double[this.nData];
        for (int i3 = 0; i3 < this.nData; ++i3) {
            xx[i3] = this.xData[0][i3];
            yy[i3] = this.yData[i3];
            ww[i3] = this.weight[i3];
        }
        ArrayList<Object> retX = Regression.dataSign(this.xData[0]);
        tempd = (Double)retX.get(0);
        double xMin = tempd;
        tempd = (Double)retX.get(2);
        double xMax = tempd;
        double distribMode = this.xData[0][peaki];
        double sd = Math.log(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        double[] cumX = new double[this.nData];
        double[] cumY = new double[this.nData];
        double[] cumW = new double[this.nData];
        ErrorProp[] cumYe = ErrorProp.oneDarray(this.nData);
        double yScale = this.calculateCumulativeValues(cumX, cumY, cumW, cumYe, peaki, yPeak, distribMode, ss);
        for (i2 = 0; i2 < this.nData; ++i2) {
            cumYe[i2] = ErrorProp.minus(1.0, cumYe[i2]);
            cumYe[i2] = ErrorProp.over(1.0, cumYe[i2]);
            cumYe[i2] = ErrorProp.log(cumYe[i2]);
            cumY[i2] = cumYe[i2].getValue();
            cumW[i2] = cumYe[i2].getError();
        }
        for (i2 = 0; i2 < this.nData; ++i2) {
            this.xData[0][i2] = cumX[i2];
            this.yData[i2] = cumY[i2];
            this.weight[i2] = cumW[i2];
        }
        boolean weightOptHold = this.weightOpt;
        this.weightOpt = true;
        this.statFlag = false;
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        for (int i4 = 0; i4 < this.nParam; ++i4) {
            start[i4] = 1.0;
            step[i4] = 0.2;
        }
        start[0] = sd;
        step[0] = 0.2;
        this.addConstraint(0, -1, 0.0);
        RayleighFunctionTwo regFun2 = f = new RayleighFunctionTwo();
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        double[] ests = Conv.copy(this.best);
        this.statFlag = true;
        this.weightOpt = weightOptHold;
        for (int i5 = 0; i5 < this.nData; ++i5) {
            this.xData[0][i5] = xx[i5];
            this.yData[i5] = yy[i5];
            this.weight[i5] = ww[i5];
        }
        start[0] = ests[0];
        if (this.scaleFlag) {
            start[1] = 1.0 / yScale;
        }
        step[0] = 0.1 * start[0];
        if (this.scaleFlag) {
            step[1] = 0.1 * start[1];
        }
        RayleighFunctionOne ff = new RayleighFunctionOne();
        ff.scaleOption = this.scaleFlag;
        ff.scaleFactor = this.yScaleFactor;
        RayleighFunctionOne regFun3 = ff;
        this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
        if (allTest == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(ff)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (magCheck) {
            for (i = 0; i < this.nData; ++i) {
                this.yData[i] = yy[i] / magScale;
                if (!this.weightOpt) continue;
                this.weight[i] = ww[i] / magScale;
            }
        }
        if (ySignFlag) {
            for (i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public void paretoShifted() {
        this.fitPareto(0, 3);
    }

    public void paretoThreePar() {
        this.fitPareto(0, 3);
    }

    public void paretoShiftedPlot() {
        this.fitPareto(1, 3);
    }

    public void paretoThreeParPlot() {
        this.fitPareto(1, 3);
    }

    public void paretoTwoPar() {
        this.fitPareto(0, 2);
    }

    public void pareto() {
        this.fitPareto(0, 2);
    }

    public void paretoTwoParPlot() {
        this.fitPareto(1, 2);
    }

    public void paretoPlot() {
        this.fitPareto(1, 2);
    }

    public void paretoOnePar() {
        this.fitPareto(0, 1);
    }

    public void paretoOneParPlot() {
        this.fitPareto(1, 1);
    }

    protected void fitPareto(int allTest, int typeFlag) {
        int i;
        int i2;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (typeFlag) {
            case 3: {
                this.lastMethod = 29;
                this.nParam = 4;
                break;
            }
            case 2: {
                this.lastMethod = 23;
                this.nParam = 3;
                break;
            }
            case 1: {
                this.lastMethod = 24;
                this.nParam = 2;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        String ss = "Pareto";
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        Integer tempi = null;
        tempi = (Integer)retY.get(5);
        int peaki = tempi;
        if (this.infinityCheck(yPeak, peaki)) {
            retY = Regression.dataSign(this.yData);
            tempd = (Double)retY.get(4);
            yPeak = tempd;
            tempi = null;
            tempi = (Integer)retY.get(5);
            peaki = tempi;
        }
        boolean ySignFlag = false;
        if (yPeak < 0.0) {
            this.reverseYsign(ss);
            retY = Regression.dataSign(this.yData);
            yPeak = -yPeak;
            ySignFlag = true;
        }
        boolean magCheck = false;
        double magScale = this.checkYallSmall(yPeak, ss);
        if (magScale != 1.0) {
            magCheck = true;
            yPeak = 1.0;
        }
        ArrayList<Object> retX = Regression.dataSign(this.xData[0]);
        tempd = (Double)retX.get(0);
        double xMin = tempd;
        tempd = (Double)retX.get(2);
        double xMax = tempd;
        double distribMode = this.xData[0][peaki];
        double sd = Math.log(2.0) * Regression.halfWidth(this.xData[0], this.yData);
        double[] xx = new double[this.nData];
        double[] yy = new double[this.nData];
        double[] ww = new double[this.nData];
        for (int i3 = 0; i3 < this.nData; ++i3) {
            xx[i3] = this.xData[0][i3];
            yy[i3] = this.yData[i3];
            ww[i3] = this.weight[i3];
        }
        double[] cumX = new double[this.nData];
        double[] cumY = new double[this.nData];
        double[] cumW = new double[this.nData];
        ErrorProp[] cumYe = ErrorProp.oneDarray(this.nData);
        double yScale = this.calculateCumulativeValues(cumX, cumY, cumW, cumYe, peaki, yPeak, distribMode, ss);
        for (i2 = 0; i2 < this.nData; ++i2) {
            cumYe[i2] = ErrorProp.minus(1.0, cumYe[i2]);
            cumY[i2] = cumYe[i2].getValue();
            cumW[i2] = cumYe[i2].getError();
        }
        for (i2 = 0; i2 < this.nData; ++i2) {
            this.xData[0][i2] = cumX[i2];
            this.yData[i2] = cumY[i2];
            this.weight[i2] = cumW[i2];
        }
        boolean weightOptHold = this.weightOpt;
        this.weightOpt = true;
        this.statFlag = false;
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        for (int i4 = 0; i4 < this.nParam; ++i4) {
            start[i4] = 1.0;
            step[i4] = 0.2;
        }
        switch (typeFlag) {
            case 3: {
                start[0] = 2.0;
                start[1] = xMin * 0.9;
                start[2] = xMin < 0.0 ? -xMin * 1.1 : xMin * 0.01;
                if (start[1] < 0.0) {
                    start[1] = 0.0;
                }
                step[0] = 0.2 * start[0];
                step[1] = 0.2 * start[1];
                if (step[1] == 0.0) {
                    double xmax = xMax;
                    if (xmax == 0.0) {
                        xmax = xMin;
                    }
                    step[1] = xmax * 0.1;
                }
                this.addConstraint(0, -1, 0.0);
                this.addConstraint(1, -1, 0.0);
                this.addConstraint(1, 1, xMin);
                break;
            }
            case 2: {
                if (xMin < 0.0) {
                    System.out.println("Method: FitParetoTwoPar/FitParetoTwoParPlot\nNegative data values present\nFitParetoShifted/FitParetoShiftedPlot would have been more appropriate");
                }
                start[0] = 2.0;
                start[1] = xMin * 0.9;
                if (start[1] < 0.0) {
                    start[1] = 0.0;
                }
                step[0] = 0.2 * start[0];
                step[1] = 0.2 * start[1];
                if (step[1] == 0.0) {
                    double xmax = xMax;
                    if (xmax == 0.0) {
                        xmax = xMin;
                    }
                    step[1] = xmax * 0.1;
                }
                this.addConstraint(0, -1, 0.0);
                this.addConstraint(1, -1, 0.0);
                break;
            }
            case 1: {
                if (xMin < 0.0) {
                    System.out.println("Method: FitParetoOnePar/FitParetoOneParPlot\nNegative data values present\nFitParetoShifted/FitParetoShiftedPlot would have been more appropriate");
                }
                start[0] = 2.0;
                step[0] = 0.2 * start[0];
                this.addConstraint(0, -1, 0.0);
                this.addConstraint(1, -1, 0.0);
            }
        }
        ParetoFunctionTwo f = new ParetoFunctionTwo();
        f.typeFlag = typeFlag;
        ParetoFunctionTwo regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        double[] ests = Conv.copy(this.best);
        this.statFlag = true;
        this.weightOpt = weightOptHold;
        for (int i5 = 0; i5 < this.nData; ++i5) {
            this.xData[0][i5] = xx[i5];
            this.yData[i5] = yy[i5];
            this.weight[i5] = ww[i5];
        }
        switch (typeFlag) {
            case 3: {
                start[0] = ests[0];
                if (start[0] <= 0.0) {
                    start[0] = start[0] == 0.0 ? 1.0 : Math.min(1.0, -start[0]);
                }
                start[1] = ests[1];
                if (start[1] <= 0.0) {
                    start[1] = start[1] == 0.0 ? 1.0 : Math.min(1.0, -start[1]);
                }
                start[2] = ests[2];
                if (this.scaleFlag) {
                    start[3] = 1.0 / yScale;
                }
                step[0] = 0.1 * start[0];
                step[1] = 0.1 * start[1];
                if (step[1] == 0.0) {
                    double xmax = xMax;
                    if (xmax == 0.0) {
                        xmax = xMin;
                    }
                    step[1] = xmax * 0.1;
                }
                if (!this.scaleFlag) break;
                step[2] = 0.1 * start[2];
                break;
            }
            case 2: {
                start[0] = ests[0];
                if (start[0] <= 0.0) {
                    start[0] = start[0] == 0.0 ? 1.0 : Math.min(1.0, -start[0]);
                }
                start[1] = ests[1];
                if (start[1] <= 0.0) {
                    start[1] = start[1] == 0.0 ? 1.0 : Math.min(1.0, -start[1]);
                }
                if (this.scaleFlag) {
                    start[2] = 1.0 / yScale;
                }
                step[0] = 0.1 * start[0];
                step[1] = 0.1 * start[1];
                if (step[1] == 0.0) {
                    double xmax = xMax;
                    if (xmax == 0.0) {
                        xmax = xMin;
                    }
                    step[1] = xmax * 0.1;
                }
                if (!this.scaleFlag) break;
                step[2] = 0.1 * start[2];
                break;
            }
            case 1: {
                start[0] = ests[0];
                if (start[0] <= 0.0) {
                    start[0] = start[0] == 0.0 ? 1.0 : Math.min(1.0, -start[0]);
                }
                if (this.scaleFlag) {
                    start[1] = 1.0 / yScale;
                }
                step[0] = 0.1 * start[0];
                if (!this.scaleFlag) break;
                step[1] = 0.1 * start[1];
            }
        }
        ParetoFunctionOne ff = new ParetoFunctionOne();
        ff.typeFlag = typeFlag;
        ff.scaleOption = this.scaleFlag;
        ff.scaleFactor = this.yScaleFactor;
        ParetoFunctionOne regFun3 = ff;
        this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
        if (allTest == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(ff)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        this.weightOpt = weightOptHold;
        if (magCheck) {
            for (i = 0; i < this.nData; ++i) {
                this.yData[i] = yy[i] / magScale;
                if (!this.weightOpt) continue;
                this.weight[i] = ww[i] / magScale;
            }
        }
        if (ySignFlag) {
            for (i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public void sigmoidThreshold() {
        this.fitSigmoidThreshold(0);
    }

    public void sigmoidThresholdPlot() {
        this.fitSigmoidThreshold(1);
    }

    protected void fitSigmoidThreshold(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 25;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double yymin = Fmath.minimum(this.yData);
        double yymax = Fmath.maximum(this.yData);
        int dirFlag = 1;
        if (yymin < 0.0) {
            dirFlag = -1;
        }
        double yyymid = (yymax - yymin) / 2.0;
        double yyxmidl = this.xData[0][0];
        int ii = 1;
        int nLen = this.yData.length;
        boolean test = true;
        while (test) {
            if (this.yData[ii] >= (double)dirFlag * yyymid) {
                yyxmidl = this.xData[0][ii];
                test = false;
                continue;
            }
            if (++ii < nLen) continue;
            yyxmidl = Stat.mean(this.xData[0]);
            ii = nLen - 1;
            test = false;
        }
        double yyxmidh = this.xData[0][nLen - 1];
        int jj = nLen - 1;
        test = true;
        while (test) {
            if (this.yData[jj] <= (double)dirFlag * yyymid) {
                yyxmidh = this.xData[0][jj];
                test = false;
                continue;
            }
            if (--jj >= 0) continue;
            yyxmidh = Stat.mean(this.xData[0]);
            jj = 1;
            test = false;
        }
        int thetaPos = (ii + jj) / 2;
        double theta0 = this.xData[0][thetaPos];
        double thetaSlope1 = 2.0 * (this.yData[nLen - 1] - theta0) / (this.xData[0][nLen - 1] - this.xData[0][thetaPos]);
        double thetaSlope2 = 2.0 * theta0 / (this.xData[0][thetaPos] - this.xData[0][nLen - 1]);
        double thetaSlope = Math.max(thetaSlope1, thetaSlope2);
        double[] start = new double[this.nParam];
        start[0] = 4.0 * thetaSlope;
        start[0] = dirFlag == 1 ? start[0] / yymax : start[0] / yymin;
        start[1] = theta0;
        if (this.scaleFlag) {
            start[2] = dirFlag == 1 ? yymax : yymin;
        }
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * start[i];
        }
        if (step[0] == 0.0) {
            step[0] = 0.1 * (this.xData[0][nLen - 1] - this.xData[0][0]) / (this.yData[nLen - 1] - this.yData[0]);
        }
        if (step[1] == 0.0) {
            step[1] = (this.xData[0][nLen - 1] - this.xData[0][0]) / 20.0;
        }
        if (this.scaleFlag && step[2] == 0.0) {
            step[2] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        SigmoidThresholdFunction f = new SigmoidThresholdFunction();
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        SigmoidThresholdFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void sigmoidHillSips() {
        this.fitsigmoidHillSips(0);
    }

    public void sigmoidHillSipsPlot() {
        this.fitsigmoidHillSips(1);
    }

    protected void fitsigmoidHillSips(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 28;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int nLen = this.yData.length;
        this.midPoint();
        double theta0 = this.midPointYvalue;
        double[] start = new double[this.nParam];
        start[0] = theta0;
        start[1] = this.directionFlag == 1 ? 1.0 : -1.0;
        if (this.scaleFlag) {
            start[2] = this.top - this.bottom;
        }
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * start[i];
        }
        if (step[0] == 0.0) {
            step[0] = (this.xData[0][nLen - 1] - this.xData[0][0]) / 20.0;
        }
        if (this.scaleFlag && step[2] == 0.0) {
            step[2] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        SigmoidHillSipsFunction f = new SigmoidHillSipsFunction();
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        SigmoidHillSipsFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void ec50() {
        this.fitEC50(0);
    }

    public void ec50Plot() {
        this.fitEC50(1);
    }

    public void ec50constrained() {
        this.fitEC50(2);
    }

    public void ec50constrainedPlot() {
        this.fitEC50(3);
    }

    public void fourParameterLogistic() {
        this.fitEC50(0);
    }

    public void fourParameterLogisticPlot() {
        this.fitEC50(1);
    }

    public void fourParameterLogisticConstrained() {
        this.fitEC50(2);
    }

    public void fourParameterLogisticConstrainedPlot() {
        this.fitEC50(3);
    }

    protected void fitEC50(int cpFlag) {
        EC50Function f;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        boolean plotFlag = false;
        boolean constrained = false;
        this.userSupplied = false;
        switch (cpFlag) {
            case 0: {
                this.lastMethod = 39;
                plotFlag = false;
                break;
            }
            case 1: {
                this.lastMethod = 39;
                plotFlag = true;
                break;
            }
            case 2: {
                this.lastMethod = 41;
                plotFlag = false;
                constrained = true;
                break;
            }
            case 3: {
                this.lastMethod = 41;
                plotFlag = true;
                constrained = true;
            }
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 4;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int nLen = this.yData.length;
        this.midPoint();
        double hillSlope = 1.0;
        if (this.directionFlag == -1) {
            hillSlope = -1.0;
        }
        double[] start = new double[this.nParam];
        start[0] = this.topS;
        start[1] = this.bottomS;
        start[2] = this.midPointXvalue;
        start[3] = hillSlope;
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * Math.abs(start[i]);
        }
        if (step[0] == 0.0) {
            step[0] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        if (step[1] == 0.0) {
            step[1] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        if (step[2] == 0.0) {
            step[2] = 0.05 * (this.xData[0][nLen - 1] - this.xData[0][0]);
        }
        if (step[3] == 0.0) {
            step[3] = 0.1 * (this.xData[0][nLen - 1] - this.xData[0][0]) / (this.yData[nLen - 1] - this.yData[0]);
        }
        if (constrained) {
            this.addConstraint(0, -1, 0.0);
        }
        EC50Function regFun2 = f = new EC50Function();
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    protected void ec50(double bottom, double top) {
        this.lastMethod = 40;
        this.fitEC50(bottom, top, 0);
    }

    protected void fourParameterLogistic(double bottom, double top) {
        this.lastMethod = 40;
        this.fitEC50(bottom, top, 0);
    }

    protected void ec50Plot(double bottom, double top) {
        this.lastMethod = 40;
        this.fitEC50(bottom, top, 1);
    }

    protected void fourParameterLogisticPlot(double bottom, double top) {
        this.lastMethod = 40;
        this.fitEC50(bottom, top, 1);
    }

    private void fitEC50(double bottom, double top, int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.bottom = bottom;
        this.top = top;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int nLen = this.yData.length;
        this.midPoint();
        double hillSlope = 1.0;
        if (this.directionFlag == -1) {
            hillSlope = -1.0;
        }
        double[] start = new double[this.nParam];
        start[0] = this.midPointXvalue;
        start[1] = hillSlope;
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * Math.abs(start[i]);
        }
        if (step[0] == 0.0) {
            step[0] = 0.05 * (this.xData[0][nLen - 1] - this.xData[0][0]);
        }
        if (step[1] == 0.0) {
            step[1] = 0.1 * (this.xData[0][nLen - 1] - this.xData[0][0]) / (this.yData[nLen - 1] - this.yData[0]);
        }
        EC50FixedFunction f = new EC50FixedFunction();
        f.setBottom(this.bottom);
        f.setTop(this.top);
        EC50FixedFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    private void midPoint() {
        double yyymid;
        this.bottomS = Fmath.minimum(this.yData);
        this.topS = Fmath.maximum(this.yData);
        this.bottomSindex = 0.0;
        this.topSindex = 0.0;
        int nLen = this.yData.length;
        int ii = 0;
        boolean test = true;
        while (test) {
            if (this.bottomS == this.yData[ii]) {
                this.bottomSindex = ii;
                test = false;
                continue;
            }
            if (++ii < nLen) continue;
            throw new IllegalArgumentException("This should not be possible - check coding");
        }
        test = true;
        ii = 0;
        while (test) {
            if (this.topS == this.yData[ii]) {
                this.topSindex = ii;
                test = false;
                continue;
            }
            if (++ii < nLen) continue;
            throw new IllegalArgumentException("This should not be possible - check coding");
        }
        this.directionFlag = 1;
        if (this.topSindex < this.bottomSindex) {
            this.directionFlag = -1;
        }
        this.midPointYvalue = yyymid = this.topS - (this.topS - this.bottomS) / 2.0;
        double yyxmidl = this.xData[0][0];
        ii = 0;
        if (this.directionFlag == 1) {
            test = true;
            while (test) {
                if (this.yData[ii] >= yyymid) {
                    yyxmidl = this.xData[0][ii];
                    test = false;
                    continue;
                }
                if (++ii < nLen) continue;
                yyxmidl = Stat.mean(this.xData[0]);
                ii = nLen - 1;
                test = false;
            }
            double yyxmidh = this.xData[0][nLen - 1];
            int jj = nLen - 1;
            test = true;
            while (test) {
                if (this.yData[jj] <= yyymid) {
                    yyxmidh = this.xData[0][jj];
                    test = false;
                    continue;
                }
                if (--jj >= 0) continue;
                yyxmidh = Stat.mean(this.xData[0]);
                jj = 1;
                test = false;
            }
            if (ii < jj) {
                int jjh = jj;
                jj = ii;
                ii = jjh;
            }
            this.midPointLowerIndex = jj;
            this.midPointUpperIndex = ii;
            this.midPointXvalue = (this.xData[0][ii] + this.xData[0][jj]) / 2.0;
        } else {
            int jjh;
            ii = 0;
            test = true;
            while (test) {
                if (this.yData[ii] <= yyymid) {
                    yyxmidl = this.xData[0][ii];
                    test = false;
                    continue;
                }
                if (++ii < nLen) continue;
                yyxmidl = Stat.mean(this.xData[0]);
                ii = nLen - 1;
                test = false;
            }
            double yyxmidh = this.xData[0][nLen - 1];
            int jj = nLen - 1;
            test = true;
            while (test) {
                if (this.yData[jj] >= yyymid) {
                    yyxmidh = this.xData[0][jj];
                    test = false;
                    continue;
                }
                if (--jj >= 0) continue;
                yyxmidh = Stat.mean(this.xData[0]);
                jj = 1;
                test = false;
            }
            if (ii > jj) {
                jjh = jj;
                jj = ii;
                ii = jjh;
            }
            if (ii < jj) {
                jjh = jj;
                jj = ii;
                ii = jjh;
            }
            this.midPointLowerIndex = jj;
            this.midPointUpperIndex = ii;
            this.midPointXvalue = (this.xData[0][ii] + this.xData[0][jj]) / 2.0;
        }
    }

    public void fiveParameterLogistic() {
        this.fitfiveParameterLogistic(0);
    }

    public void fiveParameterLogisticPlot() {
        this.fitfiveParameterLogistic(1);
    }

    protected void fitfiveParameterLogistic(int cpFlag) {
        Logistic5Function f;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        boolean plotFlag = false;
        boolean constrained = false;
        this.userSupplied = false;
        this.lastMethod = 51;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 5;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int nLen = this.yData.length;
        this.midPoint();
        double hillSlope = 1.0;
        if (this.directionFlag == -1 && hillSlope >= 0.0) {
            hillSlope = -1.0;
        }
        double[] start = new double[this.nParam];
        start[0] = this.topS;
        start[1] = this.bottomS;
        start[2] = this.midPointXvalue;
        start[3] = hillSlope;
        start[4] = 1.0;
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * Math.abs(start[i]);
        }
        if (step[0] == 0.0) {
            step[0] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        if (step[1] == 0.0) {
            step[1] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        if (step[2] == 0.0) {
            step[2] = 0.05 * (this.xData[0][nLen - 1] - this.xData[0][0]);
        }
        if (step[3] == 0.0) {
            step[3] = 0.1 * (this.xData[0][nLen - 1] - this.xData[0][0]) / (this.yData[nLen - 1] - this.yData[0]);
        }
        Logistic5Function regFun2 = f = new Logistic5Function();
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    protected void fiveParameterLogistic(double bottom, double top) {
        this.lastMethod = 42;
        this.fitFiveParameterLogistic(bottom, top, 0);
    }

    protected void fiveParameterLogisticPlot(double bottom, double top) {
        this.lastMethod = 42;
        this.fitFiveParameterLogistic(bottom, top, 1);
    }

    private void fitFiveParameterLogistic(double bottom, double top, int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        int nLen = this.yData.length;
        this.midPoint();
        double hillSlope = 1.0;
        if (this.directionFlag == -1) {
            hillSlope = -1.0;
        }
        double[] start = new double[this.nParam];
        start[0] = this.midPointXvalue;
        start[1] = hillSlope;
        start[2] = 1.0;
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * Math.abs(start[i]);
        }
        if (step[0] == 0.0) {
            step[0] = 0.05 * (this.xData[0][nLen - 1] - this.xData[0][0]);
        }
        if (step[1] == 0.0) {
            step[1] = 0.1 * (this.xData[0][nLen - 1] - this.xData[0][0]) / (this.yData[nLen - 1] - this.yData[0]);
        }
        if (step[2] == 0.0) {
            step[2] = 0.1;
        }
        Logistic5FixedFunction f = new Logistic5FixedFunction();
        f.setBottom(bottom);
        f.setTop(top);
        Logistic5FixedFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void rectangularHyperbola() {
        this.fitRectangularHyperbola(0);
    }

    public void rectangularHyperbolaPlot() {
        this.fitRectangularHyperbola(1);
    }

    protected void fitRectangularHyperbola(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 26;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            this.nParam = 1;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double yymin = Fmath.minimum(this.yData);
        double yymax = Fmath.maximum(this.yData);
        int dirFlag = 1;
        if (yymin < 0.0) {
            dirFlag = -1;
        }
        double yyymid = (yymax - yymin) / 2.0;
        double yyxmidl = this.xData[0][0];
        int ii = 1;
        int nLen = this.yData.length;
        boolean test = true;
        while (test) {
            if (this.yData[ii] >= (double)dirFlag * yyymid) {
                yyxmidl = this.xData[0][ii];
                test = false;
                continue;
            }
            if (++ii < nLen) continue;
            yyxmidl = Stat.mean(this.xData[0]);
            ii = nLen - 1;
            test = false;
        }
        double yyxmidh = this.xData[0][nLen - 1];
        int jj = nLen - 1;
        test = true;
        while (test) {
            if (this.yData[jj] <= (double)dirFlag * yyymid) {
                yyxmidh = this.xData[0][jj];
                test = false;
                continue;
            }
            if (--jj >= 0) continue;
            yyxmidh = Stat.mean(this.xData[0]);
            jj = 1;
            test = false;
        }
        int thetaPos = (ii + jj) / 2;
        double theta0 = this.xData[0][thetaPos];
        double[] start = new double[this.nParam];
        start[0] = theta0;
        if (this.scaleFlag) {
            start[1] = dirFlag == 1 ? yymax : yymin;
        }
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * start[i];
        }
        if (step[0] == 0.0) {
            step[0] = (this.xData[0][nLen - 1] - this.xData[0][0]) / 20.0;
        }
        if (this.scaleFlag && step[1] == 0.0) {
            step[1] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        RectangularHyperbolaFunction f = new RectangularHyperbolaFunction();
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        RectangularHyperbolaFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void shiftedRectangularHyperbola() {
        this.fitShiftedRectangularHyperbola(0);
    }

    public void shiftedRectangularHyperbolaPlot() {
        this.fitShiftedRectangularHyperbola(1);
    }

    protected void fitShiftedRectangularHyperbola(int plotFlag) {
        ShiftedRectangularHyperbolaFunction f;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 52;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        boolean sfhold = this.scaleFlag;
        this.scaleFlag = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double yymin = Fmath.minimum(this.yData);
        double yymax = Fmath.maximum(this.yData);
        int dirFlag = 1;
        if (yymin < 0.0) {
            dirFlag = -1;
        }
        double yyymid = (yymax - yymin) / 2.0;
        double yyxmidl = this.xData[0][0];
        int ii = 1;
        int nLen = this.yData.length;
        boolean test = true;
        while (test) {
            if (this.yData[ii] >= (double)dirFlag * yyymid) {
                yyxmidl = this.xData[0][ii];
                test = false;
                continue;
            }
            if (++ii < nLen) continue;
            yyxmidl = Stat.mean(this.xData[0]);
            ii = nLen - 1;
            test = false;
        }
        double yyxmidh = this.xData[0][nLen - 1];
        int jj = nLen - 1;
        test = true;
        while (test) {
            if (this.yData[jj] <= (double)dirFlag * yyymid) {
                yyxmidh = this.xData[0][jj];
                test = false;
                continue;
            }
            if (--jj >= 0) continue;
            yyxmidh = Stat.mean(this.xData[0]);
            jj = 1;
            test = false;
        }
        int thetaPos = (ii + jj) / 2;
        double theta0 = this.xData[0][thetaPos];
        double[] start = new double[this.nParam];
        start[0] = theta0;
        start[1] = this.yData[0];
        start[2] = dirFlag == 1 ? yymax : yymin;
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * start[i];
        }
        if (step[0] == 0.0) {
            step[0] = (this.xData[0][nLen - 1] - this.xData[0][0]) / 20.0;
        }
        if (step[1] == 0.0) {
            step[1] = Math.abs(this.yData[nLen - 1] - this.yData[0]) / 20.0;
        }
        if (step[2] == 0.0) {
            step[1] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        ShiftedRectangularHyperbolaFunction regFun2 = f = new ShiftedRectangularHyperbolaFunction();
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        this.scaleFlag = sfhold;
    }

    public void stepFunction() {
        this.fitStepFunction(0);
    }

    public void stepFunctionPlot() {
        this.fitStepFunction(1);
    }

    protected void fitStepFunction(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 27;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 2;
        if (!this.scaleFlag) {
            this.nParam = 1;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        double yymin = Fmath.minimum(this.yData);
        double yymax = Fmath.maximum(this.yData);
        int dirFlag = 1;
        if (yymin < 0.0) {
            dirFlag = -1;
        }
        double yyymid = (yymax - yymin) / 2.0;
        double yyxmidl = this.xData[0][0];
        int ii = 1;
        int nLen = this.yData.length;
        boolean test = true;
        while (test) {
            if (this.yData[ii] >= (double)dirFlag * yyymid) {
                yyxmidl = this.xData[0][ii];
                test = false;
                continue;
            }
            if (++ii < nLen) continue;
            yyxmidl = Stat.mean(this.xData[0]);
            ii = nLen - 1;
            test = false;
        }
        double yyxmidh = this.xData[0][nLen - 1];
        int jj = nLen - 1;
        test = true;
        while (test) {
            if (this.yData[jj] <= (double)dirFlag * yyymid) {
                yyxmidh = this.xData[0][jj];
                test = false;
                continue;
            }
            if (--jj >= 0) continue;
            yyxmidh = Stat.mean(this.xData[0]);
            jj = 1;
            test = false;
        }
        int thetaPos = (ii + jj) / 2;
        double theta0 = this.xData[0][thetaPos];
        double[] start = new double[this.nParam];
        start[0] = theta0;
        if (this.scaleFlag) {
            start[1] = dirFlag == 1 ? yymax : yymin;
        }
        double[] step = new double[this.nParam];
        for (int i = 0; i < this.nParam; ++i) {
            step[i] = 0.1 * start[i];
        }
        if (step[0] == 0.0) {
            step[0] = (this.xData[0][nLen - 1] - this.xData[0][0]) / 20.0;
        }
        if (this.scaleFlag && step[1] == 0.0) {
            step[1] = 0.1 * (this.yData[nLen - 1] - this.yData[0]);
        }
        StepFunctionFunction f = new StepFunctionFunction();
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        StepFunctionFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
    }

    public void logistic() {
        this.fitLogistic(0);
    }

    public void logisticPlot() {
        this.fitLogistic(1);
    }

    protected void fitLogistic(int plotFlag) {
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 30;
        this.userSupplied = false;
        this.linNonLin = false;
        this.zeroCheck = false;
        this.nParam = 3;
        if (!this.scaleFlag) {
            this.nParam = 2;
        }
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitLogistic(): This implementation of the Logistic distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> ret1 = Regression.dataSign(this.yData);
        Integer tempi = null;
        tempi = (Integer)ret1.get(5);
        int peaki = tempi;
        double mu = this.xData[0][peaki];
        double beta = Math.sqrt(6.0) * Regression.halfWidth(this.xData[0], this.yData) / Math.PI;
        tempd = (Double)ret1.get(4);
        double ym = tempd;
        ym = ym * beta * Math.sqrt(Math.PI * 2);
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        start[0] = mu;
        start[1] = beta;
        if (this.scaleFlag) {
            start[2] = ym;
        }
        step[0] = 0.1 * beta;
        step[1] = 0.1 * start[1];
        if (step[1] == 0.0) {
            ArrayList<Object> ret0 = Regression.dataSign(this.xData[0]);
            Double tempdd = null;
            tempdd = (Double)ret0.get(2);
            double xmax = tempdd;
            if (xmax == 0.0) {
                tempdd = (Double)ret0.get(0);
                xmax = tempdd;
            }
            step[0] = xmax * 0.1;
        }
        if (this.scaleFlag) {
            step[2] = 0.1 * start[2];
        }
        LogisticFunction f = new LogisticFunction();
        this.addConstraint(1, -1, 0.0);
        f.scaleOption = this.scaleFlag;
        f.scaleFactor = this.yScaleFactor;
        LogisticFunction regFun2 = f;
        this.nelderMead(regFun2, start, step, this.fTol, this.nMax);
        if (plotFlag == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(f)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public void beta() {
        this.fitBeta(0, 0);
    }

    public void betaPlot() {
        this.fitBeta(1, 0);
    }

    public void betaMinMax() {
        this.fitBeta(0, 1);
    }

    public void betaMinMaxPlot() {
        this.fitBeta(1, 1);
    }

    protected void fitBeta(int allTest, int typeFlag) {
        double betaGuess;
        double alphaGuess;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (typeFlag) {
            case 0: {
                this.lastMethod = 31;
                this.nParam = 3;
                break;
            }
            case 1: {
                this.lastMethod = 32;
                this.nParam = 5;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitBeta(): This implementation of the Beta distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> retX = Regression.dataSign(this.xData[0]);
        Integer tempi = null;
        tempi = (Integer)retY.get(5);
        int peaki = tempi;
        double distribMode = this.xData[0][peaki];
        tempd = (Double)retX.get(0);
        double minX = tempd;
        tempd = (Double)retX.get(2);
        double maxX = tempd;
        tempd = (Double)retX.get(8);
        double meanX = tempd;
        if (typeFlag == 0) {
            if (minX < 0.0) {
                System.out.println("Regression: beta: data points must be greater than or equal to 0");
                System.out.println("method betaMinMax used in place of method beta");
                typeFlag = 1;
                this.lastMethod = 32;
                this.nParam = 5;
            }
            if (maxX > 1.0) {
                System.out.println("Regression: beta: data points must be less than or equal to 1");
                System.out.println("method betaMinMax used in place of method beta");
                typeFlag = 1;
                this.lastMethod = 32;
                this.nParam = 5;
            }
        }
        double dMode = distribMode;
        double dMean = meanX;
        if (typeFlag == 1) {
            dMode = (distribMode - minX * 0.9) / (maxX * 1.2 - minX * 0.9);
            dMean = (meanX - minX * 0.9) / (maxX * 1.2 - minX * 0.9);
        }
        if ((alphaGuess = 2.0 * dMode * dMean / (dMode - dMean)) < 1.3) {
            alphaGuess = 1.6;
        }
        if ((betaGuess = alphaGuess * (1.0 - dMean) / dMean) <= 1.3) {
            betaGuess = 1.6;
        }
        double scaleGuess = 0.0;
        scaleGuess = typeFlag == 0 ? yPeak / Stat.betaPDF(alphaGuess, betaGuess, distribMode) : yPeak / Stat.betaPDF(minX, maxX, alphaGuess, betaGuess, distribMode);
        if (scaleGuess < 0.0) {
            scaleGuess = 1.0;
        }
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        switch (typeFlag) {
            case 0: {
                start[0] = alphaGuess;
                start[1] = betaGuess;
                if (this.scaleFlag) {
                    start[2] = scaleGuess;
                }
                step[0] = 0.1 * start[0];
                step[1] = 0.1 * start[1];
                if (this.scaleFlag) {
                    step[2] = 0.1 * start[2];
                }
                this.addConstraint(0, -1, 1.0);
                this.addConstraint(1, -1, 1.0);
                break;
            }
            case 1: {
                start[0] = alphaGuess;
                start[1] = betaGuess;
                start[2] = 0.9 * minX;
                start[3] = 1.1 * maxX;
                if (this.scaleFlag) {
                    start[4] = scaleGuess;
                }
                step[0] = 0.1 * start[0];
                step[1] = 0.1 * start[1];
                step[2] = 0.1 * start[2];
                step[3] = 0.1 * start[3];
                if (this.scaleFlag) {
                    step[4] = 0.1 * start[4];
                }
                this.addConstraint(0, -1, 1.0);
                this.addConstraint(1, -1, 1.0);
                this.addConstraint(2, 1, minX);
                this.addConstraint(3, -1, maxX);
            }
        }
        BetaFunction ff = new BetaFunction();
        ff.typeFlag = typeFlag;
        ff.scaleOption = this.scaleFlag;
        ff.scaleFactor = this.yScaleFactor;
        BetaFunction regFun3 = ff;
        this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
        if (allTest == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(ff)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public void gamma() {
        this.fitGamma(0, 0);
    }

    public void gammaPlot() {
        this.fitGamma(1, 0);
    }

    public void gammaStandard() {
        this.fitGamma(0, 1);
    }

    public void gammaStandardPlot() {
        this.fitGamma(1, 1);
    }

    protected void fitGamma(int allTest, int typeFlag) {
        double betaGuess;
        double muGuess;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.userSupplied = false;
        switch (typeFlag) {
            case 0: {
                this.lastMethod = 33;
                this.nParam = 4;
                break;
            }
            case 1: {
                this.lastMethod = 34;
                this.nParam = 2;
            }
        }
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitGamma(): This implementation of the Gamma distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> retX = Regression.dataSign(this.xData[0]);
        Integer tempi = null;
        tempi = (Integer)retY.get(5);
        int peaki = tempi;
        double distribMode = this.xData[0][peaki];
        tempd = (Double)retX.get(0);
        double minX = tempd;
        tempd = (Double)retX.get(2);
        double maxX = tempd;
        tempd = (Double)retX.get(8);
        double meanX = tempd;
        if (typeFlag == 1 && minX < 0.0) {
            System.out.println("Regression: gammaStandard: data points must be greater than or equal to 0");
            System.out.println("method gamma used in place of method gammaStandard");
            typeFlag = 0;
            this.lastMethod = 33;
            this.nParam = 2;
        }
        if ((muGuess = 0.8 * minX) == 0.0) {
            muGuess = -0.1;
        }
        if ((betaGuess = meanX - distribMode) <= 0.0) {
            betaGuess = 1.0;
        }
        double gammaGuess = (meanX + muGuess) / betaGuess;
        if (typeFlag == 1) {
            gammaGuess = meanX;
        }
        if (gammaGuess <= 0.0) {
            gammaGuess = 1.0;
        }
        double scaleGuess = 0.0;
        scaleGuess = typeFlag == 0 ? yPeak / Stat.gammaPDF(muGuess, betaGuess, gammaGuess, distribMode) : yPeak / Stat.gammaPDF(gammaGuess, distribMode);
        if (scaleGuess < 0.0) {
            scaleGuess = 1.0;
        }
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        switch (typeFlag) {
            case 1: {
                start[0] = gammaGuess;
                if (this.scaleFlag) {
                    start[1] = scaleGuess;
                }
                step[0] = 0.1 * start[0];
                if (this.scaleFlag) {
                    step[1] = 0.1 * start[1];
                }
                this.addConstraint(0, -1, 0.0);
                break;
            }
            case 0: {
                start[0] = muGuess;
                start[1] = betaGuess;
                start[2] = gammaGuess;
                if (this.scaleFlag) {
                    start[3] = scaleGuess;
                }
                step[0] = 0.1 * start[0];
                step[1] = 0.1 * start[1];
                step[2] = 0.1 * start[2];
                if (this.scaleFlag) {
                    step[3] = 0.1 * start[3];
                }
                this.addConstraint(1, -1, 0.0);
                this.addConstraint(2, -1, 0.0);
            }
        }
        GammaFunction ff = new GammaFunction();
        ff.typeFlag = typeFlag;
        ff.scaleOption = this.scaleFlag;
        ff.scaleFactor = this.yScaleFactor;
        GammaFunction regFun3 = ff;
        this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
        if (allTest == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(ff)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public void erlang() {
        this.fitErlang(0, 0);
    }

    public void erlangPlot() {
        this.fitErlang(1, 0);
    }

    protected void fitErlang(int allTest, int typeFlag) {
        double kay0;
        double betaGuess;
        int nParam1;
        if (this.multipleY) {
            throw new IllegalArgumentException("This method cannot handle multiply dimensioned y arrays");
        }
        this.lastMethod = 35;
        this.userSupplied = false;
        int nParam0 = 2;
        this.nParam = nParam1 = 4;
        if (!this.scaleFlag) {
            --this.nParam;
        }
        this.zeroCheck = false;
        this.degreesOfFreedom = this.nData - this.nParam;
        if (this.degreesOfFreedom < 1 && !this.ignoreDofFcheck) {
            throw new IllegalArgumentException("Degrees of freedom must be greater than 0");
        }
        Regression.sort(this.xData[0], this.yData, this.weight);
        Double tempd = null;
        ArrayList<Object> retY = Regression.dataSign(this.yData);
        tempd = (Double)retY.get(4);
        double yPeak = tempd;
        boolean yFlag = false;
        if (yPeak < 0.0) {
            System.out.println("Regression.fitGamma(): This implementation of the Erlang distribution takes only positive y values\n(noise taking low values below zero are allowed)");
            System.out.println("All y values have been multiplied by -1 before fitting");
            for (int i = 0; i < this.nData; ++i) {
                this.yData[i] = -this.yData[i];
            }
            retY = Regression.dataSign(this.yData);
            yFlag = true;
        }
        ArrayList<Object> retX = Regression.dataSign(this.xData[0]);
        Integer tempi = null;
        tempi = (Integer)retY.get(5);
        int peaki = tempi;
        double distribMode = this.xData[0][peaki];
        tempd = (Double)retX.get(0);
        double minX = tempd;
        tempd = (Double)retX.get(2);
        double maxX = tempd;
        tempd = (Double)retX.get(8);
        double meanX = tempd;
        if (minX < 0.0) {
            throw new IllegalArgumentException("data points must be greater than or equal to 0");
        }
        double muGuess = 0.8 * minX;
        if (muGuess == 0.0) {
            muGuess = -0.1;
        }
        if ((betaGuess = meanX - distribMode) <= 0.0) {
            betaGuess = 1.0;
        }
        double gammaGuess = (meanX + muGuess) / betaGuess;
        if (typeFlag == 1) {
            gammaGuess = meanX;
        }
        if (gammaGuess <= 0.0) {
            gammaGuess = 1.0;
        }
        double scaleGuess = 0.0;
        scaleGuess = yPeak / Stat.gammaPDF(muGuess, betaGuess, gammaGuess, distribMode);
        if (scaleGuess < 0.0) {
            scaleGuess = 1.0;
        }
        double[] start = new double[this.nParam];
        double[] step = new double[this.nParam];
        start[0] = muGuess;
        start[1] = betaGuess;
        start[2] = gammaGuess;
        if (this.scaleFlag) {
            start[3] = scaleGuess;
        }
        step[0] = 0.1 * start[0];
        step[1] = 0.1 * start[1];
        step[2] = 0.1 * start[2];
        if (this.scaleFlag) {
            step[3] = 0.1 * start[3];
        }
        this.addConstraint(1, -1, 0.0);
        this.addConstraint(2, -1, 0.0);
        GammaFunction ff = new GammaFunction();
        ff.typeFlag = typeFlag;
        ff.scaleOption = this.scaleFlag;
        ff.scaleFactor = this.yScaleFactor;
        GammaFunction regFun3 = ff;
        this.nelderMead(regFun3, start, step, this.fTol, this.nMax);
        this.removeConstraints();
        double[] bestGammaEst = this.getCoeff();
        this.nParam = nParam0;
        start = new double[this.nParam];
        step = new double[this.nParam];
        if (bestGammaEst[3] < 0.0) {
            bestGammaEst[3] = bestGammaEst[3] * -1.0;
        }
        start[0] = 1.0 / bestGammaEst[1];
        if (this.scaleFlag) {
            start[1] = bestGammaEst[3];
        }
        step[0] = 0.1 * start[0];
        if (this.scaleFlag) {
            step[1] = 0.1 * start[1];
        }
        this.addConstraint(0, -1, 0.0);
        double kay = kay0 = (double)Math.round(bestGammaEst[2]);
        ErlangFunction ef = new ErlangFunction();
        ef.scaleOption = this.scaleFlag;
        ef.scaleFactor = this.yScaleFactor;
        ef.kay = kay;
        boolean testKay = true;
        double ssMin = Double.NaN;
        double upSS = Double.NaN;
        double upKay = Double.NaN;
        double kayFinal = Double.NaN;
        int iStart = 1;
        int ssSame = 0;
        while (testKay) {
            ErlangFunction regFun4 = ef;
            this.nelderMead(regFun4, start, step, this.fTol, this.nMax);
            double sumOfSquaresError = this.getSumOfSquares();
            if (iStart == 1) {
                iStart = 2;
                ssMin = sumOfSquaresError;
                kay += 1.0;
                start[0] = 1.0 / bestGammaEst[1];
                if (this.scaleFlag) {
                    start[1] = bestGammaEst[3];
                }
                step[0] = 0.1 * start[0];
                if (this.scaleFlag) {
                    step[1] = 0.1 * start[1];
                }
                this.addConstraint(0, -1, 0.0);
                ef.kay = kay;
                continue;
            }
            if (sumOfSquaresError <= ssMin) {
                if (sumOfSquaresError == ssMin && ++ssSame == 10) {
                    upSS = ssMin;
                    upKay = kay - 5.0;
                    testKay = false;
                }
                ssMin = sumOfSquaresError;
                kay += 1.0;
                start[0] = 1.0 / bestGammaEst[1];
                if (this.scaleFlag) {
                    start[1] = bestGammaEst[3];
                }
                step[0] = 0.1 * start[0];
                if (this.scaleFlag) {
                    step[1] = 0.1 * start[1];
                }
                this.addConstraint(0, -1, 0.0);
                ef.kay = kay;
                continue;
            }
            upSS = ssMin;
            upKay = kay - 1.0;
            testKay = false;
        }
        if (kay0 == 1.0) {
            kayFinal = upKay;
        } else {
            iStart = 1;
            testKay = true;
            ssMin = Double.NaN;
            double downSS = Double.NaN;
            double downKay = Double.NaN;
            start[0] = 1.0 / bestGammaEst[1];
            if (this.scaleFlag) {
                start[1] = bestGammaEst[3];
            }
            step[0] = 0.1 * start[0];
            if (this.scaleFlag) {
                step[1] = 0.1 * start[1];
            }
            this.addConstraint(0, -1, 0.0);
            ef.kay = kay = kay0;
            while (testKay) {
                ErlangFunction regFun5 = ef;
                this.nelderMead(regFun5, start, step, this.fTol, this.nMax);
                double sumOfSquaresError = this.getSumOfSquares();
                if (iStart == 1) {
                    iStart = 2;
                    ssMin = sumOfSquaresError;
                    if (Math.rint(kay -= 1.0) < 1.0) {
                        downSS = ssMin;
                        downKay = kay + 1.0;
                        testKay = false;
                        continue;
                    }
                    start[0] = 1.0 / bestGammaEst[1];
                    if (this.scaleFlag) {
                        start[1] = bestGammaEst[3];
                    }
                    step[0] = 0.1 * start[0];
                    if (this.scaleFlag) {
                        step[1] = 0.1 * start[1];
                    }
                    this.addConstraint(0, -1, 0.0);
                    ef.kay = kay;
                    continue;
                }
                if (sumOfSquaresError <= ssMin) {
                    ssMin = sumOfSquaresError;
                    if (Math.rint(kay -= 1.0) < 1.0) {
                        downSS = ssMin;
                        downKay = kay + 1.0;
                        testKay = false;
                        continue;
                    }
                    start[0] = 1.0 / bestGammaEst[1];
                    if (this.scaleFlag) {
                        start[1] = bestGammaEst[3];
                    }
                    step[0] = 0.1 * start[0];
                    if (this.scaleFlag) {
                        step[1] = 0.1 * start[1];
                    }
                    this.addConstraint(0, -1, 0.0);
                    ef.kay = kay;
                    continue;
                }
                downSS = ssMin;
                downKay = kay + 1.0;
                testKay = false;
            }
            kayFinal = downSS < upSS ? downKay : upKay;
        }
        start[0] = 1.0 / bestGammaEst[1];
        if (this.scaleFlag) {
            start[1] = bestGammaEst[3];
        }
        step[0] = 0.1 * start[0];
        if (this.scaleFlag) {
            step[1] = 0.1 * start[1];
        }
        this.addConstraint(0, -1, 0.0);
        ef.scaleOption = this.scaleFlag;
        ef.scaleFactor = this.yScaleFactor;
        ef.kay = Math.round(kayFinal);
        this.kayValue = Math.round(kayFinal);
        ErlangFunction regFun4 = ef;
        this.nelderMead(regFun4, start, step, this.fTol, this.nMax);
        double[] coeff = this.getCoeff();
        start[0] = coeff[0];
        if (this.scaleFlag) {
            start[1] = coeff[1];
        }
        step[0] = 0.1 * start[0];
        if (this.scaleFlag) {
            step[1] = 0.1 * start[1];
        }
        this.addConstraint(0, -1, 0.0);
        ef.scaleOption = this.scaleFlag;
        ef.scaleFactor = this.yScaleFactor;
        ef.kay = Math.round(kayFinal);
        this.kayValue = Math.round(kayFinal);
        ErlangFunction regFun5 = ef;
        this.nelderMead(regFun5, start, step, this.fTol, this.nMax);
        if (allTest == 1) {
            int flag;
            if (!this.supressPrint) {
                this.print();
            }
            if ((flag = this.plotXY(ef)) != -2 && !this.supressYYplot) {
                this.plotYY();
            }
        }
        if (yFlag) {
            for (int i = 0; i < this.nData - 1; ++i) {
                this.yData[i] = -this.yData[i];
            }
        }
    }

    public double getKayValue() {
        return this.kayValue;
    }

    public static double[][] histogramBins(double[] data, double binWidth, double binZero, double binUpper) {
        int n = 0;
        int m = data.length;
        for (int i = 0; i < m; ++i) {
            if (!(data[i] <= binUpper)) continue;
            ++n;
        }
        if (n != m) {
            double[] newData = new double[n];
            int j = 0;
            for (int i = 0; i < m; ++i) {
                if (!(data[i] <= binUpper)) continue;
                newData[j] = data[i];
                ++j;
            }
            System.out.println(m - n + " data points, above histogram upper limit, excluded in histogramBins");
            return Regression.histogramBins(newData, binWidth, binZero);
        }
        return Regression.histogramBins(data, binWidth, binZero);
    }

    public static double[][] histogramBins(double[] data, double binWidth, double binZero) {
        double dmax = Fmath.maximum(data);
        int nBins = (int)Math.ceil((dmax - binZero) / binWidth);
        if (binZero + (double)nBins * binWidth > dmax) {
            ++nBins;
        }
        int nPoints = data.length;
        int[] dataCheck = new int[nPoints];
        for (int i = 0; i < nPoints; ++i) {
            dataCheck[i] = 0;
        }
        double[] binWall = new double[nBins + 1];
        binWall[0] = binZero;
        for (int i = 1; i <= nBins; ++i) {
            binWall[i] = binWall[i - 1] + binWidth;
        }
        double[][] binFreq = new double[2][nBins];
        for (int i = 0; i < nBins; ++i) {
            binFreq[0][i] = (binWall[i] + binWall[i + 1]) / 2.0;
            binFreq[1][i] = 0.0;
        }
        boolean test = true;
        for (int i = 0; i < nPoints; ++i) {
            test = true;
            int j = 0;
            while (test) {
                if (j == nBins - 1) {
                    if (data[i] >= binWall[j] && data[i] <= binWall[j + 1] * (1.0 + histTol)) {
                        double[] dArray = binFreq[1];
                        int n = j;
                        dArray[n] = dArray[n] + 1.0;
                        dataCheck[i] = 1;
                        test = false;
                    }
                } else if (data[i] >= binWall[j] && data[i] < binWall[j + 1]) {
                    double[] dArray = binFreq[1];
                    int n = j;
                    dArray[n] = dArray[n] + 1.0;
                    dataCheck[i] = 1;
                    test = false;
                }
                if (!test) continue;
                if (j == nBins - 1) {
                    test = false;
                    continue;
                }
                ++j;
            }
        }
        int nMissed = 0;
        for (int i = 0; i < nPoints; ++i) {
            if (dataCheck[i] != 0) continue;
            ++nMissed;
            System.out.println("p " + i + " " + data[i] + " " + binWall[0] + " " + binWall[nBins]);
        }
        if (nMissed > 0) {
            System.out.println(nMissed + " data points, outside histogram limits, excluded in histogramBins");
        }
        return binFreq;
    }

    public static double[][] histogramBins(double[] data, double binWidth) {
        double dmin = Fmath.minimum(data);
        double dmax = Fmath.maximum(data);
        double span = dmax - dmin;
        double binZero = dmin;
        int nBins = (int)Math.ceil(span / binWidth);
        double histoSpan = (double)nBins * binWidth;
        double rem = histoSpan - span;
        if (rem >= 0.0) {
            binZero -= rem / 2.0;
        } else if (Math.abs(rem) / span > histTol) {
            boolean testBw = true;
            double incr = histTol / (double)nBins;
            int iTest = 0;
            while (testBw) {
                histoSpan = (double)nBins * (binWidth += incr);
                rem = histoSpan - span;
                if (rem < 0.0) {
                    if (++iTest <= 1000) continue;
                    testBw = false;
                    System.out.println("histogram method could not encompass all data within histogram\nContact Michael thomas Flanagan");
                    continue;
                }
                testBw = false;
            }
        }
        return Regression.histogramBins(data, binWidth, binZero);
    }
}

