/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.osCmd;

import ca.mcgill.mcb.pcingola.osCmd.ExecuteOsCommand;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.File;

public class OsCmdRunner
extends Thread {
    boolean executing = false;
    boolean started = false;
    int exitValue = 0;
    long defaultWaitTime = 100L;
    long defaultLoopWaitTime = 1000L;
    String jobId = "";
    String head = "";
    String headStderr = "";
    String error;
    String stdout = "";
    String stderr = "";
    ExecuteOsCommand osCmd = null;

    public static boolean runIfNotExists(String[] opts, String outputFile, boolean redirectToOutput) {
        if (Gpr.exists(outputFile)) {
            return true;
        }
        String id = opts[0];
        OsCmdRunner cmd = new OsCmdRunner(id, opts);
        cmd.getOsCmd().setQuiet(false, false);
        return cmd.runIfNotExists(outputFile, redirectToOutput);
    }

    public OsCmdRunner(String jobId, String[] osCmdStr) {
        this.jobId = jobId;
        this.osCmd = new ExecuteOsCommand(osCmdStr);
    }

    public synchronized void close() {
        if (this.osCmd != null) {
            this.osCmd.kill();
            this.head = this.osCmd.getHead();
            this.headStderr = this.osCmd.getHeadStderr();
            this.stdout = this.osCmd.getStdout();
            this.stderr = this.osCmd.getStderr();
        }
        this.osCmd = null;
    }

    public synchronized void finish() {
        this.executing = false;
        this.notify();
    }

    public long getDefaultWaitTime() {
        return this.defaultWaitTime;
    }

    public String getError() {
        return this.error;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getHead() {
        return this.head;
    }

    public String getHeadStderr() {
        return this.headStderr;
    }

    public String getJobId() {
        return this.jobId;
    }

    public ExecuteOsCommand getOsCmd() {
        return this.osCmd;
    }

    public int getProgress() {
        return this.osCmd == null ? 0 : this.osCmd.getProgress();
    }

    public String getStderr() {
        if (this.osCmd != null) {
            return this.osCmd.getStderr();
        }
        return this.stderr;
    }

    public String getStdout() {
        if (this.osCmd != null) {
            return this.osCmd.getStdout();
        }
        return this.stdout;
    }

    public boolean isDone() {
        return this.started && !this.executing;
    }

    public boolean isExecuting() {
        if (this.osCmd == null) {
            return false;
        }
        return this.executing && this.osCmd.isExecuting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.executing = true;
            this.osCmd.start();
            Thread.sleep(this.defaultWaitTime);
            while (!this.osCmd.isStarted() && this.isExecuting()) {
                Thread.sleep(this.defaultWaitTime);
            }
            while (this.osCmd.getStdin() == null && this.isExecuting()) {
                Thread.sleep(this.defaultWaitTime);
            }
            this.started = true;
            OsCmdRunner osCmdRunner = this;
            synchronized (osCmdRunner) {
                this.osCmd.setObjetcToNotify(this);
                while (this.isExecuting()) {
                    this.wait(this.defaultLoopWaitTime);
                }
            }
        }
        catch (Throwable t) {
            this.error = t.toString();
            t.printStackTrace();
        }
        finally {
            this.exitValue = this.osCmd.getExitValue();
            this.close();
            this.executing = false;
            this.started = true;
        }
    }

    public boolean runIfNotExists(String outputFile, boolean redirectToOutput) {
        if (Gpr.exists(outputFile)) {
            return true;
        }
        try {
            if (redirectToOutput) {
                this.getOsCmd().setBinaryStdout(true);
                this.getOsCmd().setRedirectStdout(outputFile);
            }
            this.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (outputFile != null && !outputFile.isEmpty()) {
                try {
                    new File(outputFile).delete();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    public void setDefaultWaitTime(long defaultWaitTime) {
        this.defaultWaitTime = defaultWaitTime;
    }

    public void setSaveStd(boolean save) {
        this.osCmd.setSaveStd(save);
    }

    @Override
    public String toString() {
        return super.toString() + "\t" + (this.osCmd != null ? this.osCmd.toString() : "null");
    }
}

