/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.binseq;

import ca.mcgill.mcb.pcingola.binseq.BinarySequence;
import ca.mcgill.mcb.pcingola.binseq.DnaSequence;
import ca.mcgill.mcb.pcingola.binseq.IdGenerator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;

public class DnaSequenceId
extends DnaSequence {
    private static final long serialVersionUID = 452657339854548494L;
    private static DnaSequenceId EMPTY = null;
    long id;

    public static DnaSequenceId empty() {
        if (EMPTY == null) {
            EMPTY = new DnaSequenceId("");
        }
        return EMPTY;
    }

    public DnaSequenceId(long id, int length, long[] codes) {
        super(length, codes);
        this.id = id;
    }

    public DnaSequenceId(long id, String seqStr) {
        super(seqStr);
        this.id = id;
    }

    public DnaSequenceId(String seqStr) {
        super(seqStr);
        this.id = IdGenerator.id();
    }

    @Override
    protected DnaSequence factory() {
        return new DnaSequenceId(this.id, null);
    }

    @Override
    DnaSequence factory(int length, long[] codes) {
        return new DnaSequenceId(this.id, length, codes);
    }

    public long getId() {
        return this.id;
    }

    @Override
    public BinarySequence read(DataInputStream dataInStream) throws IOException {
        DnaSequenceId binSeq = new DnaSequenceId(null);
        try {
            binSeq.readDataStream(dataInStream);
        }
        catch (EOFException e) {
            return null;
        }
        return binSeq;
    }

    @Override
    protected void readDataStream(DataInputStream dataInStream) throws IOException {
        this.id = dataInStream.readLong();
        super.readDataStream(dataInStream);
    }

    @Override
    public String toString() {
        return this.id + "\t" + this.getSequence();
    }

    @Override
    public void write(DataOutputStream dataOutStream) throws IOException {
        dataOutStream.writeLong(this.id);
        super.write(dataOutStream);
    }
}

