/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.tools.jsonrpc;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.RpcClient;
import com.rabbitmq.client.ShutdownSignalException;
import com.rabbitmq.tools.json.JSONReader;
import com.rabbitmq.tools.json.JSONWriter;
import com.rabbitmq.tools.jsonrpc.JsonRpcException;
import com.rabbitmq.tools.jsonrpc.ParameterDescription;
import com.rabbitmq.tools.jsonrpc.ProcedureDescription;
import com.rabbitmq.tools.jsonrpc.ServiceDescription;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonRpcClient
extends RpcClient
implements InvocationHandler {
    private ServiceDescription serviceDescription;

    public JsonRpcClient(Channel channel, String exchange, String routingKey, int timeout) throws IOException, JsonRpcException, TimeoutException {
        super(channel, exchange, routingKey, timeout);
        this.retrieveServiceDescription();
    }

    public JsonRpcClient(Channel channel, String exchange, String routingKey) throws IOException, JsonRpcException, TimeoutException {
        this(channel, exchange, routingKey, -1);
    }

    public static Object checkReply(Map<String, Object> reply) throws JsonRpcException {
        if (reply.containsKey("error")) {
            Map map = (Map)reply.get("error");
            throw new JsonRpcException(map);
        }
        Object result = reply.get("result");
        return result;
    }

    public Object call(String method, Object[] params) throws IOException, JsonRpcException, TimeoutException {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("id", null);
        request.put("method", method);
        request.put("version", "1.1");
        request.put("params", params == null ? new Object[]{} : params);
        String requestStr = new JSONWriter().write(request);
        try {
            String replyStr = this.stringCall(requestStr);
            Map map = (Map)new JSONReader().read(replyStr);
            return JsonRpcClient.checkReply(map);
        }
        catch (ShutdownSignalException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.call(method.getName(), args);
    }

    public Object createProxy(Class<?> klass) throws IllegalArgumentException {
        return Proxy.newProxyInstance(klass.getClassLoader(), new Class[]{klass}, (InvocationHandler)this);
    }

    public static Object coerce(String val, String type) throws NumberFormatException {
        if ("bit".equals(type)) {
            return Boolean.getBoolean(val) ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("num".equals(type)) {
            try {
                return new Integer(val);
            }
            catch (NumberFormatException nfe) {
                return new Double(val);
            }
        }
        if ("str".equals(type)) {
            return val;
        }
        if ("arr".equals(type) || "obj".equals(type) || "any".equals(type)) {
            return new JSONReader().read(val);
        }
        if ("nil".equals(type)) {
            return null;
        }
        throw new IllegalArgumentException("Bad type: " + type);
    }

    public Object call(String[] args) throws NumberFormatException, IOException, JsonRpcException, TimeoutException {
        if (args.length == 0) {
            throw new IllegalArgumentException("First string argument must be method name");
        }
        String method = args[0];
        int arity = args.length - 1;
        ProcedureDescription proc = this.serviceDescription.getProcedure(method, arity);
        ParameterDescription[] params = proc.getParams();
        Object[] actuals = new Object[arity];
        for (int count = 0; count < params.length; ++count) {
            actuals[count] = JsonRpcClient.coerce(args[count + 1], params[count].type);
        }
        return this.call(method, actuals);
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    private void retrieveServiceDescription() throws IOException, JsonRpcException, TimeoutException {
        Map rawServiceDescription = (Map)this.call("system.describe", null);
        this.serviceDescription = new ServiceDescription(rawServiceDescription);
    }
}

