/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.cli;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import edu.mayo.cli.ArgumentDefinition;
import edu.mayo.cli.CLIOption;
import edu.mayo.cli.InvalidCharactersException;
import edu.mayo.cli.InvalidNumberOfArgsException;
import edu.mayo.cli.OptionDefinition;
import edu.mayo.cli.util.CLIConstants;
import edu.mayo.cli.util.PropertiesUtil;
import edu.mayo.cli.util.SageUtil;
import edu.mayo.cli.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CLIInitialization {
    private static final Logger sLogger = Logger.getLogger(CLIInitialization.class);
    private final Gson sGson = new Gson();
    private Properties pluginProps;
    private Properties globalProperties;
    private Options options;
    private List<ArgumentDefinition> argumentDefinitions;
    private String scriptName;
    private String[] cmdArgs;
    private String defaultLogName;
    private String version = "(unavailable)";
    private String pluginName;
    private Map<String, Option> optionsInOGs = new HashMap<String, Option>();

    public CLIInitialization(String pluginClassName, String scriptName, String[] cmdArgs, String defaultLogName) throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvalidCharactersException, InvalidNumberOfArgsException {
        this.pluginName = pluginClassName;
        this.scriptName = this.setShortScriptName(scriptName);
        this.cmdArgs = cmdArgs;
        this.defaultLogName = defaultLogName;
        this.globalProperties = this.loadGlobalProperties();
        this.setVersion();
        StringUtils.validateASCII(scriptName, cmdArgs);
        SageUtil.setupSage(this.globalProperties);
        this.verifyCommandPropertiesFlagsArgsExamples(pluginClassName);
        ResourceBundle pluginBundle = PropertiesUtil.getBundle(pluginClassName);
        this.pluginProps = PropertiesUtil.loadPropsFromResourceBundle(pluginBundle);
        this.argumentDefinitions = this.loadArgumentDefinitions();
        this.loadOptions();
    }

    public void verify() throws ParseException {
        String argsMessage;
        StringBuilder sb = new StringBuilder();
        String cmdLineMessage = this.verifyCmdLineOptions();
        if (cmdLineMessage.length() > 0) {
            sb.append(CLIConstants.NEW_LINE);
            sb.append(cmdLineMessage);
        }
        if ((argsMessage = this.verifyArguments()).length() > 0) {
            if (sb.length() > 0) {
                sb.append(CLIConstants.NEW_LINE);
            }
            sb.append(CLIConstants.NEW_LINE);
            sb.append("Unknown arguments:");
            sb.append(CLIConstants.NEW_LINE);
            sb.append(argsMessage);
        }
        if (sb.length() > 0) {
            throw new ParseException(sb.toString());
        }
    }

    public void verifyStandloneArguments(String[] standaloneArgs) throws ParseException {
        String standaloneArgErrors = this.getStandaloneArgErrorMsgs(standaloneArgs, this.argumentDefinitions);
        if (standaloneArgErrors.length() > 0) {
            throw new ParseException(standaloneArgErrors);
        }
    }

    protected String getStandaloneArgErrorMsgs(String[] standaloneArgs, List<ArgumentDefinition> argDefs) {
        boolean isAtLeastRequiredNumOfArgs;
        if (argDefs.size() == 0 && standaloneArgs.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isEqualNumArgs = standaloneArgs.length == argDefs.size();
        ArgumentDefinition lastArg = argDefs.size() == 0 ? null : argDefs.get(argDefs.size() - 1);
        boolean isAtLeastNumArgsAndLastIsVariable = standaloneArgs.length >= argDefs.size() && lastArg != null && lastArg.getIsVariableNumberOfArgs();
        boolean bl = isAtLeastRequiredNumOfArgs = isEqualNumArgs || isAtLeastNumArgsAndLastIsVariable;
        if (!isAtLeastRequiredNumOfArgs) {
            sb.append(this.getStandaloneArgsRequiredMsg(argDefs));
            sb.append(this.getStandaloneArgsSpecifiedMsg(standaloneArgs));
        }
        return sb.toString();
    }

    private String getStandaloneArgsRequiredMsg(List<ArgumentDefinition> argDefs) {
        String requiredArgNames = "";
        for (ArgumentDefinition argDef : argDefs) {
            requiredArgNames = requiredArgNames + argDef.getName() + " ";
        }
        requiredArgNames = requiredArgNames.trim();
        return CLIConstants.NEW_LINE + String.format("Expected %d stand-alone argument%s%s", argDefs.size(), argDefs.size() == 1 ? "" : "s", argDefs.size() == 0 ? "." : ": " + requiredArgNames) + CLIConstants.NEW_LINE;
    }

    private String getStandaloneArgsSpecifiedMsg(String[] standaloneArgs) {
        String msg = "";
        if (standaloneArgs.length == 0) {
            msg = "0 stand-alone arguments specified";
        } else {
            String providedArgNames = "";
            for (String argName : standaloneArgs) {
                providedArgNames = providedArgNames + argName + " ";
            }
            String argVsArgs = standaloneArgs.length == 1 ? "" : "s";
            msg = String.format("%d stand-alone argument%s specified: %s", standaloneArgs.length, argVsArgs, providedArgNames.trim());
        }
        return msg;
    }

    public List<ArgumentDefinition> getArgumentDefinitions() {
        return this.argumentDefinitions;
    }

    public Properties getPluginProps() {
        return this.pluginProps;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public String getVersion() {
        return this.version;
    }

    public String[] getCmdArgs() {
        return this.cmdArgs;
    }

    public Options getOptions() {
        return this.options;
    }

    public Properties getGlobalProperties() {
        return this.globalProperties;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    private Properties loadGlobalProperties() {
        Properties globalProps = new Properties();
        try {
            globalProps = PropertiesUtil.loadProps("cli/Global.properties");
        }
        catch (IOException e) {
            sLogger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return globalProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyCommandPropertiesFlagsArgsExamples(String classNameWithPackage) {
        BufferedReader fin = null;
        try {
            String classPropsFilePath = this.getPropertiesFileResourcePath(classNameWithPackage);
            fin = this.getBufferedReaderFromClassAndPackage(classPropsFilePath);
            HashSet<String> keySet = new HashSet<String>();
            HashSet flagsSet = new HashSet();
            HashSet<String> flagsSetForThisKey = new HashSet<String>();
            String line = null;
            int lineNum = 0;
            boolean isWithinKey = false;
            while ((line = fin.readLine()) != null) {
                ++lineNum;
                if (line.startsWith("#") || this.trimAndRemoveLeadingTabsAndNewlines(line).startsWith("#")) continue;
                if (line.trim().length() == 0) {
                    if (!isWithinKey) continue;
                    isWithinKey = false;
                    continue;
                }
                this.warnIfEndsInWhiteSpace(line, classPropsFilePath, lineNum);
                int idxEq = line.indexOf("=");
                if (line.contains("=") && !isWithinKey) {
                    String key = line.substring(0, idxEq).trim();
                    boolean isKeyContainsSpacesOrTabs = key.contains(" ") || key.contains("\t");
                    if (isKeyContainsSpacesOrTabs) continue;
                    if (keySet.contains(key)) {
                        System.err.println("Warning: The command properties file " + classPropsFilePath + " contains a duplicate property: " + key + " (line " + lineNum + ")");
                    }
                    keySet.add(key);
                    if (!line.trim().endsWith("\\")) continue;
                    isWithinKey = true;
                    continue;
                }
                if (!isWithinKey) continue;
                if (this.isShortOrLongOpt(line)) {
                    String optionVal = this.getShortOrLongOptionVal(line);
                    if (flagsSet.contains(optionVal)) {
                        System.err.println("Warning: The command properties file " + classPropsFilePath + " contains a duplicate flag: " + optionVal + " (line " + lineNum + ")");
                    }
                    flagsSetForThisKey.add(optionVal);
                }
                if (!line.trim().endsWith("}")) continue;
                isWithinKey = false;
                flagsSet.addAll(flagsSetForThisKey);
            }
        }
        catch (Exception e) {
            sLogger.warn((Object)("Error verifying properties file for command: " + classNameWithPackage + "\n" + e.getMessage()));
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception e) {
                sLogger.warn((Object)("Error closing properties file reader for command: " + classNameWithPackage));
            }
        }
    }

    private String trimAndRemoveLeadingTabsAndNewlines(String s) {
        s = s.trim();
        while (s.startsWith("\\t")) {
            s = s.substring(2);
        }
        while (s.startsWith("\\n")) {
            s = s.substring(2);
        }
        return s;
    }

    private boolean isShortOrLongOpt(String line) {
        return line.trim().startsWith("\"opt\"") || line.trim().startsWith("\"longOpt\"");
    }

    private String getShortOrLongOptionVal(String line) {
        String val = "";
        int idxColon = line.indexOf(":");
        if (idxColon != -1) {
            val = line.substring(idxColon + 1, line.lastIndexOf("\"")).replace("\"", "").trim();
        }
        return val;
    }

    private void warnIfEndsInWhiteSpace(String line, String classPropsFilePath, int lineNum) {
        if (line.trim().length() == 0) {
            return;
        }
        String lineTrimmed = this.trimEnd(line);
        if (line.length() != lineTrimmed.length()) {
            System.err.println("Warning: The command properties file " + classPropsFilePath + " appears to have a whitespace character at the end of the line" + " (line " + lineNum + "):  [" + line + "]");
        }
    }

    private String trimEnd(String line) {
        char c;
        StringBuilder s = new StringBuilder(line);
        for (int i = s.length() - 1; i >= 0 && ((c = s.charAt(i)) == ' ' || c == '\t'); --i) {
            s.deleteCharAt(i);
        }
        return s.toString();
    }

    private BufferedReader getBufferedReaderFromClassAndPackage(String propertiesFileResourcePath) {
        InputStream inStream = ClassLoader.getSystemClassLoader().getResourceAsStream(propertiesFileResourcePath);
        BufferedReader fin = new BufferedReader(new InputStreamReader(inStream));
        return fin;
    }

    private String getPropertiesFileResourcePath(String classNameWithPackage) {
        String className = classNameWithPackage;
        int idxLastDot = classNameWithPackage.lastIndexOf(".");
        if (idxLastDot != -1) {
            className = classNameWithPackage.substring(idxLastDot + 1);
        }
        String resourcePath = "cli/" + className + ".properties";
        return resourcePath;
    }

    private void loadOptions() {
        Map<String, String> props = this.getProperties("flag.");
        Options opts = new Options();
        HashMap<Integer, OptionGroup> optionGroups = new HashMap<Integer, OptionGroup>();
        for (String key : props.keySet()) {
            String json = props.get(key);
            if (!this.isValidJson(json)) {
                throw new JsonSyntaxException("Flag option in command help text is not valid json: " + key);
            }
            OptionDefinition def = (OptionDefinition)this.sGson.fromJson(json, OptionDefinition.class);
            CLIOption option = new CLIOption(def.getOpt(), def.getDescription());
            this.setOptionValues(option, def);
            option.setIsHidden(def.isHidden());
            if (def.getOptionGroup() == null) {
                opts.addOption((Option)option);
                continue;
            }
            OptionGroup og = (OptionGroup)optionGroups.get(def.getOptionGroup());
            if (og == null) {
                og = new OptionGroup();
                optionGroups.put(def.getOptionGroup(), og);
                og.setRequired(def.isOgRequired());
            }
            og.addOption((Option)option);
            this.optionsInOGs.put(option.getOpt(), option);
        }
        for (OptionGroup og : optionGroups.values()) {
            opts.addOptionGroup(og);
        }
        opts.addOption((Option)this.createHelpOption(opts));
        opts.addOption((Option)this.createVersionOption(opts));
        opts.addOptionGroup(this.getLogOption(opts));
        opts.addOption((Option)this.createRemoteDebugOption(opts));
        this.options = opts;
    }

    private List<ArgumentDefinition> loadArgumentDefinitions() throws InvalidNumberOfArgsException {
        Map<String, String> props = this.getProperties("arg.");
        ArrayList<ArgumentDefinition> argDefs = new ArrayList<ArgumentDefinition>();
        TreeSet<String> keys = new TreeSet<String>(props.keySet());
        for (String key : keys) {
            String json = props.get(key);
            if (!this.isValidJson(json)) {
                throw new JsonSyntaxException("Argument in command help text is not valid json: " + key);
            }
            ArgumentDefinition def = (ArgumentDefinition)this.sGson.fromJson(json, ArgumentDefinition.class);
            argDefs.add(def);
        }
        Comparator<ArgumentDefinition> orderComparator = new Comparator<ArgumentDefinition>(){

            @Override
            public int compare(ArgumentDefinition o1, ArgumentDefinition o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        };
        Collections.sort(argDefs, orderComparator);
        this.verifyOnlyLastArgumentCanBeVariable(argDefs);
        return argDefs;
    }

    private void verifyOnlyLastArgumentCanBeVariable(List<ArgumentDefinition> argDefs) throws InvalidNumberOfArgsException {
        for (int i = 0; i < argDefs.size(); ++i) {
            boolean isLast;
            boolean bl = isLast = i == argDefs.size() - 1;
            if (!argDefs.get(i).getIsVariableNumberOfArgs() || isLast) continue;
            String badArg = argDefs.get(i).getName();
            throw new InvalidNumberOfArgsException("Error in argument within command properties file.  " + badArg + ".isVariableNumberOfArgs cannot be true.  Only the last argument can have this property set to true");
        }
    }

    private Map<String, String> getProperties(String prefix) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String key : this.pluginProps.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            String val = this.pluginProps.getProperty(key);
            props.put(key, val);
        }
        return props;
    }

    private void setOptionValues(Option theOpt, OptionDefinition def) {
        if (def.getNumArgs() != null) {
            theOpt.setArgs(def.getNumArgs().intValue());
        }
        if (def.getArgName() != null) {
            theOpt.setArgName(def.getArgName());
        }
        if (def.getLongOpt() != null) {
            theOpt.setLongOpt(def.getLongOpt());
        }
        if (def.isOptionalArg() != null) {
            theOpt.setOptionalArg(def.isOptionalArg().booleanValue());
        }
        if (def.isRequired() != null) {
            theOpt.setRequired(def.isRequired().booleanValue());
        }
        if (def.getValueSeparator() != null) {
            theOpt.setValueSeparator(def.getValueSeparator().charValue());
        }
    }

    private boolean isShortOptionTaken(Options opts, String optionShortName) {
        return null != opts.getOption(optionShortName);
    }

    private CLIOption createHelpOption(Options opts) {
        boolean isHelpShortOptionTaken = this.isShortOptionTaken(opts, "h");
        String shortOption = isHelpShortOptionTaken ? "help" : "h";
        CLIOption option = new CLIOption(shortOption, "help", false, "Display help text and exit.");
        option.setArgs(0);
        return option;
    }

    private CLIOption createVersionOption(Options opts) {
        boolean isVersionShortOptionTaken = this.isShortOptionTaken(opts, "v");
        String shortOption = isVersionShortOptionTaken ? "version" : "v";
        CLIOption option = new CLIOption(shortOption, "version", false, "Display the version of the application and exit");
        option.setArgs(0);
        return option;
    }

    private CLIOption createRemoteDebugOption(Options opts) {
        boolean isRemoteDebugShortOptionTaken = this.isShortOptionTaken(opts, "remote");
        String shortOption = isRemoteDebugShortOptionTaken ? "remote-debug" : "remote";
        CLIOption option = new CLIOption(shortOption, "remote-debug", false, "Setup this command for remote debugging session.");
        option.setIsHidden(true);
        option.setArgs(0);
        return option;
    }

    private OptionGroup getLogOption(Options opts) {
        OptionGroup og = new OptionGroup();
        String logFileName = this.defaultLogName == null ? "" : " '" + this.defaultLogName + "'";
        String logMsg = String.format("Generate the default log file%s in the current directory. By default, the log file is not generated. Only one logging option may be specified, either -l or -lf.", logFileName);
        boolean isLogShortOptionTaken = this.isShortOptionTaken(opts, "l");
        boolean isLogFileShortOptionTaken = this.isShortOptionTaken(opts, "lf");
        String shortLogOption = isLogShortOptionTaken ? "log" : "l";
        CLIOption logOption = new CLIOption(shortLogOption, "log", false, logMsg);
        logOption.setArgs(0);
        og.addOption((Option)logOption);
        String shortLogFileOption = isLogFileShortOptionTaken ? "logfile" : "lf";
        OptionDefinition def = new OptionDefinition();
        def.setOpt(shortLogFileOption);
        def.setLongOpt("logfile");
        def.setNumArgs(1);
        def.setOptionalArg(true);
        def.setRequired(false);
        def.setDescription("Generate the log file as specified by <logfile_name>, which overrides the default log file name, as shown in the -l, --log description. Only one logging option may be specified, either -l or -lf.");
        def.setArgName("logfile_name");
        CLIOption logFileOption = new CLIOption(shortLogFileOption, def.getDescription());
        this.setOptionValues(logFileOption, def);
        og.addOption((Option)logFileOption);
        this.optionsInOGs.put(logOption.getOpt(), logFileOption);
        this.optionsInOGs.put(logFileOption.getOpt(), logFileOption);
        og.setRequired(false);
        return og;
    }

    private boolean isValidJson(String json) {
        try {
            new JsonParser().parse(json);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String verifyCmdLineOptions() {
        StringBuilder unknownOptions = new StringBuilder();
        String message = "";
        ArrayList<String> paramList = new ArrayList<String>(Arrays.asList(this.cmdArgs));
        for (int i = 0; i < paramList.size(); ++i) {
            String param;
            String optionNoDash = param = (String)paramList.get(i);
            boolean isLongOption = false;
            if (param.startsWith("--")) {
                optionNoDash = param.substring(param.lastIndexOf("--") + 2);
                isLongOption = true;
            } else {
                if (!param.startsWith("-")) continue;
                optionNoDash = param.substring(param.lastIndexOf("-") + 1);
                isLongOption = false;
            }
            if (!this.optionsContainOpt(optionNoDash, isLongOption)) {
                unknownOptions.append(param);
                unknownOptions.append(",");
                unknownOptions.append(" ");
                continue;
            }
            int numArgumentsToRemove = this.options.getOption(optionNoDash).getArgs();
            for (int j = 0; j < numArgumentsToRemove && i + 1 < paramList.size() && !this.isASupportedOption((String)paramList.get(i + 1)); ++j) {
                paramList.remove(i + 1);
            }
        }
        if (unknownOptions.length() > 0) {
            message = unknownOptions.toString();
            if (message.contains(",")) {
                message = message.substring(0, message.lastIndexOf(","));
            }
            message = message.contains(",") ? "Unrecognized options: " + CLIConstants.NEW_LINE + message : "Unrecognized option: " + CLIConstants.NEW_LINE + message;
        }
        return message;
    }

    private boolean optionsContainOpt(String cmdLineArgument, boolean longOpt) {
        Option option = this.options.getOption(cmdLineArgument);
        if (option == null && (option = this.optionsInOGs.get(cmdLineArgument)) == null) {
            return false;
        }
        String key = longOpt ? option.getLongOpt() : option.getOpt();
        return key.equals(cmdLineArgument);
    }

    private String verifyArguments() {
        StringBuilder message_sb = new StringBuilder();
        int i = 0;
        for (String param : this.cmdArgs) {
            String option;
            if (param.startsWith("--")) {
                option = param.substring(param.lastIndexOf("--") + 2);
                ++i;
            } else if (param.startsWith("-")) {
                option = param.substring(param.lastIndexOf("-") + 1);
                ++i;
            } else {
                ++i;
                continue;
            }
            String msg = this.verifyArg(option, param, i);
            if (msg.length() <= 0) continue;
            if (message_sb.length() > 0) {
                message_sb.append(CLIConstants.NEW_LINE);
            }
            message_sb.append(msg);
        }
        return message_sb.toString();
    }

    private String verifyArg(String optionKey, String cmd, int index) {
        StringBuilder message;
        block9: {
            ArrayList<String> argumentList;
            block8: {
                String numArgsReqStr;
                int foundArguments;
                if (optionKey == null) {
                    return "";
                }
                Option option = this.options.getOption(optionKey);
                if (option == null) {
                    return "";
                }
                int numArguments = option.getArgs();
                if (numArguments == (foundArguments = (argumentList = this.gatherArgumentsForOption(option, index)).size()) || foundArguments == 0 && option.hasOptionalArg()) {
                    return "";
                }
                message = new StringBuilder();
                if (message.length() > 0) {
                    message.append(CLIConstants.NEW_LINE);
                    message.append(CLIConstants.NEW_LINE);
                }
                message.append("-");
                message.append(option.getOpt());
                message.append(",");
                message.append(" ");
                message.append("--");
                message.append(option.getLongOpt());
                if (!option.hasArg()) break block8;
                String string = numArgsReqStr = numArguments == 1 ? "1 argument" : numArguments + " arguments";
                if (argumentList.size() == 0) {
                    message.append(String.format(" requires %s, but none have been supplied", numArgsReqStr));
                } else {
                    String numArgsSuppliedStr = argumentList.size() == 1 ? "only 1 has" : argumentList.size() + " have";
                    message.append(String.format(" requires %s, but %s been supplied:", numArgsReqStr, numArgsSuppliedStr));
                    message.append(CLIConstants.NEW_LINE);
                    message.append(cmd);
                    message.append(" ");
                    for (String arg : argumentList) {
                        message.append("\"");
                        message.append(arg);
                        message.append("\"");
                        message.append(" ");
                    }
                }
                break block9;
            }
            if (argumentList.size() <= 0) break block9;
            String numSuppliedStr = argumentList.size() == 1 ? "1 has" : argumentList.size() + " have";
            message.append(" does not require an argument, but " + numSuppliedStr + " been supplied:");
            message.append(CLIConstants.NEW_LINE);
            message.append(cmd);
            message.append(" ");
            for (String arg : argumentList) {
                message.append("\"");
                message.append(arg);
                message.append("\"");
                message.append(" ");
            }
        }
        return message.toString();
    }

    private ArrayList<String> gatherArgumentsForOption(Option option, int index) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = index; i < index + option.getArgs() && i < this.getCmdArgs().length; ++i) {
            arguments.add(this.getCmdArgs()[i]);
        }
        this.removeValidOptions(arguments);
        return arguments;
    }

    private void removeValidOptions(ArrayList<String> argumentList) {
        Collection optionList = this.options.getOptions();
        block0: for (int i = argumentList.size() - 1; i >= 0; --i) {
            for (Option option : optionList) {
                boolean isArgSameAsOption = argumentList.get(i).equals("-" + option.getOpt()) || argumentList.get(i).equals("--" + option.getLongOpt());
                if (!isArgSameAsOption) continue;
                argumentList.remove(i);
                continue block0;
            }
        }
    }

    private boolean isASupportedOption(String option) {
        return this.options.getOption(option) != null;
    }

    private String setShortScriptName(String scriptName) {
        int lastSeparatorPos = scriptName.lastIndexOf(47);
        if (lastSeparatorPos != -1) {
            return scriptName.substring(lastSeparatorPos + 1);
        }
        return scriptName;
    }

    private void setVersion() {
        try {
            Properties versionProps = PropertiesUtil.loadProps("version.txt");
            if (versionProps != null && versionProps.size() > 0) {
                this.version = versionProps.getProperty("version");
            }
        }
        catch (IOException e) {
            sLogger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

