/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineTranslator;
import htsjdk.variant.vcf.VCFHeaderVersion;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VCFSimpleHeaderLine
extends VCFHeaderLine
implements VCFIDHeaderLine {
    private String name;
    private Map<String, String> genericFields = new LinkedHashMap<String, String>();

    public VCFSimpleHeaderLine(String string, String string2, String string3) {
        super(string, "");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(1);
        linkedHashMap.put("Description", string3);
        this.initialize(string2, linkedHashMap);
    }

    public VCFSimpleHeaderLine(String string, VCFHeaderVersion vCFHeaderVersion, String string2, List<String> list) {
        this(string2, VCFHeaderLineTranslator.parseLine(vCFHeaderVersion, string, list));
    }

    public VCFSimpleHeaderLine(String string, Map<String, String> map) {
        super(string, "");
        this.name = map.get("ID");
        this.initialize(this.name, map);
    }

    String getGenericFieldValue(String string) {
        return this.genericFields.get(string);
    }

    protected void initialize(String string, Map<String, String> map) {
        if (string == null || map == null || map.isEmpty()) {
            throw new IllegalArgumentException(String.format("Invalid VCFSimpleHeaderLine: key=%s name=%s", super.getKey(), string));
        }
        if (string.contains("<") || string.contains(">")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain angle brackets");
        }
        if (string.contains("=")) {
            throw new IllegalArgumentException("VCFHeaderLine: ID cannot contain an equals sign");
        }
        this.name = string;
        this.genericFields.putAll(map);
    }

    @Override
    protected String toStringEncoding() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("ID", this.name);
        linkedHashMap.putAll(this.genericFields);
        return this.getKey() + "=" + VCFHeaderLine.toStringEncoding(linkedHashMap);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass() || !super.equals(object)) {
            return false;
        }
        VCFSimpleHeaderLine vCFSimpleHeaderLine = (VCFSimpleHeaderLine)object;
        return this.name.equals(vCFSimpleHeaderLine.name) && this.genericFields.equals(vCFSimpleHeaderLine.genericFields);
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.name.hashCode();
        n = 31 * n + this.genericFields.hashCode();
        return n;
    }

    @Override
    public String getID() {
        return this.name;
    }
}

