/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index;

import htsjdk.tribble.Tribble;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.index.Block;
import htsjdk.tribble.index.ChrIndex;
import htsjdk.tribble.index.MutableIndex;
import htsjdk.tribble.util.LittleEndianInputStream;
import htsjdk.tribble.util.LittleEndianOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractIndex
implements MutableIndex {
    public static final int VERSION = 3;
    public static final int MAGIC_NUMBER = 1480870228;
    private static final String NO_MD5 = "";
    private static final long NO_FILE_SIZE = -1L;
    private static final long NO_TS = -1L;
    protected int version = 3;
    protected File indexedFile = null;
    protected long indexedFileSize = -1L;
    protected long indexedFileTS = -1L;
    protected String indexedFileMD5 = "";
    protected int flags;
    private LinkedHashMap<String, String> properties = new LinkedHashMap();
    protected LinkedHashMap<String, ChrIndex> chrIndices = new LinkedHashMap();
    private static final int SEQUENCE_DICTIONARY_FLAG = 32768;

    public boolean hasFileSize() {
        return this.indexedFileSize != -1L;
    }

    public boolean hasTimestamp() {
        return this.indexedFileTS != -1L;
    }

    public boolean hasMD5() {
        return this.indexedFileMD5 != NO_MD5;
    }

    @Override
    public boolean equalsIgnoreProperties(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractIndex)) {
            System.err.printf("equals: %s not instance of AbstractIndex", object);
            return false;
        }
        AbstractIndex abstractIndex = (AbstractIndex)object;
        if (this.version != abstractIndex.version) {
            System.err.printf("equals version: this %d != other %d%n", this.version, abstractIndex.version);
            return false;
        }
        if (!(this.indexedFile == abstractIndex.indexedFile || this.indexedFile != null && this.indexedFile.equals(abstractIndex.indexedFile))) {
            System.err.printf("equals indexedFile: this %s != other %s%n", this.indexedFile, abstractIndex.indexedFile);
            return false;
        }
        if (this.indexedFileSize != abstractIndex.indexedFileSize) {
            System.err.printf("equals indexedFileSize: this %d != other %d%n", this.indexedFileSize, abstractIndex.indexedFileSize);
            return false;
        }
        if (!this.indexedFileMD5.equals(abstractIndex.indexedFileMD5)) {
            System.err.printf("equals indexedFileMD5: this %s != other %s%n", this.indexedFileMD5, abstractIndex.indexedFileMD5);
            return false;
        }
        if (this.flags != abstractIndex.flags) {
            System.err.printf("equals flags: this %d != other %d%n", this.flags, abstractIndex.flags);
            return false;
        }
        if (!this.chrIndices.equals(abstractIndex.chrIndices)) {
            System.err.printf("equals chrIndeces: this %s != other %s%n", this.chrIndices, abstractIndex.chrIndices);
            return false;
        }
        return true;
    }

    public AbstractIndex() {
    }

    public AbstractIndex(String string) {
        this(new File(string));
    }

    public AbstractIndex(File file) {
        this();
        this.indexedFile = file;
    }

    public AbstractIndex(AbstractIndex abstractIndex) {
        this();
        this.version = abstractIndex.version;
        this.indexedFile = abstractIndex.indexedFile;
        this.indexedFileSize = abstractIndex.indexedFileSize;
        this.indexedFileTS = abstractIndex.indexedFileTS;
        this.indexedFileMD5 = abstractIndex.indexedFileMD5;
        this.flags = abstractIndex.flags;
        this.properties = (LinkedHashMap)abstractIndex.properties.clone();
    }

    protected void validateIndexHeader(int n, LittleEndianInputStream littleEndianInputStream) throws IOException {
        int n2 = littleEndianInputStream.readInt();
        if (n2 != 1480870228) {
            throw new TribbleException(String.format("Unexpected magic number %d", n2));
        }
        int n3 = littleEndianInputStream.readInt();
        if (n3 != n) {
            throw new TribbleException(String.format("Unexpected index type %d", n3));
        }
    }

    @Override
    public boolean isCurrentVersion() {
        return this.version == 3;
    }

    public File getIndexedFile() {
        return this.indexedFile;
    }

    public long getIndexedFileSize() {
        return this.indexedFileSize;
    }

    public long getIndexedFileTS() {
        return this.indexedFileTS;
    }

    public String getIndexedFileMD5() {
        return this.indexedFileMD5;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getVersion() {
        return this.version;
    }

    public void setMD5(String string) {
        this.indexedFileMD5 = string;
    }

    @Override
    public boolean containsChromosome(String string) {
        return this.chrIndices.containsKey(string);
    }

    public void finalizeIndex() {
        if (this.indexedFile != null) {
            this.indexedFileSize = this.indexedFile.length();
            this.indexedFileTS = this.indexedFile.lastModified();
        }
    }

    private void writeHeader(LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        littleEndianOutputStream.writeInt(1480870228);
        littleEndianOutputStream.writeInt(this.getType());
        littleEndianOutputStream.writeInt(this.version);
        littleEndianOutputStream.writeString(this.indexedFile.getAbsolutePath());
        littleEndianOutputStream.writeLong(this.indexedFileSize);
        littleEndianOutputStream.writeLong(this.indexedFileTS);
        littleEndianOutputStream.writeString(this.indexedFileMD5);
        littleEndianOutputStream.writeInt(this.flags);
        littleEndianOutputStream.writeInt(this.properties.size());
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            littleEndianOutputStream.writeString(entry.getKey());
            littleEndianOutputStream.writeString(entry.getValue());
        }
    }

    private void readHeader(LittleEndianInputStream littleEndianInputStream) throws IOException {
        this.version = littleEndianInputStream.readInt();
        this.indexedFile = new File(littleEndianInputStream.readString());
        this.indexedFileSize = littleEndianInputStream.readLong();
        this.indexedFileTS = littleEndianInputStream.readLong();
        this.indexedFileMD5 = littleEndianInputStream.readString();
        this.flags = littleEndianInputStream.readInt();
        if (this.version < 3 && (this.flags & 0x8000) == 32768) {
            this.readSequenceDictionary(littleEndianInputStream);
        }
        if (this.version >= 3) {
            int n = littleEndianInputStream.readInt();
            while (n-- > 0) {
                String string = littleEndianInputStream.readString();
                String string2 = littleEndianInputStream.readString();
                this.properties.put(string, string2);
            }
        }
    }

    private void readSequenceDictionary(LittleEndianInputStream littleEndianInputStream) throws IOException {
        int n = littleEndianInputStream.readInt();
        if (n < 0) {
            throw new IllegalStateException("Size of the sequence dictionary entries is negative");
        }
        for (int i = 0; i < n; ++i) {
            littleEndianInputStream.readString();
            littleEndianInputStream.readInt();
        }
    }

    @Override
    public List<String> getSequenceNames() {
        return new ArrayList<String>(this.chrIndices.keySet());
    }

    @Override
    public List<Block> getBlocks(String string, int n, int n2) {
        return this.getChrIndex(string).getBlocks(n, n2);
    }

    public List<Block> getBlocks(String string) {
        return this.getChrIndex(string).getBlocks();
    }

    private final ChrIndex getChrIndex(String string) {
        ChrIndex chrIndex = this.chrIndices.get(string);
        if (chrIndex == null) {
            throw new IllegalArgumentException("getBlocks() called with of unknown contig " + string);
        }
        return chrIndex;
    }

    @Override
    public void write(LittleEndianOutputStream littleEndianOutputStream) throws IOException {
        this.writeHeader(littleEndianOutputStream);
        littleEndianOutputStream.writeInt(this.chrIndices.size());
        for (ChrIndex chrIndex : this.chrIndices.values()) {
            chrIndex.write(littleEndianOutputStream);
        }
    }

    @Override
    public void writeBasedOnFeatureFile(File file) throws IOException {
        if (!file.isFile()) {
            return;
        }
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(new BufferedOutputStream(new FileOutputStream(Tribble.indexFile(file))));
        this.write(littleEndianOutputStream);
        littleEndianOutputStream.close();
    }

    public void read(LittleEndianInputStream littleEndianInputStream) throws IOException {
        try {
            this.readHeader(littleEndianInputStream);
            int n = littleEndianInputStream.readInt();
            this.chrIndices = new LinkedHashMap(n);
            while (n-- > 0) {
                ChrIndex chrIndex = (ChrIndex)this.getChrIndexClass().newInstance();
                chrIndex.read(littleEndianInputStream);
                this.chrIndices.put(chrIndex.getName(), chrIndex);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new TribbleException.UnableToCreateCorrectIndexType("Unable to create class " + this.getChrIndexClass(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new TribbleException.UnableToCreateCorrectIndexType("Unable to create class " + this.getChrIndexClass(), illegalAccessException);
        }
        finally {
            littleEndianInputStream.close();
        }
    }

    protected void printIndexInfo() {
        System.out.println(String.format("Index for %s with %d indices", this.indexedFile, this.chrIndices.size()));
        BlockStats blockStats = this.getBlockStats(true);
        System.out.println(String.format("  total blocks %d", blockStats.total));
        System.out.println(String.format("  total empty blocks %d", blockStats.empty));
    }

    protected BlockStats getBlockStats(boolean bl) {
        BlockStats blockStats = new BlockStats();
        for (Map.Entry<String, ChrIndex> entry : this.chrIndices.entrySet()) {
            List<Block> list = entry.getValue().getBlocks();
            if (list == null) continue;
            int n = list.size();
            int n2 = 0;
            for (Block block : entry.getValue().getBlocks()) {
                if (block.getSize() != 0L) continue;
                ++n2;
            }
            blockStats.empty += (long)n2;
            blockStats.total += (long)n;
            if (!bl) continue;
            System.out.println(String.format("  %s => %d blocks, %d empty, %.2f", entry.getKey(), n, n2, 100.0 * (double)n2 / (double)n));
        }
        return blockStats;
    }

    protected String statsSummary() {
        BlockStats blockStats = this.getBlockStats(false);
        return String.format("%12d blocks (%12d empty (%.2f%%))", blockStats.total, blockStats.empty, 100.0 * (double)blockStats.empty / (double)blockStats.total);
    }

    @Override
    public void addProperty(String string, String string2) {
        this.properties.put(string, string2);
    }

    @Override
    public void addProperties(Map<String, String> map) {
        this.properties.putAll(map);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected abstract int getType();

    public abstract Class getChrIndexClass();

    protected static class BlockStats {
        long total = 0L;
        long empty = 0L;
        long objects = 0L;
        long size = 0L;

        protected BlockStats() {
        }
    }

    public static enum IndexType {
        LINEAR(1),
        INTERVAL_TREE(2);

        public final int fileHeaderTypeIdentifier;

        private IndexType(int n2) {
            this.fileHeaderTypeIdentifier = n2;
        }
    }
}

