/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileReader;
import htsjdk.samtools.CRAMFileReader;
import htsjdk.samtools.CustomReaderFactory;
import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.InputResource;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFormatException;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMTextReader;
import htsjdk.samtools.SamFiles;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamStreams;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.zip.GZIPInputStream;

public abstract class SamReaderFactory {
    private static ValidationStringency defaultValidationStringency = ValidationStringency.DEFAULT_STRINGENCY;
    private static SamReaderFactoryImpl DEFAULT = new SamReaderFactoryImpl(Option.DEFAULTS, defaultValidationStringency, DefaultSAMRecordFactory.getInstance());

    public abstract SamReader open(File var1);

    public abstract SamReader open(SamInputResource var1);

    public abstract ValidationStringency validationStringency();

    public abstract ReferenceSource referenceSource();

    public abstract SamReaderFactory samRecordFactory(SAMRecordFactory var1);

    public abstract SamReaderFactory enable(Option ... var1);

    public abstract SamReaderFactory disable(Option ... var1);

    public abstract SamReaderFactory setOption(Option var1, boolean var2);

    public abstract SamReaderFactory referenceSequence(File var1);

    public abstract SamReaderFactory referenceSource(ReferenceSource var1);

    public abstract SAMFileHeader getFileHeader(File var1);

    public abstract void reapplyOptions(SamReader var1);

    public abstract SamReaderFactory validationStringency(ValidationStringency var1);

    public static void setDefaultValidationStringency(ValidationStringency validationStringency) {
        defaultValidationStringency = validationStringency;
        DEFAULT = new SamReaderFactoryImpl(Option.DEFAULTS, validationStringency, DefaultSAMRecordFactory.getInstance());
    }

    public static SamReaderFactory makeDefault() {
        return SamReaderFactoryImpl.copyOf(DEFAULT);
    }

    public static SamReaderFactory make() {
        return new SamReaderFactoryImpl(EnumSet.noneOf(Option.class), ValidationStringency.DEFAULT_STRINGENCY, DefaultSAMRecordFactory.getInstance());
    }

    public static enum Option {
        INCLUDE_SOURCE_IN_RECORDS{

            @Override
            void applyTo(BAMFileReader bAMFileReader, SamReader samReader) {
                bAMFileReader.enableFileSource(samReader, true);
            }

            @Override
            void applyTo(SAMTextReader sAMTextReader, SamReader samReader) {
                sAMTextReader.enableFileSource(samReader, true);
            }

            @Override
            void applyTo(CRAMFileReader cRAMFileReader, SamReader samReader) {
                cRAMFileReader.enableFileSource(samReader, true);
            }
        }
        ,
        CACHE_FILE_BASED_INDEXES{

            @Override
            void applyTo(BAMFileReader bAMFileReader, SamReader samReader) {
                bAMFileReader.enableIndexCaching(true);
            }

            @Override
            void applyTo(SAMTextReader sAMTextReader, SamReader samReader) {
                Option.logDebugIgnoringOption(samReader, (Option)this);
            }

            @Override
            void applyTo(CRAMFileReader cRAMFileReader, SamReader samReader) {
                cRAMFileReader.enableIndexCaching(true);
            }
        }
        ,
        DONT_MEMORY_MAP_INDEX{

            @Override
            void applyTo(BAMFileReader bAMFileReader, SamReader samReader) {
                bAMFileReader.enableIndexMemoryMapping(false);
            }

            @Override
            void applyTo(SAMTextReader sAMTextReader, SamReader samReader) {
                Option.logDebugIgnoringOption(samReader, (Option)this);
            }

            @Override
            void applyTo(CRAMFileReader cRAMFileReader, SamReader samReader) {
                cRAMFileReader.enableIndexMemoryMapping(false);
            }
        }
        ,
        EAGERLY_DECODE{

            @Override
            void applyTo(BAMFileReader bAMFileReader, SamReader samReader) {
                bAMFileReader.setEagerDecode(true);
            }

            @Override
            void applyTo(SAMTextReader sAMTextReader, SamReader samReader) {
                Option.logDebugIgnoringOption(samReader, (Option)this);
            }

            @Override
            void applyTo(CRAMFileReader cRAMFileReader, SamReader samReader) {
                Option.logDebugIgnoringOption(samReader, (Option)this);
            }
        }
        ,
        VALIDATE_CRC_CHECKSUMS{

            @Override
            void applyTo(BAMFileReader bAMFileReader, SamReader samReader) {
                bAMFileReader.enableCrcChecking(true);
            }

            @Override
            void applyTo(SAMTextReader sAMTextReader, SamReader samReader) {
                Option.logDebugIgnoringOption(samReader, (Option)this);
            }

            @Override
            void applyTo(CRAMFileReader cRAMFileReader, SamReader samReader) {
                Option.logDebugIgnoringOption(samReader, (Option)this);
            }
        };

        public static EnumSet<Option> DEFAULTS;
        private static final Log LOG;

        void applyTo(SamReader.PrimitiveSamReaderToSamReaderAdapter primitiveSamReaderToSamReaderAdapter) {
            SamReader.PrimitiveSamReader primitiveSamReader = primitiveSamReaderToSamReaderAdapter.underlyingReader();
            if (primitiveSamReader instanceof BAMFileReader) {
                this.applyTo((BAMFileReader)primitiveSamReader, (SamReader)primitiveSamReaderToSamReaderAdapter);
            } else if (primitiveSamReader instanceof SAMTextReader) {
                this.applyTo((SAMTextReader)primitiveSamReader, (SamReader)primitiveSamReaderToSamReaderAdapter);
            } else if (primitiveSamReader instanceof CRAMFileReader) {
                this.applyTo((CRAMFileReader)primitiveSamReader, (SamReader)primitiveSamReaderToSamReaderAdapter);
            } else {
                throw new IllegalArgumentException(String.format("Unrecognized reader type: %s.", primitiveSamReader.getClass()));
            }
        }

        private static void logDebugIgnoringOption(SamReader samReader, Option option) {
            LOG.debug(String.format("Ignoring %s option; does not apply to %s readers.", new Object[]{option, samReader.getClass().getSimpleName()}));
        }

        abstract void applyTo(BAMFileReader var1, SamReader var2);

        abstract void applyTo(SAMTextReader var1, SamReader var2);

        abstract void applyTo(CRAMFileReader var1, SamReader var2);

        static {
            DEFAULTS = EnumSet.noneOf(Option.class);
            LOG = Log.getInstance(Option.class);
        }
    }

    private static class SamReaderFactoryImpl
    extends SamReaderFactory {
        private static final Log LOG = Log.getInstance(SamReaderFactory.class);
        private final EnumSet<Option> enabledOptions;
        private ValidationStringency validationStringency;
        private SAMRecordFactory samRecordFactory;
        private CustomReaderFactory customReaderFactory;
        private ReferenceSource referenceSource;

        private SamReaderFactoryImpl(EnumSet<Option> enumSet, ValidationStringency validationStringency, SAMRecordFactory sAMRecordFactory) {
            this.enabledOptions = EnumSet.copyOf(enumSet);
            this.samRecordFactory = sAMRecordFactory;
            this.validationStringency = validationStringency;
            this.customReaderFactory = CustomReaderFactory.getInstance();
        }

        @Override
        public SamReader open(File file) {
            SamInputResource samInputResource = SamInputResource.of(file);
            File file2 = SamFiles.findIndex(file);
            if (file2 != null) {
                samInputResource.index(file2);
            }
            return this.open(samInputResource);
        }

        @Override
        public ValidationStringency validationStringency() {
            return this.validationStringency;
        }

        @Override
        public ReferenceSource referenceSource() {
            return this.referenceSource;
        }

        @Override
        public SamReaderFactory samRecordFactory(SAMRecordFactory sAMRecordFactory) {
            this.samRecordFactory = sAMRecordFactory;
            return this;
        }

        @Override
        public SamReaderFactory enable(Option ... optionArray) {
            Collections.addAll(this.enabledOptions, optionArray);
            return this;
        }

        @Override
        public SamReaderFactory disable(Option ... optionArray) {
            for (Option option : optionArray) {
                this.enabledOptions.remove((Object)option);
            }
            return this;
        }

        @Override
        public SamReaderFactory setOption(Option option, boolean bl) {
            if (bl) {
                return this.enable(option);
            }
            return this.disable(option);
        }

        @Override
        public SamReaderFactory referenceSequence(File file) {
            this.referenceSource = new ReferenceSource(file);
            return this;
        }

        @Override
        public SamReaderFactory referenceSource(ReferenceSource referenceSource) {
            this.referenceSource = referenceSource;
            return this;
        }

        @Override
        public SAMFileHeader getFileHeader(File file) {
            SamReader samReader = this.open(file);
            SAMFileHeader sAMFileHeader = samReader.getFileHeader();
            CloserUtil.close(samReader);
            return sAMFileHeader;
        }

        @Override
        public void reapplyOptions(SamReader samReader) {
            for (Option option : this.enabledOptions) {
                option.applyTo((SamReader.PrimitiveSamReaderToSamReaderAdapter)samReader);
            }
        }

        @Override
        public SamReaderFactory validationStringency(ValidationStringency validationStringency) {
            this.validationStringency = validationStringency;
            return this;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public SamReader open(SamInputResource samInputResource) {
            try {
                void var2_16;
                Closeable closeable;
                InputResource inputResource = samInputResource.data();
                InputResource inputResource2 = samInputResource.indexMaybe();
                boolean bl = inputResource2 != null;
                InputResource.Type type = inputResource.type();
                if (type == InputResource.Type.URL && (closeable = this.customReaderFactory.maybeOpen(inputResource.asUrl())) != null) {
                    return closeable;
                }
                if (type == InputResource.Type.SEEKABLE_STREAM || type == InputResource.Type.URL) {
                    if (!SamStreams.sourceLikeBam(inputResource.asUnbufferedSeekableStream())) throw new SAMFormatException("Unrecognized file format: " + inputResource.asUnbufferedSeekableStream());
                    closeable = bl && inputResource2.asUnbufferedSeekableStream() != null ? IOUtil.maybeBufferedSeekableStream(inputResource2.asUnbufferedSeekableStream()) : null;
                    BAMFileReader bAMFileReader = new BAMFileReader(IOUtil.maybeBufferedSeekableStream(inputResource.asUnbufferedSeekableStream()), (SeekableStream)closeable, false, this.validationStringency, this.samRecordFactory);
                } else {
                    File file;
                    closeable = IOUtil.maybeBufferInputStream(inputResource.asUnbufferedInputStream(), Math.max(Defaults.BUFFER_SIZE, 65536));
                    File file2 = inputResource.asFile();
                    File file3 = file = inputResource2 == null ? null : inputResource2.asFile();
                    if (SamStreams.isBAMFile((InputStream)closeable)) {
                        if (file2 == null || !file2.isFile()) {
                            BAMFileReader bAMFileReader = new BAMFileReader((InputStream)closeable, file, false, this.validationStringency, this.samRecordFactory);
                        } else {
                            ((InputStream)closeable).close();
                            BAMFileReader bAMFileReader = new BAMFileReader(file2, file, false, this.validationStringency, this.samRecordFactory);
                        }
                    } else if (BlockCompressedInputStream.isValidFile((InputStream)closeable)) {
                        SAMTextReader sAMTextReader = new SAMTextReader(new BlockCompressedInputStream((InputStream)closeable), this.validationStringency, this.samRecordFactory);
                    } else if (SamStreams.isGzippedSAMFile((InputStream)closeable)) {
                        SAMTextReader sAMTextReader = new SAMTextReader(new GZIPInputStream((InputStream)closeable), this.validationStringency, this.samRecordFactory);
                    } else if (SamStreams.isCRAMFile((InputStream)closeable)) {
                        if (this.referenceSource == null && Defaults.REFERENCE_FASTA != null) {
                            this.referenceSource = new ReferenceSource(Defaults.REFERENCE_FASTA);
                        }
                        if (file2 == null || !file2.isFile()) {
                            CRAMFileReader cRAMFileReader = new CRAMFileReader((InputStream)closeable, file, this.referenceSource, this.validationStringency);
                        } else {
                            ((InputStream)closeable).close();
                            CRAMFileReader cRAMFileReader = new CRAMFileReader(file2, file, this.referenceSource, this.validationStringency);
                        }
                    } else {
                        if (bl) {
                            ((InputStream)closeable).close();
                            throw new RuntimeException("Cannot use index file with textual SAM file");
                        }
                        SAMTextReader sAMTextReader = new SAMTextReader((InputStream)closeable, file2, this.validationStringency, this.samRecordFactory);
                    }
                }
                closeable = new SamReader.PrimitiveSamReaderToSamReaderAdapter((SamReader.PrimitiveSamReader)var2_16, samInputResource);
                for (Option option : this.enabledOptions) {
                    option.applyTo((SamReader.PrimitiveSamReaderToSamReaderAdapter)closeable);
                }
                return closeable;
            }
            catch (IOException iOException) {
                throw new RuntimeIOException(iOException);
            }
        }

        public static SamReaderFactory copyOf(SamReaderFactoryImpl samReaderFactoryImpl) {
            return new SamReaderFactoryImpl(samReaderFactoryImpl.enabledOptions, samReaderFactoryImpl.validationStringency, samReaderFactoryImpl.samRecordFactory);
        }
    }
}

