/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractSAMHeaderRecord;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMProgramRecord;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.SequenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SamFileHeaderMerger {
    private static final char[] INT_TO_BASE36;
    private final SAMFileHeader mergedHeader;
    private Collection<SamReader> readers;
    private final Collection<SAMFileHeader> headers;
    private int recordCounter;
    private final Map<SAMFileHeader, Map<String, String>> samReadGroupIdTranslation = new IdentityHashMap<SAMFileHeader, Map<String, String>>();
    private boolean hasReadGroupCollisions = false;
    private boolean hasProgramGroupCollisions = false;
    private final Map<SAMFileHeader, Map<String, String>> samProgramGroupIdTranslation = new IdentityHashMap<SAMFileHeader, Map<String, String>>();
    private boolean hasMergedSequenceDictionary = false;
    private final Map<SAMFileHeader, Map<Integer, Integer>> samSeqDictionaryIdTranslationViaHeader = new IdentityHashMap<SAMFileHeader, Map<Integer, Integer>>();
    private static final HeaderRecordFactory<SAMReadGroupRecord> READ_GROUP_RECORD_FACTORY;
    private static final HeaderRecordFactory<SAMProgramRecord> PROGRAM_RECORD_FACTORY;
    private static final Comparator<AbstractSAMHeaderRecord> RECORD_ID_COMPARATOR;

    public SamFileHeaderMerger(Collection<SamReader> collection, SAMFileHeader.SortOrder sortOrder) {
        this(collection, sortOrder, false);
    }

    public SamFileHeaderMerger(Collection<SamReader> collection, SAMFileHeader.SortOrder sortOrder, boolean bl) {
        this(sortOrder, SamFileHeaderMerger.getHeadersFromReaders(collection), bl);
        this.readers = collection;
    }

    public SamFileHeaderMerger(SAMFileHeader.SortOrder sortOrder, Collection<SAMFileHeader> collection, boolean bl) {
        SAMSequenceDictionary sAMSequenceDictionary;
        this.headers = new LinkedHashSet<SAMFileHeader>(collection);
        this.mergedHeader = new SAMFileHeader();
        try {
            sAMSequenceDictionary = this.getSequenceDictionary(collection);
            this.hasMergedSequenceDictionary = false;
        }
        catch (SequenceUtil.SequenceListsDifferException sequenceListsDifferException) {
            if (bl) {
                sAMSequenceDictionary = this.mergeSequenceDictionaries(collection);
                this.hasMergedSequenceDictionary = true;
            }
            throw sequenceListsDifferException;
        }
        this.mergedHeader.setSequenceDictionary(sAMSequenceDictionary);
        for (SAMProgramRecord object : this.mergeProgramGroups(collection)) {
            this.mergedHeader.addProgramRecord(object);
        }
        List<SAMReadGroupRecord> list = this.mergeReadGroups(collection);
        this.mergedHeader.setReadGroups(list);
        this.mergedHeader.setGroupOrder(SAMFileHeader.GroupOrder.none);
        this.mergedHeader.setSortOrder(sortOrder);
        for (SAMFileHeader sAMFileHeader : collection) {
            for (String string : sAMFileHeader.getComments()) {
                this.mergedHeader.addComment(string);
            }
        }
    }

    private static List<SAMFileHeader> getHeadersFromReaders(Collection<SamReader> collection) {
        ArrayList<SAMFileHeader> arrayList = new ArrayList<SAMFileHeader>(collection.size());
        for (SamReader samReader : collection) {
            arrayList.add(samReader.getFileHeader());
        }
        return arrayList;
    }

    private List<SAMReadGroupRecord> mergeReadGroups(Collection<SAMFileHeader> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        LinkedList linkedList = new LinkedList();
        for (SAMFileHeader sAMFileHeader : collection) {
            for (SAMReadGroupRecord sAMReadGroupRecord : sAMFileHeader.getReadGroups()) {
                if (!hashSet.add(sAMReadGroupRecord.getId())) {
                    throw new SAMException("Input file: " + sAMFileHeader + " contains more than one RG with the same id (" + sAMReadGroupRecord.getId() + ")");
                }
                linkedList.add(new HeaderRecordAndFileHeader<SAMReadGroupRecord>(sAMReadGroupRecord, sAMFileHeader));
            }
            hashSet.clear();
        }
        LinkedList linkedList2 = new LinkedList();
        this.recordCounter = 0;
        this.hasReadGroupCollisions = this.mergeHeaderRecords(linkedList, READ_GROUP_RECORD_FACTORY, hashSet, this.samReadGroupIdTranslation, linkedList2);
        Collections.sort(linkedList2, RECORD_ID_COMPARATOR);
        return linkedList2;
    }

    private List<SAMProgramRecord> mergeProgramGroups(Collection<SAMFileHeader> collection) {
        Object object;
        Object object2;
        LinkedList<SAMProgramRecord> linkedList = new LinkedList<SAMProgramRecord>();
        HashSet<String> hashSet = new HashSet<String>();
        List<HeaderRecordAndFileHeader<SAMProgramRecord>> list = new LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>>();
        for (SAMFileHeader serializable2 : collection) {
            for (SAMProgramRecord sAMProgramRecord : serializable2.getProgramRecords()) {
                if (!hashSet.add(sAMProgramRecord.getId())) {
                    throw new SAMException("Input file: " + serializable2 + " contains more than one PG with the same id (" + sAMProgramRecord.getId() + ")");
                }
                list.add(new HeaderRecordAndFileHeader<SAMProgramRecord>(sAMProgramRecord, serializable2));
            }
            hashSet.clear();
        }
        this.recordCounter = 0;
        Object object4 = new LinkedList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (HeaderRecordAndFileHeader)iterator.next();
            if (((SAMProgramRecord)((HeaderRecordAndFileHeader)object2).getHeaderRecord()).getAttribute("PP") != null) continue;
            iterator.remove();
            object4.add(object2);
        }
        while (!object4.isEmpty()) {
            LinkedList linkedList2 = new LinkedList();
            this.hasProgramGroupCollisions |= this.mergeHeaderRecords((List)object4, PROGRAM_RECORD_FACTORY, hashSet, this.samProgramGroupIdTranslation, linkedList2);
            linkedList.addAll(linkedList2);
            object4 = this.translateIds((List<HeaderRecordAndFileHeader<SAMProgramRecord>>)object4, this.samProgramGroupIdTranslation, false);
            list = this.translateIds(list, this.samProgramGroupIdTranslation, true);
            object2 = new LinkedList();
            Iterator<HeaderRecordAndFileHeader<SAMProgramRecord>> iterator2 = list.iterator();
            block4: while (iterator2.hasNext()) {
                object = iterator2.next();
                String string = ((SAMProgramRecord)((HeaderRecordAndFileHeader)object).getHeaderRecord()).getAttribute("PP");
                Iterator iterator3 = object4.iterator();
                while (iterator3.hasNext()) {
                    HeaderRecordAndFileHeader headerRecordAndFileHeader = (HeaderRecordAndFileHeader)iterator3.next();
                    String string2 = ((SAMProgramRecord)headerRecordAndFileHeader.getHeaderRecord()).getId();
                    if (((HeaderRecordAndFileHeader)object).getFileHeader() != headerRecordAndFileHeader.getFileHeader() || !string.equals(string2)) continue;
                    iterator2.remove();
                    ((LinkedList)object2).add(object);
                    continue block4;
                }
            }
            object4 = object2;
        }
        if (!list.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer(list.size() + " program groups weren't processed. Do their PP ids point to existing PGs? \n");
            for (HeaderRecordAndFileHeader headerRecordAndFileHeader : list) {
                object = (SAMProgramRecord)headerRecordAndFileHeader.getHeaderRecord();
                stringBuffer.append("@PG ID:" + ((SAMProgramRecord)object).getProgramGroupId() + " PN:" + ((SAMProgramRecord)object).getProgramName() + " PP:" + ((SAMProgramRecord)object).getPreviousProgramGroupId() + "\n");
            }
            throw new SAMException(stringBuffer.toString());
        }
        Collections.sort(linkedList, RECORD_ID_COMPARATOR);
        return linkedList;
    }

    private List<HeaderRecordAndFileHeader<SAMProgramRecord>> translateIds(List<HeaderRecordAndFileHeader<SAMProgramRecord>> list, Map<SAMFileHeader, Map<String, String>> map, boolean bl) {
        LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>> linkedList = new LinkedList<HeaderRecordAndFileHeader<SAMProgramRecord>>();
        for (HeaderRecordAndFileHeader<SAMProgramRecord> headerRecordAndFileHeader : list) {
            SAMProgramRecord sAMProgramRecord = headerRecordAndFileHeader.getHeaderRecord();
            String string = sAMProgramRecord.getProgramGroupId();
            String string2 = sAMProgramRecord.getAttribute("PP");
            SAMFileHeader sAMFileHeader = headerRecordAndFileHeader.getFileHeader();
            Map<String, String> map2 = map.get(sAMFileHeader);
            SAMProgramRecord sAMProgramRecord2 = null;
            if (map2 != null) {
                boolean bl2;
                String string3 = map2.get(string);
                String string4 = bl ? map2.get(string2) : null;
                boolean bl3 = string3 != null && !string3.equals(string);
                boolean bl4 = bl2 = string4 != null && !string4.equals(string2);
                if (bl3 && bl2) {
                    sAMProgramRecord2 = new SAMProgramRecord(string3, sAMProgramRecord);
                    sAMProgramRecord2.setAttribute("PP", string4);
                } else if (bl3) {
                    sAMProgramRecord2 = new SAMProgramRecord(string3, sAMProgramRecord);
                } else if (bl2) {
                    sAMProgramRecord2 = new SAMProgramRecord(string, sAMProgramRecord);
                    sAMProgramRecord2.setAttribute("PP", string4);
                }
            }
            if (sAMProgramRecord2 != null) {
                linkedList.add(new HeaderRecordAndFileHeader<Object>(sAMProgramRecord2, sAMFileHeader));
                continue;
            }
            linkedList.add(headerRecordAndFileHeader);
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    private <RecordType extends AbstractSAMHeaderRecord> boolean mergeHeaderRecords(List<HeaderRecordAndFileHeader<RecordType>> list, HeaderRecordFactory<RecordType> headerRecordFactory, HashSet<String> hashSet, Map<SAMFileHeader, Map<String, String>> map, List<RecordType> list2) {
        Object object;
        Object object2;
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        for (HeaderRecordAndFileHeader<RecordType> object3 : list) {
            void var13_17;
            List list3;
            RecordType RecordType = object3.getHeaderRecord();
            object2 = object3.getFileHeader();
            object = ((AbstractSAMHeaderRecord)RecordType).getId();
            LinkedHashMap linkedHashMap2 = (LinkedHashMap)linkedHashMap.get(object);
            if (linkedHashMap2 == null) {
                linkedHashMap2 = new LinkedHashMap();
                linkedHashMap.put(object, linkedHashMap2);
            }
            if ((list3 = (List)linkedHashMap2.get(RecordType)) == null) {
                LinkedList linkedList = new LinkedList();
                linkedHashMap2.put(RecordType, linkedList);
            }
            var13_17.add(object2);
        }
        boolean bl = false;
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object2 = (String)entry.getKey();
            object = (Map)entry.getValue();
            for (Map.Entry entry2 : object.entrySet()) {
                Object object3;
                AbstractSAMHeaderRecord abstractSAMHeaderRecord = (AbstractSAMHeaderRecord)entry2.getKey();
                List list4 = (List)entry2.getValue();
                if (!hashSet.contains(object2)) {
                    object3 = object2;
                    hashSet.add((String)object2);
                    ++this.recordCounter;
                } else {
                    bl = true;
                    while (hashSet.contains(object3 = (String)object2 + "." + SamFileHeaderMerger.positiveFourDigitBase36Str(this.recordCounter++))) {
                    }
                    hashSet.add((String)object3);
                }
                for (SAMFileHeader sAMFileHeader : list4) {
                    Map<String, String> map2 = map.get(sAMFileHeader);
                    if (map2 == null) {
                        map2 = new HashMap<String, String>();
                        map.put(sAMFileHeader, map2);
                    }
                    map2.put((String)object2, (String)object3);
                }
                list2.add(headerRecordFactory.createRecord((String)object3, abstractSAMHeaderRecord));
            }
        }
        return bl;
    }

    public static String positiveFourDigitBase36Str(int n) {
        if (n == 0) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder(10);
        while (n > 0) {
            int n2 = n % 36;
            stringBuilder.append(INT_TO_BASE36[n2]);
            n /= 36;
        }
        return stringBuilder.reverse().toString();
    }

    private SAMSequenceDictionary getSequenceDictionary(Collection<SAMFileHeader> collection) {
        SAMSequenceDictionary sAMSequenceDictionary = null;
        for (SAMFileHeader sAMFileHeader : collection) {
            if (sAMSequenceDictionary == null) {
                sAMSequenceDictionary = sAMFileHeader.getSequenceDictionary();
                continue;
            }
            SAMSequenceDictionary sAMSequenceDictionary2 = sAMFileHeader.getSequenceDictionary();
            SequenceUtil.assertSequenceDictionariesEqual(sAMSequenceDictionary, sAMSequenceDictionary2);
        }
        return sAMSequenceDictionary;
    }

    private SAMSequenceDictionary mergeSequenceDictionaries(Collection<SAMFileHeader> collection) {
        SAMSequenceDictionary sAMSequenceDictionary = new SAMSequenceDictionary();
        for (SAMFileHeader sAMFileHeader : collection) {
            SAMSequenceDictionary sAMSequenceDictionary2 = sAMFileHeader.getSequenceDictionary();
            sAMSequenceDictionary = this.mergeSequences(sAMSequenceDictionary, sAMSequenceDictionary2);
        }
        this.createSequenceMapping(collection, sAMSequenceDictionary);
        return sAMSequenceDictionary;
    }

    private SAMSequenceDictionary mergeSequences(SAMSequenceDictionary sAMSequenceDictionary, SAMSequenceDictionary sAMSequenceDictionary2) {
        SAMSequenceRecord sAMSequenceRecord2;
        LinkedList<SAMSequenceRecord> linkedList = new LinkedList<SAMSequenceRecord>();
        LinkedList<SAMSequenceRecord> linkedList2 = new LinkedList<SAMSequenceRecord>();
        for (SAMSequenceRecord sAMSequenceRecord2 : sAMSequenceDictionary.getSequences()) {
            linkedList2.add(sAMSequenceRecord2);
        }
        int n = -1;
        sAMSequenceRecord2 = null;
        for (SAMSequenceRecord sAMSequenceRecord3 : sAMSequenceDictionary2.getSequences()) {
            int n2 = SamFileHeaderMerger.getIndexOfSequenceName(linkedList2, sAMSequenceRecord3.getSequenceName());
            if (n2 == -1) {
                linkedList.add(sAMSequenceRecord3.clone());
                continue;
            }
            if (n > n2) {
                throw new SAMException("Cannot merge sequence dictionaries because sequence " + sAMSequenceRecord3.getSequenceName() + " and " + sAMSequenceRecord2.getSequenceName() + " are in different orders in two input sequence dictionaries.");
            }
            linkedList2.addAll(n2, linkedList);
            n = n2 + linkedList.size();
            sAMSequenceRecord2 = sAMSequenceRecord3;
            linkedList.clear();
        }
        if (linkedList.size() != 0) {
            linkedList2.addAll(linkedList);
        }
        return new SAMSequenceDictionary(linkedList2);
    }

    private static int getIndexOfSequenceName(List<SAMSequenceRecord> list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getSequenceName().equals(string)) continue;
            return i;
        }
        return -1;
    }

    private void createSequenceMapping(Collection<SAMFileHeader> collection, SAMSequenceDictionary sAMSequenceDictionary) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (SAMSequenceRecord abstractSAMHeaderRecord : sAMSequenceDictionary.getSequences()) {
            linkedList.add(abstractSAMHeaderRecord.getSequenceName());
        }
        for (SAMFileHeader sAMFileHeader : collection) {
            HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
            SAMSequenceDictionary sAMSequenceDictionary2 = sAMFileHeader.getSequenceDictionary();
            for (SAMSequenceRecord sAMSequenceRecord : sAMSequenceDictionary2.getSequences()) {
                hashMap.put(sAMSequenceRecord.getSequenceIndex(), linkedList.indexOf(sAMSequenceRecord.getSequenceName()));
            }
            this.samSeqDictionaryIdTranslationViaHeader.put(sAMFileHeader, hashMap);
        }
    }

    public String getReadGroupId(SamReader samReader, String string) {
        return this.getReadGroupId(samReader.getFileHeader(), string);
    }

    public String getReadGroupId(SAMFileHeader sAMFileHeader, String string) {
        return this.samReadGroupIdTranslation.get(sAMFileHeader).get(string);
    }

    public String getProgramGroupId(SamReader samReader, String string) {
        return this.getProgramGroupId(samReader.getFileHeader(), string);
    }

    public String getProgramGroupId(SAMFileHeader sAMFileHeader, String string) {
        return this.samProgramGroupIdTranslation.get(sAMFileHeader).get(string);
    }

    public boolean hasReadGroupCollisions() {
        return this.hasReadGroupCollisions;
    }

    public boolean hasProgramGroupCollisions() {
        return this.hasProgramGroupCollisions;
    }

    public boolean hasMergedSequenceDictionary() {
        return this.hasMergedSequenceDictionary;
    }

    public SAMFileHeader getMergedHeader() {
        return this.mergedHeader;
    }

    public Collection<SamReader> getReaders() {
        return this.readers;
    }

    public Collection<SAMFileHeader> getHeaders() {
        return this.headers;
    }

    public Integer getMergedSequenceIndex(SamReader samReader, Integer n) {
        return this.getMergedSequenceIndex(samReader.getFileHeader(), n);
    }

    public Integer getMergedSequenceIndex(SAMFileHeader sAMFileHeader, Integer n) {
        Map<Integer, Integer> map = this.samSeqDictionaryIdTranslationViaHeader.get(sAMFileHeader);
        if (map == null) {
            throw new SAMException("No sequence dictionary mapping available for header: " + sAMFileHeader);
        }
        Integer n2 = map.get(n);
        if (n2 == null) {
            throw new SAMException("No mapping for reference index " + n + " from header: " + sAMFileHeader);
        }
        return n2;
    }

    static {
        int n;
        INT_TO_BASE36 = new char[36];
        int n2 = 65;
        int n3 = 48;
        for (n = 0; n < 10; ++n) {
            SamFileHeaderMerger.INT_TO_BASE36[n] = (char)(n3 + n);
        }
        for (n = 0; n < 26; ++n) {
            SamFileHeaderMerger.INT_TO_BASE36[n + 10] = (char)(n2 + n);
        }
        READ_GROUP_RECORD_FACTORY = new HeaderRecordFactory<SAMReadGroupRecord>(){

            @Override
            public SAMReadGroupRecord createRecord(String string, SAMReadGroupRecord sAMReadGroupRecord) {
                return new SAMReadGroupRecord(string, sAMReadGroupRecord);
            }
        };
        PROGRAM_RECORD_FACTORY = new HeaderRecordFactory<SAMProgramRecord>(){

            @Override
            public SAMProgramRecord createRecord(String string, SAMProgramRecord sAMProgramRecord) {
                return new SAMProgramRecord(string, sAMProgramRecord);
            }
        };
        RECORD_ID_COMPARATOR = new Comparator<AbstractSAMHeaderRecord>(){

            @Override
            public int compare(AbstractSAMHeaderRecord abstractSAMHeaderRecord, AbstractSAMHeaderRecord abstractSAMHeaderRecord2) {
                return abstractSAMHeaderRecord.getId().compareTo(abstractSAMHeaderRecord2.getId());
            }
        };
    }

    private static class HeaderRecordAndFileHeader<RecordType extends AbstractSAMHeaderRecord> {
        private final RecordType headerRecord;
        private final SAMFileHeader samFileHeader;

        public HeaderRecordAndFileHeader(RecordType RecordType, SAMFileHeader sAMFileHeader) {
            this.headerRecord = RecordType;
            this.samFileHeader = sAMFileHeader;
        }

        public RecordType getHeaderRecord() {
            return this.headerRecord;
        }

        public SAMFileHeader getFileHeader() {
            return this.samFileHeader;
        }
    }

    private static interface HeaderRecordFactory<RecordType extends AbstractSAMHeaderRecord> {
        public RecordType createRecord(String var1, RecordType var2);
    }
}

