/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.CRAMIterator;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.DiskBasedBAMFileIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.RuntimeEOFException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;

public class CRAMFileReader
extends SamReader.ReaderImplementation
implements SamReader.Indexing {
    private File cramFile;
    private final ReferenceSource referenceSource;
    private InputStream inputStream;
    private CRAMIterator iterator;
    private BAMIndex mIndex;
    private File mIndexFile;
    private boolean mEnableIndexCaching;
    private boolean mEnableIndexMemoryMapping;
    private ValidationStringency validationStringency;
    private static final SAMRecordIterator emptyIterator = new SAMRecordIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new RuntimeException("No records.");
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported.");
        }

        @Override
        public void close() {
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return this;
        }
    };

    public CRAMFileReader(File file, InputStream inputStream) {
        this(file, inputStream, new ReferenceSource(Defaults.REFERENCE_FASTA));
    }

    public CRAMFileReader(File file, InputStream inputStream, ReferenceSource referenceSource) {
        if (file == null && inputStream == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        this.cramFile = file;
        this.inputStream = inputStream;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File file, File file2, ReferenceSource referenceSource) {
        if (file == null) {
            throw new IllegalArgumentException("File is required.");
        }
        this.cramFile = file;
        this.mIndexFile = file2;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File file, ReferenceSource referenceSource) {
        if (file == null && this.inputStream == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        this.cramFile = file;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(InputStream inputStream, SeekableStream seekableStream, ReferenceSource referenceSource, ValidationStringency validationStringency) throws IOException {
        this.inputStream = inputStream;
        this.referenceSource = referenceSource;
        this.validationStringency = validationStringency;
        this.iterator = new CRAMIterator(inputStream, referenceSource);
        this.iterator.setValidationStringency(validationStringency);
        if (seekableStream != null) {
            try {
                this.mIndex = new CachingBAMFileIndex(seekableStream, this.iterator.getSAMFileHeader().getSequenceDictionary());
            }
            catch (Exception exception) {
                seekableStream.seek(0L);
                SeekableStream seekableStream2 = CRAIIndex.openCraiFileAsBaiStream(seekableStream, this.iterator.getSAMFileHeader().getSequenceDictionary());
                this.mIndex = new CachingBAMFileIndex(seekableStream2, this.iterator.getSAMFileHeader().getSequenceDictionary());
            }
        }
    }

    public CRAMFileReader(InputStream inputStream, File file, ReferenceSource referenceSource, ValidationStringency validationStringency) throws IOException {
        this(inputStream, file == null ? null : new SeekableFileStream(file), referenceSource, validationStringency);
    }

    public CRAMFileReader(File file, File file2, ReferenceSource referenceSource, ValidationStringency validationStringency) throws IOException {
        this((InputStream)new FileInputStream(file), file2, referenceSource, validationStringency);
        this.cramFile = file;
    }

    @Override
    void enableIndexCaching(boolean bl) {
        this.mEnableIndexCaching = bl;
    }

    @Override
    void enableIndexMemoryMapping(boolean bl) {
        this.mEnableIndexMemoryMapping = bl;
    }

    @Override
    void enableCrcChecking(boolean bl) {
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory sAMRecordFactory) {
    }

    @Override
    public boolean hasIndex() {
        return this.mIndex != null || this.mIndexFile != null;
    }

    @Override
    public BAMIndex getIndex() {
        if (!this.hasIndex()) {
            throw new SAMException("No index is available for this BAM file.");
        }
        if (this.mIndex == null) {
            SeekableStream seekableStream;
            SAMSequenceDictionary sAMSequenceDictionary = this.getFileHeader().getSequenceDictionary();
            if (this.mIndexFile.getName().endsWith(".bai")) {
                this.mIndex = this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, sAMSequenceDictionary, this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, sAMSequenceDictionary, this.mEnableIndexMemoryMapping);
                return this.mIndex;
            }
            if (!this.mIndexFile.getName().endsWith(".crai")) {
                return null;
            }
            try {
                seekableStream = CRAIIndex.openCraiFileAsBaiStream(this.mIndexFile, this.iterator.getSAMFileHeader().getSequenceDictionary());
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
            this.mIndex = this.mEnableIndexCaching ? new CachingBAMFileIndex(seekableStream, this.getFileHeader().getSequenceDictionary()) : new DiskBasedBAMFileIndex(seekableStream, this.getFileHeader().getSequenceDictionary());
        }
        return this.mIndex;
    }

    @Override
    public boolean hasBrowseableIndex() {
        return false;
    }

    @Override
    public BrowseableBAMIndex getBrowseableIndex() {
        return null;
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan sAMFileSpan) {
        long[] lArray = ((BAMFileSpan)sAMFileSpan).toCoordinateArray();
        if (lArray == null || lArray.length == 0) {
            return emptyIterator;
        }
        try {
            SeekableStream seekableStream = this.getSeekableStreamOrFailWithRTE();
            return new CRAMIterator(seekableStream, this.referenceSource, lArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.iterator.getSAMFileHeader();
    }

    public SAMRecordIterator getIterator() {
        if (this.iterator != null && this.cramFile == null) {
            return this.iterator;
        }
        try {
            CRAMIterator cRAMIterator = this.cramFile != null ? new CRAMIterator(new FileInputStream(this.cramFile), this.referenceSource) : new CRAMIterator(this.inputStream, this.referenceSource);
            cRAMIterator.setValidationStringency(this.validationStringency);
            this.iterator = cRAMIterator;
            return this.iterator;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan sAMFileSpan) {
        return this.iterator(sAMFileSpan);
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        return new BAMFileSpan(new Chunk(this.iterator.firstContainerOffset << 16, Long.MAX_VALUE));
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String string, int n) {
        Object object;
        Object object2;
        long[] lArray = null;
        SAMFileHeader sAMFileHeader = this.getFileHeader();
        int n2 = sAMFileHeader.getSequenceIndex(string);
        if (n2 != -1) {
            object2 = this.getIndex();
            object = object2.getSpanOverlapping(n2, n, -1);
            long[] lArray2 = lArray = object != null ? ((BAMFileSpan)object).toCoordinateArray() : null;
        }
        if (lArray == null || lArray.length == 0) {
            return emptyIterator;
        }
        object = this.getSeekableStreamOrFailWithRTE();
        for (int i = 0; i < lArray.length; i += 2) {
            long l = lArray[i] >>> 16;
            try {
                if (((SeekableStream)object).position() != l || this.iterator.container == null) {
                    ((SeekableStream)object).seek(l);
                    object2 = ContainerIO.readContainerHeader(this.iterator.getCramHeader().getVersion().major, (InputStream)object);
                    if (((Container)object2).alignmentStart + ((Container)object2).alignmentSpan <= n) continue;
                    ((SeekableStream)object).seek(l);
                    this.iterator.jumpWithinContainerToPos(sAMFileHeader.getSequenceIndex(string), n);
                    return new IntervalIterator(this.iterator, new QueryInterval(n2, n, -1));
                }
                object2 = this.iterator.container;
                if (((Container)object2).alignmentStart + ((Container)object2).alignmentSpan <= n) continue;
                this.iterator.jumpWithinContainerToPos(sAMFileHeader.getSequenceIndex(string), n);
                return new IntervalIterator(this.iterator, new QueryInterval(n2, n, -1));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return this.iterator;
    }

    CloseableIterator<SAMRecord> query(int n, int n2, int n3, boolean bl) throws IOException {
        Closeable closeable;
        long[] lArray = null;
        if (n != -1) {
            closeable = this.getIndex();
            BAMFileSpan bAMFileSpan = closeable.getSpanOverlapping(n, n2, -1);
            long[] lArray2 = lArray = bAMFileSpan != null ? bAMFileSpan.toCoordinateArray() : null;
        }
        if (lArray == null || lArray.length == 0) {
            return emptyIterator;
        }
        closeable = new CRAMIterator(this.getSeekableStreamOrFailWithRTE(), this.referenceSource, lArray);
        return new IntervalIterator((CloseableIterator<SAMRecord>)closeable, new QueryInterval(n, n2, n3), bl);
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        long l = this.getIndex().getStartOfLastLinearBin();
        SeekableStream seekableStream = this.getSeekableStreamOrFailWithRTE();
        try {
            seekableStream.seek(0L);
            CRAMIterator cRAMIterator = new CRAMIterator(seekableStream, this.referenceSource);
            cRAMIterator.setValidationStringency(this.validationStringency);
            seekableStream.seek(l >>> 16);
            Container container = ContainerIO.readContainerHeader(cRAMIterator.getCramHeader().getVersion().major, seekableStream);
            seekableStream.seek(seekableStream.position() + (long)container.containerByteSize);
            this.iterator = cRAMIterator;
            this.iterator.jumpWithinContainerToPos(-1, 0);
        }
        catch (IOException iOException) {
            throw new RuntimeEOFException(iOException);
        }
        return this.iterator;
    }

    private SeekableStream getSeekableStreamOrFailWithRTE() {
        SeekableStream seekableStream = null;
        if (this.cramFile != null) {
            try {
                seekableStream = new SeekableFileStream(this.cramFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new RuntimeException(fileNotFoundException);
            }
        } else if (this.inputStream instanceof SeekableStream) {
            seekableStream = (SeekableStream)this.inputStream;
        }
        return seekableStream;
    }

    @Override
    public void close() {
        CloserUtil.close(this.iterator);
        CloserUtil.close(this.inputStream);
        CloserUtil.close(this.mIndex);
    }

    @Override
    void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
        if (this.iterator != null) {
            this.iterator.setValidationStringency(validationStringency);
        }
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] queryIntervalArray, boolean bl) {
        return new MultiIntervalIterator(Arrays.asList(queryIntervalArray).iterator(), !bl);
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.CRAM_TYPE;
    }

    @Override
    void enableFileSource(SamReader samReader, boolean bl) {
        if (this.iterator != null) {
            this.iterator.setFileSource(bl ? samReader : null);
        }
    }

    public static class IntervalIterator
    implements SAMRecordIterator {
        private final CloseableIterator<SAMRecord> delegate;
        private final QueryInterval interval;
        private SAMRecord next;
        private boolean noMore = false;
        private final boolean overlap;

        public IntervalIterator(CloseableIterator<SAMRecord> closeableIterator, QueryInterval queryInterval) {
            this(closeableIterator, queryInterval, true);
        }

        public IntervalIterator(CloseableIterator<SAMRecord> closeableIterator, QueryInterval queryInterval, boolean bl) {
            this.delegate = closeableIterator;
            this.interval = queryInterval;
            this.overlap = bl;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return null;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.noMore) {
                return false;
            }
            while (this.delegate.hasNext()) {
                this.next = (SAMRecord)this.delegate.next();
                if (this.isWithinTheInterval(this.next)) break;
                if (this.isBeyondTheInterval(this.next)) {
                    this.next = null;
                    this.noMore = true;
                    return false;
                }
                this.next = null;
            }
            return this.next != null;
        }

        boolean isWithinTheInterval(SAMRecord sAMRecord) {
            boolean bl;
            boolean bl2 = bl = sAMRecord.getReferenceIndex() == this.interval.referenceIndex;
            if (this.interval.start == -1) {
                return bl;
            }
            int n = sAMRecord.getAlignmentStart();
            int n2 = sAMRecord.getAlignmentEnd();
            if (this.overlap) {
                return CoordMath.overlaps(n, n2, this.interval.start, this.interval.end < 0 ? Integer.MAX_VALUE : this.interval.end);
            }
            return CoordMath.encloses(this.interval.start, this.interval.end < 0 ? Integer.MAX_VALUE : this.interval.end, n, n2);
        }

        boolean isBeyondTheInterval(SAMRecord sAMRecord) {
            if (sAMRecord.getReadUnmappedFlag()) {
                return false;
            }
            boolean bl = sAMRecord.getReferenceIndex() == this.interval.referenceIndex;
            return !bl || this.interval.end != -1 && sAMRecord.getAlignmentStart() > this.interval.end;
        }

        @Override
        public SAMRecord next() {
            SAMRecord sAMRecord = this.next;
            this.next = null;
            return sAMRecord;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not available.");
        }
    }

    private class MultiIntervalIterator
    implements SAMRecordIterator {
        private final Iterator<QueryInterval> queries;
        private CloseableIterator<SAMRecord> iterator;
        private final boolean overlap;

        public MultiIntervalIterator(Iterator<QueryInterval> iterator, boolean bl) {
            this.queries = iterator;
            this.overlap = bl;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null || !this.iterator.hasNext()) {
                if (!this.queries.hasNext()) {
                    return false;
                }
                do {
                    QueryInterval queryInterval = this.queries.next();
                    try {
                        this.iterator = CRAMFileReader.this.query(queryInterval.referenceIndex, queryInterval.start, queryInterval.end, this.overlap);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException(iOException);
                    }
                } while (!this.iterator.hasNext() && this.queries.hasNext());
            }
            return this.iterator.hasNext();
        }

        @Override
        public SAMRecord next() {
            return (SAMRecord)this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

