/*
 * Decompiled with CFR 0.152.
 */
package flanagan.circuits;

import flanagan.analysis.ErrorProp;
import flanagan.analysis.Regression;
import flanagan.analysis.RegressionFunction2;
import flanagan.analysis.Stat;
import flanagan.circuits.ImpedSpecModel;
import flanagan.circuits.ImpedSpecRegressionFunction1;
import flanagan.circuits.ImpedSpecRegressionFunction2;
import flanagan.circuits.Impedance;
import flanagan.complex.Complex;
import flanagan.complex.ComplexErrorProp;
import flanagan.io.FileOutput;
import flanagan.math.Conv;
import flanagan.math.Fmath;
import flanagan.plot.PlotGraph;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;

public class ImpedSpecRegression
extends Regression {
    private String regressionTitle = null;
    private boolean fileType = false;
    private Complex appliedVoltage = null;
    private boolean appliedVoltageSet = false;
    private Complex appliedVoltageError = null;
    private boolean voltageErrorSet = false;
    private Complex referenceImpedance = null;
    private boolean referenceSet = false;
    private double[] frequencies = null;
    private double[] omegas = null;
    private double[] log10frequencies = null;
    private double[] log10omegas = null;
    private int numberOfFrequencies = 0;
    private boolean frequenciesSet = false;
    private Complex[] voltages = null;
    private Complex[] voltageWeights = null;
    private double[] voltageMagnitudes = null;
    private double[] voltageMagnitudeWeights = null;
    private double[] voltagePhasesRad = null;
    private double[] voltagePhaseWeightsRad = null;
    private double[] voltagePhasesDeg = null;
    private double[] voltagePhaseWeightsDeg = null;
    private double[] realV = null;
    private double[] realVweights = null;
    private double[] imagV = null;
    private double[] imagVweights = null;
    private boolean weightsSet = true;
    private int dataEnteredTypePointer = -1;
    private String[] dataEnteredType = new String[]{"Complex voltage (as real and imaginary parts)", "Complex voltage (as Complex)", "Voltage Magnitude and phase (in radians)", "Voltage Magnitude and phase (in degrees)", "Complex impedance (as real and imaginary parts)", "Complex impedance (as Complex)", "Magnitude and phase (in radians)", "Magnitude and phase (in degrees)"};
    private boolean voltageOrImpedance = true;
    private Complex[] impedances = null;
    private Complex[] impedanceWeights = null;
    private double[] impedanceMagnitudes = null;
    private double[] impedanceMagnitudeWeights = null;
    private double[] impedancePhasesRad = null;
    private double[] impedancePhaseWeightsRad = null;
    private double[] impedancePhasesDeg = null;
    private double[] impedancePhaseWeightsDeg = null;
    private double[] realZ = null;
    private double[] realZweights = null;
    private double[] imagZ = null;
    private double[] imagZweights = null;
    private boolean impedancesSet = false;
    private double[] xRegression = null;
    private double[][] yRegression = null;
    private double[][] wRegression = null;
    private int modelNumber = 0;
    private int numberOfParameters = 0;
    private String[] parameterSymbols = null;
    private boolean modelSet = false;
    private boolean estimatesNeeded = false;
    private boolean supressDefaultConstraints = false;
    private boolean supressAddedConstraints = false;
    private boolean supressAllConstraints = false;
    private ArrayList<Object> constraints = null;
    private int numberOfAddedConstraints = -1;
    private boolean constraintsAdded = false;
    private double[] initialEstimates = null;
    private double[] initialSteps = null;
    private double[] bestEstimates = null;
    private double[] standardDeviations = null;
    private double[] coefficientsOfVariation = null;
    private double[][] correlationCoefficients = null;
    private double[] preMinimumGradients = null;
    private double[] postMinimumGradients = null;
    private int degreesOfFreedom = 0;
    private double sumOfSquares = 0.0;
    private double reducedSumOfSquares = 0.0;
    private double chiSquare = Double.NaN;
    private double reducedChiSquare = Double.NaN;
    private double[] realZresiduals = null;
    private double[] imagZresiduals = null;
    private double[] calculatedRealZ = null;
    private double[] calculatedImagZ = null;
    private Complex[] calculatedImpedances = null;
    private double[] calculatedImpedanceMagnitudes = null;
    private double[] calculatedImpedancePhasesRad = null;
    private double[] calculatedImpedancePhasesDeg = null;
    private double[] calculatedRealV = null;
    private double[] calculatedImagV = null;
    private Complex[] calculatedVoltages = null;
    private double[] calculatedVoltageMagnitudes = null;
    private double[] calculatedVoltagePhasesRad = null;
    private double[] calculatedVoltagePhasesDeg = null;
    ArrayList<Object> results = null;
    private boolean estimatesSet = false;
    private ImpedSpecModel userModel = null;
    private boolean userModelSet = false;
    private RegressionFunction2 regressionFunction = null;
    private double tolerance = 1.0E-9;
    private int maximumIterations = 10000;
    private int numberOfIterations1 = -1;
    private int numberOfIterations2 = -1;
    private boolean regressionDone = false;
    private int numberOfLineFrequencies = 8000;
    private boolean logOrLinear = true;
    private double[] lineFrequencies = null;
    private double[] log10lineFrequencies = null;

    public ImpedSpecRegression() {
        this.regressionTitle = "  ";
    }

    public ImpedSpecRegression(String regressionTitle) {
        this.regressionTitle = regressionTitle;
    }

    public void setAppliedVoltage(double voltage) {
        this.appliedVoltage = new Complex(voltage, 0.0);
        this.appliedVoltageError = new Complex(0.0, 0.0);
        this.appliedVoltageSet = true;
        if (this.referenceSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void appliedVoltage(double voltage, double voltageError) {
        this.appliedVoltage = new Complex(voltage, 0.0);
        this.appliedVoltageSet = true;
        this.appliedVoltage = new Complex(voltageError, 0.0);
        this.voltageErrorSet = true;
        if (this.referenceSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void setReferenceImpedance(double resistance) {
        this.referenceImpedance = new Complex(resistance, 0.0);
        this.referenceSet = true;
        if (this.appliedVoltageSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void setReferenceImpedance(double real, double imag) {
        this.referenceImpedance = new Complex(real, imag);
        this.referenceSet = true;
        if (this.appliedVoltageSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void setReferenceImpedance(Complex impedance) {
        this.referenceImpedance = impedance;
        this.referenceSet = true;
        if (this.appliedVoltageSet && this.frequenciesSet) {
            this.calculateExperimentalImpedances();
        }
    }

    public void voltageDataAsComplex(double[] frequencies, double[] real, double[] imag) {
        double[] realWeight = new double[frequencies.length];
        double[] imagWeight = new double[frequencies.length];
        this.weightsSet = false;
        this.voltageDataAsComplex(frequencies, real, imag, realWeight, imagWeight);
    }

    public void voltageDataAsComplex(double[] frequencies, double[] real, double[] imag, double[] realWeight, double[] imagWeight) {
        this.numberOfFrequencies = frequencies.length;
        if (this.numberOfFrequencies != real.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of Real[voltages], " + real.length);
        }
        if (this.numberOfFrequencies != imag.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of Imag[voltages], " + imag.length);
        }
        if (this.numberOfFrequencies != realWeight.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of real weights, " + realWeight.length);
        }
        if (this.numberOfFrequencies != imagWeight.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of imag weights, " + imagWeight.length);
        }
        this.frequencies = Conv.copy(frequencies);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.realV = Conv.copy(real);
        this.imagV = Conv.copy(imag);
        this.realVweights = Conv.copy(realWeight);
        this.imagVweights = Conv.copy(imagWeight);
        this.voltageMagnitudes = new double[this.numberOfFrequencies];
        this.voltagePhasesDeg = new double[this.numberOfFrequencies];
        this.voltagePhasesRad = new double[this.numberOfFrequencies];
        this.voltages = Complex.oneDarray(this.numberOfFrequencies);
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.voltages[i] = new Complex(this.realV[i], this.imagV[i]);
            this.voltageMagnitudes[i] = this.voltages[i].abs();
            this.voltagePhasesRad[i] = this.voltages[i].arg();
            this.voltagePhasesDeg[i] = Math.toDegrees(this.voltagePhasesRad[i]);
        }
        this.frequenciesSet = true;
        this.setImpedanceArrayLengths();
        this.calculateExperimentalImpedances();
        this.dataEnteredTypePointer = 4;
        this.voltageOrImpedance = true;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void voltageDataAsComplex(double[] frequencies, Complex[] voltages) {
        Complex[] weights = Complex.oneDarray(voltages.length, 0.0, 0.0);
        this.weightsSet = false;
        this.voltageDataAsComplex(frequencies, voltages, weights);
    }

    public void voltageDataAsComplex(double[] frequencies, Complex[] voltages, Complex[] weights) {
        this.numberOfFrequencies = frequencies.length;
        if (this.numberOfFrequencies != voltages.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of voltages, " + voltages.length);
        }
        if (this.numberOfFrequencies != weights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of weights, " + weights.length);
        }
        this.frequencies = Conv.copy(frequencies);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.voltages = Complex.copy(voltages);
        this.voltageWeights = Complex.copy(weights);
        this.voltageMagnitudes = new double[this.numberOfFrequencies];
        this.voltagePhasesDeg = new double[this.numberOfFrequencies];
        this.voltagePhasesRad = new double[this.numberOfFrequencies];
        this.realV = new double[this.numberOfFrequencies];
        this.imagV = new double[this.numberOfFrequencies];
        this.realVweights = new double[this.numberOfFrequencies];
        this.imagVweights = new double[this.numberOfFrequencies];
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.realV[i] = this.voltages[i].getReal();
            this.imagV[i] = this.voltages[i].getImag();
            this.realVweights[i] = weights[i].getReal();
            this.imagVweights[i] = weights[i].getImag();
            this.voltageMagnitudes[i] = this.voltages[i].abs();
            this.voltagePhasesRad[i] = this.voltages[i].arg();
            this.voltagePhasesDeg[i] = Math.toDegrees(this.voltagePhasesRad[i]);
        }
        this.frequenciesSet = true;
        this.setImpedanceArrayLengths();
        this.calculateExperimentalImpedances();
        this.voltageOrImpedance = true;
        this.dataEnteredTypePointer = 1;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void voltageDataAsPhasorRad(double[] frequencies, double[] voltageMagnitudes, double[] voltagePhasesRad) {
        double[] voltageMagWeights = new double[frequencies.length];
        double[] voltagePhaseWeights = new double[frequencies.length];
        this.weightsSet = false;
        this.voltageDataAsPhasorRad(frequencies, voltageMagnitudes, voltagePhasesRad, voltageMagWeights, voltagePhaseWeights);
    }

    public void voltageDataAsPhasorRad(double[] frequencies, double[] voltageMagnitudes, double[] voltagePhasesRad, double[] voltageMagWeights, double[] voltagePhaseWeights) {
        this.numberOfFrequencies = frequencies.length;
        if (this.numberOfFrequencies != voltageMagnitudes.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitudes, " + voltageMagnitudes.length);
        }
        if (this.numberOfFrequencies != voltagePhasesRad.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phases, " + voltagePhasesRad.length);
        }
        if (this.numberOfFrequencies != voltageMagWeights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitude weights, " + voltageMagWeights.length);
        }
        if (this.numberOfFrequencies != voltagePhaseWeights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phase weights, " + voltagePhaseWeights.length);
        }
        this.frequencies = Conv.copy(frequencies);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.voltageMagnitudes = Conv.copy(voltageMagnitudes);
        this.voltageMagnitudeWeights = Conv.copy(voltageMagWeights);
        this.voltagePhaseWeightsRad = Conv.copy(voltagePhaseWeights);
        this.voltages = Complex.oneDarray(this.numberOfFrequencies);
        this.voltagePhasesDeg = new double[this.numberOfFrequencies];
        this.realV = new double[this.numberOfFrequencies];
        this.imagV = new double[this.numberOfFrequencies];
        this.realVweights = new double[this.numberOfFrequencies];
        this.imagVweights = new double[this.numberOfFrequencies];
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.voltagePhasesDeg[i] = Math.toDegrees(this.voltagePhasesRad[i]);
            this.voltages[i].polar(voltageMagnitudes[i], voltagePhasesRad[i]);
            this.realV[i] = this.voltages[i].getReal();
            this.imagV[i] = this.voltages[i].getImag();
            ErrorProp mag = new ErrorProp(voltageMagnitudes[i], this.voltageMagnitudeWeights[i]);
            ErrorProp phase = new ErrorProp(voltagePhasesRad[i], voltagePhaseWeights[i]);
            ComplexErrorProp volt = new ComplexErrorProp();
            volt.polar(mag, phase);
            this.realVweights[i] = volt.getRealError();
            this.imagVweights[i] = volt.getImagError();
        }
        this.frequenciesSet = true;
        this.setImpedanceArrayLengths();
        this.calculateExperimentalImpedances();
        this.voltageOrImpedance = true;
        this.dataEnteredTypePointer = 2;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void voltageDataAsPhasorDeg(double[] frequencies, double[] voltageMagnitudes, double[] voltagePhasesRad) {
        double[] voltageMagWeights = new double[frequencies.length];
        double[] voltagePhaseWeights = new double[frequencies.length];
        this.weightsSet = false;
        this.voltageDataAsPhasorDeg(frequencies, voltageMagnitudes, voltagePhasesRad, voltageMagWeights, voltagePhaseWeights);
    }

    public void voltageDataAsPhasorDeg(double[] frequencies, double[] voltageMagnitudes, double[] voltagePhasesDeg, double[] voltageMagWeights, double[] voltagePhaseWeights) {
        this.numberOfFrequencies = frequencies.length;
        if (this.numberOfFrequencies != voltageMagnitudes.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitudes, " + voltageMagnitudes.length);
        }
        if (this.numberOfFrequencies != voltagePhasesDeg.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phases, " + voltagePhasesDeg.length);
        }
        if (this.numberOfFrequencies != voltageMagWeights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitude weights, " + voltageMagWeights.length);
        }
        if (this.numberOfFrequencies != voltagePhaseWeights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phase weights, " + voltagePhaseWeights.length);
        }
        this.frequencies = Conv.copy(frequencies);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.voltageMagnitudes = Conv.copy(voltageMagnitudes);
        this.voltagePhasesDeg = Conv.copy(voltagePhasesDeg);
        this.voltages = Complex.oneDarray(this.numberOfFrequencies);
        this.voltagePhasesRad = new double[this.numberOfFrequencies];
        this.voltagePhaseWeightsRad = new double[this.numberOfFrequencies];
        this.voltageMagnitudeWeights = Conv.copy(voltageMagWeights);
        this.voltagePhaseWeightsDeg = Conv.copy(voltagePhaseWeights);
        this.realV = new double[this.numberOfFrequencies];
        this.imagV = new double[this.numberOfFrequencies];
        this.realVweights = new double[this.numberOfFrequencies];
        this.imagVweights = new double[this.numberOfFrequencies];
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.voltagePhasesRad[i] = Math.toRadians(this.voltagePhasesDeg[i]);
            this.voltagePhaseWeightsRad[i] = Math.toRadians(voltagePhaseWeights[i]);
            this.voltages[i].polar(voltageMagnitudes[i], this.voltagePhasesRad[i]);
            this.realV[i] = this.voltages[i].getReal();
            this.imagV[i] = this.voltages[i].getImag();
            ErrorProp mag = new ErrorProp(voltageMagnitudes[i], this.voltageMagnitudeWeights[i]);
            ErrorProp phase = new ErrorProp(this.voltagePhasesRad[i], this.voltagePhaseWeightsRad[i]);
            ComplexErrorProp volt = new ComplexErrorProp();
            volt.polar(mag, phase);
            this.realVweights[i] = volt.getRealError();
            this.imagVweights[i] = volt.getImagError();
        }
        this.frequenciesSet = true;
        this.setImpedanceArrayLengths();
        this.calculateExperimentalImpedances();
        this.voltageOrImpedance = true;
        this.dataEnteredTypePointer = 3;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void impedanceDataAsComplex(double[] frequencies, double[] real, double[] imag) {
        double[] realWeight = new double[frequencies.length];
        double[] imagWeight = new double[frequencies.length];
        this.weightsSet = false;
        this.impedanceDataAsComplex(frequencies, real, imag, realWeight, imagWeight);
    }

    public void impedanceDataAsComplex(double[] frequencies, double[] real, double[] imag, double[] realWeight, double[] imagWeight) {
        this.numberOfFrequencies = frequencies.length;
        if (this.numberOfFrequencies != real.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of Real[impedances], " + real.length);
        }
        if (this.numberOfFrequencies != imag.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of Imag[impedances], " + imag.length);
        }
        if (this.numberOfFrequencies != realWeight.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of real weights, " + realWeight.length);
        }
        if (this.numberOfFrequencies != imagWeight.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of imag weights, " + imagWeight.length);
        }
        this.frequencies = Conv.copy(frequencies);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.realZ = Conv.copy(real);
        this.imagZ = Conv.copy(imag);
        this.realZweights = Conv.copy(realWeight);
        this.imagZweights = Conv.copy(imagWeight);
        this.impedanceMagnitudes = new double[this.numberOfFrequencies];
        this.impedancePhasesDeg = new double[this.numberOfFrequencies];
        this.impedancePhasesRad = new double[this.numberOfFrequencies];
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.impedances[i] = new Complex(this.realZ[i], this.imagZ[i]);
            this.impedanceMagnitudes[i] = this.impedances[i].abs();
            this.impedancePhasesRad[i] = this.impedances[i].arg();
            this.impedancePhasesDeg[i] = Math.toDegrees(this.impedancePhasesRad[i]);
        }
        this.frequenciesSet = true;
        this.impedancesSet = true;
        this.dataEnteredTypePointer = 4;
        this.voltageOrImpedance = false;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void impedanceDataAsComplex(double[] frequencies, Complex[] impedances) {
        Complex[] weights = Complex.oneDarray(impedances.length, 0.0, 0.0);
        this.weightsSet = false;
        this.impedanceDataAsComplex(frequencies, impedances, weights);
    }

    public void impedanceDataAsComplex(double[] frequencies, Complex[] impedances, Complex[] weights) {
        this.numberOfFrequencies = frequencies.length;
        if (this.numberOfFrequencies != impedances.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of impedances, " + impedances.length);
        }
        if (this.numberOfFrequencies != weights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of weights, " + weights.length);
        }
        this.frequencies = Conv.copy(frequencies);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.impedances = Complex.copy(impedances);
        this.impedanceWeights = Complex.copy(weights);
        this.impedanceMagnitudes = new double[this.numberOfFrequencies];
        this.impedancePhasesDeg = new double[this.numberOfFrequencies];
        this.impedancePhasesRad = new double[this.numberOfFrequencies];
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.realZweights = new double[this.numberOfFrequencies];
        this.imagZweights = new double[this.numberOfFrequencies];
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.realZ[i] = this.impedances[i].getReal();
            this.imagZ[i] = this.impedances[i].getImag();
            this.realZweights[i] = weights[i].getReal();
            this.imagZweights[i] = weights[i].getImag();
            this.impedanceMagnitudes[i] = this.impedances[i].abs();
            this.impedancePhasesRad[i] = this.impedances[i].arg();
            this.impedancePhasesDeg[i] = Math.toDegrees(this.impedancePhasesRad[i]);
        }
        this.frequenciesSet = true;
        this.impedancesSet = true;
        this.voltageOrImpedance = false;
        this.dataEnteredTypePointer = 5;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void impedanceDataAsPhasorRad(double[] frequencies, double[] impedanceMagnitudes, double[] impedancePhasesRad) {
        double[] impedanceMagWeights = new double[frequencies.length];
        double[] impedancePhaseWeights = new double[frequencies.length];
        this.weightsSet = false;
        this.impedanceDataAsPhasorRad(frequencies, impedanceMagnitudes, impedancePhasesRad, impedanceMagWeights, impedancePhaseWeights);
    }

    public void impedanceDataAsPhasorRad(double[] frequencies, double[] impedanceMagnitudes, double[] impedancePhasesRad, double[] impedanceMagWeights, double[] impedancePhaseWeights) {
        this.numberOfFrequencies = frequencies.length;
        if (this.numberOfFrequencies != impedanceMagnitudes.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitudes, " + impedanceMagnitudes.length);
        }
        if (this.numberOfFrequencies != impedancePhasesRad.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phases, " + impedancePhasesRad.length);
        }
        if (this.numberOfFrequencies != impedanceMagWeights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitude weights, " + impedanceMagWeights.length);
        }
        if (this.numberOfFrequencies != impedancePhaseWeights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phase weights, " + impedancePhaseWeights.length);
        }
        this.frequencies = Conv.copy(frequencies);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.impedanceMagnitudes = Conv.copy(impedanceMagnitudes);
        this.impedanceMagnitudeWeights = Conv.copy(impedanceMagWeights);
        this.impedancePhaseWeightsRad = Conv.copy(impedancePhaseWeights);
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        this.impedancePhasesDeg = new double[this.numberOfFrequencies];
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.realZweights = new double[this.numberOfFrequencies];
        this.imagZweights = new double[this.numberOfFrequencies];
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.impedancePhasesDeg[i] = Math.toDegrees(this.impedancePhasesRad[i]);
            this.impedances[i].polar(impedanceMagnitudes[i], impedancePhasesRad[i]);
            this.realZ[i] = this.impedances[i].getReal();
            this.imagZ[i] = this.impedances[i].getImag();
            ErrorProp mag = new ErrorProp(impedanceMagnitudes[i], this.impedanceMagnitudeWeights[i]);
            ErrorProp phase = new ErrorProp(impedancePhasesRad[i], impedancePhaseWeights[i]);
            ComplexErrorProp volt = new ComplexErrorProp();
            volt.polar(mag, phase);
            this.realZweights[i] = volt.getRealError();
            this.imagZweights[i] = volt.getImagError();
        }
        this.frequenciesSet = true;
        this.impedancesSet = true;
        this.voltageOrImpedance = false;
        this.dataEnteredTypePointer = 6;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    public void impedanceDataAsPhasorDeg(double[] frequencies, double[] impedanceMagnitudes, double[] impedancePhasesRad) {
        double[] impedanceMagWeights = new double[frequencies.length];
        double[] impedancePhaseWeights = new double[frequencies.length];
        this.weightsSet = false;
        this.impedanceDataAsPhasorDeg(frequencies, impedanceMagnitudes, impedancePhasesRad, impedanceMagWeights, impedancePhaseWeights);
    }

    public void impedanceDataAsPhasorDeg(double[] frequencies, double[] impedanceMagnitudes, double[] impedancePhasesDeg, double[] impedanceMagWeights, double[] impedancePhaseWeights) {
        this.numberOfFrequencies = frequencies.length;
        if (this.numberOfFrequencies != impedanceMagnitudes.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitudes, " + impedanceMagnitudes.length);
        }
        if (this.numberOfFrequencies != impedancePhasesDeg.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phases, " + impedancePhasesDeg.length);
        }
        if (this.numberOfFrequencies != impedanceMagWeights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of magnitude weights, " + impedanceMagWeights.length);
        }
        if (this.numberOfFrequencies != impedancePhaseWeights.length) {
            throw new IllegalArgumentException("The number of frequencies, " + this.numberOfFrequencies + ", does not equal the number of phase weights, " + impedancePhaseWeights.length);
        }
        this.frequencies = Conv.copy(frequencies);
        this.setAllFrequencyArrays();
        this.setCalculatedArrayLengths();
        this.impedanceMagnitudes = Conv.copy(impedanceMagnitudes);
        this.impedancePhasesDeg = Conv.copy(impedancePhasesDeg);
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        this.impedancePhasesRad = new double[this.numberOfFrequencies];
        this.impedancePhaseWeightsRad = new double[this.numberOfFrequencies];
        this.impedanceMagnitudeWeights = Conv.copy(impedanceMagWeights);
        this.impedancePhaseWeightsDeg = Conv.copy(impedancePhaseWeights);
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.realZweights = new double[this.numberOfFrequencies];
        this.imagZweights = new double[this.numberOfFrequencies];
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.impedancePhasesRad[i] = Math.toRadians(this.impedancePhasesDeg[i]);
            this.impedancePhaseWeightsRad[i] = Math.toRadians(impedancePhaseWeights[i]);
            this.impedances[i].polar(impedanceMagnitudes[i], this.impedancePhasesRad[i]);
            this.realZ[i] = this.impedances[i].getReal();
            this.imagZ[i] = this.impedances[i].getImag();
            ErrorProp mag = new ErrorProp(impedanceMagnitudes[i], this.impedanceMagnitudeWeights[i]);
            ErrorProp phase = new ErrorProp(this.impedancePhasesRad[i], this.impedancePhaseWeightsRad[i]);
            ComplexErrorProp volt = new ComplexErrorProp();
            volt.polar(mag, phase);
            this.realZweights[i] = volt.getRealError();
            this.imagZweights[i] = volt.getImagError();
        }
        this.frequenciesSet = true;
        this.impedancesSet = true;
        this.voltageOrImpedance = false;
        this.dataEnteredTypePointer = 7;
        if (this.estimatesNeeded) {
            this.setInitialEstimates();
        }
    }

    private void setAllFrequencyArrays() {
        this.log10frequencies = new double[this.numberOfFrequencies];
        this.omegas = new double[this.numberOfFrequencies];
        this.log10omegas = new double[this.numberOfFrequencies];
        for (int i = 0; i < this.numberOfFrequencies; ++i) {
            this.log10frequencies[i] = Math.log10(this.frequencies[i]);
            this.omegas[i] = Math.PI * 2 * this.frequencies[i];
            this.log10omegas[i] = Math.log10(this.omegas[i]);
        }
        this.frequenciesSet = true;
    }

    private void setCalculatedArrayLengths() {
        this.realZresiduals = new double[this.numberOfFrequencies];
        this.imagZresiduals = new double[this.numberOfFrequencies];
        this.calculatedRealZ = new double[this.numberOfFrequencies];
        this.calculatedImagZ = new double[this.numberOfFrequencies];
        this.calculatedImpedances = Complex.oneDarray(this.numberOfFrequencies);
        this.calculatedImpedanceMagnitudes = new double[this.numberOfFrequencies];
        this.calculatedImpedancePhasesRad = new double[this.numberOfFrequencies];
        this.calculatedImpedancePhasesDeg = new double[this.numberOfFrequencies];
        if (this.appliedVoltageSet && this.referenceSet) {
            this.calculatedRealV = new double[this.numberOfFrequencies];
            this.calculatedImagV = new double[this.numberOfFrequencies];
            this.calculatedVoltages = Complex.oneDarray(this.numberOfFrequencies);
            this.calculatedVoltageMagnitudes = new double[this.numberOfFrequencies];
            this.calculatedVoltagePhasesRad = new double[this.numberOfFrequencies];
            this.calculatedVoltagePhasesDeg = new double[this.numberOfFrequencies];
        }
    }

    private void setImpedanceArrayLengths() {
        this.realZ = new double[this.numberOfFrequencies];
        this.imagZ = new double[this.numberOfFrequencies];
        this.realZweights = new double[this.numberOfFrequencies];
        this.imagZweights = new double[this.numberOfFrequencies];
        this.impedances = Complex.oneDarray(this.numberOfFrequencies);
        this.impedanceMagnitudes = new double[this.numberOfFrequencies];
        this.impedancePhasesRad = new double[this.numberOfFrequencies];
        this.impedancePhasesDeg = new double[this.numberOfFrequencies];
    }

    private void calculateExperimentalImpedances() {
        if (this.referenceSet && this.appliedVoltageSet) {
            for (int i = 0; i < this.numberOfFrequencies; ++i) {
                this.impedances[i] = this.referenceImpedance.times(this.voltages[i]).over(this.appliedVoltage.minus(this.voltages[i]));
                this.realZ[i] = this.impedances[i].getReal();
                this.imagZ[i] = this.impedances[i].getImag();
                this.impedanceMagnitudes[i] = this.impedances[i].abs();
                this.impedancePhasesRad[i] = this.impedances[i].arg();
                this.impedancePhasesDeg[i] = Math.toDegrees(this.impedancePhasesRad[i]);
                if (this.weightsSet && this.voltageErrorSet) {
                    ComplexErrorProp appliedV = new ComplexErrorProp(this.appliedVoltage.getReal(), this.appliedVoltageError.getReal(), this.appliedVoltage.getImag(), this.appliedVoltageError.getImag());
                    ComplexErrorProp expertlV = new ComplexErrorProp(this.realV[i], this.realVweights[i], this.imagV[i], this.imagVweights[i]);
                    ComplexErrorProp refImped = new ComplexErrorProp(this.referenceImpedance.getReal(), 0.0, this.referenceImpedance.getImag(), 0.0);
                    ComplexErrorProp eVoverAv = expertlV.over(appliedV).times(refImped);
                    this.realZweights[i] = eVoverAv.getRealError();
                    this.imagZweights[i] = eVoverAv.getImagError();
                }
                this.impedancesSet = true;
            }
        }
    }

    public void setModel(ImpedSpecModel userModel, String[] symbols, double[] initialEstimates, double[] initialSteps) {
        this.userModel = userModel;
        this.parameterSymbols = symbols;
        this.numberOfParameters = symbols.length;
        if (this.numberOfParameters != initialEstimates.length) {
            throw new IllegalArgumentException("The number of parameter symbols, " + this.numberOfParameters + ", does not equal the number of initial estimates, " + initialEstimates.length);
        }
        if (this.numberOfParameters != initialSteps.length) {
            throw new IllegalArgumentException("The number of parameter symbols, " + this.numberOfParameters + ", does not equal the number of initial steps, " + initialSteps.length);
        }
        this.initialEstimates = initialEstimates;
        this.initialSteps = initialSteps;
        this.setEstimateArrayDimensions();
        this.estimatesSet = true;
        this.userModelSet = true;
    }

    public void setModel(ImpedSpecModel userModel, String[] symbols, double[] initialEstimates) {
        this.userModel = userModel;
        this.parameterSymbols = symbols;
        this.numberOfParameters = symbols.length;
        if (this.numberOfParameters != initialEstimates.length) {
            throw new IllegalArgumentException("The number of parameter symbols, " + this.numberOfParameters + ", does not equal the number of initial estimates, " + initialEstimates.length);
        }
        this.initialEstimates = initialEstimates;
        this.initialSteps = new double[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            this.initialSteps[i] = Math.abs(this.initialEstimates[i]) * 0.1;
        }
        this.setEstimateArrayDimensions();
        this.estimatesSet = true;
        this.userModelSet = true;
    }

    public void setModel(int modelNumber, double[] initialEstimates, double[] initialSteps) {
        this.numberOfParameters = initialEstimates.length;
        if (this.numberOfParameters != Impedance.modelComponents(modelNumber).length) {
            throw new IllegalArgumentException("The number of parameter estimates, " + this.numberOfParameters + ", does not equal the number of parameters, " + Impedance.modelComponents(modelNumber).length + ", in model number " + modelNumber);
        }
        if (this.numberOfParameters != initialSteps.length) {
            throw new IllegalArgumentException("The number of parameter estimates, " + this.numberOfParameters + ", does not equal the number of parameter steps, " + initialSteps.length);
        }
        this.modelNumber = modelNumber;
        this.initialEstimates = initialEstimates;
        this.initialSteps = initialSteps;
        this.parameterSymbols = Impedance.modelComponents(modelNumber);
        this.setEstimateArrayDimensions();
        this.estimatesSet = true;
        this.modelSet = true;
    }

    public void setModel(int modelNumber, double[] initialEstimates) {
        this.numberOfParameters = initialEstimates.length;
        if (this.numberOfParameters != Impedance.modelComponents(modelNumber).length) {
            throw new IllegalArgumentException("The number of parameter estimates, " + this.numberOfParameters + ", does not equal the number of parameters, " + Impedance.modelComponents(modelNumber).length + ", in model number " + modelNumber);
        }
        this.modelNumber = modelNumber;
        this.initialEstimates = initialEstimates;
        this.parameterSymbols = Impedance.modelComponents(modelNumber);
        this.initialSteps = new double[this.numberOfParameters];
        for (int i = 0; i < this.numberOfParameters; ++i) {
            this.initialSteps[i] = Math.abs(this.initialEstimates[i]) * 0.1;
        }
        this.setEstimateArrayDimensions();
        this.estimatesSet = true;
        this.modelSet = true;
    }

    public void setModel(int modelNumber) {
        this.modelNumber = modelNumber;
        this.parameterSymbols = Impedance.modelComponents(modelNumber);
        this.numberOfParameters = this.parameterSymbols.length;
        this.setEstimateArrayDimensions();
        this.setInitialEstimates();
        this.estimatesSet = true;
        this.modelSet = true;
    }

    private void setEstimateArrayDimensions() {
        this.bestEstimates = new double[this.numberOfParameters];
        this.standardDeviations = new double[this.numberOfParameters];
        this.coefficientsOfVariation = new double[this.numberOfParameters];
        this.preMinimumGradients = new double[this.numberOfParameters];
        this.postMinimumGradients = new double[this.numberOfParameters];
        this.correlationCoefficients = new double[this.numberOfParameters][this.numberOfParameters];
    }

    private void setInitialEstimates() {
        if (this.impedancesSet && this.frequenciesSet) {
            int i;
            this.degreesOfFreedom = this.numberOfFrequencies - this.numberOfParameters;
            if (this.degreesOfFreedom <= 0) {
                throw new IllegalArgumentException("Degrees of freedom, " + this.degreesOfFreedom + ", are less than 1");
            }
            double meanRealZ = Stat.mean(this.realZ);
            double minRealZ = Fmath.minimum(this.realZ);
            int indexMinRealZ = Fmath.indexOf(this.realZ, minRealZ);
            double maxRealZ = Fmath.maximum(this.realZ);
            int indexMaxRealZ = Fmath.indexOf(this.realZ, maxRealZ);
            double meanImagZ = Stat.mean(this.imagZ);
            double minImagZ = Fmath.minimum(this.imagZ);
            int indexMinImagZ = Fmath.indexOf(this.imagZ, minImagZ);
            double maxImagZ = Fmath.maximum(this.imagZ);
            int indexMaxImagZ = Fmath.indexOf(this.imagZ, maxImagZ);
            double imagBig = Math.max(Math.abs(minImagZ), Math.abs(maxImagZ));
            int bigIndex = Fmath.indexOf(this.imagZ, imagBig);
            if (bigIndex == -1) {
                bigIndex = Fmath.indexOf(this.imagZ, -imagBig);
            }
            if (bigIndex == -1) {
                bigIndex = this.numberOfFrequencies / 2;
            }
            double geometricFreqMean = Stat.geometricMean(this.log10frequencies);
            switch (this.modelNumber) {
                case 1: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = meanRealZ;
                    break;
                }
                case 2: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double sumC = 0.0;
                    for (int i2 = 0; i2 < this.numberOfFrequencies; ++i2) {
                        sumC += 1.0 / Math.abs(this.imagZ[i2] * this.omegas[i2]);
                    }
                    this.initialEstimates[0] = sumC / (double)this.numberOfFrequencies;
                    break;
                }
                case 3: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double sumL = 0.0;
                    for (int i3 = 0; i3 < this.numberOfFrequencies; ++i3) {
                        sumL += Math.abs(this.imagZ[i3] / this.omegas[i3]);
                    }
                    this.initialEstimates[0] = sumL / (double)this.numberOfFrequencies;
                    break;
                }
                case 4: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double sumW = 0.0;
                    for (int i4 = 0; i4 < this.numberOfFrequencies; ++i4) {
                        sumW += Math.abs(this.realZ[i4] * Math.sqrt(this.omegas[i4]));
                        sumW += Math.abs(this.imagZ[i4] * Math.sqrt(this.omegas[i4]));
                    }
                    this.initialEstimates[0] = sumW / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 5: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double sumF = 0.0;
                    for (int i5 = 0; i5 < this.numberOfFrequencies; ++i5) {
                        sumF += Math.abs(this.realZ[i5] * Math.sqrt(this.omegas[i5]));
                        sumF += Math.abs(this.imagZ[i5] * Math.sqrt(this.omegas[i5]));
                    }
                    this.initialEstimates[0] = sumF / (2.0 * (double)this.numberOfFrequencies);
                    this.initialEstimates[1] = Math.abs(meanRealZ / this.initialEstimates[0]);
                    break;
                }
                case 6: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double sumQ = 0.0;
                    for (int i6 = 0; i6 < this.numberOfFrequencies; ++i6) {
                        sumQ += this.imagZ[i6] / this.realZ[i6];
                    }
                    double theta = Math.abs(Math.atan(sumQ /= (double)this.numberOfFrequencies));
                    double cosTheta = Math.cos(theta);
                    double sinTheta = Math.sin(theta);
                    this.initialEstimates[1] = theta / 1.5707963267948966;
                    double sigmaQ = 0.0;
                    for (int i7 = 0; i7 < this.numberOfFrequencies; ++i7) {
                        sigmaQ += Math.abs(this.realZ[i7] / (cosTheta * Math.pow(this.omegas[i7], this.initialEstimates[1])));
                        sigmaQ += Math.abs(this.imagZ[i7] / (sinTheta * Math.pow(this.omegas[i7], this.initialEstimates[1])));
                    }
                    this.initialEstimates[0] = sigmaQ / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 7: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = meanRealZ;
                    double sumC7 = 0.0;
                    for (int i8 = 0; i8 < this.numberOfFrequencies; ++i8) {
                        sumC7 += 1.0 / Math.abs(this.imagZ[i8] * this.omegas[i8]);
                    }
                    this.initialEstimates[1] = sumC7 / (double)this.numberOfFrequencies;
                    break;
                }
                case 8: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = meanRealZ;
                    double sumL8 = 0.0;
                    for (int i9 = 0; i9 < this.numberOfFrequencies; ++i9) {
                        sumL8 += Math.abs(this.imagZ[i9] / this.omegas[i9]);
                    }
                    this.initialEstimates[1] = sumL8 / (double)this.numberOfFrequencies;
                    break;
                }
                case 9: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double sumL9 = 0.0;
                    double sumC9 = 0.0;
                    for (int i10 = 1; i10 < this.numberOfFrequencies; ++i10) {
                        double cC9 = (this.frequencies[i10] - this.frequencies[i10 - 1]) / this.frequencies[i10] / (this.imagZ[i10] * this.frequencies[i10 - 1] - this.imagZ[i10 - 1] * this.frequencies[i10]);
                        double lL9 = (this.imagZ[i10] + 1.0 / (cC9 * this.frequencies[i10])) / this.frequencies[i10];
                        sumL9 += lL9;
                        sumC9 += cC9;
                    }
                    this.initialEstimates[0] = sumL9 / (double)(this.numberOfFrequencies - 1);
                    this.initialEstimates[1] = sumC9 / (double)(this.numberOfFrequencies - 1);
                    break;
                }
                case 10: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = maxRealZ;
                    this.initialEstimates[1] = 1.0 / (maxRealZ * this.frequencies[indexMinImagZ]);
                    break;
                }
                case 11: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = maxRealZ;
                    this.initialEstimates[1] = maxRealZ / this.frequencies[indexMaxImagZ];
                    break;
                }
                case 12: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    double cL12 = 1.0 / this.frequencies[indexMinImagZ];
                    double sumL12 = 0.0;
                    double sumC12 = 0.0;
                    for (int i11 = 1; i11 < this.numberOfFrequencies; ++i11) {
                        double c12 = this.imagZ[i11] * (this.frequencies[i11] * cL12 - 1.0 / this.frequencies[i11]);
                        sumL12 += c12;
                        sumC12 += cL12 / c12;
                    }
                    this.initialEstimates[0] = sumL12 / (double)this.numberOfFrequencies;
                    this.initialEstimates[1] = sumC12 / (double)this.numberOfFrequencies;
                    break;
                }
                case 13: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[2] = minRealZ;
                    this.initialEstimates[0] = maxRealZ - minRealZ;
                    this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                    break;
                }
                case 14: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[2] = minRealZ;
                    this.initialEstimates[0] = maxRealZ - minRealZ;
                    double sumL14 = 0.0;
                    double sumC14 = 0.0;
                    for (int i12 = 1; i12 < this.numberOfFrequencies; ++i12) {
                        double cC14 = (this.frequencies[i12] - this.frequencies[i12 - 1]) / this.frequencies[i12] / (this.imagZ[i12] * this.frequencies[i12 - 1] - this.imagZ[i12 - 1] * this.frequencies[i12]);
                        double lL14 = (this.imagZ[i12] + 1.0 / (cC14 * this.frequencies[i12])) / this.frequencies[i12];
                        sumL14 += lL14;
                        sumC14 += cC14;
                    }
                    this.initialEstimates[3] = sumL14 / (double)(this.numberOfFrequencies - 1);
                    this.initialEstimates[1] = sumC14 / (double)(this.numberOfFrequencies - 1);
                    break;
                }
                case 15: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[2] = minRealZ;
                    this.initialEstimates[0] = maxRealZ - minRealZ;
                    double cL15 = 1.0 / this.frequencies[indexMinImagZ];
                    double sumL15 = 0.0;
                    double sumC15 = 0.0;
                    for (int i13 = 1; i13 < this.numberOfFrequencies; ++i13) {
                        double c15 = this.imagZ[i13] * (this.frequencies[i13] * cL15 - 1.0 / this.frequencies[i13]);
                        sumL15 += c15;
                        sumC15 += cL15 / c15;
                    }
                    this.initialEstimates[3] = sumL15 / (double)this.numberOfFrequencies;
                    this.initialEstimates[1] = sumC15 / (double)this.numberOfFrequencies;
                    break;
                }
                case 16: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = maxRealZ;
                    double sumC16 = 0.0;
                    for (int i14 = 0; i14 < this.numberOfFrequencies; ++i14) {
                        sumC16 += 1.0 / Math.abs(this.imagZ[i14] * this.omegas[i14]);
                    }
                    this.initialEstimates[1] = 2.0 * sumC16 / (double)this.numberOfFrequencies;
                    this.initialEstimates[2] = this.initialEstimates[1];
                    break;
                }
                case 17: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = maxRealZ;
                    double sumC17 = 0.0;
                    for (int i15 = 0; i15 < this.numberOfFrequencies; ++i15) {
                        sumC17 += 1.0 / Math.abs(this.imagZ[i15] * this.omegas[i15]);
                    }
                    this.initialEstimates[1] = sumC17 / (2.0 * (double)this.numberOfFrequencies);
                    this.initialEstimates[2] = this.initialEstimates[1];
                }
                case 18: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = minRealZ;
                    this.initialEstimates[2] = maxRealZ - minRealZ;
                    double sumC18 = 0.0;
                    for (int i16 = 0; i16 < this.numberOfFrequencies; ++i16) {
                        sumC18 += 1.0 / Math.abs(this.imagZ[i16] * this.omegas[i16]);
                    }
                    this.initialEstimates[1] = 2.0 * sumC18 / (double)this.numberOfFrequencies;
                    this.initialEstimates[3] = this.initialEstimates[1];
                    break;
                }
                case 19: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = maxRealZ / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    this.initialEstimates[1] = 2.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    break;
                }
                case 20: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[4] = minRealZ;
                    this.initialEstimates[0] = (maxRealZ - minRealZ) / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    this.initialEstimates[1] = 2.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    break;
                }
                case 21: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[4] = minRealZ;
                    this.initialEstimates[0] = (maxRealZ - minRealZ) / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    double sumC21 = 0.0;
                    for (int i17 = 0; i17 < this.numberOfFrequencies; ++i17) {
                        sumC21 += 1.0 / Math.abs(this.imagZ[i17] * this.omegas[i17]);
                    }
                    this.initialEstimates[1] = sumC21 / (2.0 * (double)this.numberOfFrequencies);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    break;
                }
                case 22: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = maxRealZ / 3.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    this.initialEstimates[4] = this.initialEstimates[0];
                    this.initialEstimates[1] = 3.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    this.initialEstimates[5] = this.initialEstimates[1];
                    break;
                }
                case 23: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[6] = minRealZ;
                    this.initialEstimates[0] = (maxRealZ - minRealZ) / 3.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    this.initialEstimates[4] = this.initialEstimates[0];
                    this.initialEstimates[1] = 3.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    this.initialEstimates[5] = this.initialEstimates[1];
                    break;
                }
                case 24: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[3] = minRealZ;
                    this.initialEstimates[0] = maxRealZ - minRealZ;
                    double sumW24 = 0.0;
                    if (indexMinImagZ < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                        for (int i18 = indexMinImagZ; i18 < this.numberOfFrequencies; ++i18) {
                            sumW24 += Math.abs(this.realZ[i18] * Math.sqrt(this.omegas[i18]));
                            sumW24 += Math.abs(this.imagZ[i18] * Math.sqrt(this.omegas[i18]));
                        }
                        this.initialEstimates[2] = sumW24 / (2.0 * (double)(this.numberOfFrequencies - indexMinImagZ));
                        break;
                    }
                    this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * geometricFreqMean);
                    for (int i19 = 0; i19 < this.numberOfFrequencies; ++i19) {
                        sumW24 += Math.abs(this.realZ[i19] * Math.sqrt(this.omegas[i19]));
                        sumW24 += Math.abs(this.imagZ[i19] * Math.sqrt(this.omegas[i19]));
                    }
                    this.initialEstimates[2] = sumW24 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 25: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[4] = minRealZ;
                    this.initialEstimates[0] = maxRealZ - minRealZ;
                    double sumF25 = 0.0;
                    if (indexMinImagZ < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                        for (int i20 = indexMinImagZ; i20 < this.numberOfFrequencies; ++i20) {
                            sumF25 += Math.abs(this.realZ[i20] * Math.sqrt(this.omegas[i20]));
                            sumF25 += Math.abs(this.imagZ[i20] * Math.sqrt(this.omegas[i20]));
                        }
                        this.initialEstimates[2] = sumF25 / (2.0 * (double)(this.numberOfFrequencies - indexMinImagZ));
                        this.initialEstimates[3] = Math.abs(meanRealZ / this.initialEstimates[2]);
                        break;
                    }
                    this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * geometricFreqMean);
                    for (int i21 = 0; i21 < this.numberOfFrequencies; ++i21) {
                        sumF25 += Math.abs(this.realZ[i21] * Math.sqrt(this.omegas[i21]));
                        sumF25 += Math.abs(this.imagZ[i21] * Math.sqrt(this.omegas[i21]));
                    }
                    this.initialEstimates[2] = sumF25 / (2.0 * (double)this.numberOfFrequencies);
                    this.initialEstimates[3] = Math.abs(meanRealZ / this.initialEstimates[2]);
                    break;
                }
                case 26: {
                    int i22;
                    double sigmaQ26;
                    double theta26;
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[4] = minRealZ;
                    this.initialEstimates[0] = maxRealZ - minRealZ;
                    double sumQ26 = 0.0;
                    if (indexMinImagZ < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                        for (int i23 = indexMinImagZ; i23 < this.numberOfFrequencies; ++i23) {
                            sumQ26 += this.imagZ[i23] / this.realZ[i23];
                        }
                        theta26 = Math.abs(Math.atan(sumQ26 /= (double)(this.numberOfFrequencies - indexMinImagZ)));
                        double cosTheta26 = Math.cos(theta26);
                        double sinTheta26 = Math.sin(theta26);
                        this.initialEstimates[3] = theta26 / 1.5707963267948966;
                        sigmaQ26 = 0.0;
                        for (i22 = indexMinImagZ; i22 < this.numberOfFrequencies; ++i22) {
                            sigmaQ26 += Math.abs(this.realZ[i22] / (cosTheta26 * Math.pow(this.omegas[i22], this.initialEstimates[1])));
                            sigmaQ26 += Math.abs(this.imagZ[i22] / (sinTheta26 * Math.pow(this.omegas[i22], this.initialEstimates[1])));
                        }
                        this.initialEstimates[2] = sigmaQ26 / (2.0 * (double)(this.numberOfFrequencies - indexMinImagZ));
                        break;
                    }
                    this.initialEstimates[1] = 1.0 / (this.initialEstimates[0] * geometricFreqMean);
                    for (int i24 = 0; i24 < this.numberOfFrequencies; ++i24) {
                        sumQ26 += this.imagZ[i24] / this.realZ[i24];
                    }
                    theta26 = Math.abs(Math.atan(sumQ26 /= (double)this.numberOfFrequencies));
                    double cosTheta26 = Math.cos(theta26);
                    double sinTheta26 = Math.sin(theta26);
                    this.initialEstimates[3] = theta26 / 1.5707963267948966;
                    sigmaQ26 = 0.0;
                    for (i22 = 0; i22 < this.numberOfFrequencies; ++i22) {
                        sigmaQ26 += Math.abs(this.realZ[i22] / (cosTheta26 * Math.pow(this.omegas[i22], this.initialEstimates[1])));
                        sigmaQ26 += Math.abs(this.imagZ[i22] / (sinTheta26 * Math.pow(this.omegas[i22], this.initialEstimates[1])));
                    }
                    this.initialEstimates[2] = sigmaQ26 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 27: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[0] = maxRealZ / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    double sumW27 = 0.0;
                    if (indexMinImagZ < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 2.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                        this.initialEstimates[3] = this.initialEstimates[1];
                        for (int i25 = indexMinImagZ; i25 < this.numberOfFrequencies; ++i25) {
                            sumW27 += Math.abs(this.realZ[i25] * Math.sqrt(this.omegas[i25]));
                            sumW27 += Math.abs(this.imagZ[i25] * Math.sqrt(this.omegas[i25]));
                        }
                        this.initialEstimates[4] = sumW27 / (2.0 * (double)(this.numberOfFrequencies - indexMinImagZ));
                        break;
                    }
                    this.initialEstimates[1] = 2.0 / (this.initialEstimates[0] * geometricFreqMean);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    for (int i26 = indexMinImagZ; i26 < this.numberOfFrequencies; ++i26) {
                        sumW27 += Math.abs(this.realZ[i26] * Math.sqrt(this.omegas[i26]));
                        sumW27 += Math.abs(this.imagZ[i26] * Math.sqrt(this.omegas[i26]));
                    }
                    this.initialEstimates[4] = sumW27 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                case 28: {
                    this.initialEstimates = new double[this.numberOfParameters];
                    this.initialEstimates[6] = minRealZ;
                    this.initialEstimates[0] = (maxRealZ - minRealZ) / 2.0;
                    this.initialEstimates[2] = this.initialEstimates[0];
                    double sumW28 = 0.0;
                    if (indexMinImagZ < this.numberOfFrequencies - 3) {
                        this.initialEstimates[1] = 3.0 / (this.initialEstimates[0] * this.frequencies[indexMinImagZ]);
                        this.initialEstimates[3] = this.initialEstimates[1];
                        this.initialEstimates[5] = this.initialEstimates[1];
                        for (int i27 = indexMinImagZ; i27 < this.numberOfFrequencies; ++i27) {
                            sumW28 += Math.abs(this.realZ[i27] * Math.sqrt(this.omegas[i27]));
                            sumW28 += Math.abs(this.imagZ[i27] * Math.sqrt(this.omegas[i27]));
                        }
                        this.initialEstimates[4] = sumW28 / (2.0 * (double)(this.numberOfFrequencies - indexMinImagZ));
                        break;
                    }
                    this.initialEstimates[1] = 3.0 / (this.initialEstimates[0] * geometricFreqMean);
                    this.initialEstimates[3] = this.initialEstimates[1];
                    this.initialEstimates[5] = this.initialEstimates[1];
                    for (int i28 = indexMinImagZ; i28 < this.numberOfFrequencies; ++i28) {
                        sumW28 += Math.abs(this.realZ[i28] * Math.sqrt(this.omegas[i28]));
                        sumW28 += Math.abs(this.imagZ[i28] * Math.sqrt(this.omegas[i28]));
                    }
                    this.initialEstimates[4] = sumW28 / (2.0 * (double)this.numberOfFrequencies);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Automatically calculated initial estimates are only presntly available for models 1 to 28");
                }
            }
            this.initialSteps = new double[this.numberOfParameters];
            for (i = 0; i < this.numberOfParameters; ++i) {
                this.initialSteps[i] = Math.abs(this.initialEstimates[i]) * 0.1;
            }
            for (i = 0; i < this.numberOfParameters; ++i) {
                if (this.initialSteps[i] != 0.0) continue;
                if (this.parameterSymbols[i].trim().substring(0, 1).equals("R")) {
                    this.initialSteps[i] = maxRealZ * 0.01;
                }
                if (this.parameterSymbols[i].trim().substring(0, 1).equals("C")) {
                    this.initialSteps[i] = 0.01 / (imagBig * this.frequencies[bigIndex]);
                }
                if (this.parameterSymbols[i].trim().substring(0, 1).equals("L")) {
                    this.initialSteps[i] = imagBig * 0.01 / this.frequencies[bigIndex];
                }
                if (this.parameterSymbols[i].trim().substring(0, 1).equals("W")) {
                    this.initialSteps[i] = 0.01 / (imagBig * Math.sqrt(this.frequencies[bigIndex]));
                }
                if (this.parameterSymbols[i].trim().substring(0, 2).equals("Fs")) {
                    this.initialSteps[i] = 0.01 / (imagBig * Math.sqrt(this.frequencies[bigIndex]));
                }
                if (this.parameterSymbols[i].trim().substring(0, 2).equals("Fd")) {
                    this.initialSteps[i] = 0.05;
                }
                if (this.parameterSymbols[i].trim().substring(0, 2).equals("Qs")) {
                    this.initialSteps[i] = 0.01 / (imagBig * Math.sqrt(this.frequencies[bigIndex]));
                }
                if (!this.parameterSymbols[i].trim().substring(0, 2).equals("Qa")) continue;
                this.initialSteps[i] = 0.005;
            }
            this.estimatesSet = true;
        } else {
            this.estimatesNeeded = true;
        }
    }

    @Override
    public double[] getInitialEstimates() {
        if (!this.estimatesSet) {
            throw new IllegalArgumentException("No initial estimates have been entered or calculated");
        }
        return this.initialEstimates;
    }

    public String[] getCircuitComponents() {
        return this.parameterSymbols;
    }

    public void addNewConstraint(int parameter, int direction, double boundary) {
        this.constraints.add(new Integer(parameter));
        this.constraints.add(new Integer(direction));
        this.constraints.add(new Double(boundary));
        ++this.numberOfAddedConstraints;
        this.constraintsAdded = true;
    }

    public void addNewConstraint(String parameterSymbol, int direction, double boundary) {
        if (this.numberOfParameters == 0) {
            throw new IllegalArgumentException("No model number or model parameters entered");
        }
        int parameterNumber = -1;
        for (int i = 0; i < this.numberOfParameters; ++i) {
            if (!this.parameterSymbols[i].trim().equals(parameterSymbol.trim())) continue;
            parameterNumber = i;
        }
        if (parameterNumber == -1) {
            throw new IllegalArgumentException("Parameter symbol, " + parameterSymbol + ", not found");
        }
        this.constraints.add(new Integer(parameterNumber));
        this.constraints.add(new Integer(direction));
        this.constraints.add(new Double(boundary));
        ++this.numberOfAddedConstraints;
        this.constraintsAdded = true;
    }

    public void removeDefaultConstraints() {
        this.supressDefaultConstraints = true;
    }

    public void restoreDefaultConstraints() {
        this.supressDefaultConstraints = false;
    }

    public void removeAddedConstraints() {
        this.supressAddedConstraints = true;
        this.constraintsAdded = false;
    }

    public void removeAllConstraints() {
        this.supressDefaultConstraints = true;
        this.supressAddedConstraints = true;
        this.constraintsAdded = false;
    }

    public void resetMaximumNumberOfIterations(int max) {
        this.maximumIterations = max;
    }

    public void resetTolerance(double tol) {
        this.tolerance = tol;
    }

    public ArrayList<Object> getRegressionResultsAsArrayList() {
        if (!this.regressionDone) {
            this.regression();
        }
        return this.results;
    }

    public Vector<Object> getRegressionResultsAsVector() {
        if (!this.regressionDone) {
            this.regression();
        }
        int n = this.results.size();
        Vector<Object> res = new Vector<Object>(n);
        for (int i = 0; i < n; ++i) {
            res.add(this.results.get(i));
        }
        return res;
    }

    public Vector<Object> getRegressionResults() {
        return this.getRegressionResults();
    }

    private void setRegressionArrays() {
        int i;
        this.xRegression = new double[this.numberOfFrequencies];
        this.yRegression = new double[2][this.numberOfFrequencies];
        if (this.weightsSet) {
            this.wRegression = new double[2][this.numberOfFrequencies];
        }
        for (i = 0; i < this.numberOfFrequencies; ++i) {
            this.xRegression[i] = this.omegas[i];
            this.yRegression[0][i] = this.realZ[i];
            this.yRegression[1][i] = this.imagZ[i];
        }
        if (this.weightsSet) {
            for (i = 0; i < this.numberOfFrequencies; ++i) {
                this.wRegression[0][i] = this.realZweights[i];
                this.wRegression[1][i] = this.imagZweights[i];
            }
        }
    }

    public ArrayList<Object> regression() {
        int i;
        int i2;
        RegressionFunction2 function;
        this.degreesOfFreedom = this.numberOfFrequencies - this.numberOfParameters;
        if (this.degreesOfFreedom <= 0) {
            throw new IllegalArgumentException("Degrees of freedom, " + this.degreesOfFreedom + ", are less than 1");
        }
        if (!this.impedancesSet) {
            throw new IllegalArgumentException("No impedances or voltages have been entered");
        }
        if (!this.estimatesSet && !this.userModelSet) {
            this.setInitialEstimates();
        }
        this.setRegressionArrays();
        this.results = new ArrayList();
        this.results.add(new Integer(this.numberOfFrequencies));
        this.results.add(new Integer(this.numberOfParameters));
        this.results.add(new Integer(this.degreesOfFreedom));
        this.results.add(this.parameterSymbols);
        this.results.add(Conv.copy(this.initialEstimates));
        this.results.add(Conv.copy(this.initialSteps));
        if (this.weightsSet) {
            this.enterData(this.xRegression, this.yRegression, this.wRegression);
        } else {
            this.enterData(this.xRegression, this.yRegression);
        }
        if (this.userModelSet) {
            function = new ImpedSpecRegressionFunction2();
            function.numberOfFrequencies = this.numberOfFrequencies;
            function.isModel = this.userModel;
            this.regressionFunction = function;
        } else {
            function = new ImpedSpecRegressionFunction1();
            ((ImpedSpecRegressionFunction1)function).numberOfFrequencies = this.numberOfFrequencies;
            ((ImpedSpecRegressionFunction1)function).modelNumber = this.modelNumber;
            this.regressionFunction = function;
        }
        int[] param = null;
        int[] direct = null;
        double[] bound = null;
        if (this.constraintsAdded) {
            param = new int[this.numberOfAddedConstraints];
            direct = new int[this.numberOfAddedConstraints];
            bound = new double[this.numberOfAddedConstraints];
            int index = 0;
            for (int i3 = 0; i3 < this.numberOfAddedConstraints; ++i3) {
                double boundary;
                int direction;
                int parameter;
                param[i3] = parameter = ((Integer)this.constraints.get(index)).intValue();
                direct[i3] = direction = ((Integer)this.constraints.get(++index)).intValue();
                bound[i3] = boundary = ((Double)this.constraints.get(++index)).doubleValue();
                ++index;
                this.addConstraint(parameter, direction, boundary);
            }
        }
        if (!this.supressDefaultConstraints) {
            for (int i4 = 0; i4 < this.numberOfParameters; ++i4) {
                double lower = 0.0;
                double upper = 1.0;
                if (this.constraintsAdded) {
                    for (int j = 0; j < this.numberOfAddedConstraints; ++j) {
                        if (param[j] != i4) continue;
                        if (direct[j] == 1) {
                            upper = bound[j];
                            continue;
                        }
                        lower = bound[j];
                    }
                }
                this.addConstraint(i4, -1, lower);
                if (!this.parameterSymbols[i4].trim().substring(0, 1).equals("Qa")) continue;
                this.addConstraint(i4, 1, upper);
            }
        }
        this.simplex2(this.regressionFunction, Conv.copy(this.initialEstimates), Conv.copy(this.initialSteps), this.tolerance, this.maximumIterations);
        this.numberOfIterations1 = this.getNiter();
        double[] estimates = this.getCoeff();
        double[] steps = new double[this.numberOfParameters];
        for (int i5 = 0; i5 < this.numberOfParameters; ++i5) {
            steps[i5] = Math.abs(estimates[i5]) * 0.1;
        }
        this.simplex2(this.regressionFunction, estimates, steps, this.tolerance, this.maximumIterations);
        this.bestEstimates = this.getCoeff();
        this.results.add(this.bestEstimates);
        this.standardDeviations = this.getCoeffSd();
        this.results.add(this.standardDeviations);
        this.coefficientsOfVariation = this.getCoeffVar();
        this.results.add(this.coefficientsOfVariation);
        this.correlationCoefficients = this.getCorrCoeffMatrix();
        this.results.add(this.correlationCoefficients);
        double[][] gradients = new double[this.numberOfParameters][2];
        if (this.getGrad() == null) {
            for (i2 = 0; i2 < this.numberOfParameters; ++i2) {
                this.preMinimumGradients[i2] = Double.NaN;
                this.postMinimumGradients[i2] = Double.NaN;
            }
        } else {
            gradients = this.getGrad();
            for (i2 = 0; i2 < this.numberOfParameters; ++i2) {
                this.preMinimumGradients[i2] = gradients[i2][0];
                this.postMinimumGradients[i2] = gradients[i2][1];
            }
        }
        this.results.add(this.preMinimumGradients);
        this.results.add(this.postMinimumGradients);
        this.sumOfSquares = this.getSumOfSquares();
        this.results.add(new Double(this.sumOfSquares));
        this.reducedSumOfSquares = this.sumOfSquares / (double)this.degreesOfFreedom;
        this.results.add(new Double(this.reducedSumOfSquares));
        if (this.weightsSet) {
            this.chiSquare = this.getChiSquare();
            this.results.add(new Double(this.chiSquare));
            this.reducedChiSquare = this.getReducedChiSquare();
            this.results.add(new Double(this.reducedChiSquare));
        } else {
            this.results.add(null);
            this.results.add(null);
        }
        this.numberOfIterations2 = this.getNiter();
        this.results.add(new Integer(this.numberOfIterations1));
        this.results.add(new Integer(this.numberOfIterations2));
        this.results.add(new Integer(this.maximumIterations));
        this.results.add(this.dataEnteredType[this.dataEnteredTypePointer]);
        this.results.add(this.frequencies);
        this.results.add(this.log10frequencies);
        this.results.add(this.omegas);
        this.results.add(this.log10omegas);
        this.results.add(this.impedanceMagnitudes);
        this.results.add(this.impedancePhasesRad);
        this.results.add(this.impedancePhasesDeg);
        this.results.add(this.impedances);
        this.results.add(this.realZ);
        this.results.add(this.imagZ);
        double[] calculatedY = this.getYcalc();
        for (int i6 = 0; i6 < this.numberOfFrequencies; ++i6) {
            this.calculatedRealZ[i6] = calculatedY[i6];
            this.calculatedImagZ[i6] = calculatedY[i6 + this.numberOfFrequencies];
        }
        this.results.add(this.calculatedRealZ);
        this.results.add(this.calculatedImagZ);
        double[] residuals = this.getResiduals();
        for (i = 0; i < this.numberOfFrequencies; ++i) {
            this.realZresiduals[i] = residuals[i];
            this.imagZresiduals[i] = residuals[i + this.numberOfFrequencies];
        }
        this.results.add(this.realZresiduals);
        this.results.add(this.imagZresiduals);
        if (this.weightsSet) {
            switch (this.dataEnteredTypePointer) {
                case 0: {
                    this.results.add(this.realVweights);
                    this.results.add(this.imagVweights);
                    break;
                }
                case 1: {
                    this.results.add(this.voltageWeights);
                    this.results.add(null);
                    break;
                }
                case 2: {
                    this.results.add(this.voltageMagnitudeWeights);
                    this.results.add(this.voltagePhaseWeightsRad);
                    break;
                }
                case 3: {
                    this.results.add(this.voltageMagnitudeWeights);
                    this.results.add(this.voltagePhaseWeightsDeg);
                    break;
                }
                case 4: {
                    this.results.add(this.realZweights);
                    this.results.add(this.imagZweights);
                    break;
                }
                case 5: {
                    this.results.add(this.impedanceWeights);
                    this.results.add(null);
                    break;
                }
                case 6: {
                    this.results.add(this.impedanceMagnitudeWeights);
                    this.results.add(this.impedancePhaseWeightsRad);
                    break;
                }
                case 7: {
                    this.results.add(this.impedanceMagnitudeWeights);
                    this.results.add(this.impedancePhaseWeightsDeg);
                    break;
                }
                default: {
                    this.results.add(null);
                    this.results.add(null);
                }
            }
            this.results.add(this.realZweights);
            this.results.add(this.imagZweights);
        } else {
            for (i = 0; i < 4; ++i) {
                this.results.add(null);
            }
        }
        for (i = 0; i < this.numberOfFrequencies; ++i) {
            this.calculatedImpedances[i] = new Complex(this.calculatedRealZ[i], this.calculatedImagZ[i]);
            this.calculatedImpedanceMagnitudes[i] = this.calculatedImpedances[i].abs();
            this.calculatedImpedancePhasesRad[i] = this.calculatedImpedances[i].arg();
            this.calculatedImpedancePhasesDeg[i] = Math.toDegrees(this.calculatedImpedancePhasesRad[i]);
        }
        this.results.add(this.calculatedImpedances);
        this.results.add(this.calculatedImpedanceMagnitudes);
        this.results.add(this.calculatedImpedancePhasesRad);
        this.results.add(this.calculatedImpedancePhasesDeg);
        if (this.appliedVoltageSet && this.referenceSet) {
            for (i = 0; i < this.numberOfFrequencies; ++i) {
                this.calculatedVoltages[i] = this.appliedVoltage.times(this.calculatedImpedances[i]).over(this.calculatedImpedances[i].plus(this.referenceImpedance));
                this.calculatedRealV[i] = this.calculatedVoltages[i].getReal();
                this.calculatedImagV[i] = this.calculatedVoltages[i].getImag();
                this.calculatedVoltageMagnitudes[i] = this.calculatedVoltages[i].abs();
                this.calculatedVoltagePhasesRad[i] = this.calculatedVoltages[i].arg();
                this.calculatedVoltagePhasesDeg[i] = Math.toDegrees(this.calculatedVoltagePhasesRad[i]);
            }
            this.results.add(this.calculatedVoltages);
            this.results.add(this.calculatedRealV);
            this.results.add(this.calculatedImagV);
            this.results.add(this.calculatedVoltageMagnitudes);
            this.results.add(this.calculatedVoltagePhasesRad);
            this.results.add(this.calculatedVoltagePhasesDeg);
        } else {
            for (i = 0; i < 6; ++i) {
                this.results.add(null);
            }
        }
        this.regressionDone = true;
        return this.results;
    }

    @Override
    public double[] getBestEstimates() {
        if (!this.regressionDone) {
            this.regression();
        }
        return this.bestEstimates;
    }

    public double[] getStandardDeviations() {
        if (!this.regressionDone) {
            this.regression();
        }
        return this.standardDeviations;
    }

    public int getFirstNumberOfIterations() {
        return this.numberOfIterations1;
    }

    public int getSecondNumberOfIterations() {
        return this.numberOfIterations2;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    public void setLinearPlot() {
        this.logOrLinear = false;
    }

    public void setLog10Plot() {
        this.logOrLinear = true;
    }

    private void calculateLineFrequencies() {
        double lowestFrequency = Fmath.minimum(this.frequencies);
        double highestFrequency = Fmath.maximum(this.frequencies);
        if (this.logOrLinear) {
            int i;
            double logLow = Fmath.log10(lowestFrequency);
            double logHigh = Fmath.log10(highestFrequency);
            double increment = (logHigh - logLow) / (double)(this.numberOfLineFrequencies - 1);
            this.lineFrequencies = new double[this.numberOfLineFrequencies];
            this.log10lineFrequencies = new double[this.numberOfLineFrequencies];
            this.log10lineFrequencies[0] = logLow;
            this.log10lineFrequencies[this.numberOfLineFrequencies - 1] = logHigh;
            for (i = 1; i < this.numberOfLineFrequencies - 1; ++i) {
                this.log10lineFrequencies[i] = this.log10lineFrequencies[i - 1] + increment;
            }
            for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                this.lineFrequencies[i] = Math.pow(10.0, this.log10lineFrequencies[i]);
            }
        } else {
            int i;
            double increment = (highestFrequency - lowestFrequency) / (double)(this.numberOfLineFrequencies - 1);
            this.lineFrequencies = new double[this.numberOfLineFrequencies];
            this.lineFrequencies[0] = lowestFrequency;
            this.log10lineFrequencies = new double[this.numberOfLineFrequencies];
            this.lineFrequencies[this.numberOfLineFrequencies - 1] = highestFrequency;
            for (i = 1; i < this.numberOfLineFrequencies - 1; ++i) {
                this.lineFrequencies[i] = this.lineFrequencies[i - 1] + increment;
            }
            for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                this.log10lineFrequencies[i] = Fmath.log10(this.lineFrequencies[i]);
            }
        }
    }

    private String[] dateAndTime() {
        Date d = new Date();
        String[] ret = new String[]{DateFormat.getDateInstance().format(d), DateFormat.getTimeInstance().format(d)};
        return ret;
    }

    public ArrayList<Object> plotColeCole() {
        int i;
        String[] dAndT = this.dateAndTime();
        String graphTitle1 = "ImpedSpecRegression program:  Cole - Cole plot   [" + dAndT[0] + "    " + dAndT[1] + "]";
        String graphTitle2 = this.regressionTitle;
        if (!this.regressionDone) {
            this.regression();
        }
        this.calculateLineFrequencies();
        double[][] data = PlotGraph.data(2, this.numberOfLineFrequencies);
        for (i = 0; i < this.numberOfFrequencies; ++i) {
            data[0][i] = this.realZ[this.numberOfFrequencies - i - 1];
            data[1][i] = -this.imagZ[this.numberOfFrequencies - i - 1];
        }
        if (this.userModelSet) {
            for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                data[2][i] = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[this.numberOfLineFrequencies - i - 1] * 2.0 * Math.PI).getReal();
                data[3][i] = -this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[this.numberOfLineFrequencies - i - 1] * 2.0 * Math.PI).getImag();
            }
        } else {
            for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                data[2][i] = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[this.numberOfLineFrequencies - i - 1] * 2.0 * Math.PI, this.modelNumber).getReal();
                data[3][i] = -Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[this.numberOfLineFrequencies - i - 1] * 2.0 * Math.PI, this.modelNumber).getImag();
            }
        }
        PlotGraph pg = new PlotGraph(data);
        int[] lineOpt = new int[]{0, 3};
        pg.setLine(lineOpt);
        int[] pointOpt = new int[]{1, 0};
        pg.setPoint(pointOpt);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        pg.setXaxisLegend("Real[Impedance / ohms]");
        pg.setYaxisLegend("-Imag[Impedance / ohms]");
        pg.plot();
        return this.results;
    }

    public ArrayList<Object> plotImpedanceMagnitudes() {
        Complex imped;
        int i;
        String[] dAndT = this.dateAndTime();
        String graphTitle1 = "ImpedSpecRegression program:  Impedance magnitude versus frequency plot   [" + dAndT[0] + "    " + dAndT[1] + "]";
        String graphTitle2 = this.regressionTitle;
        if (!this.regressionDone) {
            this.regression();
        }
        this.calculateLineFrequencies();
        double[][] data = PlotGraph.data(2, this.numberOfLineFrequencies);
        if (this.logOrLinear) {
            for (i = 0; i < this.numberOfFrequencies; ++i) {
                data[0][i] = this.log10frequencies[i];
                data[1][i] = this.impedanceMagnitudes[i];
            }
        } else {
            for (i = 0; i < this.numberOfFrequencies; ++i) {
                data[0][i] = this.frequencies[i];
                data[1][i] = this.impedanceMagnitudes[i];
            }
        }
        if (this.logOrLinear) {
            if (this.userModelSet) {
                for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                    data[2][i] = this.log10lineFrequencies[i];
                    imped = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI);
                    data[3][i] = imped.abs();
                }
            } else {
                for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                    data[2][i] = this.log10lineFrequencies[i];
                    imped = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI, this.modelNumber);
                    data[3][i] = imped.abs();
                }
            }
        } else if (this.userModelSet) {
            for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                data[2][i] = this.lineFrequencies[i];
                imped = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI);
                data[3][i] = imped.abs();
            }
        } else {
            for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                data[2][i] = this.lineFrequencies[i];
                imped = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI, this.modelNumber);
                data[3][i] = imped.abs();
            }
        }
        PlotGraph pg = new PlotGraph(data);
        int[] lineOpt = new int[]{0, 3};
        pg.setLine(lineOpt);
        int[] pointOpt = new int[]{1, 0};
        pg.setPoint(pointOpt);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        if (this.logOrLinear) {
            pg.setXaxisLegend("Log10[Frequency / Hz]");
        } else {
            pg.setXaxisLegend("Frequency / Hz");
        }
        pg.setYaxisLegend("Impedance Magnitude");
        pg.plot();
        return this.results;
    }

    public ArrayList<Object> plotImpedancePhases() {
        Complex imped;
        int i;
        String[] dAndT = this.dateAndTime();
        String graphTitle1 = "ImpedSpecRegression program:  Impedance phase versus frequency plot   [" + dAndT[0] + "    " + dAndT[1] + "]";
        String graphTitle2 = this.regressionTitle;
        if (!this.regressionDone) {
            this.regression();
        }
        this.calculateLineFrequencies();
        double[][] data = PlotGraph.data(2, this.numberOfLineFrequencies);
        if (this.logOrLinear) {
            for (i = 0; i < this.numberOfFrequencies; ++i) {
                data[0][i] = this.log10frequencies[i];
                data[1][i] = this.impedancePhasesDeg[i];
            }
        } else {
            for (i = 0; i < this.numberOfFrequencies; ++i) {
                data[0][i] = this.frequencies[i];
                data[1][i] = this.impedancePhasesDeg[i];
            }
        }
        if (this.logOrLinear) {
            if (this.userModelSet) {
                for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                    data[2][i] = this.log10lineFrequencies[i];
                    imped = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI);
                    data[3][i] = Math.toDegrees(imped.arg());
                }
            } else {
                for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                    data[2][i] = this.log10lineFrequencies[i];
                    imped = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI, this.modelNumber);
                    data[3][i] = Math.toDegrees(imped.arg());
                }
            }
        } else if (this.userModelSet) {
            for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                data[2][i] = this.lineFrequencies[i];
                imped = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI);
                data[3][i] = Math.toDegrees(imped.arg());
            }
        } else {
            for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                data[2][i] = this.lineFrequencies[i];
                imped = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI, this.modelNumber);
                data[3][i] = Math.toDegrees(imped.arg());
            }
        }
        PlotGraph pg = new PlotGraph(data);
        int[] lineOpt = new int[]{0, 3};
        pg.setLine(lineOpt);
        int[] pointOpt = new int[]{1, 0};
        pg.setPoint(pointOpt);
        pg.setGraphTitle(graphTitle1);
        pg.setGraphTitle2(graphTitle2);
        if (this.logOrLinear) {
            pg.setXaxisLegend("Log10[Frequency / Hz]");
        } else {
            pg.setXaxisLegend("Frequency / Hz");
        }
        pg.setYaxisLegend("Impedance Phase / degrees");
        pg.plot();
        return this.results;
    }

    public ArrayList<Object> plotVoltageMagnitudes() {
        if (!this.regressionDone) {
            this.regression();
        }
        if (this.referenceSet && this.appliedVoltageSet) {
            Complex volt;
            Complex imped;
            int i;
            String[] dAndT = this.dateAndTime();
            String graphTitle1 = "ImpedSpecRegression program:  Voltage magnitude versus frequency plot   [" + dAndT[0] + "    " + dAndT[1] + "]";
            String graphTitle2 = this.regressionTitle;
            this.calculateLineFrequencies();
            double[][] data = PlotGraph.data(2, this.numberOfLineFrequencies);
            if (this.logOrLinear) {
                for (i = 0; i < this.numberOfFrequencies; ++i) {
                    data[0][i] = this.log10frequencies[i];
                    data[1][i] = this.voltageMagnitudes[i];
                }
            } else {
                for (i = 0; i < this.numberOfFrequencies; ++i) {
                    data[0][i] = this.frequencies[i];
                    data[1][i] = this.voltageMagnitudes[i];
                }
            }
            if (this.logOrLinear) {
                if (this.userModelSet) {
                    for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                        data[2][i] = this.log10lineFrequencies[i];
                        imped = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI);
                        volt = imped.times(this.appliedVoltage).over(this.referenceImpedance.plus(imped));
                        data[3][i] = volt.abs();
                    }
                } else {
                    for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                        data[2][i] = this.log10lineFrequencies[i];
                        imped = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI, this.modelNumber);
                        volt = imped.times(this.appliedVoltage).over(this.referenceImpedance.plus(imped));
                        data[3][i] = volt.abs();
                    }
                }
            } else if (this.userModelSet) {
                for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                    data[2][i] = this.lineFrequencies[i];
                    imped = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI);
                    volt = imped.times(this.appliedVoltage).over(this.referenceImpedance.plus(imped));
                    data[3][i] = volt.abs();
                }
            } else {
                for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                    data[2][i] = this.lineFrequencies[i];
                    imped = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI, this.modelNumber);
                    volt = imped.times(this.appliedVoltage).over(this.referenceImpedance.plus(imped));
                    data[3][i] = volt.abs();
                }
            }
            PlotGraph pg = new PlotGraph(data);
            int[] lineOpt = new int[]{0, 3};
            pg.setLine(lineOpt);
            int[] pointOpt = new int[]{1, 0};
            pg.setPoint(pointOpt);
            pg.setGraphTitle(graphTitle1);
            pg.setGraphTitle2(graphTitle2);
            if (this.logOrLinear) {
                pg.setXaxisLegend("Log10[Frequency / Hz]");
            } else {
                pg.setXaxisLegend("Frequency / Hz");
            }
            pg.setYaxisLegend("Voltage Magnitude");
            pg.plot();
        } else {
            System.out.println("The voltage magnitudes cannot be plotted as no reference impedance or applied voltage has been entered");
        }
        return this.results;
    }

    public ArrayList<Object> plotVoltagePhases() {
        if (!this.regressionDone) {
            this.regression();
        }
        if (this.referenceSet && this.appliedVoltageSet) {
            Complex volt;
            Complex imped;
            int i;
            String[] dAndT = this.dateAndTime();
            String graphTitle1 = "ImpedSpecRegression program:  Voltage phase versus frequency plot   [" + dAndT[0] + "    " + dAndT[1] + "]";
            String graphTitle2 = this.regressionTitle;
            this.calculateLineFrequencies();
            double[][] data = PlotGraph.data(2, this.numberOfLineFrequencies);
            if (this.logOrLinear) {
                for (i = 0; i < this.numberOfFrequencies; ++i) {
                    data[0][i] = this.log10frequencies[i];
                    data[1][i] = this.voltagePhasesDeg[i];
                }
            } else {
                for (i = 0; i < this.numberOfFrequencies; ++i) {
                    data[0][i] = this.frequencies[i];
                    data[1][i] = this.voltagePhasesDeg[i];
                }
            }
            if (this.logOrLinear) {
                if (this.userModelSet) {
                    for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                        data[2][i] = this.log10lineFrequencies[i];
                        imped = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI);
                        volt = imped.times(this.appliedVoltage).over(this.referenceImpedance.plus(imped));
                        data[3][i] = Math.toDegrees(volt.arg());
                    }
                } else {
                    for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                        data[2][i] = this.log10lineFrequencies[i];
                        imped = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI, this.modelNumber);
                        volt = imped.times(this.appliedVoltage).over(this.referenceImpedance.plus(imped));
                        data[3][i] = Math.toDegrees(volt.arg());
                    }
                }
            } else if (this.userModelSet) {
                for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                    data[2][i] = this.lineFrequencies[i];
                    imped = this.userModel.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI);
                    volt = imped.times(this.appliedVoltage).over(this.referenceImpedance.plus(imped));
                    data[3][i] = Math.toDegrees(volt.arg());
                }
            } else {
                for (i = 0; i < this.numberOfLineFrequencies; ++i) {
                    data[2][i] = this.lineFrequencies[i];
                    imped = Impedance.modelImpedance(this.bestEstimates, this.lineFrequencies[i] * 2.0 * Math.PI, this.modelNumber);
                    volt = imped.times(this.appliedVoltage).over(this.referenceImpedance.plus(imped));
                    data[3][i] = Math.toDegrees(volt.arg());
                }
            }
            PlotGraph pg = new PlotGraph(data);
            int[] lineOpt = new int[]{0, 3};
            pg.setLine(lineOpt);
            int[] pointOpt = new int[]{1, 0};
            pg.setPoint(pointOpt);
            pg.setGraphTitle(graphTitle1);
            pg.setGraphTitle2(graphTitle2);
            if (this.logOrLinear) {
                pg.setXaxisLegend("Log10[Frequency / Hz]");
            } else {
                pg.setXaxisLegend("Frequency / Hz");
            }
            pg.setYaxisLegend("Voltage Phases / degrees");
            pg.plot();
        } else {
            System.out.println("The voltage magnitudes cannot be plotted as no reference impedance or applied voltage has been entered");
        }
        return this.results;
    }

    public ArrayList<Object> printToTextFile() {
        String fileName = "ImpedSpecRegressionOutput.txt";
        this.fileType = true;
        return this.printToTextFile(fileName);
    }

    public ArrayList<Object> printToTextFile(String fileName) {
        int i;
        if (!this.regressionDone) {
            this.regression();
        }
        int field = 11;
        int trunc = 4;
        int dotPosition = (fileName = fileName.trim()).indexOf(46);
        if (dotPosition == -1) {
            fileName = fileName + ".txt";
        }
        FileOutput fout = null;
        fout = this.fileType ? new FileOutput(fileName, 'n') : new FileOutput(fileName);
        fout.println("ImpedSpecRegression Program Output File:  " + this.regressionTitle);
        fout.dateAndTimeln(fileName);
        fout.println();
        if (this.modelSet) {
            fout.println("Circuit - model number " + this.modelNumber);
        } else {
            fout.println("Circuit supplied by the user");
        }
        fout.println();
        fout.println("Circuit Parameters");
        fout.println("Best Estimates");
        fout.print("Parameter", field);
        fout.print("Best", field);
        fout.print("Standard", field);
        fout.print("Coeff. of", field);
        fout.print("Pre-", field);
        fout.println("Post-");
        fout.print("   ", field);
        fout.print("estimate", field);
        fout.print("deviation", field);
        fout.print("variation", field);
        fout.print("gradient", field);
        fout.println("gradient");
        for (i = 0; i < this.numberOfParameters; ++i) {
            fout.print(this.parameterSymbols[i], field);
            fout.print(Fmath.truncate(this.bestEstimates[i], trunc), field);
            fout.print(Fmath.truncate(this.standardDeviations[i], trunc), field);
            fout.print(Fmath.truncate(this.coefficientsOfVariation[i], trunc), field);
            fout.print(Fmath.truncate(this.preMinimumGradients[i], trunc), field);
            fout.println(Fmath.truncate(this.postMinimumGradients[i], trunc));
        }
        fout.println();
        fout.println("Initial Estimates");
        fout.print("Parameter", field);
        fout.print("Initial", field);
        fout.println("initial");
        fout.print("   ", field);
        fout.print("estimate", field);
        fout.println("step size");
        for (i = 0; i < this.numberOfParameters; ++i) {
            fout.print(this.parameterSymbols[i], field);
            fout.print(Fmath.truncate(this.initialEstimates[i], trunc), field);
            fout.println(Fmath.truncate(this.initialSteps[i], trunc));
        }
        fout.println();
        fout.println("Sum of squares of the Real[Z] and Imag[Z] residuals:         " + Fmath.truncate(this.sumOfSquares, trunc));
        fout.println("Reduced sum of squares of the Real[Z] and Imag[Z] residuals: " + Fmath.truncate(this.sumOfSquares / (double)this.degreesOfFreedom, trunc));
        fout.println("Degrees of freedom: " + this.degreesOfFreedom);
        if (this.weightsSet) {
            fout.println("Chi square:         " + Fmath.truncate(this.chiSquare, trunc));
            fout.println("Reduced chi square: " + Fmath.truncate(this.reducedChiSquare, trunc));
        }
        fout.println("Number of iterations taken in the first regression:      " + this.numberOfIterations1);
        fout.println("Number of iterations taken in the second regression:     " + this.numberOfIterations2);
        fout.println("Maximum number of iterations allowed in each regression: " + this.maximumIterations);
        fout.println();
        if (this.appliedVoltageSet) {
            fout.println("Applied voltage: " + this.appliedVoltage.getReal());
        }
        if (this.referenceSet) {
            fout.println("Reference impedance: " + this.referenceImpedance);
        }
        fout.println();
        field = 14;
        fout.println("Fitted and entered data [frequencies, calculated impedances, data as entered]");
        fout.print("Entered data type:  ");
        fout.println(this.dataEnteredType[this.dataEnteredTypePointer]);
        fout.println();
        fout.print("Frequency", field);
        fout.print("Experimental", field);
        fout.print("Calculated", field);
        fout.print("Experimental", field);
        fout.print("Calculated", field);
        switch (this.dataEnteredTypePointer) {
            case 0: {
                fout.print("Real", field);
                fout.print("Imag", field);
                break;
            }
            case 1: {
                fout.print("Complex", field);
                break;
            }
            case 2: {
                fout.print("Magnitude", field);
                fout.print("Phase (rad)", field);
                break;
            }
            case 3: {
                fout.print("Magnitude", field);
                fout.print("Phase (deg)", field);
                break;
            }
            case 4: {
                fout.print("Real", field);
                fout.print("Imag", field);
                break;
            }
            case 5: {
                fout.print("Complex", field);
                break;
            }
            case 6: {
                fout.print("Magnitude", field);
                fout.print("Phase (rad)", field);
                break;
            }
            case 7: {
                fout.print("Magnitude", field);
                fout.print("Phase (deg)", field);
            }
        }
        fout.println();
        fout.print("Frequency", field);
        fout.print("Real[Z]", field);
        fout.print("Real[Z]", field);
        fout.print("Imag[Z]", field);
        fout.print("Imag[Z]", field);
        switch (this.dataEnteredTypePointer) {
            case 0: {
                fout.print("[voltage]", field);
                fout.print("[voltage]", field);
                break;
            }
            case 1: {
                fout.print("voltage", field);
                break;
            }
            case 2: {
                fout.print("[voltage]", field);
                fout.print("[voltage]", field);
                break;
            }
            case 3: {
                fout.print("[voltage]", field);
                fout.print("[voltage]", field);
                break;
            }
            case 4: {
                fout.print("[impedance]", field);
                fout.print("[impedance]", field);
                break;
            }
            case 5: {
                fout.print("impedance", field);
                break;
            }
            case 6: {
                fout.print("[impedance]", field);
                fout.print("[impedance]", field);
                break;
            }
            case 7: {
                fout.print("[impedance]", field);
                fout.print("[impedance]", field);
            }
        }
        fout.println();
        for (i = 0; i < this.numberOfFrequencies; ++i) {
            fout.print(Fmath.truncate(this.frequencies[i], trunc), field);
            fout.print(Fmath.truncate(this.realZ[i], trunc), field);
            fout.print(Fmath.truncate(this.calculatedRealZ[i], trunc), field);
            fout.print(Fmath.truncate(this.imagZ[i], trunc), field);
            fout.print(Fmath.truncate(this.calculatedImagZ[i], trunc), field);
            switch (this.dataEnteredTypePointer) {
                case 0: {
                    fout.print(Fmath.truncate(this.realV[i], trunc), field);
                    fout.print(Fmath.truncate(this.imagV[i], trunc), field);
                    break;
                }
                case 1: {
                    fout.print(Complex.truncate(this.voltages[i], trunc), field);
                    break;
                }
                case 2: {
                    fout.print(Fmath.truncate(this.voltageMagnitudes[i], trunc), field);
                    fout.print(Fmath.truncate(this.voltagePhasesRad[i], trunc), field);
                    break;
                }
                case 3: {
                    fout.print(Fmath.truncate(this.voltageMagnitudes[i], trunc), field);
                    fout.print(Fmath.truncate(this.voltagePhasesDeg[i], trunc), field);
                    break;
                }
                case 4: {
                    fout.print(Fmath.truncate(this.realZ[i], trunc), field);
                    fout.print(Fmath.truncate(this.imagZ[i], trunc), field);
                    break;
                }
                case 5: {
                    fout.print(Complex.truncate(this.impedances[i], trunc), field);
                    break;
                }
                case 6: {
                    fout.print(Fmath.truncate(this.impedanceMagnitudes[i], trunc), field);
                    fout.print(Fmath.truncate(this.impedancePhasesRad[i], trunc), field);
                    break;
                }
                case 7: {
                    fout.print(Fmath.truncate(this.impedanceMagnitudes[i], trunc), field);
                    fout.print(Fmath.truncate(this.impedancePhasesDeg[i], trunc), field);
                }
            }
            fout.println();
        }
        fout.close();
        return this.results;
    }

    public ArrayList<Object> printToExcelFile() {
        String fileName = "ImpedSpecRegressionOutput.txt";
        this.fileType = true;
        return this.printToExcelFile(fileName);
    }

    public ArrayList<Object> printToExcelFile(String fileName) {
        int i;
        if (!this.regressionDone) {
            this.regression();
        }
        int field = 11;
        int trunc = 4;
        int dotPosition = (fileName = fileName.trim()).indexOf(46);
        fileName = dotPosition == -1 ? fileName + ".xls" : fileName.substring(0, dotPosition) + ".xls";
        FileOutput fout = null;
        fout = this.fileType ? new FileOutput(fileName, 'n') : new FileOutput(fileName);
        fout.println("ImpedSpecRegression Program Output File:  " + this.regressionTitle);
        fout.dateAndTimeln(fileName);
        fout.println();
        if (this.modelSet) {
            fout.println("Circuit - model number " + this.modelNumber);
        } else {
            fout.println("Circuit supplied by the user");
        }
        fout.println();
        fout.println("Circuit Parameters");
        fout.println("Best Estimates");
        fout.printtab("Parameter", field);
        fout.printtab("Best", field);
        fout.printtab("Standard", field);
        fout.printtab("Coeff. of", field);
        fout.printtab("Pre-", field);
        fout.println("Post-");
        fout.printtab("   ", field);
        fout.printtab("estimate", field);
        fout.printtab("deviation", field);
        fout.printtab("variation", field);
        fout.printtab("gradient", field);
        fout.println("gradient");
        for (i = 0; i < this.numberOfParameters; ++i) {
            fout.printtab(this.parameterSymbols[i], field);
            fout.printtab(Fmath.truncate(this.bestEstimates[i], trunc), field);
            fout.printtab(Fmath.truncate(this.standardDeviations[i], trunc), field);
            fout.printtab(Fmath.truncate(this.coefficientsOfVariation[i], trunc), field);
            fout.printtab(Fmath.truncate(this.preMinimumGradients[i], trunc), field);
            fout.println(Fmath.truncate(this.postMinimumGradients[i], trunc));
        }
        fout.println();
        fout.println("Initial Estimates");
        fout.printtab("Parameter", field);
        fout.printtab("Initial", field);
        fout.println("initial");
        fout.printtab("   ", field);
        fout.printtab("estimate", field);
        fout.println("step size");
        for (i = 0; i < this.numberOfParameters; ++i) {
            fout.printtab(this.parameterSymbols[i], field);
            fout.printtab(Fmath.truncate(this.initialEstimates[i], trunc), field);
            fout.println(Fmath.truncate(this.initialSteps[i], trunc));
        }
        fout.println();
        fout.println("Sum of squares of the Real[Z] and Imag[z] residuals:         " + Fmath.truncate(this.sumOfSquares, trunc));
        fout.println("Reduced sum of squares of the Real[Z] and Imag[z] residuals: " + Fmath.truncate(this.sumOfSquares / (double)this.degreesOfFreedom, trunc));
        fout.println("Degrees of freedom: " + this.degreesOfFreedom);
        if (this.weightsSet) {
            fout.println("Chi square:         " + Fmath.truncate(this.chiSquare, trunc));
            fout.println("Reduced chi square: " + Fmath.truncate(this.reducedChiSquare, trunc));
        }
        fout.println("Number of iterations taken in the first regression:      " + this.numberOfIterations1);
        fout.println("Number of iterations taken in the second regression:     " + this.numberOfIterations2);
        fout.println("Maximum number of iterations allowed in each regression: " + this.maximumIterations);
        fout.println();
        field = 14;
        fout.println("Fitted and entered data [frequencies, calculated impedances, data as entered]");
        fout.print("Entered data type:  ");
        fout.println(this.dataEnteredType[this.dataEnteredTypePointer]);
        fout.println();
        fout.printtab("Frequency", field);
        fout.printtab("Experimental", field);
        fout.printtab("Calculated", field);
        fout.printtab("Experimental", field);
        fout.printtab("Calculated", field);
        switch (this.dataEnteredTypePointer) {
            case 0: {
                fout.printtab("Real", field);
                fout.printtab("Imag", field);
                break;
            }
            case 1: {
                fout.printtab("Complex", field);
                break;
            }
            case 2: {
                fout.printtab("Magnitude", field);
                fout.printtab("Phase (rad)", field);
                break;
            }
            case 3: {
                fout.printtab("Magnitude", field);
                fout.printtab("Phase (deg)", field);
                break;
            }
            case 4: {
                fout.printtab("Real", field);
                fout.printtab("Imag", field);
                break;
            }
            case 5: {
                fout.printtab("Complex", field);
                break;
            }
            case 6: {
                fout.printtab("Magnitude", field);
                fout.printtab("Phase (rad)", field);
                break;
            }
            case 7: {
                fout.printtab("Magnitude", field);
                fout.printtab("Phase (deg)", field);
            }
        }
        fout.println();
        fout.printtab("Frequency", field);
        fout.printtab("Real[Z]", field);
        fout.printtab("Real[Z]", field);
        fout.printtab("Imag[Z]", field);
        fout.printtab("Imag[Z]", field);
        switch (this.dataEnteredTypePointer) {
            case 0: {
                fout.printtab("[voltage]", field);
                fout.printtab("[voltage]", field);
                break;
            }
            case 1: {
                fout.printtab("voltage", field);
                break;
            }
            case 2: {
                fout.printtab("[voltage]", field);
                fout.printtab("[voltage]", field);
                break;
            }
            case 3: {
                fout.printtab("[voltage]", field);
                fout.printtab("[voltage]", field);
                break;
            }
            case 4: {
                fout.printtab("[impedance]", field);
                fout.printtab("[impedance]", field);
                break;
            }
            case 5: {
                fout.printtab("impedance", field);
                break;
            }
            case 6: {
                fout.printtab("[impedance]", field);
                fout.printtab("[impedance]", field);
                break;
            }
            case 7: {
                fout.printtab("[impedance]", field);
                fout.printtab("[impedance]", field);
            }
        }
        fout.println();
        for (i = 0; i < this.numberOfFrequencies; ++i) {
            fout.printtab(Fmath.truncate(this.frequencies[i], trunc), field);
            fout.printtab(Fmath.truncate(this.realZ[i], trunc), field);
            fout.printtab(Fmath.truncate(this.calculatedRealZ[i], trunc), field);
            fout.printtab(Fmath.truncate(this.imagZ[i], trunc), field);
            fout.printtab(Fmath.truncate(this.calculatedImagZ[i], trunc), field);
            switch (this.dataEnteredTypePointer) {
                case 0: {
                    fout.printtab(Fmath.truncate(this.realV[i], trunc), field);
                    fout.printtab(Fmath.truncate(this.imagV[i], trunc), field);
                    break;
                }
                case 1: {
                    fout.printtab(Complex.truncate(this.voltages[i], trunc), field);
                    break;
                }
                case 2: {
                    fout.printtab(Fmath.truncate(this.voltageMagnitudes[i], trunc), field);
                    fout.printtab(Fmath.truncate(this.voltagePhasesRad[i], trunc), field);
                    break;
                }
                case 3: {
                    fout.printtab(Fmath.truncate(this.voltageMagnitudes[i], trunc), field);
                    fout.printtab(Fmath.truncate(this.voltagePhasesDeg[i], trunc), field);
                    break;
                }
                case 4: {
                    fout.printtab(Fmath.truncate(this.realZ[i], trunc), field);
                    fout.printtab(Fmath.truncate(this.imagZ[i], trunc), field);
                    break;
                }
                case 5: {
                    fout.printtab(Complex.truncate(this.impedances[i], trunc), field);
                    break;
                }
                case 6: {
                    fout.printtab(Fmath.truncate(this.impedanceMagnitudes[i], trunc), field);
                    fout.printtab(Fmath.truncate(this.impedancePhasesRad[i], trunc), field);
                    break;
                }
                case 7: {
                    fout.printtab(Fmath.truncate(this.impedanceMagnitudes[i], trunc), field);
                    fout.printtab(Fmath.truncate(this.impedancePhasesDeg[i], trunc), field);
                }
            }
            fout.println();
        }
        fout.close();
        return this.results;
    }
}

