/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Markers;
import ca.mcgill.mcb.pcingola.stats.IntStats;

public class MineMarkerIntervals {
    Markers markers;
    IntStats lengthStats;
    IntStats distanceStats;

    public MineMarkerIntervals(Markers markers) {
        this.markers = markers;
        this.lengthStats = new IntStats();
        this.distanceStats = new IntStats();
    }

    public IntStats getDistanceStats() {
        return this.distanceStats;
    }

    public IntStats getLengthStats() {
        return this.lengthStats;
    }

    public void stats() {
        this.markers.sort(false, false);
        Marker prev = null;
        for (Marker m : this.markers) {
            this.lengthStats.sample(m.size());
            if (prev != null && m.getChromosome().getId().equals(prev.getChromosome().getId())) {
                if (m.intersects(prev)) {
                    this.distanceStats.sample(0);
                } else {
                    this.distanceStats.sample(m.getStart() - prev.getEnd());
                }
            }
            prev = m;
        }
    }
}

