/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.stats;

import ca.mcgill.mcb.pcingola.stats.IntStats;
import ca.mcgill.mcb.pcingola.stats.SamplingStats;
import ca.mcgill.mcb.pcingola.vcf.VcfEntry;
import ca.mcgill.mcb.pcingola.vcf.VcfGenotype;

public class AlleleFrequencyStats
implements SamplingStats<VcfEntry> {
    static int[] GENOTYPE_SINGLE_ALT_CHANGE = new int[]{1};
    IntStats count = new IntStats();

    public IntStats getCount() {
        return this.count;
    }

    @Override
    public boolean hasData() {
        return this.count.isValidData();
    }

    @Override
    public void sample(VcfEntry vcfEntry) {
        if (!vcfEntry.isSnp() || !vcfEntry.isVariant()) {
            return;
        }
        int genotypes = vcfEntry.getVcfGenotypes().size();
        String[] alts = vcfEntry.getAlts();
        int[] countGenotypes = new int[alts.length + 1];
        if (genotypes > 0) {
            for (VcfGenotype vcfGenotype : vcfEntry) {
                if (!vcfGenotype.isVariant()) continue;
                int[] gens = vcfGenotype.getGenotype();
                if (gens == null) {
                    gens = GENOTYPE_SINGLE_ALT_CHANGE;
                }
                for (int gen : gens) {
                    if (gen <= 0) continue;
                    int n = gen;
                    countGenotypes[n] = countGenotypes[n] + 1;
                }
            }
            for (int c : countGenotypes) {
                if (c <= 0) continue;
                this.count.sample(c);
            }
        } else {
            this.count.sample(1);
        }
    }

    public String toString() {
        return this.count.toString();
    }
}

