/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr5prime;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.snpEffect.factory.SnpEffPredictorFactoryRand;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesTranscript
extends TestCase {
    boolean debug = false;
    Random rand;
    Config config;
    Genome genome;
    Chromosome chromosome;
    Gene gene;
    Transcript transcript;
    SnpEffectPredictor snpEffectPredictor;
    String chromoSequence = "";
    char[] chromoBases;

    public TestCasesTranscript() {
        this.init();
    }

    void init() {
        this.initRand();
        this.initSnpEffPredictor();
    }

    void initRand() {
        this.rand = new Random(20120131L);
    }

    void initSnpEffPredictor() {
        this.config = new Config("testCase", "snpEff.config");
        int maxGeneLen = 1000;
        int maxTranscripts = 1;
        int maxExons = 5;
        SnpEffPredictorFactoryRand sepf = new SnpEffPredictorFactoryRand(this.config, 1, this.rand, maxGeneLen, maxTranscripts, maxExons);
        this.snpEffectPredictor = sepf.create();
        this.config.setSnpEffectPredictor(this.snpEffectPredictor);
        this.chromoSequence = sepf.getChromoSequence();
        this.chromoBases = this.chromoSequence.toCharArray();
        this.config.getSnpEffectPredictor().setUpDownStreamLength(0);
        this.config.getSnpEffectPredictor().buildForest();
        this.chromosome = sepf.getChromo();
        this.genome = this.config.getGenome();
        this.gene = this.genome.getGenes().iterator().next();
        this.transcript = (Transcript)this.gene.iterator().next();
    }

    public void test_CdsPos() {
        int N = 1000;
        for (int iter = 0; iter < N; ++iter) {
            this.initSnpEffPredictor();
            if (this.debug) {
                System.out.println("Test CDS pos iteration: " + iter + "\n" + this.transcript);
            } else {
                System.out.println("Test CDS pos iteration: " + iter + "\t" + (this.transcript.getStrand() >= 0 ? "+" : "-") + "\t" + this.transcript.cds());
            }
            int cdsBaseNum = 0;
            int[] cds2pos = this.transcript.cdsBaseNumber2ChrPos();
            for (Exon exon : this.transcript.sortedStrand()) {
                int min = this.transcript.isStrandPlus() ? exon.getStart() : exon.getEnd();
                int step = this.transcript.isStrandPlus() ? 1 : -1;
                int pos = min;
                while (exon.intersects(pos)) {
                    int cdsBaseNumCalc = this.transcript.cdsBaseNumber(pos, true);
                    Assert.assertEquals((int)cdsBaseNum, (int)cdsBaseNumCalc);
                    Assert.assertEquals((int)pos, (int)cds2pos[cdsBaseNum]);
                    pos += step;
                    ++cdsBaseNum;
                }
            }
        }
    }

    public void test_cdsStartEnd_1() {
        Gene g = new Gene(this.chromosome, 0, 100, 1, "g1", "g1", "");
        Transcript tr = new Transcript(g, 10, 100, 1, "tr1");
        Exon e1 = new Exon(tr, 10, 30, 1, "e1", 1);
        Exon e2 = new Exon(tr, 50, 80, 1, "e2", 2);
        Exon e3 = new Exon(tr, 90, 100, 1, "e3", 3);
        tr.add(e1);
        tr.add(e2);
        tr.add(e3);
        Assert.assertEquals((int)10, (int)tr.getCdsStart());
        Assert.assertEquals((int)100, (int)tr.getCdsEnd());
        System.out.println("Transcript : " + tr);
        System.out.println("CDS.start: " + tr.getCdsStart() + "\tCDS.end: " + tr.getCdsEnd());
    }

    public void test_cdsStartEnd_2() {
        Gene g = new Gene(this.chromosome, 10, 100, 1, "g1", "g1", "");
        Transcript tr = new Transcript(g, 10, 100, 1, "tr1");
        Exon e1 = new Exon(tr, 10, 30, 1, "e1", 1);
        Exon e2 = new Exon(tr, 50, 80, 1, "e2", 2);
        Exon e3 = new Exon(tr, 90, 100, 1, "e3", 3);
        tr.add(e1);
        tr.add(e2);
        tr.add(e3);
        Utr5prime u1 = new Utr5prime(e1, 10, 30, 1, "u1");
        Utr5prime u2 = new Utr5prime(e2, 50, 80, 1, "u2");
        Utr5prime u3 = new Utr5prime(e3, 90, 100, 1, "u3");
        tr.add(u1);
        tr.add(u2);
        tr.add(u3);
        Assert.assertEquals((int)10, (int)tr.getCdsStart());
        Assert.assertEquals((int)10, (int)tr.getCdsEnd());
        System.out.println("Transcript : " + tr);
        System.out.println("CDS.start: " + tr.getCdsStart() + "\tCDS.end: " + tr.getCdsEnd());
    }
}

