/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.snpEffect.testCases;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.LossOfFunction;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.util.HashSet;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TestCasesNmd
extends TestCase {
    public static boolean debug = false;
    public static boolean verbose = false;
    public static int SHOW_EVERY = 10;
    Config config;
    int countTest = 1;

    void checkNmd(Gene gene, Transcript tr) {
        if (verbose) {
            System.err.print("\tTranscript " + tr.getId() + " " + (tr.isStrandPlus() ? (char)'+' : '-') + " :");
        } else {
            Gpr.showMark(this.countTest++, SHOW_EVERY);
        }
        int pos = 0;
        boolean[] isNmd = new boolean[tr.cds().length()];
        HashSet<Exon> codingExons = new HashSet<Exon>();
        StringBuilder nmdStr = new StringBuilder();
        StringBuilder nmdStrSimple = new StringBuilder();
        for (Exon exon : tr.sortedStrand()) {
            int from;
            int step = exon.isStrandPlus() ? 1 : -1;
            for (int expos = from = exon.isStrandPlus() ? exon.getStart() : exon.getEnd(); exon.getStart() <= expos && expos <= exon.getEnd(); expos += step) {
                if (!tr.isUtr(expos)) {
                    codingExons.add(exon);
                    SeqChange seqChange = new SeqChange(tr.getChromosome(), expos, expos, "");
                    ChangeEffect changeEffect = new ChangeEffect(seqChange);
                    changeEffect.set(exon, ChangeEffect.EffectType.STOP_GAINED, "");
                    LinkedList<ChangeEffect> changeEffects = new LinkedList<ChangeEffect>();
                    changeEffects.add(changeEffect);
                    LossOfFunction lof = new LossOfFunction(changeEffects);
                    isNmd[pos] = lof.isNmd();
                    nmdStr.append(isNmd[pos] ? (char)'+' : '.');
                    nmdStrSimple.append(isNmd[pos] ? (char)'+' : '.');
                    ++pos;
                    continue;
                }
                nmdStr.append('U');
            }
            nmdStr.append('\t');
            nmdStrSimple.append('\t');
        }
        if (verbose) {
            System.err.println(nmdStr);
        }
        if (debug) {
            System.err.println("\tCoding Exons:" + codingExons.size());
        }
        if (codingExons.size() > 1) {
            StringBuilder sb = new StringBuilder();
            String[] ex = nmdStrSimple.toString().split("\t");
            for (int i = 0; i < ex.length - 1; ++i) {
                sb.append(ex[i]);
            }
            String simpleNoLast = sb.toString();
            int lastNmd = Math.max(0, simpleNoLast.length() - 50);
            String points = simpleNoLast.substring(lastNmd) + ex[ex.length - 1];
            String plus = simpleNoLast.substring(0, lastNmd);
            if (debug) {
                System.err.println("\tPoints: " + points + "\n\tPlus :" + plus);
            }
            Assert.assertEquals((int)0, (int)points.replace('.', ' ').trim().length());
            Assert.assertEquals((int)0, (int)plus.replace('+', ' ').trim().length());
        }
    }

    public void test_01() {
        String genomeVer = "testHg3766Chr1";
        Gpr.debug("Loading database '" + genomeVer + "'");
        Config config = new Config(genomeVer, "snpEff.config");
        config.loadSnpEffectPredictor();
        for (Gene gene : config.getGenome().getGenes()) {
            if (verbose) {
                System.err.println("NMD test\tGene ID:" + gene.getId());
            }
            for (Transcript tr : gene) {
                if (debug) {
                    System.err.println(tr);
                }
                this.checkNmd(gene, tr);
            }
        }
    }
}

