/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval.codonChange;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.codonChange.CodonChange;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;

public class CodonChangeSnp
extends CodonChange {
    public CodonChangeSnp(SeqChange seqChange, Transcript transcript, ChangeEffect changeEffect) {
        super(seqChange, transcript, changeEffect);
        this.returnNow = true;
    }

    @Override
    boolean codonChangeSingle(ChangeEffect changeEffect, Exon exon) {
        this.codonsOld = this.codonsOld();
        if (this.codonsOld.isEmpty()) {
            changeEffect.addError(ChangeEffect.ErrorType.ERROR_MISSING_CDS_SEQUENCE);
        }
        this.codonsNew = this.codonsNew();
        changeEffect.set(this.transcript, ChangeEffect.EffectType.CODON_CHANGE, "");
        changeEffect.setCodons(this.codonsOld, this.codonsNew, this.codonNum, this.codonIndex);
        return true;
    }

    @Override
    String codonsNew() {
        if (this.codonsOld.isEmpty()) {
            return "";
        }
        char[] codonChars = this.codonsOld.toLowerCase().toCharArray();
        char snpBase = this.seqChange.netChange(this.transcript.getStrand()).charAt(0);
        codonChars[this.codonIndex] = Character.toUpperCase(snpBase);
        String codonsNew = new String(codonChars);
        return codonsNew;
    }

    @Override
    public String codonsOld() {
        int maxBase;
        int numCodons = 1;
        String cdsStr = this.transcript.cds();
        int cdsLen = cdsStr.length();
        int minBase = this.codonNum * 3;
        if (minBase < 0) {
            minBase = 0;
        }
        if ((maxBase = this.codonNum * 3 + numCodons * 3) > cdsLen) {
            maxBase = cdsLen;
        }
        if (cdsStr.isEmpty() || cdsLen <= minBase) {
            return "";
        }
        char[] codonChars = cdsStr.substring(minBase, maxBase).toLowerCase().toCharArray();
        codonChars[this.codonIndex] = Character.toUpperCase(codonChars[this.codonIndex]);
        String codon = new String(codonChars);
        return codon;
    }
}

