/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.codons.CodonTable;
import ca.mcgill.mcb.pcingola.codons.CodonTables;
import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByEnd;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.interval.Utr;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import java.util.Collections;
import java.util.List;

public class Utr5prime
extends Utr {
    private static final long serialVersionUID = 3710420226746056364L;

    public Utr5prime() {
        this.type = ChangeEffect.EffectType.UTR_5_PRIME;
    }

    public Utr5prime(Exon parent, int start, int end, int strand, String id) {
        super(parent, start, end, strand, id);
        this.type = ChangeEffect.EffectType.UTR_5_PRIME;
    }

    @Override
    public boolean isUtr3prime() {
        return false;
    }

    @Override
    public boolean isUtr5prime() {
        return true;
    }

    @Override
    public List<ChangeEffect> seqChangeEffect(SeqChange seqChange, ChangeEffect changeEffect) {
        if (seqChange.includes(this) && seqChange.getChangeType() == SeqChange.ChangeType.DEL) {
            changeEffect.set(this, ChangeEffect.EffectType.UTR_5_DELETED, "");
            return changeEffect.newList();
        }
        Transcript tint = (Transcript)this.findParent(Transcript.class);
        String utrDistStr = this.utrDistance(seqChange, tint);
        String gained = this.startGained(seqChange, tint);
        if (gained.length() > 0) {
            changeEffect.set(this, ChangeEffect.EffectType.START_GAINED, gained + ", " + (Object)((Object)ChangeEffect.EffectType.UTR_5_PRIME) + ": " + utrDistStr);
        } else {
            changeEffect.set(this, this.type, utrDistStr);
        }
        Exon exon = (Exon)this.findParent(Exon.class);
        if (exon != null) {
            exon.check(seqChange, changeEffect);
        }
        return changeEffect.newList();
    }

    String startGained(char[] chars, int pos) {
        CodonTable ctable = CodonTables.getInstance().getTable(this.getGenome(), this.getChromosomeName());
        for (int i = Math.max(0, pos - 2); i <= pos && i + 2 < chars.length; ++i) {
            String codon = "" + chars[i] + chars[i + 1] + chars[i + 2];
            if (!ctable.isStart(codon)) continue;
            return codon.toUpperCase();
        }
        return "";
    }

    String startGained(SeqChange seqChange, Transcript tint) {
        char snpBase;
        if (!seqChange.isSnp()) {
            return "";
        }
        List<Utr5prime> utrs = tint.get5primeUtrs();
        if (this.strand >= 0) {
            Collections.sort(utrs, new IntervalComparatorByStart());
        } else {
            Collections.sort(utrs, new IntervalComparatorByEnd(true));
        }
        StringBuffer sb = new StringBuffer();
        for (Utr5prime utr : utrs) {
            Exon eint = (Exon)utr.getParent();
            String utrSeq = eint.getSequence().substring(0, utr.getEnd() - utr.getStart() + 1);
            sb.append(utrSeq);
        }
        int pos = seqChange.distanceFrom(utrs, this.strand < 0);
        char[] chars = sb.toString().toCharArray();
        chars[pos] = snpBase = seqChange.netChange(this).charAt(0);
        return this.startGained(chars, pos);
    }

    @Override
    String utrDistance(SeqChange seqChange, Transcript tint) {
        List<Utr5prime> utrs = tint.get5primeUtrs();
        boolean fromEnd = this.strand >= 0;
        int dist = seqChange.distanceFrom(utrs, fromEnd) + 1;
        return dist + " bases from TSS";
    }
}

