/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByEnd;
import ca.mcgill.mcb.pcingola.interval.IntervalComparatorByStart;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.snpEffect.ChangeEffect;
import ca.mcgill.mcb.pcingola.util.GprSeq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SeqChange
extends Marker {
    private static final long serialVersionUID = -2928105165111400441L;
    Boolean heterozygous;
    ChangeType changeType;
    String reference;
    String change;
    String[] changeOptions;
    double quality;
    double score = Double.NaN;
    int coverage;
    boolean imprecise = false;

    public SeqChange(Marker parent, int start, int end, int strand, String id) {
        super(parent, start, end, strand, id);
        this.change = "";
        this.reference = "";
        this.changeType = ChangeType.Interval;
        this.changeOptions = new String[1];
        this.changeOptions[0] = "";
    }

    public SeqChange(Marker parent, int start, int end, String id) {
        super(parent, start, end, 1, id);
        this.change = "";
        this.reference = "";
        this.changeType = ChangeType.Interval;
        this.changeOptions = new String[1];
        this.changeOptions[0] = "";
    }

    public SeqChange(Marker parent, int position, String referenceStr, String changeStr, int strand, String id, double quality, int coverage) {
        super(parent, position, position, strand, id);
        this.init(parent, position, referenceStr, changeStr, strand, id, quality, coverage);
    }

    public String change() {
        return this.strand >= 0 ? this.change : GprSeq.reverseWc(this.change);
    }

    public int distanceFrom(List<? extends Marker> ints, boolean fromEnd) {
        ArrayList<? extends Marker> intsSort = new ArrayList<Marker>();
        intsSort.addAll(ints);
        if (fromEnd) {
            Collections.sort(intsSort, new IntervalComparatorByEnd(true));
        } else {
            Collections.sort(intsSort, new IntervalComparatorByStart());
        }
        int len = 0;
        int latest = 0;
        for (Marker marker : intsSort) {
            if (fromEnd) {
                if (this.intersects(marker)) {
                    return len + (marker.getEnd() - this.start);
                }
                latest = marker.getStart();
            } else {
                if (this.intersects(marker)) {
                    return len + (this.start - marker.getStart());
                }
                latest = marker.getEnd();
            }
            len += marker.getEnd() - marker.getStart();
        }
        return len + (this.start - latest);
    }

    public String getChange() {
        return this.change;
    }

    public String getChangeOption(int i) {
        return this.changeOptions[i];
    }

    public int getChangeOptionCount() {
        return this.changeOptions.length;
    }

    public ChangeType getChangeType() {
        return this.changeType;
    }

    public int getCoverage() {
        return this.coverage;
    }

    public double getQuality() {
        return this.quality;
    }

    public String getReference() {
        return this.reference;
    }

    public double getScore() {
        return this.score;
    }

    public SeqChange getSeqChangeOption(int i) {
        if (this.changeType == ChangeType.Interval) {
            return this;
        }
        if (this.reference.equalsIgnoreCase(this.changeOptions[i])) {
            return null;
        }
        return new SeqChange((Marker)this.parent, this.start, this.reference, this.changeOptions[i], this.strand, this.id, this.quality, this.coverage);
    }

    @Override
    public int getStrand() {
        return this.strand;
    }

    @Override
    public int hashCode() {
        int hashCode = this.getChromosomeName().hashCode();
        hashCode = hashCode * 31 + this.start;
        hashCode = hashCode * 31 + this.end;
        hashCode = hashCode * 31 + this.strand;
        hashCode = hashCode * 31 + this.id.hashCode();
        hashCode = hashCode * 31 + this.reference.hashCode();
        hashCode = hashCode * 31 + this.change.hashCode();
        return hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void init(Marker parent, int position, String referenceStr, String changeStr, int strand, String id, double quality, int coverage) {
        int i;
        this.reference = referenceStr.toUpperCase();
        this.change = changeStr.toUpperCase();
        this.quality = quality;
        this.coverage = coverage;
        this.heterozygous = false;
        this.changeType = ChangeType.MNP;
        if (this.change.length() == 1) {
            this.changeType = ChangeType.SNP;
            if (this.change.equals("A") || this.change.equals("C") || this.change.equals("G") || this.change.equals("T")) {
                this.heterozygous = false;
                this.changeOptions = new String[1];
                this.changeOptions[0] = this.change;
            } else {
                this.heterozygous = true;
                if (this.change.length() == 1) {
                    if (this.change.equals("N")) {
                        this.changeOptions = new String[4];
                        this.changeOptions[0] = "A";
                        this.changeOptions[1] = "C";
                        this.changeOptions[2] = "G";
                        this.changeOptions[3] = "T";
                    } else if (this.change.equals("B")) {
                        this.changeOptions = new String[3];
                        this.changeOptions[0] = "C";
                        this.changeOptions[1] = "G";
                        this.changeOptions[2] = "T";
                    } else if (this.change.equals("D")) {
                        this.changeOptions = new String[3];
                        this.changeOptions[0] = "A";
                        this.changeOptions[1] = "G";
                        this.changeOptions[2] = "T";
                    } else if (this.change.equals("H")) {
                        this.changeOptions = new String[3];
                        this.changeOptions[0] = "A";
                        this.changeOptions[1] = "C";
                        this.changeOptions[2] = "T";
                    } else if (this.change.equals("V")) {
                        this.changeOptions = new String[3];
                        this.changeOptions[0] = "A";
                        this.changeOptions[1] = "C";
                        this.changeOptions[2] = "G";
                    } else if (this.change.equals("M")) {
                        this.changeOptions = new String[2];
                        this.changeOptions[0] = "A";
                        this.changeOptions[1] = "C";
                    } else if (this.change.equals("R")) {
                        this.changeOptions = new String[2];
                        this.changeOptions[0] = "A";
                        this.changeOptions[1] = "G";
                    } else if (this.change.equals("W")) {
                        this.changeOptions = new String[2];
                        this.changeOptions[0] = "A";
                        this.changeOptions[1] = "T";
                    } else if (this.change.equals("S")) {
                        this.changeOptions = new String[2];
                        this.changeOptions[0] = "C";
                        this.changeOptions[1] = "G";
                    } else if (this.change.equals("Y")) {
                        this.changeOptions = new String[2];
                        this.changeOptions[0] = "C";
                        this.changeOptions[1] = "T";
                    } else {
                        if (!this.change.equals("K")) throw new RuntimeException("WARNING: Unkown IUB code for SNP '" + this.change + "'");
                        this.changeOptions = new String[2];
                        this.changeOptions[0] = "G";
                        this.changeOptions[1] = "T";
                    }
                }
            }
        } else {
            this.changeOptions = this.change.indexOf(44) >= 0 ? this.change.split(",") : this.change.split("/");
            if (this.changeOptions.length > 1) {
                this.heterozygous = false;
                for (i = 0; i < this.changeOptions.length - 1; ++i) {
                    this.heterozygous = this.heterozygous | !this.changeOptions[i].equals(this.changeOptions[i + 1]);
                }
            }
            if (!this.heterozygous.booleanValue() && this.changeOptions.length > 1) {
                String[] changeOptionsNew = new String[]{this.changeOptions[0]};
                this.changeOptions = changeOptionsNew;
            }
            if (this.changeOptions[0].equals("*") && this.changeOptions.length > 1) {
                this.changeOptions[0] = this.changeOptions[1];
                this.changeOptions[1] = "*";
                this.change = this.changeOptions[0] + "/" + this.changeOptions[1];
            }
            if (this.change.startsWith("+")) {
                this.changeType = ChangeType.INS;
            } else if (this.change.startsWith("-")) {
                this.changeType = ChangeType.DEL;
                if (this.changeOptions[0].length() > 1) {
                    this.end = position + this.changeOptions[0].length() - 2;
                }
            }
            if (this.changeType == ChangeType.INS || this.changeType == ChangeType.DEL) {
                this.reference = "*";
            }
        }
        this.type = ChangeEffect.EffectType.NONE;
        this.start = position;
        if (this.isIns() || this.isSnp()) {
            this.end = this.start;
            return;
        } else {
            for (i = 0; i < this.changeOptions.length; ++i) {
                String ch = this.changeOptions[i];
                if (ch.startsWith("+") || ch.startsWith("-")) {
                    ch = ch.substring(1);
                }
                this.end = Math.max(this.end, this.start + ch.length() - 1);
            }
        }
    }

    public boolean isChange() {
        for (String chg : this.changeOptions) {
            if (this.reference.equals(chg)) continue;
            return true;
        }
        return false;
    }

    public boolean isDel() {
        return this.changeType == ChangeType.DEL;
    }

    public boolean isHeterozygous() {
        return this.heterozygous != null && this.heterozygous != false;
    }

    public boolean isHomozygous() {
        return this.heterozygous != null && this.heterozygous == false;
    }

    public boolean isImprecise() {
        return this.imprecise;
    }

    public boolean isInDel() {
        return this.changeType == ChangeType.INS || this.changeType == ChangeType.DEL;
    }

    public boolean isIns() {
        return this.changeType == ChangeType.INS;
    }

    public boolean isInterval() {
        return this.changeType == ChangeType.Interval;
    }

    public boolean isMnp() {
        return this.changeType == ChangeType.MNP;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public boolean isSnp() {
        return this.changeType == ChangeType.SNP;
    }

    public String netChange(int referenceStrand) {
        String netChange = this.change;
        if (this.change.startsWith("+") || this.change.startsWith("-")) {
            netChange = this.change.substring(1);
        }
        boolean needRwc = false;
        if (this.strand >= 0 && referenceStrand < 0) {
            needRwc = true;
        } else if (this.strand < 0 && referenceStrand >= 0) {
            needRwc = true;
        }
        return needRwc ? GprSeq.reverseWc(netChange) : netChange;
    }

    public String netChange(Marker marker) {
        int removeAfter;
        int removeBefore;
        String netChange = this.change;
        if (this.change.startsWith("+") || this.change.startsWith("-")) {
            netChange = this.change.substring(1);
        }
        if ((removeBefore = marker.getStart() - this.start) > 0) {
            if (removeBefore >= netChange.length()) {
                return "";
            }
        } else {
            removeBefore = 0;
        }
        if ((removeAfter = this.end - marker.getEnd()) > 0) {
            if (removeBefore + removeAfter >= netChange.length()) {
                return "";
            }
        } else {
            removeAfter = 0;
        }
        if (this.strand <= 0) {
            netChange = GprSeq.reverseWc(netChange);
        }
        netChange = netChange.substring(removeBefore, netChange.length() - removeAfter);
        return netChange;
    }

    public String reference() {
        return this.strand >= 0 ? this.reference : GprSeq.reverseWc(this.reference);
    }

    public void setChangeType(ChangeType changeType) {
        this.changeType = changeType;
    }

    public void setHeterozygous(Boolean heterozygous) {
        this.heterozygous = heterozygous;
    }

    public void setImprecise(boolean imprecise) {
        this.imprecise = imprecise;
    }

    public void setScore(double score) {
        this.score = score;
    }

    @Override
    public String toString() {
        if (this.changeType == ChangeType.Interval) {
            return "chr" + this.getChromosomeName() + ":" + this.start + "-" + this.end;
        }
        return "chr" + this.getChromosomeName() + ":" + this.start + "_" + this.getReference() + "/" + this.getChange() + (this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "");
    }

    public String toStringEnsembl() {
        return this.getChromosomeName() + "\t" + this.start + "\t" + this.end + "\t" + this.reference + "/" + this.change + "\t+";
    }

    public static enum ChangeType {
        SNP,
        MNP,
        INS,
        DEL,
        MIXED,
        Interval;

    }
}

