/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.interval;

import ca.mcgill.mcb.pcingola.interval.Exon;
import ca.mcgill.mcb.pcingola.interval.Gene;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.Marker;
import ca.mcgill.mcb.pcingola.interval.Transcript;
import ca.mcgill.mcb.pcingola.snpEffect.Config;
import ca.mcgill.mcb.pcingola.snpEffect.SnpEffectPredictor;
import ca.mcgill.mcb.pcingola.stats.CountByType;
import ca.mcgill.mcb.pcingola.util.Gpr;
import ca.mcgill.mcb.pcingola.util.Timer;
import java.util.HashMap;

public class ExonSpliceCaracterizer {
    public static final int MAX_EXONS = 1000;
    public static final int SHOW_EVERY = 1000;
    boolean verbose = false;
    Genome genome;
    HashMap<Exon, Exon.ExonSpliceType> typeByExon;
    CountByType countByType = new CountByType();

    public ExonSpliceCaracterizer(Genome genome) {
        this.genome = genome;
        this.typeByExon = new HashMap();
    }

    public ExonSpliceCaracterizer(String genomeVer) {
        Config config = new Config(genomeVer);
        SnpEffectPredictor snpEffectPredictor = config.loadSnpEffectPredictor();
        this.genome = snpEffectPredictor.getGenome();
        this.typeByExon = new HashMap();
    }

    public CountByType caracterize() {
        this.type();
        return this.countByType;
    }

    int countExons() {
        int count = 0;
        for (Gene g : this.genome.getGenes()) {
            for (Transcript tr : g) {
                count += tr.numChilds();
            }
        }
        return count;
    }

    boolean intersectsAnyExon(Marker m, Transcript tr) {
        for (Exon e : tr) {
            if (!m.intersects(e)) continue;
            return true;
        }
        return false;
    }

    boolean isAlt3ss(Exon exon, Gene gene) {
        for (Transcript tr : gene) {
            for (Exon e : tr) {
                if (!exon.intersects(e) || !(exon.isStrandPlus() ? exon.getStart() != e.getStart() && exon.getEnd() == e.getEnd() : exon.getStart() == e.getStart() && exon.getEnd() != e.getEnd())) continue;
                return true;
            }
        }
        return false;
    }

    boolean isAlt5ss(Exon exon, Gene gene) {
        for (Transcript tr : gene) {
            for (Exon e : tr) {
                if (!exon.intersects(e) || !(exon.isStrandPlus() ? exon.getStart() == e.getStart() && exon.getEnd() != e.getEnd() : exon.getStart() != e.getStart() && exon.getEnd() == e.getEnd())) continue;
                return true;
            }
        }
        return false;
    }

    boolean isMutEx(Exon exon, Gene gene) {
        if (gene.numChilds() <= 1) {
            return false;
        }
        String exonKey = this.key(exon);
        HashMap<String, Exon> uniqEx = new HashMap<String, Exon>();
        for (Transcript tr : gene) {
            for (Exon e : tr) {
                String ekey = this.key(e);
                if (exonKey.equals(ekey)) continue;
                uniqEx.put(ekey, e);
            }
        }
        Transcript exonTr = (Transcript)exon.getParent();
        for (Exon e : uniqEx.values()) {
            Exon.ExonSpliceType type = this.typeByExon.get(e);
            if (type != Exon.ExonSpliceType.SKIPPED) continue;
            boolean xor = true;
            for (Transcript tr : gene) {
                if (exonTr.intersects(tr) && exon.intersects(tr) && e.intersects(exonTr)) {
                    xor &= this.intersectsAnyExon(e, tr) ^ this.intersectsAnyExon(exon, tr);
                    continue;
                }
                xor = false;
            }
            if (!xor) continue;
            return true;
        }
        return false;
    }

    String key(Marker m) {
        return m.getChromosomeName() + ":" + m.getStart() + "-" + m.getEnd();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void type() {
        if (this.verbose) {
            Timer.showStdErr("Caracterizing exons by splicing (stage 1) : ");
        }
        int numExon = 1;
        for (Gene g : this.genome.getGenes()) {
            CountByType count = new CountByType();
            for (Transcript tr : g) {
                for (Exon e : tr) {
                    count.inc(this.key(e));
                }
            }
            int countTr = g.numChilds();
            for (Transcript tr : g) {
                for (Exon e : tr) {
                    Gpr.showMark(numExon++, 1000);
                    String eKey = this.key(e);
                    int countEx = (int)count.get(eKey);
                    if (countEx == countTr) {
                        this.type(e, Exon.ExonSpliceType.RETAINED);
                        continue;
                    }
                    if (this.isAlt3ss(e, g)) {
                        this.type(e, Exon.ExonSpliceType.ALTTENATIVE_3SS);
                        continue;
                    }
                    if (this.isAlt5ss(e, g)) {
                        this.type(e, Exon.ExonSpliceType.ALTTENATIVE_5SS);
                        continue;
                    }
                    if (tr.numChilds() <= 1) continue;
                    if (e.getRank() == 1) {
                        this.type(e, Exon.ExonSpliceType.ALTTENATIVE_PROMOMOTER);
                        continue;
                    }
                    if (e.getRank() == tr.numChilds()) {
                        this.type(e, Exon.ExonSpliceType.ALTTENATIVE_POLY_A);
                        continue;
                    }
                    this.type(e, Exon.ExonSpliceType.SKIPPED);
                }
            }
        }
        if (this.verbose) {
            System.err.println("");
            Timer.showStdErr("Caracterizing exons by splicing (stage 2) : ");
        }
        numExon = 1;
        for (Gene g : this.genome.getGenes()) {
            for (Transcript tr : g) {
                if (tr.numChilds() < 1000) {
                    for (Exon e : tr) {
                        Gpr.showMark(numExon++, 1000);
                        Exon.ExonSpliceType type = this.typeByExon.get(e);
                        if (type != Exon.ExonSpliceType.SKIPPED || !this.isMutEx(e, g)) continue;
                        this.type(e, Exon.ExonSpliceType.MUTUALLY_EXCLUSIVE);
                    }
                    continue;
                }
                System.err.println("");
                Gpr.debug("WARNING: Gene '" + g.getId() + "', transcript '" + tr.getId() + "' has too many exons (" + tr.numChilds() + " exons). Skipped");
            }
        }
        if (this.verbose) {
            Timer.showStdErr("done.");
        }
    }

    void type(Exon e, Exon.ExonSpliceType type) {
        e.spliceType = type;
        this.countByType.inc(type.toString());
        this.typeByExon.put(e, type);
    }
}

