/*
 * Decompiled with CFR 0.152.
 */
package ca.mcgill.mcb.pcingola.fileIterator;

import ca.mcgill.mcb.pcingola.fileIterator.SeqChangeFileIterator;
import ca.mcgill.mcb.pcingola.interval.Chromosome;
import ca.mcgill.mcb.pcingola.interval.Genome;
import ca.mcgill.mcb.pcingola.interval.SeqChange;
import ca.mcgill.mcb.pcingola.util.Gpr;
import java.io.IOException;

public class SeqChangeBedFileIterator
extends SeqChangeFileIterator {
    public SeqChangeBedFileIterator(String fileName) {
        super(fileName, 0);
    }

    public SeqChangeBedFileIterator(String fileName, Genome genome, int inOffset) {
        super(fileName, genome, inOffset);
    }

    @Override
    protected SeqChange readNext() {
        try {
            while (this.ready()) {
                int start;
                String[] fields;
                this.line = this.readLine();
                if (this.line == null) {
                    return null;
                }
                if (this.line.length() <= 0 || this.line.startsWith("#") || (fields = this.line.split("\\t")).length < 2) continue;
                String chromosome = fields[0].trim();
                Chromosome chromo = this.getChromosome(chromosome);
                this.sanityCheckChromo(chromosome, chromo);
                int end = start = this.parsePosition(fields[1]);
                if (fields.length > 2) {
                    end = this.parsePosition(fields[2]) - 1;
                }
                if (end < start) {
                    end = start;
                }
                String id = "line_" + this.lineNum;
                if (fields.length > 3 && !fields[3].isEmpty()) {
                    id = fields[3];
                }
                double score = 0.0;
                if (fields.length > 4) {
                    score = Gpr.parseDoubleSafe(fields[4]);
                }
                SeqChange seqChange = new SeqChange(chromo, start, end, id);
                seqChange.setScore(score);
                seqChange.setChromosomeNameOri(chromosome);
                return seqChange;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }
}

