/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.alignment.blast;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojavax.bio.alignment.RemotePairwiseAlignmentProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteQBlastAlignmentProperties
implements RemotePairwiseAlignmentProperties {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> param = new HashMap();

    public String getBlastProgram() {
        return this.param.get("PROGRAM");
    }

    public void setBlastProgram(String program) throws BioException {
        boolean isValid = false;
        Object[] blastPr = new String[]{"blastn", "blastp", "blastx", "tblastn", "tblastx"};
        if (Arrays.binarySearch(blastPr, program) >= 0) {
            isValid = true;
        }
        if (!isValid) {
            throw new BioException("Invalid blastall program selection! Use one of valid values: blastn/blastp/blastx/tblastn/tblastx");
        }
    }

    public String getBlastDatabase() {
        return this.param.get("DATABASE");
    }

    public void setBlastDatabase(String db) {
        this.param.put("DATABASE", db);
    }

    public void setAdvancedOptions(String aStr) {
        this.param.put("OTHER_ADVANCED", "OTHER_ADVANCED=" + aStr);
    }

    public String getBlastAdvancedOptions() {
        return this.param.get("OTHER_ADVANCED");
    }

    @Override
    public String getAlignmentOption(String key) throws BioException {
        if (this.param.containsKey(key)) {
            return this.param.get(key);
        }
        throw new BioException("The key named " + key + " is not set in this RemoteQBlastOutputProperties object");
    }

    @Override
    public void setAlignementOption(String key, String val) {
        this.param.put(key, val);
    }

    @Override
    public Set<String> getAlignmentOptions() {
        return this.param.keySet();
    }
}

