/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.biojava.bio.Annotatable;
import org.biojava.ontology.Term;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Note;
import org.biojavax.RichAnnotation;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNote;
import org.biojavax.ontology.ComparableTerm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRichAnnotation
extends AbstractChangeable
implements RichAnnotation {
    private Set<Note> notes = new TreeSet<Note>();

    @Override
    public void clear() throws ChangeVetoException {
        Iterator<Note> i = new ArrayList<Note>(this.notes).iterator();
        while (i.hasNext()) {
            this.removeNote(i.next());
        }
    }

    @Override
    public Map asMap() {
        TreeMap<ComparableTerm, String> m = new TreeMap<ComparableTerm, String>();
        for (Note n : this.notes) {
            m.put(n.getTerm(), n.getValue());
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNote(Note note) throws ChangeVetoException {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null");
        }
        if (!this.hasListeners(Annotatable.ANNOTATION)) {
            this.notes.add(note);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Annotatable.ANNOTATION, note, null);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Annotatable.ANNOTATION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                boolean change = this.notes.add(note);
                if (!change) {
                    Note current2 = null;
                    for (Note current2 : this.notes) {
                        if (note.equals(current2)) break;
                    }
                    SimpleNote clone = new SimpleNote(current2.getTerm(), current2.getValue(), current2.getRank());
                    current2.setValue(note.getValue());
                    ce = new ChangeEvent(this, Annotatable.ANNOTATION, current2, clone);
                }
                cs.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public boolean contains(Note note) {
        return this.notes.contains(note);
    }

    @Override
    public boolean containsProperty(Object key) {
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        for (Note n : this.notes) {
            if (!n.getTerm().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Note getNote(Note note) throws NoSuchElementException {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null");
        }
        for (Note n : this.notes) {
            if (!note.equals(n)) continue;
            return n;
        }
        throw new NoSuchElementException("No such property: " + note.getTerm() + ", rank " + note.getRank());
    }

    @Override
    public Object getProperty(Object key) throws NoSuchElementException {
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        for (Note n : this.notes) {
            if (!n.getTerm().equals(key)) continue;
            return n.getValue();
        }
        throw new NoSuchElementException("No such property: " + key);
    }

    @Override
    public Note[] getProperties(Object key) {
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        LinkedList<Note> l = new LinkedList<Note>();
        for (Note n : this.notes) {
            if (!n.getTerm().equals(key)) continue;
            l.add(n);
        }
        Collections.sort(l);
        Note[] na = new Note[l.size()];
        l.toArray(na);
        return na;
    }

    @Override
    public Set keys() {
        return this.asMap().keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNote(Note note) throws ChangeVetoException {
        if (note == null) {
            throw new IllegalArgumentException("Note cannot be null");
        }
        if (!this.hasListeners(Annotatable.ANNOTATION)) {
            this.notes.remove(note);
        } else {
            ChangeSupport cs;
            ChangeEvent ce = new ChangeEvent(this, Annotatable.ANNOTATION, null, note);
            ChangeSupport changeSupport = cs = this.getChangeSupport(Annotatable.ANNOTATION);
            synchronized (changeSupport) {
                cs.firePreChangeEvent(ce);
                boolean removed = this.notes.remove(note);
                if (!removed) {
                    ce = new ChangeEvent(this, Annotatable.ANNOTATION, null, null);
                }
                cs.firePostChangeEvent(ce);
            }
        }
    }

    @Override
    public void removeProperty(Object key) throws NoSuchElementException, ChangeVetoException {
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        for (Note n : this.notes) {
            if (!n.getTerm().equals(key)) continue;
            this.removeNote(n);
            return;
        }
        throw new NoSuchElementException("No such property: " + key);
    }

    @Override
    public void setProperty(Object key, Object value) throws IllegalArgumentException, ChangeVetoException {
        if (key == null) {
            throw new IllegalArgumentException("Property keys cannot be null");
        }
        key = key instanceof Term ? RichObjectFactory.getDefaultOntology().getOrImportTerm((Term)key) : RichObjectFactory.getDefaultOntology().getOrCreateTerm(key.toString());
        this.addNote(new SimpleNote((ComparableTerm)key, (String)(value == null ? value : value.toString()), 0));
    }

    @Override
    public Set<Note> getNoteSet() {
        return this.notes;
    }

    @Override
    public void setNoteSet(Set<Note> notes) throws ChangeVetoException {
        this.notes = notes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator<Note> i = this.notes.iterator();
        while (i.hasNext()) {
            sb.append("[");
            sb.append(i.next());
            sb.append("]");
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

