/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.util.test;

import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.util.Pipeline;
import edu.mayo.pipes.history.History;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.Assert;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

public class PipeTestUtils {
    public static List<String> getResults(Pipe pipe) {
        ArrayList<String> results = new ArrayList<String>();
        while (pipe.hasNext()) {
            Object obj = pipe.next();
            if (obj instanceof String) {
                results.add((String)obj);
                continue;
            }
            if (obj instanceof History) {
                results.add(((History)obj).getMergedData("\t"));
                continue;
            }
            results.add(obj.toString());
        }
        return results;
    }

    @Deprecated
    public static List<String> pipeOutputToStrings(Pipe<History, History> pipe) {
        ArrayList<String> lines = new ArrayList<String>();
        while (pipe.hasNext()) {
            History history = (History)pipe.next();
            lines.add(history.getMergedData("\t"));
        }
        return lines;
    }

    @Deprecated
    public static List<String> pipeOutputToStrings2(Pipe<Object, String> pipe) {
        ArrayList<String> lines = new ArrayList<String>();
        while (pipe.hasNext()) {
            String str = (String)pipe.next();
            lines.add(str);
        }
        return lines;
    }

    public static void printLines(List<String> lines) {
        for (String s : lines) {
            System.out.println(s);
        }
    }

    public static void assertListsEqual(List<String> expected, List<String> actual, boolean isIgnorePaths, boolean isExactStringMatch) {
        int smallestSize = Math.min(expected.size(), actual.size());
        if (expected.size() != actual.size()) {
            System.out.println("Expected size (" + expected.size() + ") does not match actual size (" + actual.size() + ") - comparing up to lowest # of lines:");
        }
        for (int i = 0; i < smallestSize; ++i) {
            String actualStr;
            String expectedStr = isIgnorePaths ? PipeTestUtils.wipePath(expected.get(i)) : expected.get(i);
            String string = actualStr = isIgnorePaths ? PipeTestUtils.wipePath(actual.get(i)) : actual.get(i);
            if (expectedStr == null && actualStr == null) continue;
            Assert.assertTrue((String)("One of the rows is null while the other is not.\nExpected: " + expectedStr + "\nActual:   " + actualStr), (expectedStr != null && actualStr != null ? 1 : 0) != 0);
            String[] expectedRow = expectedStr.split("\t");
            String[] actualRow = actualStr.split("\t");
            Assert.assertEquals((String)("Row does not have the same number of columns\nExpected: " + expectedStr + "\nActual:   " + actualStr), (long)expectedRow.length, (long)actualRow.length);
            for (int j = 0; j < expectedRow.length; ++j) {
                String errMsg = "Column[" + j + "] differs\n  Expected: " + expectedRow[j] + "\n  Actual:   " + actualRow[j] + ") is not the same\nRows\n  Expected: " + expectedStr + "\n  Actual:   " + actualStr;
                PipeTestUtils.assertColumnEqual(errMsg, expectedRow[j], actualRow[j], isExactStringMatch);
            }
        }
        Assert.assertEquals((String)"Array sizes are not equal!", (long)expected.size(), (long)actual.size());
    }

    private static void assertColumnEqual(String errMsg, String expectedCol, String actualCol, boolean isExactStringMatch) {
        try {
            if (!isExactStringMatch && PipeTestUtils.isJson(actualCol)) {
                JSONAssert.assertEquals((String)expectedCol, (String)actualCol, (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
            } else {
                Assert.assertEquals((Object)expectedCol, (Object)actualCol);
            }
        }
        catch (Throwable e) {
            Assert.fail((String)("Exception thrown when trying to assert JSON equality.\n" + errMsg));
        }
    }

    public static void assertListsEqual(List<String> expected, List<String> actual) {
        PipeTestUtils.assertListsEqual(expected, actual, false, false);
    }

    public static void assertListsEqualExactStringMatch(List<String> expected, List<String> actual) {
        PipeTestUtils.assertListsEqual(expected, actual, false, true);
    }

    public static boolean isJson(String str) {
        try {
            new JSONObject(str);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(str);
            }
            catch (JSONException ex2) {
                return false;
            }
        }
        return true;
    }

    public static String wipePath(String line) {
        String PATH = "Path=\"";
        if (line != null && line.startsWith("##") && line.contains("Path=\"")) {
            int start = line.indexOf("Path=\"");
            int end = line.indexOf("\"", start + "Path=\"".length());
            return line.substring(0, start + "Path=\"".length()) + line.substring(end);
        }
        return line;
    }

    public static void walkPipeline(Pipeline pipeline, int depth) {
        List pipes = pipeline.getPipes();
        for (Pipe pipe : pipes) {
            if (pipe instanceof Pipeline) {
                PipeTestUtils.walkPipeline((Pipeline)pipe, depth + 1);
                continue;
            }
            System.out.println(PipeTestUtils.getDepthSpaces(depth) + pipe.getClass().getCanonicalName());
        }
    }

    private static String getDepthSpaces(int depth) {
        StringBuilder str = new StringBuilder();
        while (str.length() < depth) {
            str.append("\t");
        }
        return str.toString();
    }

    public static List<String> toListStr(String[][] lines) {
        ArrayList<String> lineList = new ArrayList<String>();
        for (int i = 0; i < lines.length; ++i) {
            lineList.add(PipeTestUtils.combine(lines[i], "\t"));
        }
        return lineList;
    }

    public static String combine(String[] line, String DELIM) {
        StringBuilder str = new StringBuilder();
        for (int j = 0; j < line.length; ++j) {
            str.append(j > 0 ? DELIM : "");
            str.append(line[j]);
        }
        return str.toString();
    }
}

