/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import edu.mayo.pipes.bioinformatics.HeaderFieldDefinitionHelpers;
import edu.mayo.pipes.bioinformatics.KeyValueHeaderPair;
import edu.mayo.pipes.bioinformatics.MetaHeader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SampleHeader {
    private String id;
    private String originalLine;
    private List<KeyValueHeaderPair> keyValPairs = new ArrayList<KeyValueHeaderPair>();
    protected String PREFIX = "##SAMPLE";

    public void createFromString(String sampleHeaderLine) throws UnsupportedEncodingException {
        if (!sampleHeaderLine.startsWith(this.PREFIX + "=<") && !sampleHeaderLine.endsWith(">")) {
            throw new IllegalArgumentException("Invalid " + this.PREFIX + " line.  Format should be: " + this.PREFIX + "=<....>");
        }
        this.originalLine = sampleHeaderLine;
        this.id = null;
        this.keyValPairs = new ArrayList<KeyValueHeaderPair>();
        sampleHeaderLine = sampleHeaderLine.substring(this.PREFIX.length() + 2, sampleHeaderLine.length() - 1);
        List<String> keyVals = HeaderFieldDefinitionHelpers.splitHandleQuotes(sampleHeaderLine, ",");
        for (String keyValStr : keyVals) {
            KeyValueHeaderPair keyValPair = new KeyValueHeaderPair();
            int eqIdx = keyValStr.indexOf("=");
            if (eqIdx == -1) {
                keyValPair.key = keyValStr;
                keyValPair.valueType = HeaderFieldDefinitionHelpers.ValueType.Flag;
            } else {
                keyValPair.key = keyValStr.substring(0, eqIdx);
                String rightOfEq = "";
                if (eqIdx < keyValStr.length()) {
                    rightOfEq = keyValStr.substring(eqIdx + 1);
                }
                keyValPair.values = HeaderFieldDefinitionHelpers.splitHandleQuotes(rightOfEq, ";");
                for (int i = 0; i < keyValPair.values.size(); ++i) {
                    keyValPair.values.set(i, HeaderFieldDefinitionHelpers.decodeSpecialChars(HeaderFieldDefinitionHelpers.stripQuotes(keyValPair.values.get(i))));
                }
            }
            if ("ID".equalsIgnoreCase(keyValPair.key) && keyValPair.values.size() > 0) {
                this.id = keyValPair.values.get(0);
            }
            this.keyValPairs.add(keyValPair);
        }
    }

    public String getOriginalLine() {
        return this.originalLine;
    }

    public String getId() {
        KeyValueHeaderPair idKeyValPair = this.getKeyValuePair("ID");
        if (idKeyValPair != null && idKeyValPair.values.size() > 0) {
            return idKeyValPair.values.get(0);
        }
        return "";
    }

    public void setKeyValuePairs(List<KeyValueHeaderPair> keyValPairsList) {
        this.keyValPairs = keyValPairsList;
    }

    public List<KeyValueHeaderPair> getKeyValuePairs() {
        return this.keyValPairs;
    }

    public KeyValueHeaderPair getKeyValuePair(String key) {
        for (int i = 0; i < this.keyValPairs.size(); ++i) {
            if (!key.equalsIgnoreCase(this.keyValPairs.get((int)i).key)) continue;
            return this.keyValPairs.get(i);
        }
        return null;
    }

    public void setTypesFromMeta(Map<String, MetaHeader> metaDefs) {
        if (metaDefs == null) {
            return;
        }
        for (KeyValueHeaderPair keyValPair : this.keyValPairs) {
            if ("ID".equalsIgnoreCase(keyValPair.key)) {
                keyValPair.valueType = HeaderFieldDefinitionHelpers.ValueType.String;
                continue;
            }
            if (!metaDefs.containsKey(keyValPair.key) || metaDefs.get(keyValPair.key) == null) continue;
            keyValPair.valueType = metaDefs.get(keyValPair.key).getType();
        }
    }
}

