/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes.bioinformatics;

import edu.mayo.pipes.bioinformatics.HeaderFieldDefinition;
import edu.mayo.pipes.bioinformatics.HeaderFieldDefinitionHelpers;
import edu.mayo.pipes.bioinformatics.KeyValueHeaderPair;
import edu.mayo.pipes.bioinformatics.VCFParseException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class MetaHeader
extends HeaderFieldDefinition {
    public List<String> values = new ArrayList<String>();

    public MetaHeader() {
        this.fieldType = "META";
        this.requiredFields = Arrays.asList("ID", "Type", "Number");
    }

    public void createFromString(String metaHeaderLine) throws VCFParseException, UnsupportedEncodingException {
        this.originalLine = metaHeaderLine;
        this.verifyLine(metaHeaderLine);
        String PREFIX = "##" + this.fieldType + "=<";
        metaHeaderLine = metaHeaderLine.substring(PREFIX.length(), metaHeaderLine.length() - 1);
        int idxStart = metaHeaderLine.indexOf(",Values=[");
        int idxEnd = metaHeaderLine.indexOf("]", idxStart);
        if (idxStart != -1 && idxEnd != -1) {
            String valuesArray = metaHeaderLine.substring(idxStart + 9, idxEnd);
            this.values = HeaderFieldDefinitionHelpers.trim(HeaderFieldDefinitionHelpers.splitHandleQuotes(valuesArray, ","));
            for (int i = 0; i < this.values.size(); ++i) {
                this.values.set(i, HeaderFieldDefinitionHelpers.decodeSpecialChars(this.values.get(i)));
            }
            metaHeaderLine = metaHeaderLine.substring(0, idxStart) + metaHeaderLine.substring(idxEnd + 1);
        }
        Map<String, KeyValueHeaderPair> keyValPairMap = HeaderFieldDefinitionHelpers.getKeyValuePairsFromString(metaHeaderLine);
        this.id = this.getFirstVal(keyValPairMap.get("ID"));
        this.type = HeaderFieldDefinitionHelpers.parseType(this.getFirstVal(keyValPairMap.get("Type")));
        this.number = HeaderFieldDefinitionHelpers.parseNumber(this.getFirstVal(keyValPairMap.get("Number")), this.type);
        this.desc = this.stripQuotesAndUnescape(this.getFirstVal(keyValPairMap.get("Description")), true);
    }

    private void verifyLine(String metaHeaderLine) {
        if (!metaHeaderLine.startsWith("##" + this.fieldType + "=<") && !metaHeaderLine.endsWith(">")) {
            throw new IllegalArgumentException("Invalid ##" + this.fieldType + " line.  Format should be: ##" + this.fieldType + "=<....>\n" + "Example:  ##META=<ID=Ethnicity,Type=String,Number=.,Values=[AFR, CEU, ASN, MEX]>");
        }
        for (String requiredField : this.requiredFields) {
            if (metaHeaderLine.contains("=<" + requiredField + "=") || metaHeaderLine.contains("," + requiredField + "=")) continue;
            throw new IllegalArgumentException("Invalid ##" + this.fieldType + " line.  These fields are required: " + this.requiredFields.toString());
        }
    }
}

