/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.pipes;

import com.tinkerpop.pipes.AbstractPipe;
import edu.mayo.pipes.history.History;
import java.util.List;
import java.util.NoSuchElementException;

public class ChunkPipe<S>
extends AbstractPipe<S, S> {
    private long mCurrentLine = 0L;
    private long mStart = 1L;
    private long mEnd = -1L;
    private boolean mIsIncludeHeader = true;

    public ChunkPipe(long startDataLine) {
        this(startDataLine, -1L, true);
    }

    public ChunkPipe(long startDataLine, long endDataLine) {
        this(startDataLine, endDataLine, true);
    }

    public ChunkPipe(long startDataLine, long endDataLine, boolean isIncludeHeader) {
        this.mStart = startDataLine;
        this.mEnd = endDataLine;
        this.mIsIncludeHeader = isIncludeHeader;
        String errMsg = null;
        if (endDataLine != -1L && endDataLine < startDataLine) {
            errMsg = "ChunkPipe: Start line must be before (or equal to) end line";
        }
        if (startDataLine < 1L) {
            errMsg = "ChunkPipe: Start line must be >= 1";
        }
        if (endDataLine < 1L && endDataLine != -1L) {
            errMsg = "ChunkPipe: End line must be >= 1 (or -1, or unspecified to read to end of lines)";
        }
        if (errMsg != null) {
            System.err.println(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
    }

    protected S processNextStart() throws NoSuchElementException {
        Object line = this.starts.next();
        while (this.isHeader(line)) {
            if (this.mIsIncludeHeader) {
                return (S)line;
            }
            line = this.starts.next();
        }
        ++this.mCurrentLine;
        while (this.mCurrentLine < this.mStart) {
            ++this.mCurrentLine;
            line = this.starts.next();
        }
        if (this.mEnd != -1L && this.mCurrentLine > this.mEnd) {
            throw new NoSuchElementException("Have reach the specified end line.  Stopping.");
        }
        return (S)line;
    }

    private boolean isHeader(S line) {
        if (line instanceof History) {
            return ((String)((History)line).get(0)).startsWith("#");
        }
        if (line instanceof List) {
            return ((String)((List)line).get(0)).startsWith("#");
        }
        if (line instanceof String) {
            return ((String)line).startsWith("#");
        }
        return false;
    }

    public long getCurrentLineNumber() {
        return this.mCurrentLine;
    }
}

