/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.senders;

import edu.mayo.senders.Sender;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public class SystemOutSender
implements Sender {
    protected Logger log = Logger.getLogger(SystemOutSender.class);
    private PrintStream stdout = System.out;
    private PrintStream stderr = System.err;
    private String location = "stdout";

    public SystemOutSender(String location) {
        this.setLocation(location);
    }

    protected void setStdout(PrintStream stream) {
        this.stdout = stream;
    }

    protected void setStderr(PrintStream stream) {
        this.stderr = stream;
    }

    public void setLocation(String location) {
        this.location = location.equalsIgnoreCase("error") || location.equalsIgnoreCase("err") || location.equalsIgnoreCase("stderr") ? "stderr" : (location.equalsIgnoreCase("out") || location.equalsIgnoreCase("stdout") ? "stdout" : "log4j");
    }

    public void write(String message) {
        if (this.location.equalsIgnoreCase("stdout")) {
            this.stdout.println(message);
        } else if (this.location.equalsIgnoreCase("stderr")) {
            this.stderr.println(message);
        } else {
            this.log.info((Object)message);
        }
    }

    public void close() {
    }
}

