/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.tabix;

import htsjdk.tribble.TribbleException;

public class TabixFormat
implements Cloneable {
    public static final int ZERO_BASED = 65536;
    public static final int GENERIC_FLAGS = 0;
    public static final int SAM_FLAGS = 1;
    public static final int VCF_FLAGS = 2;
    public static final int UCSC_FLAGS = 65536;
    public static TabixFormat GFF = new TabixFormat(0, 1, 4, 5, '#', 0);
    public static TabixFormat BED = new TabixFormat(65536, 1, 2, 3, '#', 0);
    public static TabixFormat PSLTBL = new TabixFormat(65536, 15, 17, 18, '#', 0);
    public static TabixFormat SAM = new TabixFormat(1, 3, 4, 0, '@', 0);
    public static TabixFormat VCF = new TabixFormat(2, 1, 2, 0, '#', 0);
    public int flags;
    public int sequenceColumn;
    public int startPositionColumn;
    public int endPositionColumn;
    public char metaCharacter;
    public int numHeaderLinesToSkip;

    public TabixFormat() {
    }

    public TabixFormat(int n, int n2, int n3, int n4, char c, int n5) {
        this.flags = n;
        this.sequenceColumn = n2;
        this.startPositionColumn = n3;
        this.endPositionColumn = n4;
        this.metaCharacter = c;
        this.numHeaderLinesToSkip = n5;
    }

    public TabixFormat clone() {
        try {
            return (TabixFormat)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new TribbleException("unpossible!");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TabixFormat tabixFormat = (TabixFormat)object;
        if (this.endPositionColumn != tabixFormat.endPositionColumn) {
            return false;
        }
        if (this.flags != tabixFormat.flags) {
            return false;
        }
        if (this.metaCharacter != tabixFormat.metaCharacter) {
            return false;
        }
        if (this.numHeaderLinesToSkip != tabixFormat.numHeaderLinesToSkip) {
            return false;
        }
        if (this.sequenceColumn != tabixFormat.sequenceColumn) {
            return false;
        }
        return this.startPositionColumn == tabixFormat.startPositionColumn;
    }

    public int hashCode() {
        int n = this.flags;
        n = 31 * n + this.sequenceColumn;
        n = 31 * n + this.startPositionColumn;
        n = 31 * n + this.endPositionColumn;
        n = 31 * n + this.metaCharacter;
        n = 31 * n + this.numHeaderLinesToSkip;
        return n;
    }
}

