/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.tribble.index.interval;

import htsjdk.tribble.Feature;
import htsjdk.tribble.index.Index;
import htsjdk.tribble.index.TribbleIndexCreator;
import htsjdk.tribble.index.interval.IntervalTreeIndex;
import htsjdk.tribble.index.interval.MutableInterval;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;

public class IntervalIndexCreator
extends TribbleIndexCreator {
    public static int DEFAULT_FEATURE_COUNT = 600;
    private int featuresPerInterval = DEFAULT_FEATURE_COUNT;
    private final LinkedList<IntervalTreeIndex.ChrIndex> chrList = new LinkedList();
    private int featureCount = 0;
    private final ArrayList<MutableInterval> intervals = new ArrayList();
    File inputFile;

    public IntervalIndexCreator(File file, int n) {
        this.inputFile = file;
        this.featuresPerInterval = n;
    }

    public IntervalIndexCreator(File file) {
        this(file, DEFAULT_FEATURE_COUNT);
    }

    @Override
    public void addFeature(Feature feature, long l) {
        if (this.chrList.size() == 0 || !this.chrList.getLast().getName().equals(feature.getChr())) {
            if (this.chrList.size() != 0) {
                this.addIntervalsToLastChr(l);
            }
            this.chrList.add(new IntervalTreeIndex.ChrIndex(feature.getChr()));
            this.intervals.clear();
        }
        if (this.featureCount >= this.featuresPerInterval || this.intervals.size() == 0) {
            MutableInterval mutableInterval = new MutableInterval();
            mutableInterval.setStart(feature.getStart());
            mutableInterval.setStartFilePosition(l);
            if (this.intervals.size() > 0) {
                this.intervals.get(this.intervals.size() - 1).setEndFilePosition(l);
            }
            this.featureCount = 0;
            this.intervals.add(mutableInterval);
        }
        this.intervals.get(this.intervals.size() - 1).setStop(Math.max(feature.getEnd(), this.intervals.get(this.intervals.size() - 1).getStop()));
        ++this.featureCount;
    }

    private void addIntervalsToLastChr(long l) {
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (i == this.intervals.size() - 1) {
                this.intervals.get(i).setEndFilePosition(l);
            }
            this.chrList.getLast().insert(this.intervals.get(i).toInterval());
        }
    }

    @Override
    public Index finalizeIndex(long l) {
        IntervalTreeIndex intervalTreeIndex = new IntervalTreeIndex(this.inputFile.getAbsolutePath());
        this.addIntervalsToLastChr(l);
        intervalTreeIndex.setChrIndex(this.chrList);
        intervalTreeIndex.addProperties(this.properties);
        intervalTreeIndex.finalizeIndex();
        return intervalTreeIndex;
    }

    public int getFeaturesPerInterval() {
        return this.featuresPerInterval;
    }
}

