/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.Locatable;
import java.util.Collection;

public class Interval
implements Comparable<Interval>,
Cloneable,
Locatable {
    private final boolean negativeStrand;
    private final String name;
    private final String contig;
    private final int start;
    private final int end;

    public Interval(String string, int n, int n2) {
        this(string, n, n2, false, null);
    }

    public Interval(String string, int n, int n2, boolean bl, String string2) {
        this.contig = string;
        this.start = n;
        this.end = n2;
        this.negativeStrand = bl;
        this.name = string2;
    }

    @Deprecated
    public String getSequence() {
        return this.getContig();
    }

    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    public boolean isPositiveStrand() {
        return !this.negativeStrand;
    }

    public String getName() {
        return this.name;
    }

    public boolean intersects(Interval interval) {
        return this.getContig().equals(interval.getContig()) && CoordMath.overlaps(this.getStart(), this.getEnd(), interval.getStart(), interval.getEnd());
    }

    public int getIntersectionLength(Interval interval) {
        if (this.intersects(interval)) {
            return CoordMath.getOverlap(this.getStart(), this.getEnd(), interval.getStart(), interval.getEnd());
        }
        return 0;
    }

    public Interval intersect(Interval interval) {
        if (!this.intersects(interval)) {
            throw new IllegalArgumentException(interval + " does not intersect " + this);
        }
        return new Interval(this.getContig(), Math.max(this.getStart(), interval.getStart()), Math.min(this.getEnd(), interval.getEnd()), this.negativeStrand, this.name + " intersection " + interval.name);
    }

    public boolean abuts(Interval interval) {
        return this.getContig().equals(interval.getContig()) && (this.getStart() == interval.getEnd() + 1 || interval.getStart() == this.getEnd() + 1);
    }

    public int length() {
        return this.getEnd() - this.getStart() + 1;
    }

    public Interval pad(int n, int n2) {
        return new Interval(this.getContig(), this.getStart() - n, this.getEnd() + n2, this.negativeStrand, this.name);
    }

    public static long countBases(Collection<Interval> collection) {
        long l = 0L;
        for (Interval interval : collection) {
            l += (long)interval.length();
        }
        return l;
    }

    @Override
    public int compareTo(Interval interval) {
        if (interval == null) {
            return -1;
        }
        int n = this.getContig().compareTo(interval.getContig());
        if (n == 0) {
            n = this.getStart() == interval.getStart() ? this.getEnd() - interval.getEnd() : this.getStart() - interval.getStart();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Interval)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Interval interval = (Interval)object;
        return this.compareTo(interval) == 0;
    }

    public int hashCode() {
        int n = this.getContig().hashCode();
        n = 31 * n + this.getStart();
        n = 31 * n + this.getEnd();
        return n;
    }

    public String toString() {
        return this.getContig() + ":" + this.getStart() + "-" + this.getEnd() + "\t" + (this.negativeStrand ? (char)'-' : '+') + "\t" + (null == this.name ? Character.valueOf('.') : this.name);
    }

    public Interval clone() {
        try {
            return (Interval)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SAMException("That's unpossible", cloneNotSupportedException);
        }
    }

    @Override
    public String getContig() {
        return this.contig;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }
}

