/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.BinaryCodec;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.BlockCompressedStreamConstants;
import htsjdk.samtools.util.LocationAware;
import htsjdk.samtools.util.zip.DeflaterFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;

public class BlockCompressedOutputStream
extends OutputStream
implements LocationAware {
    private static int defaultCompressionLevel = BlockCompressedStreamConstants.DEFAULT_COMPRESSION_LEVEL;
    private final BinaryCodec codec;
    private final byte[] uncompressedBuffer = new byte[65498];
    private int numUncompressedBytes = 0;
    private final byte[] compressedBuffer = new byte[65518];
    private final Deflater deflater;
    private final Deflater noCompressionDeflater = new Deflater(0, true);
    private final CRC32 crc32 = new CRC32();
    private File file = null;
    private long mBlockAddress = 0L;
    private final byte[] singleByteArray = new byte[1];

    public static void setDefaultCompressionLevel(int n) {
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("Invalid compression level: " + n);
        }
        defaultCompressionLevel = n;
    }

    public static int getDefaultCompressionLevel() {
        return defaultCompressionLevel;
    }

    public BlockCompressedOutputStream(String string) {
        this(string, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(File file) {
        this(file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(String string, int n) {
        this(new File(string), n);
    }

    public BlockCompressedOutputStream(File file, int n) {
        this.file = file;
        this.codec = new BinaryCodec(file, true);
        this.deflater = DeflaterFactory.makeDeflater(n, true);
    }

    public BlockCompressedOutputStream(OutputStream outputStream, File file) {
        this(outputStream, file, defaultCompressionLevel);
    }

    public BlockCompressedOutputStream(OutputStream outputStream, File file, int n) {
        this.file = file;
        this.codec = new BinaryCodec(outputStream);
        if (file != null) {
            this.codec.setOutputFileName(file.getAbsolutePath());
        }
        this.deflater = DeflaterFactory.makeDeflater(n, true);
    }

    public static BlockCompressedOutputStream maybeBgzfWrapOutputStream(File file, OutputStream outputStream) {
        if (!(outputStream instanceof BlockCompressedOutputStream)) {
            return new BlockCompressedOutputStream(outputStream, file);
        }
        return (BlockCompressedOutputStream)outputStream;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        assert (this.numUncompressedBytes < this.uncompressedBuffer.length);
        while (n2 > 0) {
            int n3 = Math.min(this.uncompressedBuffer.length - this.numUncompressedBytes, n2);
            System.arraycopy(byArray, n, this.uncompressedBuffer, this.numUncompressedBytes, n3);
            this.numUncompressedBytes += n3;
            n += n3;
            assert ((n2 -= n3) >= 0);
            if (this.numUncompressedBytes != this.uncompressedBuffer.length) continue;
            this.deflateBlock();
        }
    }

    @Override
    public void flush() throws IOException {
        while (this.numUncompressedBytes > 0) {
            this.deflateBlock();
        }
        this.codec.getOutputStream().flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.codec.writeBytes(BlockCompressedStreamConstants.EMPTY_GZIP_BLOCK);
        this.codec.close();
        if (this.file == null || !this.file.isFile()) {
            return;
        }
        if (BlockCompressedInputStream.checkTermination(this.file) != BlockCompressedInputStream.FileTermination.HAS_TERMINATOR_BLOCK) {
            throw new IOException("Terminator block not found after closing BGZF file " + this.file);
        }
    }

    @Override
    public void write(int n) throws IOException {
        this.singleByteArray[0] = (byte)n;
        this.write(this.singleByteArray);
    }

    public long getFilePointer() {
        return BlockCompressedFilePointerUtil.makeFilePointer(this.mBlockAddress, this.numUncompressedBytes);
    }

    @Override
    public long getPosition() {
        return this.getFilePointer();
    }

    private int deflateBlock() {
        if (this.numUncompressedBytes == 0) {
            return 0;
        }
        int n = this.numUncompressedBytes;
        this.deflater.reset();
        this.deflater.setInput(this.uncompressedBuffer, 0, n);
        this.deflater.finish();
        int n2 = this.deflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
        if (!this.deflater.finished()) {
            this.noCompressionDeflater.reset();
            this.noCompressionDeflater.setInput(this.uncompressedBuffer, 0, n);
            this.noCompressionDeflater.finish();
            n2 = this.noCompressionDeflater.deflate(this.compressedBuffer, 0, this.compressedBuffer.length);
            if (!this.noCompressionDeflater.finished()) {
                throw new IllegalStateException("unpossible");
            }
        }
        this.crc32.reset();
        this.crc32.update(this.uncompressedBuffer, 0, n);
        int n3 = this.writeGzipBlock(n2, n, this.crc32.getValue());
        assert (n <= this.numUncompressedBytes);
        if (n == this.numUncompressedBytes) {
            this.numUncompressedBytes = 0;
        } else {
            System.arraycopy(this.uncompressedBuffer, n, this.uncompressedBuffer, 0, this.numUncompressedBytes - n);
            this.numUncompressedBytes -= n;
        }
        this.mBlockAddress += (long)n3;
        return n3;
    }

    private int writeGzipBlock(int n, int n2, long l) {
        this.codec.writeByte((byte)31);
        this.codec.writeByte(139);
        this.codec.writeByte((byte)8);
        this.codec.writeByte(4);
        this.codec.writeInt(0);
        this.codec.writeByte(0);
        this.codec.writeByte(255);
        this.codec.writeShort((short)6);
        this.codec.writeByte((byte)66);
        this.codec.writeByte((byte)67);
        this.codec.writeShort((short)2);
        int n3 = n + 18 + 8;
        this.codec.writeShort((short)(n3 - 1));
        this.codec.writeBytes(this.compressedBuffer, 0, n);
        this.codec.writeInt((int)l);
        this.codec.writeInt(n2);
        return n3;
    }
}

