/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

import htsjdk.samtools.SAMException;
import htsjdk.samtools.fastq.FastqRecord;
import htsjdk.samtools.fastq.FastqWriter;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;

public class BasicFastqWriter
implements FastqWriter {
    private final String path;
    private final PrintStream writer;

    public BasicFastqWriter(File file) {
        this(file, false);
    }

    public BasicFastqWriter(File file, boolean bl) {
        this(file, new PrintStream(IOUtil.maybeBufferOutputStream(BasicFastqWriter.maybeMd5Wrap(file, bl))));
    }

    private BasicFastqWriter(File file, PrintStream printStream) {
        this.path = file != null ? file.getAbsolutePath() : "";
        this.writer = printStream;
    }

    public BasicFastqWriter(PrintStream printStream) {
        this(null, printStream);
    }

    @Override
    public void write(FastqRecord fastqRecord) {
        this.writer.print("@");
        this.writer.println(fastqRecord.getReadHeader());
        this.writer.println(fastqRecord.getReadString());
        this.writer.print("+");
        this.writer.println(fastqRecord.getBaseQualityHeader() == null ? "" : fastqRecord.getBaseQualityHeader());
        this.writer.println(fastqRecord.getBaseQualityString());
        if (this.writer.checkError()) {
            throw new SAMException("Error in writing fastq file " + this.path);
        }
    }

    public void flush() {
        this.writer.flush();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    private static OutputStream maybeMd5Wrap(File file, boolean bl) {
        if (bl) {
            return IOUtil.openFileForMd5CalculatingWriting(file);
        }
        return IOUtil.openFileForWriting(file);
    }
}

