/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import java.util.Arrays;
import java.util.Comparator;

public class SubstitutionMatrix {
    public static final byte[] BASES = new byte[]{65, 67, 71, 84, 78};
    private static final byte[] BASES_LC = new byte[]{97, 99, 103, 116, 110};
    private static final byte[] ORDER = new byte[255];
    private byte[] bytes = new byte[5];
    private final byte[][] codes = new byte[255][255];
    private final byte[][] bases = new byte[255][255];
    private static final Comparator<SubCode> comparator;

    /*
     * WARNING - void declaration
     */
    public SubstitutionMatrix(long[][] lArray) {
        void var2_5;
        for (byte by : BASES) {
            this.bytes[SubstitutionMatrix.ORDER[by]] = this.rank(by, lArray[by]);
        }
        for (byte[] byArray : this.bases) {
            Arrays.fill(byArray, (byte)78);
        }
        boolean bl = false;
        while (var2_5 < BASES.length) {
            int n = BASES[var2_5];
            for (byte by : BASES) {
                if (n == by) continue;
                this.bases[n][this.codes[n][by]] = by;
                this.bases[SubstitutionMatrix.BASES_LC[var2_5]][this.codes[n][by]] = by;
            }
            ++var2_5;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : "ACGTN".getBytes()) {
            stringBuilder.append((char)by);
            stringBuilder.append(":");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append((char)this.bases[by][i]);
            }
            stringBuilder.append("\t");
        }
        return stringBuilder.toString();
    }

    public SubstitutionMatrix(byte[] byArray) {
        this.bytes = byArray;
        for (byte[] byArray3 : this.bases) {
            Arrays.fill(byArray3, (byte)78);
        }
        this.bases[65][this.bytes[0] >> 6 & 3] = 67;
        this.bases[65][this.bytes[0] >> 4 & 3] = 71;
        this.bases[65][this.bytes[0] >> 2 & 3] = 84;
        this.bases[65][this.bytes[0] & 3] = 78;
        System.arraycopy(this.bases[65], 0, this.bases[97], 0, 4);
        this.bases[67][this.bytes[1] >> 6 & 3] = 65;
        this.bases[67][this.bytes[1] >> 4 & 3] = 71;
        this.bases[67][this.bytes[1] >> 2 & 3] = 84;
        this.bases[67][this.bytes[1] & 3] = 78;
        System.arraycopy(this.bases[67], 0, this.bases[99], 0, 4);
        this.bases[71][this.bytes[2] >> 6 & 3] = 65;
        this.bases[71][this.bytes[2] >> 4 & 3] = 67;
        this.bases[71][this.bytes[2] >> 2 & 3] = 84;
        this.bases[71][this.bytes[2] & 3] = 78;
        System.arraycopy(this.bases[71], 0, this.bases[103], 0, 4);
        this.bases[84][this.bytes[3] >> 6 & 3] = 65;
        this.bases[84][this.bytes[3] >> 4 & 3] = 67;
        this.bases[84][this.bytes[3] >> 2 & 3] = 71;
        this.bases[84][this.bytes[3] & 3] = 78;
        System.arraycopy(this.bases[84], 0, this.bases[116], 0, 4);
        this.bases[78][this.bytes[4] >> 6 & 3] = 65;
        this.bases[78][this.bytes[4] >> 4 & 3] = 67;
        this.bases[78][this.bytes[4] >> 2 & 3] = 71;
        this.bases[78][this.bytes[4] & 3] = 84;
        for (byte by : BASES) {
            for (int n = 0; n < 4; n = (int)((byte)(n + 1))) {
                this.codes[by][this.bases[by][n]] = n;
            }
        }
    }

    public byte[] getEncodedMatrix() {
        return this.bytes;
    }

    private byte rank(byte by, long[] lArray) {
        SubCode[] subCodeArray = new SubCode[4];
        int n = 0;
        byte[] byArray = BASES;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            byte by2 = byArray[i];
            if (by == by2) continue;
            subCodeArray[n++] = new SubCode(by2, lArray[by2]);
        }
        Arrays.sort(subCodeArray, comparator);
        for (n = 0; n < subCodeArray.length; n = (int)((byte)(n + 1))) {
            subCodeArray[n].rank = (byte)n;
        }
        for (SubCode subCode : subCodeArray) {
            subCode.freq = 0L;
        }
        Arrays.sort(subCodeArray, comparator);
        byte by3 = 0;
        for (SubCode subCode : subCodeArray) {
            by3 = (byte)(by3 << 2);
            by3 = (byte)(by3 | subCode.rank);
        }
        for (SubCode subCode : subCodeArray) {
            this.codes[by][subCode.base] = subCode.rank;
        }
        return by3;
    }

    public byte code(byte by, byte by2) {
        return this.codes[by][by2];
    }

    public byte base(byte by, byte by2) {
        return this.bases[by][by2];
    }

    static {
        Arrays.fill(ORDER, (byte)-1);
        SubstitutionMatrix.ORDER[65] = 0;
        SubstitutionMatrix.ORDER[67] = 1;
        SubstitutionMatrix.ORDER[71] = 2;
        SubstitutionMatrix.ORDER[84] = 3;
        SubstitutionMatrix.ORDER[78] = 4;
        comparator = new Comparator<SubCode>(){

            @Override
            public int compare(SubCode subCode, SubCode subCode2) {
                if (subCode.freq != subCode2.freq) {
                    return (int)(subCode2.freq - subCode.freq);
                }
                return ORDER[subCode.base] - ORDER[subCode2.base];
            }
        };
    }

    private static class SubCode {
        final byte base;
        long freq;
        byte rank;

        public SubCode(byte by, long l) {
            this.base = by;
            this.freq = l;
        }
    }
}

