/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.io.CRC32OutputStream;
import htsjdk.samtools.cram.io.CramArray;
import htsjdk.samtools.cram.io.CramInt;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.LTF8;
import htsjdk.samtools.cram.structure.Container;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class ContainerHeaderIO {
    ContainerHeaderIO() {
    }

    public boolean readContainerHeader(Container container, InputStream inputStream) throws IOException {
        return this.readContainerHeader(2, container, inputStream);
    }

    public boolean readContainerHeader(int n, Container container, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[4];
        int n2 = inputStream.read();
        if (n2 == -1) {
            return false;
        }
        byArray[0] = (byte)n2;
        for (int i = 1; i < byArray.length; ++i) {
            n2 = inputStream.read();
            if (n2 == -1) {
                throw new RuntimeException("Incomplete or broken stream.");
            }
            byArray[i] = (byte)n2;
        }
        container.containerByteSize = CramInt.int32(byArray);
        container.sequenceId = ITF8.readUnsignedITF8(inputStream);
        container.alignmentStart = ITF8.readUnsignedITF8(inputStream);
        container.alignmentSpan = ITF8.readUnsignedITF8(inputStream);
        container.nofRecords = ITF8.readUnsignedITF8(inputStream);
        container.globalRecordCounter = LTF8.readUnsignedLTF8(inputStream);
        container.bases = LTF8.readUnsignedLTF8(inputStream);
        container.blockCount = ITF8.readUnsignedITF8(inputStream);
        container.landmarks = CramArray.array(inputStream);
        if (n >= 3) {
            container.checksum = CramInt.int32(inputStream);
        }
        return true;
    }

    public int writeContainerHeader(int n, Container container, OutputStream outputStream) throws IOException {
        CRC32OutputStream cRC32OutputStream = new CRC32OutputStream(outputStream);
        int n2 = (CramInt.writeInt32(container.containerByteSize, cRC32OutputStream) + 7) / 8;
        n2 += (ITF8.writeUnsignedITF8(container.sequenceId, cRC32OutputStream) + 7) / 8;
        n2 += (ITF8.writeUnsignedITF8(container.alignmentStart, cRC32OutputStream) + 7) / 8;
        n2 += (ITF8.writeUnsignedITF8(container.alignmentSpan, cRC32OutputStream) + 7) / 8;
        n2 += (ITF8.writeUnsignedITF8(container.nofRecords, cRC32OutputStream) + 7) / 8;
        n2 += (LTF8.writeUnsignedLTF8(container.globalRecordCounter, cRC32OutputStream) + 7) / 8;
        n2 += (LTF8.writeUnsignedLTF8(container.bases, cRC32OutputStream) + 7) / 8;
        n2 += (ITF8.writeUnsignedITF8(container.blockCount, cRC32OutputStream) + 7) / 8;
        n2 += (CramArray.write(container.landmarks, cRC32OutputStream) + 7) / 8;
        if (n >= 3) {
            outputStream.write(cRC32OutputStream.getCrc32_LittleEndian());
            n2 += 32;
        }
        return n2;
    }
}

