/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalIntegerCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.util.Map;

public class ExternalIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID encodingId = EncodingID.EXTERNAL;
    private int contentId = -1;

    public static EncodingParams toParam(int n) {
        ExternalIntegerEncoding externalIntegerEncoding = new ExternalIntegerEncoding();
        externalIntegerEncoding.contentId = n;
        return new EncodingParams(encodingId, externalIntegerEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        return ITF8.writeUnsignedITF8(this.contentId);
    }

    @Override
    public void fromByteArray(byte[] byArray) {
        this.contentId = ITF8.readUnsignedITF8(byArray);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> map, Map<Integer, ExposedByteArrayOutputStream> map2) {
        InputStream inputStream = map == null ? null : map.get(this.contentId);
        ExposedByteArrayOutputStream exposedByteArrayOutputStream = map2 == null ? null : map2.get(this.contentId);
        return new ExternalIntegerCodec(exposedByteArrayOutputStream, inputStream);
    }

    @Override
    public EncodingID id() {
        return encodingId;
    }
}

