/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.ComparableSamRecordIterator;
import htsjdk.samtools.ReservedTagConstants;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordComparator;
import htsjdk.samtools.SAMRecordCoordinateComparator;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.CloseableIterator;
import java.util.Collection;
import java.util.Map;
import java.util.PriorityQueue;

public class MergingSamRecordIterator
implements CloseableIterator<SAMRecord> {
    private final PriorityQueue<ComparableSamRecordIterator> pq;
    private final SamFileHeaderMerger samHeaderMerger;
    private final Collection<SamReader> readers;
    private final SAMFileHeader.SortOrder sortOrder;
    private final SAMRecordComparator comparator;
    private boolean initialized = false;

    public MergingSamRecordIterator(SamFileHeaderMerger samFileHeaderMerger, boolean bl) {
        this(samFileHeaderMerger, samFileHeaderMerger.getReaders(), bl);
    }

    public MergingSamRecordIterator(SamFileHeaderMerger samFileHeaderMerger, Collection<SamReader> collection, boolean bl) {
        this.samHeaderMerger = samFileHeaderMerger;
        this.sortOrder = samFileHeaderMerger.getMergedHeader().getSortOrder();
        this.comparator = this.getComparator();
        this.readers = collection;
        this.pq = new PriorityQueue(collection.size());
        for (SamReader samReader : collection) {
            if (!this.samHeaderMerger.getHeaders().contains(samReader.getFileHeader())) {
                throw new SAMException("All iterators to be merged must be accounted for in the SAM header merger");
            }
            if (bl || this.sortOrder == SAMFileHeader.SortOrder.unsorted || samReader.getFileHeader().getSortOrder() == this.sortOrder) continue;
            throw new SAMException("Files are not compatible with sort order");
        }
    }

    public MergingSamRecordIterator(SamFileHeaderMerger samFileHeaderMerger, Map<SamReader, CloseableIterator<SAMRecord>> map, boolean bl) {
        this(samFileHeaderMerger, map.keySet(), bl);
        for (Map.Entry<SamReader, CloseableIterator<SAMRecord>> entry : map.entrySet()) {
            this.addIfNotEmpty(new ComparableSamRecordIterator(entry.getKey(), entry.getValue(), this.comparator));
        }
        this.initialized = true;
    }

    private void startIterationIfRequired() {
        if (this.initialized) {
            return;
        }
        for (SamReader samReader : this.readers) {
            this.addIfNotEmpty(new ComparableSamRecordIterator(samReader, samReader.iterator(), this.comparator));
        }
        this.initialized = true;
    }

    @Override
    public void close() {
        for (CloseableIterator closeableIterator : this.pq) {
            closeableIterator.close();
        }
    }

    @Override
    public boolean hasNext() {
        this.startIterationIfRequired();
        return !this.pq.isEmpty();
    }

    @Override
    public SAMRecord next() {
        String string;
        String string2;
        this.startIterationIfRequired();
        ComparableSamRecordIterator comparableSamRecordIterator = this.pq.poll();
        SAMRecord sAMRecord = (SAMRecord)comparableSamRecordIterator.next();
        this.addIfNotEmpty(comparableSamRecordIterator);
        sAMRecord.setHeader(this.samHeaderMerger.getMergedHeader());
        if (this.samHeaderMerger.hasReadGroupCollisions() && (string2 = (String)sAMRecord.getAttribute(ReservedTagConstants.READ_GROUP_ID)) != null) {
            string = this.samHeaderMerger.getReadGroupId(comparableSamRecordIterator.getReader().getFileHeader(), string2);
            sAMRecord.setAttribute(ReservedTagConstants.READ_GROUP_ID, (Object)string);
        }
        if (this.samHeaderMerger.hasProgramGroupCollisions() && (string2 = (String)sAMRecord.getAttribute(ReservedTagConstants.PROGRAM_GROUP_ID)) != null) {
            string = this.samHeaderMerger.getProgramGroupId(comparableSamRecordIterator.getReader().getFileHeader(), string2);
            sAMRecord.setAttribute(ReservedTagConstants.PROGRAM_GROUP_ID, (Object)string);
        }
        if (this.samHeaderMerger.hasMergedSequenceDictionary()) {
            if (sAMRecord.getReferenceIndex() != -1) {
                sAMRecord.setReferenceIndex(this.samHeaderMerger.getMergedSequenceIndex(comparableSamRecordIterator.getReader().getFileHeader(), sAMRecord.getReferenceIndex()));
            }
            if (sAMRecord.getReadPairedFlag() && sAMRecord.getMateReferenceIndex() != -1) {
                sAMRecord.setMateReferenceIndex(this.samHeaderMerger.getMergedSequenceIndex(comparableSamRecordIterator.getReader().getFileHeader(), sAMRecord.getMateReferenceIndex()));
            }
        }
        return sAMRecord;
    }

    private void addIfNotEmpty(ComparableSamRecordIterator comparableSamRecordIterator) {
        if (comparableSamRecordIterator.hasNext()) {
            this.pq.offer(comparableSamRecordIterator);
        } else {
            comparableSamRecordIterator.close();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("MergingSAMRecorderIterator.remove()");
    }

    private SAMRecordComparator getComparator() {
        if (this.sortOrder == SAMFileHeader.SortOrder.unsorted) {
            return new SAMRecordComparator(){

                @Override
                public int fileOrderCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                    return System.identityHashCode(sAMRecord) - System.identityHashCode(sAMRecord2);
                }

                @Override
                public int compare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
                    return this.fileOrderCompare(sAMRecord, sAMRecord2);
                }
            };
        }
        if (this.samHeaderMerger.hasMergedSequenceDictionary() && this.sortOrder.equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            return new MergedSequenceDictionaryCoordinateOrderComparator();
        }
        return this.sortOrder.getComparatorInstance();
    }

    public SAMFileHeader getMergedHeader() {
        return this.samHeaderMerger.getMergedHeader();
    }

    private class MergedSequenceDictionaryCoordinateOrderComparator
    extends SAMRecordCoordinateComparator {
        private MergedSequenceDictionaryCoordinateOrderComparator() {
        }

        @Override
        public int fileOrderCompare(SAMRecord sAMRecord, SAMRecord sAMRecord2) {
            int n;
            int n2 = this.getReferenceIndex(sAMRecord);
            if (n2 != (n = this.getReferenceIndex(sAMRecord2))) {
                if (n2 == -1) {
                    return 1;
                }
                if (n == -1) {
                    return -1;
                }
                return n2 - n;
            }
            if (n2 == -1) {
                return 0;
            }
            return sAMRecord.getAlignmentStart() - sAMRecord2.getAlignmentStart();
        }

        private int getReferenceIndex(SAMRecord sAMRecord) {
            if (sAMRecord.getReferenceIndex() != -1) {
                return MergingSamRecordIterator.this.samHeaderMerger.getMergedSequenceIndex(sAMRecord.getHeader(), sAMRecord.getReferenceIndex());
            }
            if (sAMRecord.getMateReferenceIndex() != -1) {
                return MergingSamRecordIterator.this.samHeaderMerger.getMergedSequenceIndex(sAMRecord.getHeader(), sAMRecord.getMateReferenceIndex());
            }
            return -1;
        }
    }
}

