/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

abstract class InputResource {
    private final Type type;

    protected InputResource(Type type) {
        this.type = type;
    }

    final Type type() {
        return this.type;
    }

    abstract File asFile();

    abstract URL asUrl();

    abstract SeekableStream asUnbufferedSeekableStream();

    abstract InputStream asUnbufferedInputStream();

    public String toString() {
        String string;
        switch (this.type()) {
            case FILE: {
                string = this.asFile().toString();
                break;
            }
            case INPUT_STREAM: {
                string = this.asUnbufferedInputStream().toString();
                break;
            }
            case SEEKABLE_STREAM: {
                string = this.asUnbufferedSeekableStream().toString();
                break;
            }
            case URL: {
                string = this.asUrl().toString();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return String.format("%s:%s", new Object[]{this.type(), string});
    }

    static enum Type {
        FILE,
        URL,
        SEEKABLE_STREAM,
        INPUT_STREAM;

    }
}

