/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.DuplicateScoringStrategy;
import htsjdk.samtools.DuplicateSet;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordDuplicateComparator;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import java.util.Collections;

public class DuplicateSetIterator
implements CloseableIterator<DuplicateSet> {
    private final CloseableIterator<SAMRecord> wrappedIterator;
    private DuplicateSet duplicateSet = null;
    private final SAMRecordDuplicateComparator comparator;

    public DuplicateSetIterator(CloseableIterator<SAMRecord> closeableIterator, SAMFileHeader sAMFileHeader) {
        this(closeableIterator, sAMFileHeader, false);
    }

    public DuplicateSetIterator(CloseableIterator<SAMRecord> closeableIterator, SAMFileHeader sAMFileHeader, boolean bl) {
        this.comparator = new SAMRecordDuplicateComparator(Collections.singletonList(sAMFileHeader));
        if (bl) {
            this.wrappedIterator = closeableIterator;
        } else {
            int n = SAMFileWriterImpl.getDefaultMaxRecordsInRam();
            File file = new File(System.getProperty("java.io.tmpdir"));
            SortingCollection<SAMRecord> sortingCollection = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(sAMFileHeader), this.comparator, n, file);
            while (closeableIterator.hasNext()) {
                SAMRecord sAMRecord = (SAMRecord)closeableIterator.next();
                sortingCollection.add(sAMRecord);
            }
            closeableIterator.close();
            this.wrappedIterator = sortingCollection.iterator();
        }
        this.duplicateSet = new DuplicateSet(this.comparator);
        if (this.hasNext()) {
            this.duplicateSet.add((SAMRecord)this.wrappedIterator.next());
        }
    }

    public void setScoringStrategy(DuplicateScoringStrategy.ScoringStrategy scoringStrategy) {
        this.comparator.setScoringStrategy(scoringStrategy);
    }

    @Override
    public DuplicateSet next() {
        DuplicateSet duplicateSet = null;
        int n = 0;
        while (0 == n) {
            if (!this.wrappedIterator.hasNext()) {
                duplicateSet = this.duplicateSet;
                this.duplicateSet = new DuplicateSet(this.comparator);
                break;
            }
            SAMRecord sAMRecord = (SAMRecord)this.wrappedIterator.next();
            SAMRecord sAMRecord2 = this.duplicateSet.getRepresentative();
            if (sAMRecord2.getReadUnmappedFlag() || sAMRecord2.isSecondaryOrSupplementary()) {
                duplicateSet = this.duplicateSet;
                this.duplicateSet = new DuplicateSet(this.comparator);
                this.duplicateSet.add(sAMRecord);
                break;
            }
            n = this.duplicateSet.add(sAMRecord);
            if (0 < n) {
                throw new SAMException("The input records were not sorted in duplicate order:\n" + sAMRecord2.getSAMString() + sAMRecord.getSAMString());
            }
            if (n >= 0) continue;
            duplicateSet = this.duplicateSet;
            this.duplicateSet = new DuplicateSet(this.comparator);
            this.duplicateSet.add(sAMRecord);
        }
        return duplicateSet;
    }

    @Override
    public void close() {
        this.wrappedIterator.close();
    }

    @Override
    public boolean hasNext() {
        return !this.duplicateSet.isEmpty() || this.wrappedIterator.hasNext();
    }

    @Override
    public void remove() {
    }
}

