/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class DiskBasedBAMFileIndex
extends AbstractBAMFileIndex {
    DiskBasedBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary) {
        super(file, sAMSequenceDictionary);
    }

    DiskBasedBAMFileIndex(SeekableStream seekableStream, SAMSequenceDictionary sAMSequenceDictionary) {
        super(seekableStream, sAMSequenceDictionary);
    }

    DiskBasedBAMFileIndex(File file, SAMSequenceDictionary sAMSequenceDictionary, boolean bl) {
        super(file, sAMSequenceDictionary, bl);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int n, int n2, int n3) {
        BAMIndexContent bAMIndexContent = this.query(n, n2, n3);
        if (bAMIndexContent == null) {
            return null;
        }
        List<Chunk> list = new ArrayList<Chunk>();
        for (Chunk chunk : bAMIndexContent.getAllChunks()) {
            list.add(chunk.clone());
        }
        list = Chunk.optimizeChunkList(list, bAMIndexContent.getLinearIndex().getMinimumOffset(n2));
        return new BAMFileSpan(list);
    }

    @Override
    protected BAMIndexContent getQueryResults(int n) {
        throw new UnsupportedOperationException();
    }
}

