/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.BAMIndexMetaData;
import htsjdk.samtools.BAMIndexWriter;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinaryBAMIndexWriter;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.LinearIndex;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedFilePointerUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;

public class CRAMIndexer {
    private final int numReferences;
    private final BAMIndexWriter outputWriter;
    private int currentReference = 0;
    private final BAMIndexBuilder indexBuilder;

    public CRAMIndexer(File file, SAMFileHeader sAMFileHeader) {
        this.numReferences = sAMFileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(sAMFileHeader);
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, file);
    }

    public CRAMIndexer(OutputStream outputStream, SAMFileHeader sAMFileHeader) {
        this.numReferences = sAMFileHeader.getSequenceDictionary().size();
        this.indexBuilder = new BAMIndexBuilder(sAMFileHeader);
        this.outputWriter = new BinaryBAMIndexWriter(this.numReferences, outputStream);
    }

    public void processAlignment(Slice slice) {
        try {
            int n = slice.sequenceId;
            if (n != -1 && n != this.currentReference) {
                this.advanceToReference(n);
            }
            this.indexBuilder.processAlignment(slice);
        }
        catch (Exception exception) {
            throw new SAMException("Exception creating BAM index for slice " + slice, exception);
        }
    }

    public void finish() {
        this.advanceToReference(this.numReferences);
        this.outputWriter.writeNoCoordinateRecordCount(this.indexBuilder.getNoCoordinateRecordCount());
        this.outputWriter.close();
    }

    private void advanceToReference(int n) {
        while (this.currentReference < n) {
            BAMIndexContent bAMIndexContent = this.indexBuilder.processReference(this.currentReference);
            this.outputWriter.writeReference(bAMIndexContent);
            ++this.currentReference;
            this.indexBuilder.startNewReference();
        }
    }

    public static void createIndex(SeekableStream seekableStream, File file, Log log) throws IOException {
        CramHeader cramHeader = CramIO.readCramHeader(seekableStream);
        CRAMIndexer cRAMIndexer = new CRAMIndexer(file, cramHeader.getSamFileHeader());
        int n = 0;
        Container container = null;
        do {
            if (++n % 10 == 0 && null != log) {
                log.info(n + " slices processed ...");
            }
            try {
                long l = seekableStream.position();
                container = ContainerIO.readContainer(cramHeader.getVersion(), (InputStream)seekableStream);
                if (container == null || container.isEOF()) break;
                container.offset = l;
                int n2 = 0;
                for (Slice slice : container.slices) {
                    slice.containerOffset = l;
                    slice.index = n2++;
                    cRAMIndexer.processAlignment(slice);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to read cram container", iOException);
            }
        } while (!container.isEOF());
        cRAMIndexer.finish();
    }

    private class BAMIndexBuilder {
        private final SAMFileHeader bamHeader;
        private Bin[] bins;
        private int binsSeen = 0;
        private final long[] index = new long[LinearIndex.MAX_LINEAR_INDEX_SIZE];
        private int largestIndexSeen = -1;
        private final BAMIndexMetaData indexStats = new BAMIndexMetaData();

        BAMIndexBuilder(SAMFileHeader sAMFileHeader) {
            this.bamHeader = sAMFileHeader;
        }

        private int computeIndexingBin(Slice slice) {
            int n = slice.alignmentStart + slice.alignmentSpan - 1;
            int n2 = slice.alignmentStart - 1;
            if (n <= n2) {
                n = n2 + 1;
            }
            return GenomicIndexUtil.reg2bin(n2, n);
        }

        public void processAlignment(Slice slice) {
            Object object;
            this.indexStats.recordMetaData(slice);
            int n = slice.alignmentStart;
            if (n == 0) {
                return;
            }
            int n2 = slice.sequenceId;
            if (n2 != CRAMIndexer.this.currentReference) {
                throw new SAMException("Unexpected reference " + n2 + " when constructing index for " + CRAMIndexer.this.currentReference + " for record " + slice);
            }
            int n3 = this.computeIndexingBin(slice);
            if (this.bins == null) {
                object = this.bamHeader.getSequence(n2);
                this.bins = object == null ? new Bin[37451] : new Bin[AbstractBAMFileIndex.getMaxBinNumberForSequenceLength(((SAMSequenceRecord)object).getSequenceLength()) + 1];
            }
            if (this.bins[n3] != null) {
                object = this.bins[n3];
            } else {
                this.bins[n3] = object = new Bin(n2, n3);
                ++this.binsSeen;
            }
            long l = slice.containerOffset << 16 | (long)slice.index;
            long l2 = (slice.containerOffset << 16 | (long)slice.index) + 1L;
            Chunk chunk = new Chunk(l, l2);
            List<Chunk> list = ((Bin)object).getChunkList();
            if (!((Bin)object).containsChunks()) {
                ((Bin)object).addInitialChunk(chunk);
            } else {
                Chunk chunk2 = ((Bin)object).getLastChunk();
                if (BlockCompressedFilePointerUtil.areInSameOrAdjacentBlocks(chunk2.getChunkEnd(), l)) {
                    chunk2.setChunkEnd(l2);
                } else {
                    list.add(chunk);
                    ((Bin)object).setLastChunk(chunk);
                }
            }
            int n4 = slice.alignmentStart + slice.alignmentSpan;
            int n5 = LinearIndex.convertToLinearIndexOffset(n);
            int n6 = n4 == 0 ? (n5 = LinearIndex.convertToLinearIndexOffset(n - 1)) : LinearIndex.convertToLinearIndexOffset(n4);
            if (n6 > this.largestIndexSeen) {
                this.largestIndexSeen = n6;
            }
            for (int i = n5; i <= n6; ++i) {
                if (this.index[i] != 0L && l >= this.index[i]) continue;
                this.index[i] = l;
            }
        }

        public BAMIndexContent processReference(int n) {
            if (n != CRAMIndexer.this.currentReference) {
                throw new SAMException("Unexpected reference " + n + " when constructing index for " + CRAMIndexer.this.currentReference);
            }
            if (this.binsSeen == 0) {
                return null;
            }
            long[] lArray = new long[this.largestIndexSeen + 1];
            long l = 0L;
            for (int i = 0; i <= this.largestIndexSeen; ++i) {
                if (this.index[i] == 0L) {
                    this.index[i] = l;
                } else {
                    l = this.index[i];
                }
                lArray[i] = this.index[i];
            }
            LinearIndex linearIndex = new LinearIndex(n, 0, lArray);
            return new BAMIndexContent(n, this.bins, this.binsSeen, this.indexStats, linearIndex);
        }

        public long getNoCoordinateRecordCount() {
            return this.indexStats.getNoCoordinateRecordCount();
        }

        void startNewReference() {
            this.bins = null;
            if (this.binsSeen > 0) {
                Arrays.fill(this.index, 0L);
            }
            this.binsSeen = 0;
            this.largestIndexSeen = -1;
            this.indexStats.newReference();
        }
    }
}

