/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.util;

import edu.mayo.bior.util.FieldProcessorBase;
import java.util.HashMap;
import java.util.Map;

public class TextLookupProcessor
extends FieldProcessorBase {
    private Map<String, String> lookupTable;

    public TextLookupProcessor(String[] find, String[] replace) {
        int findSize = find == null ? 0 : find.length;
        int replaceSize = replace == null ? 0 : replace.length;
        int size = Math.min(findSize, replaceSize);
        this.lookupTable = new HashMap<String, String>(size);
        for (int i = 0; i < size; ++i) {
            this.lookupTable.put(find[i], replace[i]);
        }
    }

    public TextLookupProcessor(Map<String, String> lookupTable) {
        if (lookupTable == null) {
            this.lookupTable = new HashMap<String, String>();
            return;
        }
        this.lookupTable = new HashMap<String, String>(lookupTable);
    }

    public String addPair(String find, String replace) {
        if (find == null || find.isEmpty()) {
            return null;
        }
        if (replace == null) {
            return this.lookupTable.remove(find);
        }
        return this.lookupTable.put(find, replace);
    }

    @Override
    public String process(String value) {
        String result = this.lookupTable.get(value);
        if (result == null) {
            if (super.isBlank(value)) {
                return gCurBlankValue;
            }
            return value;
        }
        return result;
    }
}

