/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.VEP;

import edu.mayo.exec.AbnormalExitException;
import edu.mayo.exec.UnixStreamCommand;
import edu.mayo.pipes.history.History;
import edu.mayo.pipes.util.BiorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class VEPEXE {
    private static final Logger sLogger = Logger.getLogger(VEPEXE.class);
    private UnixStreamCommand mVep;
    public static final int VEP_BUFFER_SIZE_DEFAULT = 100;
    private static int mVepBufferSize = 100;
    private static final int VCF_REF_COL = 3;
    private static final int VCF_ALT_COL = 4;
    private static final long RECEIVE_TIMEOUT = 10L;
    private List<String> mVepFormatHeaders = new ArrayList<String>();
    private long mLinesSent = 0L;

    public static void setBufferSize(int bufferSize) {
        mVepBufferSize = bufferSize;
    }

    public VEPEXE() throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        this(new String[0]);
    }

    public VEPEXE(String[] userSuppliedOptions) throws IOException, InterruptedException, BrokenBarrierException, TimeoutException, AbnormalExitException {
        try {
            Map NO_CUSTOM_ENV = Collections.emptyMap();
            String[] allCmdFlags = VEPEXE.getVEPCommand(userSuppliedOptions);
            this.mVep = new UnixStreamCommand(allCmdFlags, NO_CUSTOM_ENV, true, true);
            this.mVep.launch();
            this.mVep.send(this.concat("#CHROM", "POS", "ID", "REF", "ALT", "QUAL", "FILTER", "INFO"));
            int bufferSize = this.getVepBufferSize();
            String fakeLinesIn = this.getFakeInput(bufferSize);
            this.mVep.send(fakeLinesIn);
            String infoHeader = this.mVep.receive();
            String colHeader = this.mVep.receive();
            sLogger.info((Object)"VEP Priming ---------------------------------------------");
            sLogger.info((Object)("Header, ##INFO CSQ: " + infoHeader));
            sLogger.info((Object)("Header, columns:    " + colHeader));
            for (int i = 0; i < bufferSize; ++i) {
                String dataLineOut = this.mVep.receive();
                sLogger.info((Object)("Data line out [" + i + "]: " + dataLineOut));
            }
            sLogger.info((Object)"---------------------------------------------------------");
            this.setVepFormatHeaders(infoHeader);
        }
        catch (AbnormalExitException e) {
            sLogger.error((Object)"VEP failed to run.  Please verify that the VEP properties are configured correctly, and that the system VEP is running on has the correct Perl path, variant_effect_predictor.pl, and VEP cache paths.");
            throw e;
        }
    }

    private String getFakeInput(int bufferSize) {
        String fakeLine = this.concat("chr1", "1588717", "rs009", "G", "A", "0.0", ".", ".");
        StringBuilder fakeLinesIn = new StringBuilder();
        for (int i = 0; i < bufferSize; ++i) {
            if (i > 0) {
                fakeLinesIn.append("\n");
            }
            fakeLinesIn.append(fakeLine);
        }
        return fakeLinesIn.toString();
    }

    private String concat(String ... s) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            if (i > 0) {
                str.append("\t");
            }
            str.append(s[i]);
        }
        return str.toString();
    }

    private void setVepFormatHeaders(String vepInfoHeader) {
        int idxFormat = vepInfoHeader.indexOf("Format: ");
        int idxQuoteAfter = vepInfoHeader.indexOf("\"", idxFormat);
        if (!vepInfoHeader.startsWith("##INFO=<ID=CSQ") || idxFormat == -1 || idxQuoteAfter == -1) {
            throw new IllegalArgumentException("##INFO header coming back from VEP command was not correct: " + vepInfoHeader);
        }
        String format = vepInfoHeader.substring(idxFormat + 8, idxQuoteAfter);
        this.mVepFormatHeaders = Arrays.asList(format.split("\\|"));
    }

    public List<String> getVepColHeaders() {
        return this.mVepFormatHeaders;
    }

    public static String[] getVEPCommand(String[] userOptions) throws IOException {
        BiorProperties biorProps = new BiorProperties();
        ArrayList<String> command = new ArrayList<String>();
        String vepPerlPath = biorProps.get(BiorProperties.Key.BiorVepPerl);
        String vepPath = biorProps.get(BiorProperties.Key.BiorVep);
        String vepCacheDir = biorProps.get(BiorProperties.Key.BiorVepCache);
        String cmdBeforeVariableSubstitutions = biorProps.get(BiorProperties.Key.BiorVepCmdFlags);
        String vepBufferSizeStr = biorProps.get(BiorProperties.Key.BiorVepBufferSize);
        if (vepPerlPath == null || vepPath == null || vepCacheDir == null || cmdBeforeVariableSubstitutions == null || vepBufferSizeStr == null) {
            VEPEXE.logAndSysError("Error: Properties missing in bior.properties.  Location of properties file: " + BiorProperties.getFile());
        }
        if (vepPerlPath == null) {
            VEPEXE.logAndSysError("    " + BiorProperties.Key.BiorVepPerl);
        }
        if (vepPath == null) {
            VEPEXE.logAndSysError("    " + BiorProperties.Key.BiorVep);
        }
        if (vepCacheDir == null) {
            VEPEXE.logAndSysError("    " + BiorProperties.Key.BiorVepCache);
        }
        if (cmdBeforeVariableSubstitutions == null) {
            VEPEXE.logAndSysError("    " + BiorProperties.Key.BiorVepCmdFlags);
        }
        if (vepBufferSizeStr == null) {
            VEPEXE.logAndSysError("    " + BiorProperties.Key.BiorVepBufferSize);
        }
        int vepBufferSize = VEPEXE.loadVepBufferSizeProperty(biorProps);
        String cmdFlagWithVarSubstitutions = biorProps.get(BiorProperties.Key.BiorVepCmdFlags).replace("$BiorVepCache", vepCacheDir).replace("$BiorVepBufferSize", vepBufferSize + "");
        command.add(vepPerlPath);
        command.add(vepPath);
        command.addAll(Arrays.asList(cmdFlagWithVarSubstitutions.split(" +")));
        command.addAll(VEPEXE.getMacFlagsIfNecessary());
        if (userOptions != null) {
            command.addAll(Arrays.asList(userOptions));
        }
        return command.toArray(new String[command.size()]);
    }

    private static void logAndSysError(String msg) {
        System.err.println(msg);
        sLogger.error((Object)msg);
    }

    public static int loadVepBufferSizeProperty(BiorProperties biorProps) {
        String vepBufferSize;
        if (mVepBufferSize == 100 && (vepBufferSize = biorProps.get(BiorProperties.Key.BiorVepBufferSize)) != null && VEPEXE.isInteger(vepBufferSize)) {
            mVepBufferSize = Integer.parseInt(vepBufferSize);
        }
        return mVepBufferSize;
    }

    public int getVepBufferSize() {
        return mVepBufferSize;
    }

    private static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static List<String> getMacFlagsIfNecessary() {
        String os = System.getProperty("os.name");
        ArrayList<String> macFlags = new ArrayList<String>();
        if (os.equals("Mac OS X")) {
            macFlags.add("--compress");
            macFlags.add("gunzip -c");
            sLogger.info((Object)String.format("Running on %s.  Adding Mac-specific options.", os));
        }
        return macFlags;
    }

    public void sendLines(String vcfLines) {
        try {
            String[] lines = vcfLines.split("\n");
            if (lines.length != mVepBufferSize) {
                String msg = "Lines being passed to VEP (" + lines.length + ") do not equal the buffer size (" + mVepBufferSize + ")";
                sLogger.error((Object)msg);
                throw new RuntimeException();
            }
            sLogger.info((Object)("VEP - sending lines to VEP (" + mVepBufferSize + " lines in buffer) -------------"));
            sLogger.info((Object)vcfLines);
            this.mVep.send(vcfLines);
            sLogger.info((Object)"VEP - Lines sent. -------------------------------------------------------------------");
        }
        catch (RuntimeException runtimeExc) {
            this.terminate();
            throw runtimeExc;
        }
        catch (Exception ex) {
            this.terminate();
            sLogger.error((Object)ex);
            throw new NoSuchElementException();
        }
    }

    public History getNextLine() {
        try {
            sLogger.info((Object)"VEP - Receiving line...");
            String result = this.mVep.receive(10L, TimeUnit.SECONDS);
            sLogger.info((Object)("VEP - received line: " + result));
            return new History(result);
        }
        catch (TimeoutException te) {
            this.terminate();
            sLogger.error((Object)te);
            throw new RuntimeException("VEP timed out while retrieving next line: " + te.getMessage());
        }
        catch (Exception e) {
            this.terminate();
            sLogger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected String getDefaultErrorResponse() {
        return "CSQ=VEPERR";
    }

    public void terminate() {
        try {
            this.mVep.terminate();
        }
        catch (Exception e) {
            sLogger.error((Object)("Error terminating VEPEXE pipe" + e));
        }
    }

    protected boolean isBypass(String line) {
        return this.isBypass(new History(line));
    }

    protected boolean isBypass(History history) {
        if (history.size() < 5) {
            return true;
        }
        String ref = ((String)history.get(3)).trim();
        String alt = ((String)history.get(4)).trim();
        return alt.length() == 0 || alt.equals(".") || alt.equals(ref);
    }
}

