/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.pipeline.Treat.format;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import edu.mayo.bior.pipeline.Treat.JsonColumn;
import edu.mayo.bior.pipeline.Treat.format.FormatUtils;
import edu.mayo.bior.pipeline.Treat.format.Formatter;
import java.util.Arrays;
import java.util.List;

public class DbsnpClinvarFormatter
implements Formatter {
    private static final String[] JSON_DRILL_PATHS = new String[]{"INFO.CLNSIG[0]", "INFO.CLNDBN[0]"};
    private static final JsonPath PATH_CLNSIG = JsonPath.compile((String)JSON_DRILL_PATHS[0], (Predicate[])new Predicate[0]);
    private static final JsonPath PATH_CLNDBN = JsonPath.compile((String)JSON_DRILL_PATHS[1], (Predicate[])new Predicate[0]);

    @Override
    public JsonColumn getJSONColumn() {
        return JsonColumn.DBSNP_CLINVAR;
    }

    @Override
    public List<String> getHeaders() {
        return Arrays.asList("dbSNP.ClinicalSig", "dbSNP.DiseaseVariant");
    }

    @Override
    public List<String> format(String json) {
        return Arrays.asList(FormatUtils.drill(PATH_CLNSIG, json), FormatUtils.drill(PATH_CLNDBN, json));
    }

    @Override
    public List<String> getJsonDrillPaths() {
        return Arrays.asList(JSON_DRILL_PATHS);
    }

    private String translateCLNSIG(String clnsig) {
        int code;
        try {
            code = Integer.parseInt(clnsig);
        }
        catch (NumberFormatException e) {
            return clnsig;
        }
        switch (code) {
            case 0: {
                return "unknown";
            }
            case 1: {
                return "untested";
            }
            case 2: {
                return "non-pathogenic";
            }
            case 3: {
                return "probable-non-pathogenic";
            }
            case 4: {
                return "probable-pathogenic";
            }
            case 5: {
                return "pathogenic";
            }
            case 6: {
                return "drug-response";
            }
            case 7: {
                return "histocompatibility";
            }
            case 255: {
                return "other";
            }
        }
        return clnsig;
    }

    private String translateCLNDBN(String clndbn) {
        if ((clndbn = clndbn.trim()).length() > 0 && clndbn.charAt(0) != '.') {
            return "1";
        }
        return "0";
    }
}

