/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.cli.cmd;

import edu.mayo.bior.catalog.CatalogFiles;
import edu.mayo.bior.catalog.CatalogFormatException;
import edu.mayo.bior.catalog.stats.CatalogStats;
import edu.mayo.bior.catalog.stats.StatsBuilder;
import edu.mayo.bior.catalog.stats.StatsPrinter;
import edu.mayo.bior.cli.cmd.CommandUtil;
import edu.mayo.cli.CommandPlugin;
import edu.mayo.pipes.history.ColumnMetaData;
import edu.mayo.pipes.history.ColumnMetaDataOperations;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class CatalogStatsCommand
implements CommandPlugin {
    private static final String OPTION_CATALOG_BGZ_FILE = "d";
    private static final String OPTION_OUTPUT_DIR = "o";
    private static final String OPTION_VALUE_COUNT = "n";
    private static final String OPTION_SAMPLE_1_IN_X = "s";
    private static final String OPTION_START_LINE = "startLine";
    private static final String OPTION_NUM_LINES = "numLines";
    private int defaultValueCount;
    private File defaultOutputDir = new File(System.getProperty("user.dir"));

    public void init(Properties properties) throws Exception {
        this.defaultValueCount = Integer.parseInt(properties.getProperty("DEFAULT_VALUE_COUNT"));
    }

    public void execute(CommandLine cl, Options options) throws Exception {
        File outputDir;
        List<CommandUtil.FileAttributes> catalogFileAttrs = Arrays.asList(CommandUtil.FileAttributes.EXISTS, CommandUtil.FileAttributes.READABLE);
        File catalogFile = CommandUtil.handleFile(cl, OPTION_CATALOG_BGZ_FILE, catalogFileAttrs);
        int maxValueCount = cl.hasOption(OPTION_VALUE_COUNT) ? CommandUtil.handleInteger(cl, OPTION_VALUE_COUNT, 1, null) : this.defaultValueCount;
        File file = outputDir = cl.hasOption(OPTION_OUTPUT_DIR) ? new File(cl.getOptionValue(OPTION_OUTPUT_DIR)) : this.defaultOutputDir;
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        long DEFAULT_ONE_IN_X_SAMPLING = StatsBuilder.getOneInXSamplingDefault();
        long oneInXSampling = cl.hasOption(OPTION_SAMPLE_1_IN_X) ? CommandUtil.handleLong(cl, OPTION_SAMPLE_1_IN_X, 1L, null) : DEFAULT_ONE_IN_X_SAMPLING;
        long DEFAULT_START_LINE = StatsBuilder.getStartLineDefault();
        long startLine = cl.hasOption(OPTION_START_LINE) ? CommandUtil.handleLong(cl, OPTION_START_LINE, 1L, null) : DEFAULT_START_LINE;
        long DEFAULT_NUM_LINES = StatsBuilder.getNumLinesDefault();
        long numLines = cl.hasOption(OPTION_NUM_LINES) ? CommandUtil.handleLong(cl, OPTION_NUM_LINES, 0L, null) : DEFAULT_NUM_LINES;
        this.runStats(catalogFile, maxValueCount, oneInXSampling, outputDir, startLine, numLines);
    }

    private void runStats(File catalogFile, int maxValues, long oneInXSampling, File outputDir, long startLine, long numLines) throws IOException, CatalogFormatException {
        StatsBuilder s = new StatsBuilder();
        CatalogStats stats = s.build(catalogFile, maxValues, oneInXSampling, startLine, numLines);
        CatalogFiles files = new CatalogFiles(catalogFile);
        ColumnMetaDataOperations metaDataOperations = new ColumnMetaDataOperations(files.getColumnsFile());
        HashMap metaDataMap = metaDataOperations.load();
        for (String column : stats.getColumns()) {
            ColumnMetaData metaData = (ColumnMetaData)metaDataMap.get(column);
            File statsFile = new File(outputDir, column + "_stats.txt");
            FileWriter fileWtr = new FileWriter(statsFile);
            StatsPrinter.printStats(new PrintWriter(fileWtr), stats, column, metaData);
            fileWtr.close();
        }
    }
}

