/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.misses;

import edu.mayo.bior.catalog.misses.TabixReaderBAD;
import htsjdk.tribble.readers.TabixReader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.samtools.util.BlockCompressedInputStream;

public class TabixReaderTest {
    private TabixReaderBAD mTabixReaderBad;
    private TabixReader mTabixReaderGood;
    private String mCatalogPath = null;
    private File mVcfFile = null;
    private File mOutputFile = null;

    private static void printUsage() {
        System.out.println("This is a utility provided by the BIOR team to help assess the impact to user-generated\nBIOR catalogs due to a bug in a Broad Institute Java-based tabix reader used within the BIOR toolkit\nprior to versions 2.4.2 and 4.1.2.\n\nBy default the utility outputs all lines from of a BIOR catalog that do not return an expected\nresult. These lines in the catalog would have been incorrectly ommitted from annotations outputted\nby some commands in the BIOR toolkit.\n\nYou can also ensure your catalog is now returning all the expected results, as it should have been, by\nrunning this utility with the optional '--fixed' parameter.\n\nFor more information on this issue, please see web-site: http://bsiweb.mayo.edu/bior/java-tabix-bug-2016-09\n");
        System.out.println("USAGE: bior_count_catalog_misses --catalog <CATALOG> [--output_file_path <OUTPUT_FILE_PATH>]   [--vcf <VCF_PATH>]  [--fixed]");
        System.out.println("where: \t--catalog <CATALOG>  is required.\n            This is the catalog to check if any misses occurred by scanning the whole catalog line-by-line to see\n            if an overlap operation does NOT return the same line, in which case we know there is a problem with\n            the TabixReader implementation.\n            If --vcf is specified, then it is the VCF file that is crawled line-by-line for problems against the catalog,\n            comparing hits between bad and fixed TabixReader.\n       \t--output_file_path <OUTPUT_FILE_PATH>  is optional. \n            If provided, the reported catalog rows that did not return an expected result will be written to this file.\n            If the file already exists, the program will exit with an error. If not provided, an output file name will \n            be generated automatically based on the catalog file name and reported at the conclusion of the program run.\n       \t--vcf <VCF_PATH>  is optional\n            If specified, this checks each line in the VCF against the catalog using both the bad and fixed\n            TabixReader class and dumps out any VCF lines that are different between the two.\n       \t--fixed  is optional. \n            If --fixed is specified, the new, fixed htsjdk TabixReader will be used to check your catalog so that you can\n            verify the previous problem with the Java TabixReader has been resolved for your catalog.  If the --fixed parameter\n            is left out, this utility uses the older, broken TabixReader so that you can assess which annotations \n            from the specific catalog were incorrectly ommited in the past.  This is ignored if checking a VCF against a catalog.\n");
        System.exit(0);
    }

    public static void main(String[] args) {
        File vcfFile;
        File outFile;
        if (args.length == 0) {
            TabixReaderTest.printUsage();
        }
        boolean useFixed = false;
        String catalogFilePath = null;
        String outputFilePath = null;
        String vcfPath = null;
        for (int i = 0; i < args.length; ++i) {
            String eachArg = args[i];
            String nextArg = null;
            if (i + 1 < args.length) {
                nextArg = args[i + 1];
            }
            if (eachArg.equals("-h") || eachArg.equals("--help") || eachArg.equals("-help")) {
                TabixReaderTest.printUsage();
            }
            if (eachArg.equals("-c") || eachArg.equals("--catalog")) {
                catalogFilePath = nextArg;
                ++i;
            }
            if (eachArg.equals("-o") || eachArg.equals("--output_file_path")) {
                outputFilePath = nextArg;
                ++i;
            }
            if (eachArg.equals("-v") || eachArg.equals("--vcf")) {
                vcfPath = nextArg;
                ++i;
            }
            if (!eachArg.equals("-f") && !eachArg.equals("--fixed")) continue;
            useFixed = true;
        }
        if (catalogFilePath == null || catalogFilePath.length() == 0) {
            System.err.println("\nERROR: Catalog file to check not specified. Please specify a catalog.\n");
            TabixReaderTest.printUsage();
        } else {
            File catFile = new File(catalogFilePath);
            if (catFile == null || !catFile.exists()) {
                System.err.println("\nERROR: Catalog file specified does not exist. Please specify a valid catalog.\n");
                TabixReaderTest.printUsage();
            }
        }
        File catalogIndexFile = new File(catalogFilePath + ".tbi");
        if (catalogIndexFile == null || !catalogIndexFile.exists()) {
            System.err.println("\nERROR: Catalog tabix index file for the catalog does not exist [" + catalogIndexFile.getAbsolutePath() + "].  If this is a catalog that has genomic coordinates in the first three columns, you must create a tabix index in order to check it for misses due to the Java tabix issue. If this is not a positional catalog, there is no need to check for misses.  Non-positional catalogs are not designed to return results using the tools affected by this Java tabix issue.\n");
            TabixReaderTest.printUsage();
        }
        if (outputFilePath == null || outputFilePath.length() == 0) {
            File catalogFile = new File(catalogFilePath);
            String basename = catalogFile.getName();
            outputFilePath = useFixed ? basename + "_misses_fixed.txt" : basename + "_misses.txt";
        }
        if ((outFile = new File(outputFilePath)).exists()) {
            if (!outFile.isFile()) {
                System.err.println("\nERROR: Output file is not a file [" + outputFilePath + "]. Please specify an output file value.\n");
                TabixReaderTest.printUsage();
            } else {
                System.err.println("\nERROR: Output file already exists [" + outputFilePath + "]. Please remove and rerun, or specify new value.\n");
                TabixReaderTest.printUsage();
            }
        }
        File file = vcfFile = vcfPath == null ? null : new File(vcfPath);
        if (vcfFile != null && !vcfFile.exists()) {
            System.err.println("\nERROR: VCF file specified does not exist. Please specify a valid VCF file.\n");
            TabixReaderTest.printUsage();
        }
        File parentDir = null;
        parentDir = outFile.getParentFile() == null ? new File(".").getAbsoluteFile() : outFile.getParentFile();
        if (parentDir == null || !parentDir.canWrite()) {
            System.err.println("\nERROR: Output file specified is not writable [" + outputFilePath + "]. Please change permissions on directory/file and rerun, or specify new value.\n");
            TabixReaderTest.printUsage();
        }
        try {
            TabixReaderTest tester = new TabixReaderTest(catalogFilePath, outFile, vcfFile);
            if (vcfFile != null && vcfFile.exists()) {
                tester.dumpMissesFromVcf();
            } else {
                tester.dumpMissesFromCatalog(useFixed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public TabixReaderTest(String catalogPath, File outputFile, File vcfFile) throws IOException {
        this.mCatalogPath = catalogPath;
        this.mOutputFile = outputFile;
        this.mVcfFile = vcfFile;
        this.mTabixReaderBad = new TabixReaderBAD(catalogPath);
        this.mTabixReaderGood = new TabixReader(catalogPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMissesFromCatalog(boolean useFixed) {
        BufferedWriter outWtr = null;
        try {
            double start = System.currentTimeMillis();
            outWtr = new BufferedWriter(new FileWriter(this.mOutputFile));
            File catalogFile = new File(this.mCatalogPath);
            BlockCompressedInputStream inStream = new BlockCompressedInputStream(catalogFile);
            String line = null;
            long numLines = 0L;
            long numMisses = 0L;
            System.err.println(". = 10k lines,  o=100k lines");
            while ((line = inStream.readLine()) != null) {
                String tabixRegionQueryStr;
                if (++numLines % 1000000L == 0L) {
                    System.err.println(numLines);
                } else if (numLines % 100000L == 0L) {
                    System.err.print("o");
                } else if (numLines % 10000L == 0L) {
                    System.err.print(".");
                }
                String chrom = this.getMid(line, "_landmark\":\"", "\"");
                String min = this.getMid(line, "_minBP\":", ",");
                String max = this.getMid(line, "_maxBP\":", ",");
                if (!this.isGiven(chrom) || this.isAtLeastOneHit(tabixRegionQueryStr = chrom + ":" + min + "-" + max, useFixed)) continue;
                ++numMisses;
                outWtr.write(line + "\t{}\n");
            }
            System.err.println();
            double end = System.currentTimeMillis();
            double runtime = (end - start) / 1000.0;
            long linesPerSecond = (long)((double)numLines / runtime);
            File tabixIndex = new File(this.mCatalogPath + ".tbi");
            String fileSizeWithCommas = new DecimalFormat("#,###").format(catalogFile.length());
            System.err.println("Catalog path:     " + this.mCatalogPath);
            System.err.println("Size of catalog:  " + fileSizeWithCommas);
            System.err.println("Last modified:    " + new Date(catalogFile.lastModified()));
            System.err.println("Tabix index size: " + new DecimalFormat("#,###").format(tabixIndex.length()));
            System.err.println("Tabix index last modified: " + new Date(tabixIndex.lastModified()));
            System.err.println("Time of this run: " + new Date());
            System.err.println("Total runtime (seconds) = " + runtime);
            System.err.println("Output file for MISSES:   " + this.mOutputFile.getCanonicalPath());
            System.err.println("# lines processed:        " + numLines);
            System.err.println("# lines processed per second: " + linesPerSecond);
            System.err.println("# MISSES:  " + numMisses);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outWtr != null) {
                    outWtr.flush();
                    outWtr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpMissesFromVcf() {
        BufferedWriter outWtr = null;
        try {
            double start = System.currentTimeMillis();
            outWtr = new BufferedWriter(new FileWriter(this.mOutputFile));
            outWtr.write("## These are the lines from the VCF file where there was a difference between using the old/bad TabixWriter and the new/fixed one.\n");
            outWtr.write("## VCF File: " + this.mVcfFile.getCanonicalPath() + "\n");
            File catalogFile = new File(this.mCatalogPath);
            BufferedReader inStream = null;
            boolean isCompressedVcf = this.mVcfFile.getName().endsWith(".gz") || this.mVcfFile.getName().endsWith(".bgz");
            inStream = isCompressedVcf ? new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream(this.mVcfFile))) : new BufferedReader(new FileReader(this.mVcfFile));
            String line = null;
            long numLines = 0L;
            long numMisses = 0L;
            System.err.println(". = 10k lines,  o=100k lines");
            while ((line = inStream.readLine()) != null) {
                List<String> fixed;
                if (line.startsWith("#")) continue;
                if (++numLines % 1000000L == 0L) {
                    System.err.println(numLines);
                } else if (numLines % 100000L == 0L) {
                    System.err.print("o");
                } else if (numLines % 10000L == 0L) {
                    System.err.print(".");
                }
                String[] lineSplit = line.split("\t", -1);
                String chrom = lineSplit[0];
                Long min = Long.parseLong(lineSplit[1]);
                String ref = lineSplit[3];
                Long max = min + (long)ref.length();
                String tabixRegionQueryStr = chrom + ":" + min + "-" + max;
                List<String> bad = this.getHitsBad(tabixRegionQueryStr);
                if (this.isListSame(bad, fixed = this.getHitsFixed(tabixRegionQueryStr))) continue;
                ++numMisses;
                outWtr.write(line + "\n");
            }
            System.err.println();
            double end = System.currentTimeMillis();
            double runtime = (end - start) / 1000.0;
            long linesPerSecond = (long)((double)numLines / runtime);
            File tabixIndex = new File(this.mCatalogPath + ".tbi");
            String fileSizeWithCommas = new DecimalFormat("#,###").format(catalogFile.length());
            System.err.println("Catalog path:     " + this.mCatalogPath);
            System.err.println("Size of catalog:  " + fileSizeWithCommas);
            System.err.println("Last modified:    " + new Date(catalogFile.lastModified()));
            System.err.println("Tabix index size: " + new DecimalFormat("#,###").format(tabixIndex.length()));
            System.err.println("Tabix index last modified: " + new Date(tabixIndex.lastModified()));
            System.err.println("VCF file:         " + this.mVcfFile.getCanonicalPath());
            System.err.println("Time of this run: " + new Date());
            System.err.println("Total runtime (seconds) = " + runtime);
            System.err.println("Output file for MISSES:   " + this.mOutputFile.getCanonicalPath());
            System.err.println("# lines processed:        " + numLines);
            System.err.println("# lines processed per second: " + linesPerSecond);
            System.err.println("# MISSES:  " + numMisses);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (outWtr != null) {
                    outWtr.flush();
                    outWtr.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private boolean isListSame(List<String> bad, List<String> fixed) {
        if (bad.size() != fixed.size()) {
            return false;
        }
        for (int i = 0; i < bad.size(); ++i) {
            if (bad.get(i).equals(fixed.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAtLeastOneHit(String tabixRegionQueryStr, boolean useFixed) {
        try {
            if (useFixed) {
                TabixReader.Iterator iter = this.mTabixReaderGood.query(tabixRegionQueryStr);
                return iter != null && this.isGiven(iter.next());
            }
            TabixReaderBAD.Iterator iter = this.mTabixReaderBad.query(tabixRegionQueryStr);
            return iter != null && this.isGiven(iter.next());
        }
        catch (Exception e) {
            return false;
        }
    }

    private List<String> getHitsBad(String tabixRegionQueryStr) throws IOException {
        TabixReaderBAD.Iterator iter = this.mTabixReaderBad.query(tabixRegionQueryStr);
        ArrayList<String> results = new ArrayList<String>();
        String line = null;
        while (iter != null && (line = iter.next()) != null) {
            results.add(line);
        }
        return results;
    }

    private List<String> getHitsFixed(String tabixRegionQueryStr) throws IOException {
        TabixReader.Iterator iter = this.mTabixReaderGood.query(tabixRegionQueryStr);
        ArrayList<String> results = new ArrayList<String>();
        String line = null;
        while (iter != null && (line = iter.next()) != null) {
            results.add(line);
        }
        return results;
    }

    private boolean isGiven(String s) {
        return s != null && s.trim().length() > 0;
    }

    private String getMid(String line, String pre, String post) {
        int idx1 = line.indexOf(pre);
        int idx2 = line.indexOf(post, idx1 + pre.length());
        if (idx1 == -1) {
            return "{}";
        }
        if (idx2 == -1) {
            idx2 = line.length();
        }
        return line.substring(idx1 + pre.length(), idx2).replace("}", "");
    }
}

