/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.MarkdownUtils;
import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogDiffStatistics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class CatalogVolumeImpl
implements MarkdownTransformer {
    static final String TEMPLATE_KEYWORD = "COMPARISON_STATISTICS_VOLUME_TABLE";
    private CatalogDiffStatistics stats;

    CatalogVolumeImpl(CatalogDiffStatistics stats) {
        this.stats = stats;
    }

    @Override
    public String transform(String markdown) throws TransformException {
        if (this.stats == null) {
            return markdown.replace(TEMPLATE_KEYWORD, "Information is not available");
        }
        return markdown.replace(TEMPLATE_KEYWORD, MarkdownUtils.chompTrailingNewlines(this.buildTable()));
    }

    private String buildTable() {
        long netDifference = this.stats.getSummaryStats().getCatalogNewEntries() - this.stats.getSummaryStats().getCatalogOldEntries();
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        pWtr.println("Metric | Description | Count");
        pWtr.println("--- | --- | ---");
        pWtr.println(String.format("%s | %s | %d", "Previous Rows", "# of rows in the previous catalog", this.stats.getSummaryStats().getCatalogOldEntries()));
        pWtr.println(String.format("%s | %s | %s", "Removed Rows", "# of rows removed from the previous catalog", MarkdownUtils.positiveNumPrint(-1L * this.stats.getSummaryStats().getCatalogEntriesRemoved())));
        pWtr.println(String.format("%s | %s | %s", "Added Rows", "# of rows added to the previous catalog", MarkdownUtils.positiveNumPrint(this.stats.getSummaryStats().getCatalogEntriesAdded())));
        pWtr.println(String.format("%s | %s | %d", "Current Rows", "# of rows in the current catalog", this.stats.getSummaryStats().getCatalogNewEntries()));
        pWtr.println(String.format("%s | %s | %s", "Net Difference", "Difference between Previous Rows and Current Rows", MarkdownUtils.positiveNumPrint(netDifference)));
        IOUtils.closeQuietly((Writer)pWtr);
        IOUtils.closeQuietly((Writer)sWtr);
        return sWtr.toString();
    }
}

