/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.markdown.transformer.comparison;

import edu.mayo.bior.catalog.markdown.MarkdownUtils;
import edu.mayo.bior.catalog.markdown.transformer.MarkdownTransformer;
import edu.mayo.bior.catalog.markdown.transformer.TransformException;
import edu.mayo.bior.catalog.markdown.transformer.comparison.CatalogDiffStatistics;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class CatalogTableImpl
implements MarkdownTransformer {
    static final String TEMPLATE_KEYWORD = "COMPARISON_STATISTICS_CATALOG_TABLE";
    private CatalogDiffStatistics stats;

    CatalogTableImpl(CatalogDiffStatistics stats) {
        this.stats = stats;
    }

    @Override
    public String transform(String markdown) throws TransformException {
        if (this.stats == null) {
            return markdown.replace(TEMPLATE_KEYWORD, "Information is not available");
        }
        return markdown.replace(TEMPLATE_KEYWORD, MarkdownUtils.chompTrailingNewlines(this.buildTable()));
    }

    private String buildTable() {
        StringWriter sWtr = new StringWriter();
        PrintWriter pWtr = new PrintWriter(sWtr);
        pWtr.println("Catalog | Path");
        pWtr.println("--- | ---");
        pWtr.println("Previous | " + this.stats.getDiffInfo().getOldCatalogTsvBgz());
        pWtr.println("Current | " + this.stats.getDiffInfo().getNewCatalogTsvBgz());
        IOUtils.closeQuietly((Writer)pWtr);
        IOUtils.closeQuietly((Writer)sWtr);
        return sWtr.toString();
    }
}

