/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.catalog.list;

import edu.mayo.bior.catalog.CatalogFormatException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CatalogInfo {
    private static final String TAB = "\t";
    public static final String DOT = ".";
    public CatalogStatus status;
    public String path;
    public String lastUpdated;
    public String shortName;
    public List<String> indexes;
    public String dataSource;
    public String version;
    public String build;
    public String buildBase;
    public String dataset;

    public CatalogInfo() {
    }

    public CatalogInfo(String tabSeparatedLine) throws CatalogFormatException {
        if (tabSeparatedLine == null) {
            throw new RuntimeException("Must supply line to CatalogInfo constructor");
        }
        String[] fields = tabSeparatedLine.split(TAB);
        if (fields.length != 10) {
            String numFieldsDescription = "fields";
            if (fields.length == 1) {
                numFieldsDescription = "field";
            }
            String msg = String.format("Expecting lines with 10 tab separated fields but got %d %s from '%s',", fields.length, numFieldsDescription, tabSeparatedLine);
            throw new CatalogFormatException(msg);
        }
        String statusStr = fields[0];
        if (statusStr.toLowerCase().equals(CatalogStatus.Active.toString().toLowerCase())) {
            this.status = CatalogStatus.Active;
        } else if (statusStr.toLowerCase().equals(CatalogStatus.Deprecated.toString().toLowerCase())) {
            this.status = CatalogStatus.Deprecated;
        } else {
            String msg = String.format("Expected '%s' or '%s' but got '%s' as first field (status) from '%s'", CatalogStatus.Active.toString(), CatalogStatus.Deprecated.toString(), statusStr, tabSeparatedLine);
            throw new CatalogFormatException(msg);
        }
        this.path = this.getStr(fields[1]);
        this.lastUpdated = this.getStr(fields[2]);
        this.shortName = this.getStr(fields[3]);
        this.indexes = this.indexesFromStr(fields[4]);
        this.dataSource = this.getStr(fields[5]);
        this.version = this.getStr(fields[6]);
        this.build = this.getStr(fields[7]);
        this.buildBase = this.getStr(fields[8]);
        this.dataset = this.getStr(fields[9]);
    }

    public String toString() {
        ArrayList<String> data = new ArrayList<String>();
        data.add(this.status.toString());
        data.add(this.dotIfNullOrEmpty(this.path));
        data.add(this.dotIfNullOrEmpty(this.lastUpdated));
        data.add(this.dotIfNullOrEmpty(this.shortName));
        data.add(this.getIndexesAsStr());
        data.add(this.dotIfNullOrEmpty(this.dataSource));
        data.add(this.dotIfNullOrEmpty(this.version));
        data.add(this.dotIfNullOrEmpty(this.build));
        data.add(this.dotIfNullOrEmpty(this.buildBase));
        data.add(this.dotIfNullOrEmpty(this.dataset));
        return StringUtils.join(data, (String)TAB);
    }

    public boolean isActive() {
        return this.status == CatalogStatus.Active;
    }

    public boolean isDeprecated() {
        return this.status == CatalogStatus.Deprecated;
    }

    public String getPath() {
        return this.path;
    }

    public String getLastUpdated() {
        return this.lastUpdated;
    }

    public String getShortName() {
        return this.shortName;
    }

    public List<String> getIndexes() {
        return this.indexes;
    }

    public int getIndexesSize() {
        return this.indexes.size();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public String getBuildBase() {
        return this.buildBase;
    }

    public String getDataset() {
        return this.dataset;
    }

    private List<String> indexesFromStr(String s) {
        String indexStr = this.getStr(s);
        if (indexStr != null) {
            String[] fields = indexStr.split(",");
            return Arrays.asList(fields);
        }
        return new ArrayList<String>();
    }

    private String getIndexesAsStr() {
        if (this.indexes.size() == 0) {
            return DOT;
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.indexes.size(); ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.indexes.get(i));
        }
        return str.toString();
    }

    private String getStr(String s) {
        if (s == null || s.trim().equals(DOT)) {
            return null;
        }
        return s.trim();
    }

    private String dotIfNullOrEmpty(String s) {
        if (s == null || s.trim().length() == 0) {
            return DOT;
        }
        return s;
    }

    public static enum CatalogStatus {
        Active,
        Deprecated;

    }
}

