/*
 * Decompiled with CFR 0.152.
 */
package edu.mayo.bior.buildcatalog;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class BackupUtils {
    protected static boolean isCurrentSameAsLastBackup(File currentFile) throws IOException {
        File lastBackupFile = BackupUtils.getLastBackup(currentFile);
        String currentContents = FileUtils.readFileToString((File)currentFile);
        String lastBackupContents = FileUtils.readFileToString((File)lastBackupFile);
        return currentContents.equals(lastBackupContents);
    }

    protected static File getLastBackup(File currentFile) throws IOException {
        File last = null;
        int i = 1;
        while (BackupUtils.getBackup(currentFile, i).exists()) {
            last = BackupUtils.getBackup(currentFile, i);
            ++i;
        }
        return last;
    }

    protected static void removeLastBackup(File currentFile) throws IOException {
        File lastBackup = BackupUtils.getLastBackup(currentFile);
        if (lastBackup != null && lastBackup.exists()) {
            lastBackup.delete();
        }
    }

    protected static void backupCurrentFile(File currentFile) throws IOException {
        File nextBackupFile = BackupUtils.getNextBackup(currentFile);
        FileUtils.copyFile((File)currentFile, (File)nextBackupFile);
    }

    protected static File getNextBackup(File currentFile) throws IOException {
        File nextBackup;
        int i = 1;
        do {
            nextBackup = BackupUtils.getBackup(currentFile, i);
            ++i;
        } while (nextBackup.exists());
        return nextBackup;
    }

    protected static File getBackup(File currentFile, int i) throws IOException {
        String extension = (i < 10 ? ".0" : ".") + Integer.toString(i);
        File buildDir = new File(currentFile.getParentFile(), "build");
        return new File(buildDir, currentFile.getName() + extension);
    }
}

